/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ranges.Ranges;
import com.maddyhome.idea.vim.register.Register;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/RepeatCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ForEachCaret;", "ranges", "Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "argument", "", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;Ljava/lang/String;)V", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgument", "()Ljava/lang/String;", "lastArg", "", "getRanges", "()Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "toString", "vim-engine"})
public final class RepeatCommand
extends Command.ForEachCaret {
    @NotNull
    private final Ranges ranges;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;
    private char lastArg;

    public RepeatCommand(@NotNull Ranges ranges, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(ranges, argument);
        this.ranges = ranges;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_REQUIRED, Command.Access.SELF_SYNCHRONIZED, new Command.Flag[0]);
        this.lastArg = (char)58;
    }

    @NotNull
    public final Ranges getRanges() {
        return this.ranges;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    public Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) throws ExException {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        char arg = this.argument.charAt(0);
        if (arg == '@') {
            arg = this.lastArg;
        }
        this.lastArg = arg;
        int line = this.getLine(editor, caret);
        caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToLineWithSameColumn(editor, line, editor.primaryCaret()));
        if (arg == ':') {
            return VimInjectorKt.getInjector().getVimscriptExecutor().executeLastCommand(editor, context) ? (ExecutionResult)ExecutionResult.Success.INSTANCE : (ExecutionResult)ExecutionResult.Error.INSTANCE;
        }
        Register register = VimInjectorKt.getInjector().getRegisterGroup().getPlaybackRegister(arg);
        if (register == null) {
            return ExecutionResult.Error.INSTANCE;
        }
        Register reg = register;
        String string = reg.getText();
        if (string == null) {
            return ExecutionResult.Error.INSTANCE;
        }
        String text2 = string;
        VimInjectorKt.getInjector().getVimscriptExecutor().execute(text2, editor, context, false, true, this.getVimContext());
        return ExecutionResult.Success.INSTANCE;
    }

    @NotNull
    public final Ranges component1() {
        return this.ranges;
    }

    @NotNull
    public final String component2() {
        return this.argument;
    }

    @NotNull
    public final RepeatCommand copy(@NotNull Ranges ranges, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new RepeatCommand(ranges, argument);
    }

    public static /* synthetic */ RepeatCommand copy$default(RepeatCommand repeatCommand, Ranges ranges, String string, int n, Object object) {
        if ((n & 1) != 0) {
            ranges = repeatCommand.ranges;
        }
        if ((n & 2) != 0) {
            string = repeatCommand.argument;
        }
        return repeatCommand.copy(ranges, string);
    }

    @NotNull
    public String toString() {
        return "RepeatCommand(ranges=" + this.ranges + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.ranges.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RepeatCommand)) {
            return false;
        }
        RepeatCommand repeatCommand = (RepeatCommand)other;
        if (!Intrinsics.areEqual((Object)this.ranges, (Object)repeatCommand.ranges)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)repeatCommand.argument);
    }
}

