/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimExOutputPanel;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimJumpServiceKt;
import com.maddyhome.idea.vim.api.VirtualFile;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ranges.Ranges;
import com.maddyhome.idea.vim.helper.EngineStringHelper;
import com.maddyhome.idea.vim.mark.Jump;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/JumpsCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "ranges", "Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "argument", "", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;Ljava/lang/String;)V", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgument", "()Ljava/lang/String;", "getRanges", "()Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "toString", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nJumpsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JumpsCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/JumpsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1864#2,3:67\n*S KotlinDebug\n*F\n+ 1 JumpsCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/JumpsCommand\n*L\n34#1:67,3\n*E\n"})
public final class JumpsCommand
extends Command.SingleExecution {
    @NotNull
    private final Ranges ranges;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public JumpsCommand(@NotNull Ranges ranges, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(ranges, argument);
        this.ranges = ranges;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_FORBIDDEN, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Ranges getRanges() {
        return this.ranges;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    public Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        List<Jump> jumps = VimJumpServiceKt.getJumps(VimInjectorKt.getInjector().getJumpService(), editor);
        int spot = VimJumpServiceKt.getJumpSpot(VimInjectorKt.getInjector().getJumpService(), editor);
        StringBuilder text2 = new StringBuilder(" jump line  col file/text\n");
        Iterable $this$forEachIndexed$iv = jumps;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void jump;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Jump jump2 = (Jump)item$iv;
            int idx = n;
            boolean bl = false;
            int jumpSizeMinusSpot = jumps.size() - idx - spot - 1;
            text2.append(jumpSizeMinusSpot == 0 ? ">" : " ");
            text2.append(StringsKt.padStart$default((String)String.valueOf(Math.abs(jumpSizeMinusSpot)), (int)3, (char)'\u0000', (int)2, null));
            text2.append(" ");
            text2.append(StringsKt.padStart$default((String)String.valueOf(jump.getLine() + 1), (int)5, (char)'\u0000', (int)2, null));
            text2.append("  ");
            text2.append(StringsKt.padStart$default((String)String.valueOf(jump.getCol()), (int)3, (char)'\u0000', (int)2, null));
            text2.append(" ");
            VirtualFile vf = editor.getVirtualFile();
            if (vf != null && Intrinsics.areEqual((Object)vf.getPath(), (Object)jump.getFilepath())) {
                String line = StringsKt.take((String)((Object)StringsKt.trim((CharSequence)editor.getLineText(jump.getLine()))).toString(), (int)200);
                List<KeyStroke> keys = VimInjectorKt.getInjector().getParser().stringToKeys(line);
                text2.append(StringsKt.take((String)EngineStringHelper.INSTANCE.toPrintableCharacters(keys), (int)200));
            } else {
                text2.append(jump.getFilepath());
            }
            text2.append("\n");
        }
        if (spot == -1) {
            text2.append(">\n");
        }
        VimExOutputPanel vimExOutputPanel = VimInjectorKt.getInjector().getExOutputPanel().getPanel(editor);
        String string = text2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        vimExOutputPanel.output(string);
        return ExecutionResult.Success.INSTANCE;
    }

    @NotNull
    public final Ranges component1() {
        return this.ranges;
    }

    @NotNull
    public final String component2() {
        return this.argument;
    }

    @NotNull
    public final JumpsCommand copy(@NotNull Ranges ranges, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new JumpsCommand(ranges, argument);
    }

    public static /* synthetic */ JumpsCommand copy$default(JumpsCommand jumpsCommand, Ranges ranges, String string, int n, Object object) {
        if ((n & 1) != 0) {
            ranges = jumpsCommand.ranges;
        }
        if ((n & 2) != 0) {
            string = jumpsCommand.argument;
        }
        return jumpsCommand.copy(ranges, string);
    }

    @NotNull
    public String toString() {
        return "JumpsCommand(ranges=" + this.ranges + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.ranges.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JumpsCommand)) {
            return false;
        }
        JumpsCommand jumpsCommand = (JumpsCommand)other;
        if (!Intrinsics.areEqual((Object)this.ranges, (Object)jumpsCommand.ranges)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)jumpsCommand.argument);
    }
}

