/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.register;

import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.Options;
import com.maddyhome.idea.vim.api.StringListOptionValue;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.options.GlobalOptionChangeListener;
import com.maddyhome.idea.vim.register.Register;
import com.maddyhome.idea.vim.register.VimRegisterGroup;
import com.maddyhome.idea.vim.register.VimRegisterGroupBase;
import com.maddyhome.idea.vim.state.VimStateMachine;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 X2\u00020\u0001:\u0001XB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010'\u001a\u00020\u001cJ\b\u0010(\u001a\u00020\u001cH\u0016J\b\u0010)\u001a\u00020\u0004H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u00112\u0006\u0010+\u001a\u00020\u0004H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010\u00112\u0006\u0010+\u001a\u00020\u0004H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020\u000bH\u0016J\b\u00104\u001a\u00020\u000bH\u0016J\u0010\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u0004H\u0016J\u0010\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u0004H\u0016J\u0018\u0010<\u001a\u0002022\u0006\u00101\u001a\u0002022\u0006\u0010=\u001a\u000200H\u0004J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020\u001fH\u0016J\u0010\u0010@\u001a\u00020\u001c2\u0006\u00101\u001a\u000202H\u0016J\n\u0010A\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010A\u001a\u0004\u0018\u00010\u00112\u0006\u0010+\u001a\u00020\u0004H\u0002J\n\u0010B\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010C\u001a\u00020\u001cH\u0016J\b\u0010D\u001a\u00020\u001cH\u0016J\u0018\u0010E\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u0011H\u0016J\u0010\u0010F\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u0004H\u0016J\u001e\u0010G\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u00042\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001f0.H\u0016J&\u0010G\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u00042\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001f0.2\u0006\u0010=\u001a\u000200H\u0016J&\u0010I\u001a\u00020\u001c2\u0006\u00101\u001a\u0002022\u0006\u0010J\u001a\u0002022\f\u0010K\u001a\b\u0012\u0004\u0012\u00020L0.H\u0002J&\u0010M\u001a\u00020\u001c2\u0006\u00101\u001a\u0002022\u0006\u0010J\u001a\u0002022\f\u0010K\u001a\b\u0012\u0004\u0012\u00020L0.H\u0002J\u0010\u0010N\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u0004H\u0016J0\u0010O\u001a\u00020\u000b2\u0006\u00106\u001a\u0002072\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u0010=\u001a\u0002002\u0006\u0010T\u001a\u00020\u000bH\u0016J\u0018\u0010O\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u00042\u0006\u00101\u001a\u000202H\u0016J \u0010O\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u00042\u0006\u00101\u001a\u0002022\u0006\u0010U\u001a\u000200H\u0016J>\u0010V\u001a\u00020\u000b2\u0006\u00106\u001a\u0002072\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u00101\u001a\u0002022\u0006\u0010=\u001a\u0002002\u0006\u00109\u001a\u00020\u00042\u0006\u0010T\u001a\u00020\u000bJ\u0018\u0010W\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u00042\u0006\u00101\u001a\u000202H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\u00048\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u001a\u0010\r\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\f\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0006\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u00198\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R*\u0010!\u001a\u0004\u0018\u00010\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010&\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006Y"}, d2={"Lcom/maddyhome/idea/vim/register/VimRegisterGroupBase;", "Lcom/maddyhome/idea/vim/register/VimRegisterGroup;", "()V", "currentRegister", "", "getCurrentRegister", "()C", "defaultRegister", "getDefaultRegister", "defaultRegisterChar", "isRecording", "", "()Z", "isRegisterSpecifiedExplicitly", "setRegisterSpecifiedExplicitly", "(Z)V", "lastRegister", "Lcom/maddyhome/idea/vim/register/Register;", "getLastRegister", "()Lcom/maddyhome/idea/vim/register/Register;", "lastRegisterChar", "getLastRegisterChar", "setLastRegisterChar", "(C)V", "myRegisters", "Ljava/util/HashMap;", "onClipboardChanged", "Lkotlin/Function0;", "", "recordList", "", "Ljavax/swing/KeyStroke;", "value", "recordRegister", "getRecordRegister", "()Ljava/lang/Character;", "setRecordRegister", "(Ljava/lang/Character;)V", "Ljava/lang/Character;", "clearListener", "finishRecording", "getCurrentRegisterForMulticaret", "getPlaybackRegister", "r", "getRegister", "getRegisters", "", "guessSelectionType", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "text", "", "isPrimaryRegisterSupported", "isRegisterWritable", "isSmallDeletionSpecialCase", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "isSystemClipboard", "register", "isValid", "reg", "preprocessTextBeforeStoring", "type", "recordKeyStroke", "key", "recordText", "refreshClipboardRegister", "refreshPrimaryRegister", "resetRegister", "resetRegisters", "saveRegister", "selectRegister", "setKeys", "keys", "setSystemClipboardRegisterText", "rawText", "transferableData", "", "setSystemPrimaryRegisterText", "startRecording", "storeText", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "isDelete", "selectionType", "storeTextInternal", "storeTextSpecial", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimRegisterGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimRegisterGroupBase.kt\ncom/maddyhome/idea/vim/register/VimRegisterGroupBase\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,553:1\n33#2,4:554\n33#2,4:558\n33#2,4:562\n33#2,4:566\n33#2,4:570\n33#2,4:574\n33#2,4:578\n33#2,4:582\n38#2:614\n1#3:586\n1#3:611\n819#4:587\n847#4,2:588\n483#5,11:590\n1024#5,9:601\n1174#5:610\n1175#5:612\n1033#5:613\n*S KotlinDebug\n*F\n+ 1 VimRegisterGroupBase.kt\ncom/maddyhome/idea/vim/register/VimRegisterGroupBase\n*L\n120#1:554,4\n209#1:558,4\n221#1:562,4\n225#1:566,4\n248#1:570,4\n283#1:574,4\n342#1:578,4\n350#1:582,4\n538#1:614\n460#1:611\n457#1:587\n457#1:588,2\n459#1:590,11\n460#1:601,9\n460#1:610\n460#1:612\n460#1:613\n*E\n"})
public abstract class VimRegisterGroupBase
implements VimRegisterGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Character recordRegister;
    @JvmField
    @Nullable
    protected List<KeyStroke> recordList;
    @JvmField
    @NotNull
    protected final HashMap<Character, Register> myRegisters = new HashMap();
    @JvmField
    protected char defaultRegisterChar;
    private char lastRegisterChar = this.defaultRegisterChar = (char)34;
    private boolean isRegisterSpecifiedExplicitly;
    @NotNull
    private final Function0<Unit> onClipboardChanged = (Function0)new Function0<Unit>(this){
        final /* synthetic */ VimRegisterGroupBase this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final void invoke() {
            StringListOptionValue clipboardOptionValue = VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getClipboard();
            this.this$0.defaultRegisterChar = (char)(clipboardOptionValue.contains((Object)"unnamedplus") ? (this.this$0.isPrimaryRegisterSupported() ? 43 : 42) : (clipboardOptionValue.contains((Object)"unnamed") ? 42 : 34));
            this.this$0.setLastRegisterChar(this.this$0.defaultRegisterChar);
        }
    };
    @NotNull
    private static final VimLogger logger;

    public VimRegisterGroupBase() {
        Function0<Unit> function0 = this.onClipboardChanged;
        VimInjectorKt.getInjector().getOptionGroup().addGlobalOptionChangeListener(Options.INSTANCE.getClipboard(), new GlobalOptionChangeListener(function0){
            private final /* synthetic */ Function0 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onGlobalOptionChanged() {
                this.function.invoke();
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof GlobalOptionChangeListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        this.onClipboardChanged.invoke();
    }

    @Override
    public boolean isRecording() {
        return this.getRecordRegister() != null;
    }

    @Override
    @Nullable
    public Character getRecordRegister() {
        return this.recordRegister;
    }

    public void setRecordRegister(@Nullable Character value) {
        this.recordRegister = value;
        if (value != null) {
            VimInjectorKt.getInjector().getListenersNotifier().notifyMacroRecordingStarted();
        } else {
            VimInjectorKt.getInjector().getListenersNotifier().notifyMacroRecordingFinished();
        }
    }

    @Override
    public char getLastRegisterChar() {
        return this.lastRegisterChar;
    }

    @Override
    public void setLastRegisterChar(char c) {
        this.lastRegisterChar = c;
    }

    @Override
    public boolean isRegisterSpecifiedExplicitly() {
        return this.isRegisterSpecifiedExplicitly;
    }

    public void setRegisterSpecifiedExplicitly(boolean bl) {
        this.isRegisterSpecifiedExplicitly = bl;
    }

    @Override
    public char getCurrentRegister() {
        return this.getLastRegisterChar();
    }

    @Override
    public char getDefaultRegister() {
        return this.defaultRegisterChar;
    }

    @Override
    @Nullable
    public Register getLastRegister() {
        return this.getRegister(this.getLastRegisterChar());
    }

    public final void clearListener() {
        Function0<Unit> function0 = this.onClipboardChanged;
        VimInjectorKt.getInjector().getOptionGroup().removeGlobalOptionChangeListener(Options.INSTANCE.getClipboard(), new /* invalid duplicate definition of identical inner class */);
    }

    @Override
    public boolean isValid(char reg) {
        return StringsKt.indexOf$default((CharSequence)"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+*-_\"/%:.#=", (char)reg, (int)0, (boolean)false, (int)6, null) != -1;
    }

    @Override
    public boolean selectRegister(char reg) {
        boolean bl;
        if (this.isValid(reg)) {
            this.setRegisterSpecifiedExplicitly(true);
            this.setLastRegisterChar(reg);
            VimLogger $this$debug$iv = logger;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                VimLogger vimLogger = $this$debug$iv;
                boolean bl2 = false;
                vimLogger.debug("register selected: " + this.getLastRegister());
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void resetRegister() {
        this.setRegisterSpecifiedExplicitly(false);
        this.setLastRegisterChar(this.getDefaultRegister());
        logger.debug("Last register reset to default register");
    }

    @Override
    public void recordKeyStroke(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List<KeyStroke> myRecordList = this.recordList;
        if (this.isRecording() && myRecordList != null) {
            myRecordList.add(key);
        }
    }

    @Override
    public boolean isRegisterWritable() {
        return StringsKt.indexOf$default((CharSequence)"%:.#=", (char)this.getLastRegisterChar(), (int)0, (boolean)false, (int)6, null) < 0;
    }

    @Override
    public void resetRegisters() {
        this.setRegisterSpecifiedExplicitly(false);
        this.defaultRegisterChar = (char)34;
        this.setLastRegisterChar(this.getDefaultRegister());
        this.myRegisters.clear();
    }

    private final boolean isSmallDeletionSpecialCase(VimEditor editor) {
        Argument argument;
        Command currentCommand = VimStateMachine.Companion.getInstance(editor).getExecutingCommand();
        if (currentCommand != null && (argument = currentCommand.getArgument()) != null) {
            Command motionCommand = argument.getMotion();
            EditorActionHandlerBase action2 = motionCommand.getAction();
            return Intrinsics.areEqual((Object)action2.getId(), (Object)"VimMotionPercentOrMatchAction") || Intrinsics.areEqual((Object)action2.getId(), (Object)"VimMotionSentencePreviousStartAction") || Intrinsics.areEqual((Object)action2.getId(), (Object)"VimMotionSentenceNextStartAction") || Intrinsics.areEqual((Object)action2.getId(), (Object)"VimMotionGotoFileMarkAction") || Intrinsics.areEqual((Object)action2.getId(), (Object)"VimSearchEntryFwdAction") || Intrinsics.areEqual((Object)action2.getId(), (Object)"VimSearchEntryRevAction") || Intrinsics.areEqual((Object)action2.getId(), (Object)"VimSearchAgainNextAction") || Intrinsics.areEqual((Object)action2.getId(), (Object)"VimSearchAgainPreviousAction") || Intrinsics.areEqual((Object)action2.getId(), (Object)"VimMotionParagraphNextAction") || Intrinsics.areEqual((Object)action2.getId(), (Object)"VimMotionParagraphPreviousAction");
        }
        return false;
    }

    public final boolean storeTextInternal(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull TextRange range, @NotNull String text2, @NotNull SelectionType type, char register, boolean isDelete) {
        Object transferableClasses2;
        VimLogger vimLogger;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (this.getLastRegisterChar() == '_') {
            return true;
        }
        int start2 = range.getStartOffset();
        int end = range.getEndOffset();
        if (isDelete && start2 == end) {
            return true;
        }
        if (start2 > end) {
            int t = start2;
            start2 = end;
            end = t;
        }
        List<Object> transferableData = start2 != -1 ? VimInjectorKt.getInjector().getClipboardManager().getTransferableData(editor, range, text2) : (List<Object>)new ArrayList();
        String processedText = start2 != -1 ? VimInjectorKt.getInjector().getClipboardManager().preprocessText(editor, range, text2, transferableData) : text2;
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            vimLogger = $this$debug$iv;
            boolean bl = false;
            transferableClasses2 = CollectionsKt.joinToString$default((Iterable)transferableData, (CharSequence)",", null, null, (int)0, null, (Function1)storeTextInternal.1.transferableClasses.1.INSTANCE, (int)30, null);
            vimLogger.debug("Copy to '" + this.getLastRegister() + "' with transferable data: " + (String)transferableClasses2);
        }
        if (Character.isUpperCase(register)) {
            char lreg = Character.toLowerCase(register);
            Register r = this.myRegisters.get(Character.valueOf(lreg));
            if (r != null) {
                r.addTextAndResetTransferableData(processedText);
            } else {
                transferableClasses2 = Character.valueOf(lreg);
                ((Map)this.myRegisters).put(transferableClasses2, new Register(lreg, type, processedText, new ArrayList(transferableData)));
                VimLogger $this$debug$iv2 = logger;
                boolean $i$f$debug2 = false;
                if ($this$debug$iv2.isDebug()) {
                    vimLogger = $this$debug$iv2;
                    boolean bl = false;
                    vimLogger.debug("register '" + register + "' contains: \"" + processedText + "\"");
                }
            }
        } else {
            Character r = Character.valueOf(register);
            ((Map)this.myRegisters).put(r, new Register(register, type, processedText, new ArrayList(transferableData)));
            $this$debug$iv = logger;
            $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                vimLogger = $this$debug$iv;
                boolean bl = false;
                vimLogger.debug("register '" + register + "' contains: \"" + processedText + "\"");
            }
        }
        if (register == '+') {
            VimInjectorKt.getInjector().getClipboardManager().setClipboardText(processedText, text2, new ArrayList(transferableData));
            if (!this.isRegisterSpecifiedExplicitly() && !isDelete && this.isPrimaryRegisterSupported() && VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getClipboard().contains((Object)"unnamedplus")) {
                VimInjectorKt.getInjector().getClipboardManager().setPrimaryText(processedText, text2, new ArrayList(transferableData));
            }
        }
        if (register == '*') {
            if (this.isPrimaryRegisterSupported()) {
                VimInjectorKt.getInjector().getClipboardManager().setPrimaryText(processedText, text2, new ArrayList(transferableData));
                if (!this.isRegisterSpecifiedExplicitly() && !isDelete && VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getClipboard().contains((Object)"unnamed")) {
                    VimInjectorKt.getInjector().getClipboardManager().setClipboardText(processedText, text2, new ArrayList(transferableData));
                }
            } else {
                VimInjectorKt.getInjector().getClipboardManager().setClipboardText(processedText, text2, new ArrayList(transferableData));
            }
        }
        if (register != '\"' && StringsKt.indexOf$default((CharSequence)".:/", (char)register, (int)0, (boolean)false, (int)6, null) == -1) {
            ((Map)this.myRegisters).put(Character.valueOf('\"'), new Register('\"', type, processedText, new ArrayList(transferableData)));
            $this$debug$iv = logger;
            $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                vimLogger = $this$debug$iv;
                boolean bl = false;
                vimLogger.debug("register '\"' contains: \"" + processedText + "\"");
            }
        }
        if (isDelete) {
            boolean smallInlineDeletion;
            boolean bl = smallInlineDeletion = (type == SelectionType.CHARACTER_WISE || type == SelectionType.BLOCK_WISE) && editor.offsetToBufferPosition(start2).getLine() == editor.offsetToBufferPosition(end).getLine();
            if (!smallInlineDeletion && register == this.getDefaultRegister() || this.isSmallDeletionSpecialCase(editor)) {
                char d = '8';
                while (Intrinsics.compare((int)d, (int)49) >= 0) {
                    Register t = this.myRegisters.get(Character.valueOf(d));
                    if (t != null) {
                        t.setName((char)(d + '\u0001'));
                        ((Map)this.myRegisters).put(Character.valueOf((char)(d + '\u0001')), t);
                    }
                    char c = d;
                    d = (char)(c + -1);
                }
                ((Map)this.myRegisters).put(Character.valueOf('1'), new Register('1', type, processedText, new ArrayList(transferableData)));
            }
            if (smallInlineDeletion && register == this.getDefaultRegister()) {
                ((Map)this.myRegisters).put(Character.valueOf('-'), new Register('-', type, processedText, new ArrayList(transferableData)));
            }
        } else if (register == this.getDefaultRegister()) {
            ((Map)this.myRegisters).put(Character.valueOf('0'), new Register('0', type, processedText, new ArrayList(transferableData)));
            $this$debug$iv = logger;
            $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                vimLogger = $this$debug$iv;
                boolean bl = false;
                vimLogger.debug("register '0' contains: \"" + processedText + "\"");
            }
        }
        return true;
    }

    @Override
    public boolean storeText(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull TextRange range, @NotNull SelectionType type, boolean isDelete) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (this.isRegisterWritable()) {
            String text2 = this.preprocessTextBeforeStoring(EngineEditorHelperKt.getText(editor, range), type);
            return this.storeTextInternal(editor, caret, range, text2, type, this.getLastRegisterChar(), isDelete);
        }
        return false;
    }

    @NotNull
    protected final String preprocessTextBeforeStoring(@NotNull String text2, @NotNull SelectionType type) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (type == SelectionType.LINE_WISE && (((CharSequence)text2).length() == 0 || text2.charAt(text2.length() - 1) != '\n')) {
            return text2 + "\n";
        }
        return text2;
    }

    @Override
    public boolean storeTextSpecial(char register, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (StringsKt.indexOf$default((CharSequence)"%:.#=", (char)register, (int)0, (boolean)false, (int)6, null) == -1 && register != '/' && register != '\"') {
            return false;
        }
        Character c = Character.valueOf(register);
        ((Map)this.myRegisters).put(c, new Register(register, SelectionType.CHARACTER_WISE, text2, new ArrayList()));
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("register '" + register + "' contains: \"" + text2 + "\"");
        }
        return true;
    }

    @Override
    public boolean storeText(char register, @NotNull String text2, @NotNull SelectionType selectionType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)selectionType), (String)"selectionType");
        if (!StringsKt.contains$default((CharSequence)"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+*-_\"/", (char)register, (boolean)false, (int)2, null)) {
            return false;
        }
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("register '" + register + "' contains: \"" + text2 + "\"");
        }
        if (Character.isUpperCase(register)) {
            Object object2 = this.getRegister(Character.toLowerCase(register));
            if (object2 == null || (object2 = ((Register)object2).getRawText()) == null) {
                object2 = "";
            }
            object = (String)object2 + text2;
        } else {
            object = text2;
        }
        String textToStore = object;
        Register reg = new Register(register, selectionType, textToStore, new ArrayList());
        this.saveRegister(register, reg);
        if (register == '/') {
            VimInjectorKt.getInjector().getSearchGroup().setLastSearchPattern(text2);
        }
        return true;
    }

    @Override
    public boolean storeText(char register, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.storeText(register, text2, SelectionType.CHARACTER_WISE);
    }

    private final SelectionType guessSelectionType(String text2) {
        return StringsKt.endsWith$default((String)text2, (String)"\n", (boolean)false, (int)2, null) ? SelectionType.LINE_WISE : SelectionType.CHARACTER_WISE;
    }

    private final Register refreshClipboardRegister(char r) {
        Register register;
        char c = r;
        if (c == '*') {
            register = this.refreshPrimaryRegister();
        } else if (c == '+') {
            register = this.refreshClipboardRegister();
        } else {
            throw new RuntimeException("Clipboard register expected, got " + r);
        }
        return register;
    }

    @Override
    public boolean isPrimaryRegisterSupported() {
        return System.getenv("DISPLAY") != null && VimInjectorKt.getInjector().getSystemInfoService().isXWindow();
    }

    private final void setSystemPrimaryRegisterText(String text2, String rawText, List<? extends Object> transferableData) {
        logger.trace("Setting text: " + text2 + " to primary selection...");
        if (this.isPrimaryRegisterSupported()) {
            try {
                VimInjectorKt.getInjector().getClipboardManager().setPrimaryText(text2, rawText, transferableData);
            }
            catch (Exception e) {
                logger.warn("False positive X11 primary selection support");
                logger.trace("Setting text to primary selection failed. Setting it to clipboard selection instead");
                this.setSystemClipboardRegisterText(text2, rawText, transferableData);
            }
        } else {
            logger.trace("X11 primary selection is not supporting. Setting clipboard selection instead");
            this.setSystemClipboardRegisterText(text2, rawText, transferableData);
        }
    }

    private final void setSystemClipboardRegisterText(String text2, String rawText, List<? extends Object> transferableData) {
        VimInjectorKt.getInjector().getClipboardManager().setClipboardText(text2, rawText, transferableData);
    }

    private final Register refreshPrimaryRegister() {
        logger.trace("Syncing cached primary selection value..");
        if (!this.isPrimaryRegisterSupported()) {
            logger.trace("X11 primary selection is not supported. Syncing clipboard selection..");
            return this.refreshClipboardRegister();
        }
        try {
            Register register;
            List transferableData;
            Pair<String, List<Object>> pair = VimInjectorKt.getInjector().getClipboardManager().getPrimaryTextAndTransferableData();
            if (pair == null) {
                return null;
            }
            Pair<String, List<Object>> clipboardData = pair;
            Register currentRegister = this.myRegisters.get(Character.valueOf('*'));
            String text2 = (String)clipboardData.getFirst();
            List list = (List)clipboardData.getSecond();
            List list2 = transferableData = list != null ? CollectionsKt.toMutableList((Collection)list) : null;
            if (currentRegister != null && Intrinsics.areEqual((Object)text2, (Object)currentRegister.getText())) {
                return currentRegister;
            }
            List list3 = transferableData;
            if (list3 != null) {
                List it = list3;
                boolean bl = false;
                register = new Register('*', this.guessSelectionType(text2), text2, it);
            } else {
                register = null;
            }
            return register;
        }
        catch (Exception e) {
            logger.warn("False positive X11 primary selection support");
            logger.trace("Syncing primary selection failed. Syncing clipboard selection instead");
            return this.refreshClipboardRegister();
        }
    }

    private final Register refreshClipboardRegister() {
        Register register;
        List transferableData;
        char systemAwareClipboardRegister = this.isPrimaryRegisterSupported() ? (char)'+' : '*';
        Pair<String, List<Object>> pair = VimInjectorKt.getInjector().getClipboardManager().getClipboardTextAndTransferableData();
        if (pair == null) {
            return null;
        }
        Pair<String, List<Object>> clipboardData = pair;
        Register currentRegister = this.myRegisters.get(Character.valueOf(systemAwareClipboardRegister));
        String text2 = (String)clipboardData.getFirst();
        List list = (List)clipboardData.getSecond();
        List list2 = transferableData = list != null ? CollectionsKt.toMutableList((Collection)list) : null;
        if (currentRegister != null && Intrinsics.areEqual((Object)text2, (Object)currentRegister.getText())) {
            return currentRegister;
        }
        List list3 = transferableData;
        if (list3 != null) {
            List it = list3;
            boolean bl = false;
            register = new Register(systemAwareClipboardRegister, this.guessSelectionType(text2), text2, it);
        } else {
            register = null;
        }
        return register;
    }

    @Override
    @Nullable
    public Register getRegister(char r) {
        char myR = r;
        if (Character.isUpperCase(myR)) {
            myR = Character.toLowerCase(myR);
        }
        return StringsKt.indexOf$default((CharSequence)"+*", (char)myR, (int)0, (boolean)false, (int)6, null) >= 0 ? this.refreshClipboardRegister(myR) : this.myRegisters.get(Character.valueOf(myR));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Register> getRegisters() {
        void $this$mapNotNullTo$iv$iv;
        CharSequence $this$filterNotTo$iv$iv;
        void $this$filterNotTo$iv$iv2;
        Collection<Register> collection = this.myRegisters.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filterNot$iv = collection;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
            Register it = (Register)element$iv$iv;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)"+*", (char)it.getName(), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredRegisters = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        String $this$filterNot$iv2 = "+*";
        boolean $i$f$filterNot2 = false;
        destination$iv$iv = $this$filterNot$iv2;
        Object destination$iv$iv2 = new StringBuilder();
        boolean $i$f$filterNotTo2 = false;
        for (int element$iv$iv = 0; element$iv$iv < $this$filterNotTo$iv$iv.length(); ++element$iv$iv) {
            char element$iv$iv2;
            char it = element$iv$iv2 = $this$filterNotTo$iv$iv.charAt(element$iv$iv);
            boolean bl = false;
            if (it == '+' && !this.isPrimaryRegisterSupported()) continue;
            destination$iv$iv2.append(element$iv$iv2);
        }
        String string = ((StringBuilder)destination$iv$iv2).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        CharSequence $this$mapNotNull$iv = string;
        boolean $i$f$mapNotNull = false;
        $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv$iv$iv.length(); ++i) {
            Register it$iv$iv;
            char element$iv$iv$iv;
            char element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv.charAt(i);
            boolean bl = false;
            char it = element$iv$iv;
            boolean bl2 = false;
            if (this.refreshClipboardRegister(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List clipboardRegisters = (List)destination$iv$iv2;
        return CollectionsKt.sortedWith((Iterable)CollectionsKt.plus((Collection)filteredRegisters, (Iterable)clipboardRegisters), (Comparator)Register.KeySorter.INSTANCE);
    }

    @Override
    public void saveRegister(char r, @NotNull Register register) {
        Intrinsics.checkNotNullParameter((Object)register, (String)"register");
        int myR = Character.isUpperCase((char)r) ? Character.toLowerCase((char)r) : r;
        String text2 = register.getText();
        String rawText = register.getRawText();
        if (StringsKt.indexOf$default((CharSequence)"+*", (char)myR, (int)0, (boolean)false, (int)6, null) >= 0 && text2 != null && rawText != null) {
            int n = myR;
            if (n == 43) {
                if (!this.isPrimaryRegisterSupported()) {
                    myR = 42;
                }
                this.setSystemClipboardRegisterText(text2, rawText, new ArrayList(register.getTransferableData()));
            } else if (n == 42) {
                this.setSystemPrimaryRegisterText(text2, rawText, new ArrayList(register.getTransferableData()));
            }
        }
        Character c = Character.valueOf((char)myR);
        ((Map)this.myRegisters).put(c, register);
    }

    @Override
    public boolean startRecording(char register) {
        boolean bl;
        if (StringsKt.indexOf$default((CharSequence)"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\"", (char)register, (int)0, (boolean)false, (int)6, null) != -1) {
            this.setRecordRegister(Character.valueOf(register));
            this.recordList = new ArrayList();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @Nullable
    public Register getPlaybackRegister(char r) {
        return StringsKt.indexOf$default((CharSequence)"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\"\"+*.", (char)r, (int)0, (boolean)false, (int)6, null) != 0 ? this.getRegister(r) : null;
    }

    @Override
    public void recordText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List<KeyStroke> myRecordList = this.recordList;
        if (this.isRecording() && myRecordList != null) {
            myRecordList.addAll((Collection<KeyStroke>)VimInjectorKt.getInjector().getParser().stringToKeys(text2));
        }
    }

    @Override
    public void setKeys(char register, @NotNull List<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Character c = Character.valueOf(register);
        ((Map)this.myRegisters).put(c, new Register(register, SelectionType.CHARACTER_WISE, CollectionsKt.toMutableList((Collection)keys)));
    }

    @Override
    public void setKeys(char register, @NotNull List<? extends KeyStroke> keys, @NotNull SelectionType type) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Character c = Character.valueOf(register);
        ((Map)this.myRegisters).put(c, new Register(register, type, CollectionsKt.toMutableList((Collection)keys)));
    }

    @Override
    public void finishRecording() {
        Character register = this.getRecordRegister();
        if (register != null) {
            List<KeyStroke> myRecordList;
            Register reg = null;
            if (Character.isUpperCase(register.charValue())) {
                reg = this.getRegister(register.charValue());
            }
            if ((myRecordList = this.recordList) != null) {
                if (reg == null) {
                    reg = new Register(Character.toLowerCase(register.charValue()), SelectionType.CHARACTER_WISE, myRecordList);
                    ((Map)this.myRegisters).put(Character.valueOf(Character.toLowerCase(register.charValue())), reg);
                } else {
                    reg.addKeys(myRecordList);
                }
            }
        }
        this.setRecordRegister(null);
    }

    @Override
    public char getCurrentRegisterForMulticaret() {
        return (char)(this.isRegisterSpecifiedExplicitly() || !this.isSystemClipboard(this.getCurrentRegister()) ? this.getCurrentRegister() : 34);
    }

    @Override
    public boolean isSystemClipboard(char register) {
        return register == '+' || register == '*';
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(VimRegisterGroupBase.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/register/VimRegisterGroupBase$Companion;", "", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLogger", "()Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

