/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.put;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.MutableVimEditor;
import com.maddyhome.idea.vim.api.VimApplication;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimCaretKt;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimMarkServiceKt;
import com.maddyhome.idea.vim.api.VimMotionGroup;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.Offset;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.common.VimRangeKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.group.visual.VimSelection;
import com.maddyhome.idea.vim.helper.RWLockLabel;
import com.maddyhome.idea.vim.put.ProcessedTextData;
import com.maddyhome.idea.vim.put.PutData;
import com.maddyhome.idea.vim.put.VimPasteProvider;
import com.maddyhome.idea.vim.put.VimPut;
import com.maddyhome.idea.vim.put.VimPutBase;
import com.maddyhome.idea.vim.put.VimPutBaseKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000 :2\u00020\u0001:\u0001:B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J2\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J(\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J@\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0011H\u0004JB\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140!2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0005J\u001c\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002JD\u0010(\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020'H\u0003J8\u0010)\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J<\u0010+\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020'2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0017Jd\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0-2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0011H\u0002Jd\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0-2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0011H\u0002J8\u00104\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u0011H\u0017Jd\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0-2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0011H\u0002Jd\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0-2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0011H\u0002J\u0010\u00108\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020'H\u0002J \u00109\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020'H\u0002\u00a8\u0006;"}, d2={"Lcom/maddyhome/idea/vim/put/VimPutBase;", "Lcom/maddyhome/idea/vim/put/VimPut;", "()V", "collectPreModificationData", "", "", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "data", "Lcom/maddyhome/idea/vim/put/PutData;", "deleteSelectedText", "Lcom/maddyhome/idea/vim/api/VimCaret;", "caret", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "saveToRegister", "", "", "doIndent", "", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "startOffset", "endOffset", "getMaxSegmentLength", "text", "moveCaretToEndPosition", "typeInRegister", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "modeInEditor", "caretAfterInsertedText", "prepareDocumentAndGetStartOffsets", "", "vimEditor", "vimCaret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "additionalData", "processText", "Lcom/maddyhome/idea/vim/put/ProcessedTextData;", "putForCaret", "putText", "updateVisualMarks", "putTextAndSetCaretPosition", "putTextBlockwise", "Lkotlin/Pair;", "type", "mode", "count", "indent", "cursorAfter", "putTextCharacterwise", "putTextForCaret", "modifyRegister", "putTextInternal", "putTextLinewise", "wasTextInsertedLineWise", "wrapInsertedTextWithVisualMarks", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimPutBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimPutBase.kt\ncom/maddyhome/idea/vim/put/VimPutBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,594:1\n1054#2:595\n1855#2,2:596\n1549#2:598\n1620#2,3:599\n1855#2,2:602\n1054#2:604\n*S KotlinDebug\n*F\n+ 1 VimPutBase.kt\ncom/maddyhome/idea/vim/put/VimPutBase\n*L\n122#1:595\n123#1:596,2\n426#1:598\n426#1:599,3\n502#1:602,2\n564#1:604\n*E\n"})
public abstract class VimPutBase
implements VimPut {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<VimLogger> logger$delegate = LazyKt.lazy((Function0)Companion.logger.2.INSTANCE);

    @Override
    @RWLockLabel.SelfSynchronized
    public boolean putText(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull PutData data, @NotNull OperatorArguments operatorArguments, boolean updateVisualMarks, boolean saveToRegister) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        Map<String, Object> additionalData = this.collectPreModificationData(editor, data);
        this.deleteSelectedText(editor, data, operatorArguments, saveToRegister);
        ProcessedTextData processedTextData = this.processText(null, data);
        if (processedTextData == null) {
            return false;
        }
        ProcessedTextData processedText = processedTextData;
        this.putTextAndSetCaretPosition(editor, context, processedText, data, additionalData);
        if (updateVisualMarks) {
            this.wrapInsertedTextWithVisualMarks(editor.currentCaret(), data, processedText);
        }
        return true;
    }

    private final Map<String, Object> collectPreModificationData(VimEditor editor, PutData data) {
        Map map;
        if (data.getVisualSelection() != null && ModeExtensionsKt.isBlock(data.getVisualSelection().getTypeInEditor())) {
            VimSelection vimSelection = (VimSelection)MapsKt.getValue(data.getVisualSelection().getCaretsAndSelections(), (Object)editor.primaryCaret());
            BufferPosition selStart = editor.offsetToBufferPosition(vimSelection.getVimStart());
            BufferPosition selEnd = editor.offsetToBufferPosition(vimSelection.getVimEnd());
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"startColumnOfSelection", (Object)Math.min(selStart.getColumn(), selEnd.getColumn())), TuplesKt.to((Object)"selectedLines", (Object)Math.abs(selStart.getLine() - selEnd.getLine())), TuplesKt.to((Object)"firstSelectedLine", (Object)Math.min(selStart.getLine(), selEnd.getLine()))};
            map = MapsKt.mapOf((Pair[])pairArray);
        } else {
            map = new LinkedHashMap();
        }
        return map;
    }

    private final boolean wasTextInsertedLineWise(ProcessedTextData text2) {
        return text2.getTypeInRegister() == SelectionType.LINE_WISE;
    }

    private final void wrapInsertedTextWithVisualMarks(VimCaret caret, PutData data, ProcessedTextData text2) {
        Object object = data.getTextData();
        if (object == null || (object = ((PutData.TextData)object).getRawText()) == null) {
            return;
        }
        int textLength = ((String)object).length();
        Object object2 = data.getVisualSelection();
        if (object2 == null || (object2 = ((PutData.VisualSelection)object2).getCaretsAndSelections()) == null) {
            return;
        }
        Object caretsAndSelections = object2;
        VimSelection vimSelection = (VimSelection)caretsAndSelections.get(caret);
        if (vimSelection == null) {
            Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull((Iterable)caretsAndSelections.entrySet());
            vimSelection = entry != null ? (VimSelection)entry.getValue() : null;
            if (vimSelection == null) {
                return;
            }
        }
        VimSelection selection = vimSelection;
        int leftIndex = Math.min(selection.getVimStart(), selection.getVimEnd());
        int rightIndex = leftIndex + textLength - 1;
        TextRange rangeForMarks = new TextRange(leftIndex, rightIndex);
        VimMarkServiceKt.setVisualSelectionMarks(VimInjectorKt.getInjector().getMarkService(), caret, rangeForMarks);
    }

    @RWLockLabel.SelfSynchronized
    private final VimCaret deleteSelectedText(VimEditor editor, VimCaret caret, PutData data, OperatorArguments operatorArguments, boolean saveToRegister) {
        if (data.getVisualSelection() == null) {
            return null;
        }
        if (!caret.isValid()) {
            return null;
        }
        VimSelection vimSelection = data.getVisualSelection().getCaretsAndSelections().get(caret);
        if (vimSelection == null) {
            return null;
        }
        VimSelection selectionForCaret = vimSelection;
        TextRange range = selectionForCaret.toVimTextRange(false).normalize();
        VimInjectorKt.getInjector().getApplication().runWriteAction((Function0)new Function0<Boolean>(editor, caret, range, selectionForCaret, operatorArguments, saveToRegister){
            final /* synthetic */ VimEditor $editor;
            final /* synthetic */ VimCaret $caret;
            final /* synthetic */ TextRange $range;
            final /* synthetic */ VimSelection $selectionForCaret;
            final /* synthetic */ OperatorArguments $operatorArguments;
            final /* synthetic */ boolean $saveToRegister;
            {
                this.$editor = $editor;
                this.$caret = $caret;
                this.$range = $range;
                this.$selectionForCaret = $selectionForCaret;
                this.$operatorArguments = $operatorArguments;
                this.$saveToRegister = $saveToRegister;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return VimInjectorKt.getInjector().getChangeGroup().deleteRange(this.$editor, this.$caret, this.$range, this.$selectionForCaret.getType(), false, this.$operatorArguments, this.$saveToRegister);
            }
        });
        return caret.moveToInlayAwareOffset(range.getStartOffset());
    }

    /*
     * WARNING - void declaration
     */
    @RWLockLabel.SelfSynchronized
    private final void deleteSelectedText(VimEditor editor, PutData data, OperatorArguments operatorArguments, boolean saveToRegister) {
        void $this$forEach$iv;
        if (data.getVisualSelection() == null) {
            return;
        }
        Iterable $this$sortedByDescending$iv = data.getVisualSelection().getCaretsAndSelections().entrySet();
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = ((VimCaret)it.getKey()).getBufferPosition();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((VimCaret)it.getKey()).getBufferPosition());
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            VimCaret caret = (VimCaret)entry.getKey();
            VimSelection selection = (VimSelection)entry.getValue();
            if (!caret.isValid()) continue;
            TextRange range = selection.toVimTextRange(false).normalize();
            VimInjectorKt.getInjector().getApplication().runWriteAction((Function0)new Function0<Boolean>(editor, caret, range, selection, operatorArguments, saveToRegister){
                final /* synthetic */ VimEditor $editor;
                final /* synthetic */ VimCaret $caret;
                final /* synthetic */ TextRange $range;
                final /* synthetic */ VimSelection $selection;
                final /* synthetic */ OperatorArguments $operatorArguments;
                final /* synthetic */ boolean $saveToRegister;
                {
                    this.$editor = $editor;
                    this.$caret = $caret;
                    this.$range = $range;
                    this.$selection = $selection;
                    this.$operatorArguments = $operatorArguments;
                    this.$saveToRegister = $saveToRegister;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return VimInjectorKt.getInjector().getChangeGroup().deleteRange(this.$editor, this.$caret, this.$range, this.$selection.getType(), false, this.$operatorArguments, this.$saveToRegister);
                }
            });
            caret.moveToInlayAwareOffset(range.getStartOffset());
        }
    }

    private final ProcessedTextData processText(VimCaret caret, PutData data) {
        Object object = data.getTextData();
        if (object == null || (object = ((PutData.TextData)object).getRawText()) == null) {
            VimPutBase $this$processText_u24lambda_u242 = this;
            boolean bl = false;
            if (caret == null) {
                return null;
            }
            if (data.getVisualSelection() != null) {
                int offset = caret.getOffset().getPoint();
                VimInjectorKt.getInjector().getMarkService().setMark(caret, '.', offset);
                VimMarkServiceKt.setChangeMarks(VimInjectorKt.getInjector().getMarkService(), caret, new TextRange(offset, offset + 1));
            }
            return null;
        }
        Object text2 = object;
        Object object2 = data.getVisualSelection();
        boolean bl = object2 != null && (object2 = object2.getTypeInEditor()) != null ? ModeExtensionsKt.isLine((SelectionType)((Object)object2)) : false;
        if (bl && ModeExtensionsKt.isChar(data.getTextData().getTypeInRegister())) {
            text2 = (String)text2 + "\n";
        }
        if (ModeExtensionsKt.isLine(data.getTextData().getTypeInRegister()) && ((CharSequence)text2).length() > 0 && StringsKt.last((CharSequence)((CharSequence)text2)) != '\n') {
            text2 = (String)text2 + "\n";
        }
        if (ModeExtensionsKt.isChar(data.getTextData().getTypeInRegister())) {
            Character c = StringsKt.lastOrNull((CharSequence)((CharSequence)text2));
            char c2 = '\n';
            if (c != null && c.charValue() == c2) {
                Object object3 = data.getVisualSelection();
                boolean bl2 = object3 != null && (object3 = object3.getTypeInEditor()) != null ? !ModeExtensionsKt.isLine((SelectionType)((Object)object3)) : false;
                if (bl2) {
                    text2 = StringsKt.dropLast((String)text2, (int)1);
                }
            }
        }
        return new ProcessedTextData((String)text2, data.getTextData().getTypeInRegister(), data.getTextData().getTransferableData(), data.getTextData().getRegisterChar());
    }

    @NotNull
    protected final VimCaret moveCaretToEndPosition(@NotNull VimEditor editor, @NotNull VimCaret caret, int startOffset, int endOffset, @NotNull SelectionType typeInRegister, @NotNull SelectionType modeInEditor, boolean caretAfterInsertedText) {
        VimCaret vimCaret;
        String cursorMode;
        String string;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)((Object)typeInRegister), (String)"typeInRegister");
        Intrinsics.checkNotNullParameter((Object)((Object)modeInEditor), (String)"modeInEditor");
        switch (WhenMappings.$EnumSwitchMapping$0[typeInRegister.ordinal()]) {
            case 2: {
                if (WhenMappings.$EnumSwitchMapping$0[modeInEditor.ordinal()] == 1) {
                    if (caretAfterInsertedText) {
                        string = "postEndOffset";
                        break;
                    }
                    string = "startOffset";
                    break;
                }
                if (caretAfterInsertedText) {
                    string = "preLineEndOfEndOffset";
                    break;
                }
                string = "startOffset";
                break;
            }
            case 1: {
                if (caretAfterInsertedText) {
                    string = "postEndOffset";
                    break;
                }
                string = "startOffsetSkipLeading";
                break;
            }
            case 3: {
                if (WhenMappings.$EnumSwitchMapping$0[modeInEditor.ordinal()] == 1) {
                    if (caretAfterInsertedText) {
                        string = "postEndOffset";
                        break;
                    }
                    string = "startOffset";
                    break;
                }
                if (caretAfterInsertedText) {
                    string = "preLineEndOfEndOffset";
                    break;
                }
                string = "preEndOffset";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        switch (cursorMode = string) {
            case "startOffset": {
                vimCaret = caret.moveToOffset(startOffset);
                break;
            }
            case "preEndOffset": {
                vimCaret = caret.moveToOffset(endOffset - 1);
                break;
            }
            case "startOffsetSkipLeading": {
                VimCaret updated = caret.moveToOffset(startOffset);
                vimCaret = updated.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStartSkipLeading(editor, updated));
                break;
            }
            case "postEndOffset": {
                vimCaret = caret.moveToOffset(endOffset + 1);
                break;
            }
            case "preLineEndOfEndOffset": {
                int rightestPosition = EngineEditorHelperKt.getLineEndForOffset(editor, endOffset - 1);
                if (!(editor.getMode() instanceof Mode.INSERT)) {
                    --rightestPosition;
                }
                int pos = Math.min(endOffset, rightestPosition);
                vimCaret = caret.moveToOffset(pos);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected mode".toString());
            }
        }
        return vimCaret;
    }

    @Override
    public int doIndent(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final Pair<Integer, VimCaret> putTextCharacterwise(VimEditor editor, VimCaret caret, ExecutionContext context, String text2, SelectionType type, SelectionType mode, int startOffset, int count, boolean indent, boolean cursorAfter) {
        VimCaret updatedCaret = caret.moveToOffset(startOffset);
        String insertedText = StringsKt.repeat((CharSequence)text2, (int)count);
        updatedCaret = VimInjectorKt.getInjector().getChangeGroup().insertText(editor, updatedCaret, insertedText);
        int endOffset = indent ? this.doIndent(editor, updatedCaret, context, startOffset, startOffset + insertedText.length()) : startOffset + insertedText.length();
        updatedCaret = this.moveCaretToEndPosition(editor, updatedCaret, startOffset, endOffset, type, mode, cursorAfter);
        return TuplesKt.to((Object)endOffset, (Object)updatedCaret);
    }

    private final Pair<Integer, VimCaret> putTextLinewise(VimEditor editor, VimCaret caret, ExecutionContext context, String text2, SelectionType type, SelectionType mode, int startOffset, int count, boolean indent, boolean cursorAfter) {
        ArrayList<VimCaret> overlappedCarets = new ArrayList<VimCaret>(editor.carets().size());
        for (VimCaret possiblyOverlappedCaret : editor.carets()) {
            if (possiblyOverlappedCaret.getOffset().getPoint() != startOffset || Intrinsics.areEqual((Object)possiblyOverlappedCaret, (Object)caret)) continue;
            VimCaret updated = VimCaretKt.moveToMotion(possiblyOverlappedCaret, VimMotionGroup.getHorizontalMotion$default(VimInjectorKt.getInjector().getMotion(), editor, possiblyOverlappedCaret, 1, true, false, 16, null));
            overlappedCarets.add(updated);
        }
        Pair<Integer, VimCaret> endOffset = this.putTextCharacterwise(editor, caret, context, text2, type, mode, startOffset, count, indent, cursorAfter);
        for (VimCaret overlappedCaret : overlappedCarets) {
            Intrinsics.checkNotNull((Object)overlappedCaret);
            VimCaretKt.moveToMotion(overlappedCaret, VimMotionGroup.getHorizontalMotion$default(VimInjectorKt.getInjector().getMotion(), editor, overlappedCaret, -1, true, false, 16, null));
        }
        return endOffset;
    }

    private final int getMaxSegmentLength(String text2) {
        StringTokenizer tokenizer = new StringTokenizer(text2, "\n");
        int maxLen = 0;
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            maxLen = Math.max(s.length(), maxLen);
        }
        return maxLen;
    }

    private final Pair<Integer, VimCaret> putTextBlockwise(VimEditor editor, VimCaret caret, ExecutionContext context, String text2, SelectionType type, SelectionType mode, int startOffset, int count, boolean indent, boolean cursorAfter) {
        BufferPosition startPosition = editor.offsetToBufferPosition(startOffset);
        int currentColumn = mode == SelectionType.LINE_WISE ? 0 : startPosition.getColumn();
        int currentLine = startPosition.getLine();
        int lineCount = VimPutBaseKt.access$getLineBreakCount(text2) + 1;
        VimCaret updated = caret;
        if (currentLine + lineCount >= editor.nativeLineCount()) {
            int limit = currentLine + lineCount - editor.nativeLineCount();
            for (int i = 0; i < limit; ++i) {
                updated = updated.moveToOffset((int)editor.fileSize());
                updated = VimInjectorKt.getInjector().getChangeGroup().insertText(editor, updated, "\n");
            }
        }
        int maxLen = this.getMaxSegmentLength(text2);
        StringTokenizer tokenizer = new StringTokenizer(text2, "\n");
        int endOffset = startOffset;
        while (tokenizer.hasMoreTokens()) {
            Object segment;
            Object origSegment = segment = tokenizer.nextToken();
            if (((String)segment).length() < maxLen) {
                segment = (String)segment + StringsKt.repeat((CharSequence)" ", (int)(maxLen - ((String)segment).length()));
                if (currentColumn != 0 && currentColumn < EngineEditorHelperKt.lineLength(editor, currentLine)) {
                    origSegment = segment;
                }
            }
            String pad = VimInjectorKt.getInjector().getEngineEditorHelper().pad(editor, context, currentLine, currentColumn);
            int insertOffset = editor.bufferPositionToOffset(new BufferPosition(currentLine, currentColumn, false, 4, null));
            updated = updated.moveToOffset(insertOffset);
            Object object = segment;
            Intrinsics.checkNotNull((Object)object);
            String insertedText = (String)origSegment + StringsKt.repeat((CharSequence)((CharSequence)object), (int)(count - 1));
            updated = VimInjectorKt.getInjector().getChangeGroup().insertText(editor, updated, insertedText);
            endOffset += insertedText.length();
            if (mode == SelectionType.LINE_WISE) {
                updated = updated.moveToOffset(endOffset);
                updated = VimInjectorKt.getInjector().getChangeGroup().insertText(editor, updated, "\n");
                ++endOffset;
            } else if (((CharSequence)pad).length() > 0) {
                updated = updated.moveToOffset(insertOffset);
                updated = VimInjectorKt.getInjector().getChangeGroup().insertText(editor, updated, pad);
                endOffset += pad.length();
            }
            ++currentLine;
        }
        if (indent) {
            endOffset = this.doIndent(editor, updated, context, startOffset, endOffset);
        }
        updated = this.moveCaretToEndPosition(editor, updated, startOffset, endOffset, type, mode, cursorAfter);
        return TuplesKt.to((Object)endOffset, (Object)updated);
    }

    private final Pair<Integer, VimCaret> putTextInternal(VimEditor editor, VimCaret caret, ExecutionContext context, String text2, SelectionType type, SelectionType mode, int startOffset, int count, boolean indent, boolean cursorAfter) {
        Pair<Integer, VimCaret> pair;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 3: {
                pair = this.putTextCharacterwise(editor, caret, context, text2, type, mode, startOffset, count, indent, cursorAfter);
                break;
            }
            case 1: {
                pair = this.putTextLinewise(editor, caret, context, text2, type, mode, startOffset, count, indent, cursorAfter);
                break;
            }
            default: {
                pair = this.putTextBlockwise(editor, caret, context, text2, type, mode, startOffset, count, indent, cursorAfter);
            }
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @RWLockLabel.SelfSynchronized
    @NotNull
    protected final List<Integer> prepareDocumentAndGetStartOffsets(@NotNull VimEditor vimEditor, @NotNull ImmutableVimCaret vimCaret, @NotNull SelectionType typeInRegister, @NotNull PutData data, @NotNull Map<String, ? extends Object> additionalData) {
        List list;
        int line;
        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"vimEditor");
        Intrinsics.checkNotNullParameter((Object)vimCaret, (String)"vimCaret");
        Intrinsics.checkNotNullParameter((Object)((Object)typeInRegister), (String)"typeInRegister");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(additionalData, (String)"additionalData");
        VimApplication application2 = VimInjectorKt.getInjector().getApplication();
        PutData.VisualSelection visualSelection = data.getVisualSelection();
        if (visualSelection != null) {
            Character lastChar;
            List list2;
            if (ModeExtensionsKt.isChar(visualSelection.getTypeInEditor()) && ModeExtensionsKt.isLine(typeInRegister)) {
                application2.runWriteAction((Function0)new Function0<Unit>(vimEditor, vimCaret){
                    final /* synthetic */ VimEditor $vimEditor;
                    final /* synthetic */ ImmutableVimCaret $vimCaret;
                    {
                        this.$vimEditor = $vimEditor;
                        this.$vimCaret = $vimCaret;
                        super(0);
                    }

                    public final void invoke() {
                        VimEditor vimEditor = this.$vimEditor;
                        Intrinsics.checkNotNull((Object)vimEditor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.MutableVimEditor");
                        ((MutableVimEditor)vimEditor).insertText(this.$vimCaret.getOffset(), "\n");
                    }
                });
                list2 = CollectionsKt.listOf((Object)(vimCaret.getOffset().getPoint() + 1));
                return list2;
            }
            if (ModeExtensionsKt.isBlock(visualSelection.getTypeInEditor())) {
                Object object = additionalData.get("firstSelectedLine");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                int firstSelectedLine = (Integer)object;
                Object object2 = additionalData.get("selectedLines");
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                int selectedLines = (Integer)object2;
                Object object3 = additionalData.get("startColumnOfSelection");
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Int");
                int startColumnOfSelection = (Integer)object3;
                int line2 = RangesKt.coerceAtMost((int)(data.getInsertTextBeforeCaret() ? firstSelectedLine : firstSelectedLine + selectedLines), (int)(vimEditor.lineCount() - 1));
                switch (WhenMappings.$EnumSwitchMapping$0[typeInRegister.ordinal()]) {
                    case 1: {
                        if (data.getInsertTextBeforeCaret()) {
                            list2 = CollectionsKt.listOf((Object)vimEditor.getLineStartOffset(line2));
                            return list2;
                        }
                        int pos = EngineEditorHelperKt.getLineEndOffset(vimEditor, line2, true);
                        application2.runWriteAction((Function0)new Function0<Unit>(vimEditor, pos){
                            final /* synthetic */ VimEditor $vimEditor;
                            final /* synthetic */ int $pos;
                            {
                                this.$vimEditor = $vimEditor;
                                this.$pos = $pos;
                                super(0);
                            }

                            public final void invoke() {
                                VimEditor vimEditor = this.$vimEditor;
                                Intrinsics.checkNotNull((Object)vimEditor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.MutableVimEditor");
                                ((MutableVimEditor)vimEditor).insertText(VimRangeKt.getOffset(this.$pos), "\n");
                            }
                        });
                        list2 = CollectionsKt.listOf((Object)(pos + 1));
                        return list2;
                    }
                    case 3: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable pos = (Iterable)RangesKt.downTo((int)(firstSelectedLine + selectedLines), (int)firstSelectedLine);
                        boolean $i$f$map = false;
                        void var15_19 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.iterator();
                        while (true) {
                            void it;
                            int item$iv$iv;
                            if (!iterator.hasNext()) {
                                list2 = (List)destination$iv$iv;
                                return list2;
                            }
                            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(vimEditor.bufferPositionToOffset(new BufferPosition((int)it, startColumnOfSelection, false, 4, null)));
                        }
                    }
                    case 2: {
                        list2 = CollectionsKt.listOf((Object)vimEditor.bufferPositionToOffset(new BufferPosition(firstSelectedLine, startColumnOfSelection, false, 4, null)));
                        return list2;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            if (!ModeExtensionsKt.isLine(visualSelection.getTypeInEditor())) {
                list2 = CollectionsKt.listOf((Object)vimCaret.getOffset().getPoint());
                return list2;
            }
            Character c = lastChar = vimEditor.fileSize() > 0L ? Character.valueOf(EngineEditorHelperKt.getText(vimEditor, new TextRange((int)vimEditor.fileSize() - 1, (int)vimEditor.fileSize())).charAt(0)) : null;
            if (vimCaret.getOffset().getPoint() == (int)vimEditor.fileSize() && (int)vimEditor.fileSize() != 0) {
                Character c2 = lastChar;
                char selectedLines = '\n';
                if (c2 == null || c2.charValue() != selectedLines) {
                    application2.runWriteAction((Function0)new Function0<Unit>(vimEditor, vimCaret){
                        final /* synthetic */ VimEditor $vimEditor;
                        final /* synthetic */ ImmutableVimCaret $vimCaret;
                        {
                            this.$vimEditor = $vimEditor;
                            this.$vimCaret = $vimCaret;
                            super(0);
                        }

                        public final void invoke() {
                            VimEditor vimEditor = this.$vimEditor;
                            Intrinsics.checkNotNull((Object)vimEditor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.MutableVimEditor");
                            ((MutableVimEditor)vimEditor).insertText(this.$vimCaret.getOffset(), "\n");
                        }
                    });
                    list2 = CollectionsKt.listOf((Object)(vimCaret.getOffset().getPoint() + 1));
                    return list2;
                }
            }
            list2 = CollectionsKt.listOf((Object)vimCaret.getOffset().getPoint());
            return list2;
        }
        if (data.getInsertTextBeforeCaret()) {
            List list3;
            if (WhenMappings.$EnumSwitchMapping$0[typeInRegister.ordinal()] == 1) {
                list3 = CollectionsKt.listOf((Object)VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStart(vimEditor, vimCaret));
                return list3;
            }
            list3 = CollectionsKt.listOf((Object)vimCaret.getOffset().getPoint());
            return list3;
        }
        Ref.IntRef startOffset = new Ref.IntRef();
        int n = line = data.getPutToLine() < 0 ? vimCaret.getBufferPosition().getLine() : data.getPutToLine();
        if (WhenMappings.$EnumSwitchMapping$0[typeInRegister.ordinal()] == 1) {
            startOffset.element = Math.min(vimEditor.text().length(), VimInjectorKt.getInjector().getMotion().moveCaretToLineEnd(vimEditor, line, true) + 1);
            if (startOffset.element > 0 && vimEditor.getDocument().getOffsetGuard(new Offset(startOffset.element)) != null) {
                application2.runWriteAction((Function0)new Function0<Unit>(vimEditor, startOffset){
                    final /* synthetic */ VimEditor $vimEditor;
                    final /* synthetic */ Ref.IntRef $startOffset;
                    {
                        this.$vimEditor = $vimEditor;
                        this.$startOffset = $startOffset;
                        super(0);
                    }

                    public final void invoke() {
                        VimEditor vimEditor = this.$vimEditor;
                        Intrinsics.checkNotNull((Object)vimEditor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.MutableVimEditor");
                        ((MutableVimEditor)vimEditor).insertText(VimRangeKt.getOffset(this.$startOffset.element - 1), "\n");
                    }
                });
            }
            if (startOffset.element > 0 && startOffset.element == vimEditor.text().length() && vimEditor.text().charAt(startOffset.element - 1) != '\n') {
                application2.runWriteAction((Function0)new Function0<Unit>(vimEditor, startOffset){
                    final /* synthetic */ VimEditor $vimEditor;
                    final /* synthetic */ Ref.IntRef $startOffset;
                    {
                        this.$vimEditor = $vimEditor;
                        this.$startOffset = $startOffset;
                        super(0);
                    }

                    public final void invoke() {
                        VimEditor vimEditor = this.$vimEditor;
                        Intrinsics.checkNotNull((Object)vimEditor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.MutableVimEditor");
                        ((MutableVimEditor)vimEditor).insertText(VimRangeKt.getOffset(this.$startOffset.element), "\n");
                    }
                });
                int n2 = startOffset.element;
                startOffset.element = n2 + 1;
            }
        } else {
            startOffset.element = vimCaret.getOffset().getPoint();
            if (!EngineEditorHelperKt.isLineEmpty(vimEditor, line, false)) {
                int n3 = startOffset.element;
                startOffset.element = n3 + 1;
            }
        }
        if (startOffset.element > vimEditor.text().length()) {
            list = CollectionsKt.listOf((Object)vimEditor.text().length());
            return list;
        }
        list = CollectionsKt.listOf((Object)startOffset.element);
        return list;
    }

    @RWLockLabel.SelfSynchronized
    private final VimCaret putForCaret(VimEditor editor, VimCaret caret, PutData data, Map<String, ? extends Object> additionalData, ExecutionContext context, ProcessedTextData text2) {
        VimCaret updated = null;
        updated = caret;
        this.notifyAboutIdeaPut(editor);
        Object object = data.getVisualSelection();
        boolean bl = object != null && (object = object.getTypeInEditor()) != null ? ModeExtensionsKt.isLine((SelectionType)((Object)object)) : false;
        if (bl && editor.isOneLineMode()) {
            return updated;
        }
        List<Integer> startOffsets = this.prepareDocumentAndGetStartOffsets(editor, updated, text2.getTypeInRegister(), data, additionalData);
        Iterable $this$forEach$iv = startOffsets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimCaret updatedCaret;
            int startOffset = ((Number)element$iv).intValue();
            boolean bl2 = false;
            Object object2 = data.getVisualSelection();
            if (object2 == null || (object2 = object2.getTypeInEditor()) == null) {
                object2 = SelectionType.CHARACTER_WISE;
            }
            Object subMode = object2;
            Pair<Integer, VimCaret> pair = this.putTextInternal(editor, updated, context, text2.getText(), text2.getTypeInRegister(), (SelectionType)((Object)subMode), startOffset, data.getCount(), data.getIndent(), data.getCaretAfterInsertedText());
            int endOffset = ((Number)pair.component1()).intValue();
            updated = updatedCaret = (VimCaret)pair.component2();
            VimMarkServiceKt.setChangeMarks(VimInjectorKt.getInjector().getMarkService(), updatedCaret, new TextRange(startOffset, endOffset));
            updated = this.moveCaretToEndPosition(editor, updatedCaret, startOffset, endOffset, text2.getTypeInRegister(), (SelectionType)((Object)subMode), data.getCaretAfterInsertedText());
        }
        return updated;
    }

    @Override
    @RWLockLabel.SelfSynchronized
    public boolean putTextForCaret(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull PutData data, boolean updateVisualMarks, boolean modifyRegister) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Map<String, Object> additionalData = this.collectPreModificationData(editor, data);
        VimCaret currentCaret = null;
        currentCaret = caret;
        PutData.VisualSelection visualSelection = data.getVisualSelection();
        if (visualSelection != null) {
            PutData.VisualSelection it = visualSelection;
            boolean bl = false;
            VimCaret vimCaret = this.deleteSelectedText(editor, caret, data, new OperatorArguments(false, 0, editor.getMode()), modifyRegister);
            if (vimCaret == null) {
                return false;
            }
            currentCaret = vimCaret;
        }
        ProcessedTextData processedTextData = this.processText(currentCaret, data);
        if (processedTextData == null) {
            return false;
        }
        ProcessedTextData processedText = processedTextData;
        currentCaret = this.putForCaret(editor, currentCaret, data, additionalData, context, processedText);
        if (updateVisualMarks) {
            this.wrapInsertedTextWithVisualMarks(currentCaret, data, processedText);
        }
        return true;
    }

    @Override
    @RWLockLabel.SelfSynchronized
    public void putTextAndSetCaretPosition(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull ProcessedTextData text2, @NotNull PutData data, @NotNull Map<String, ? extends Object> additionalData) {
        Object object;
        block6: {
            block5: {
                VimPasteProvider idePasteProvider;
                Object subMode;
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter(additionalData, (String)"additionalData");
                PutData.VisualSelection visualSelection = data.getVisualSelection();
                Object object2 = visualSelection;
                if (object2 == null || (object2 = object2.getTypeInEditor()) == null) {
                    object2 = subMode = SelectionType.CHARACTER_WISE;
                }
                if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getClipboard().contains((Object)"ideaput") && (idePasteProvider = this.getProviderForPasteViaIde(editor, text2.getTypeInRegister(), data)) != null) {
                    Companion.getLogger().debug("Perform put via idea paste");
                    this.putTextViaIde(idePasteProvider, editor, context, text2, (SelectionType)((Object)subMode), data, additionalData);
                    return;
                }
                Companion.getLogger().debug("Perform put via plugin");
                object = visualSelection;
                if (object == null || (object = ((PutData.VisualSelection)object).getCaretsAndSelections()) == null || (object = object.keySet()) == null) break block5;
                Iterable $this$sortedByDescending$iv = (Iterable)object;
                boolean $i$f$sortedByDescending = false;
                object = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        VimCaret it = (VimCaret)b;
                        boolean bl = false;
                        Comparable comparable = it.getBufferPosition();
                        it = (VimCaret)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getBufferPosition());
                    }
                });
                if (object != null) break block6;
            }
            object = CollectionsKt.reversed((Iterable)editor.sortedNativeCarets());
        }
        Collection<Object> myCarets = object;
        VimInjectorKt.getInjector().getApplication().runWriteAction((Function0)new Function0<Unit>(myCarets, this, editor, data, additionalData, context, text2){
            final /* synthetic */ List<VimCaret> $myCarets;
            final /* synthetic */ VimPutBase this$0;
            final /* synthetic */ VimEditor $editor;
            final /* synthetic */ PutData $data;
            final /* synthetic */ Map<String, Object> $additionalData;
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ ProcessedTextData $text;
            {
                this.$myCarets = $myCarets;
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$data = $data;
                this.$additionalData = $additionalData;
                this.$context = $context;
                this.$text = $text;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                Iterable iterable = this.$myCarets;
                VimPutBase vimPutBase = this.this$0;
                VimEditor vimEditor = this.$editor;
                PutData putData = this.$data;
                Map<String, Object> map = this.$additionalData;
                ExecutionContext executionContext = this.$context;
                ProcessedTextData processedTextData = this.$text;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    VimCaret caret = (VimCaret)element$iv;
                    boolean bl = false;
                    VimPutBase.access$putForCaret(vimPutBase, vimEditor, caret, putData, map, executionContext, processedTextData);
                }
            }
        });
    }

    public static final /* synthetic */ VimCaret access$putForCaret(VimPutBase $this, VimEditor editor, VimCaret caret, PutData data, Map additionalData, ExecutionContext context, ProcessedTextData text2) {
        return $this.putForCaret(editor, caret, data, additionalData, context, text2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/put/VimPutBase$Companion;", "", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLogger", "()Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "logger$delegate", "Lkotlin/Lazy;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimLogger getLogger() {
            Lazy lazy = logger$delegate;
            return (VimLogger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SelectionType.values().length];
            try {
                nArray[SelectionType.LINE_WISE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SelectionType.BLOCK_WISE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SelectionType.CHARACTER_WISE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

