/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.maddyhome.idea.vim.helper.CharacterHelper;
import java.util.Arrays;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0014\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/helper/EngineStringHelper;", "", "()V", "toPrintableCharacter", "", "key", "Ljavax/swing/KeyStroke;", "toPrintableCharacters", "keys", "", "vim-engine"})
public final class EngineStringHelper {
    @NotNull
    public static final EngineStringHelper INSTANCE = new EngineStringHelper();

    private EngineStringHelper() {
    }

    @NotNull
    public final String toPrintableCharacters(@NotNull List<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        if (keys.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (KeyStroke keyStroke : keys) {
            builder.append(EngineStringHelper.toPrintableCharacter(keyStroke));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String toPrintableCharacter(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        char c = key.getKeyChar();
        if (c == '\uffff' && key.getModifiers() == 0) {
            c = (char)key.getKeyCode();
        } else if (c == '\uffff' && (key.getModifiers() & 0x80) != 0) {
            c = (char)(key.getKeyCode() - 65 + 1);
        }
        if (c <= '\u001f') {
            return "^" + (char)(c + 65 - 1);
        }
        if (c == '\u007f') {
            return "^" + (char)(c - 65 + 1);
        }
        if (CharacterHelper.isInvisibleControlCharacter(c) || CharacterHelper.isZeroWidthCharacter(c)) {
            String string = "<%04x>";
            Object[] objectArray = new Object[]{(int)c};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
        return String.valueOf(c);
    }
}

