/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler;

import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimCaretListener;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimFoldRegion;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.command.MotionType;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.handler.Motion;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.helper.StrictMode;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 *2\u00020\u0001:\u0004)*+,B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J0\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0002J(\u0010#\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020$H\u0002J \u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0002J4\u0010'\u001a\u00020 *\u00020(2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0002(-\u00a8\u0006."}, d2={"Lcom/maddyhome/idea/vim/handler/MotionActionHandler;", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "()V", "keepFold", "", "getKeepFold", "()Z", "motionType", "Lcom/maddyhome/idea/vim/command/MotionType;", "getMotionType", "()Lcom/maddyhome/idea/vim/command/MotionType;", "type", "Lcom/maddyhome/idea/vim/command/Command$Type;", "getType", "()Lcom/maddyhome/idea/vim/command/Command$Type;", "baseExecute", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "getHandlerOffset", "Lcom/maddyhome/idea/vim/handler/Motion;", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "moveToAbsoluteOffset", "", "offset", "Lcom/maddyhome/idea/vim/handler/Motion$AbsoluteOffset;", "moveToAdjustedOffset", "Lcom/maddyhome/idea/vim/handler/Motion$AdjustedOffset;", "prepareMoveToAbsoluteOffset", "", "doExecuteForEach", "Lcom/maddyhome/idea/vim/handler/MotionActionHandler$ForEachCaret;", "CaretMergingWatcher", "Companion", "ForEachCaret", "SingleExecution", "Lcom/maddyhome/idea/vim/handler/MotionActionHandler$SingleExecution;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nMotionActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MotionActionHandler.kt\ncom/maddyhome/idea/vim/handler/MotionActionHandler\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,259:1\n38#2:260\n*S KotlinDebug\n*F\n+ 1 MotionActionHandler.kt\ncom/maddyhome/idea/vim/handler/MotionActionHandler\n*L\n256#1:260\n*E\n"})
public abstract class MotionActionHandler
extends EditorActionHandlerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean keepFold;
    @NotNull
    private final Command.Type type = Command.Type.MOTION;
    @NotNull
    private static final VimLogger logger;

    private MotionActionHandler() {
        super(false);
    }

    public boolean getKeepFold() {
        return this.keepFold;
    }

    @NotNull
    public abstract MotionType getMotionType();

    @Override
    @NotNull
    public final Command.Type getType() {
        return this.type;
    }

    @NotNull
    public final Motion getHandlerOffset(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull ExecutionContext context, @Nullable Argument argument, @NotNull OperatorArguments operatorArguments) {
        Motion motion;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        MotionActionHandler motionActionHandler = this;
        if (motionActionHandler instanceof SingleExecution) {
            motion = ((SingleExecution)this).getOffset(editor, context, argument, operatorArguments);
        } else if (motionActionHandler instanceof ForEachCaret) {
            motion = ((ForEachCaret)this).getOffset(editor, caret, context, argument, operatorArguments);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return motion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean baseExecute(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        boolean blockSubmodeActive = EditorExtensionsKt.getInBlockSelection(editor);
        MotionActionHandler motionActionHandler = this;
        if (motionActionHandler instanceof SingleExecution) {
            SingleExecution $this$baseExecute_u24lambda_u240 = (SingleExecution)this;
            boolean bl = false;
            Motion offset = $this$baseExecute_u24lambda_u240.getOffset(editor, context, cmd.getArgument(), operatorArguments);
            Motion motion = offset;
            if (motion instanceof Motion.AdjustedOffset) {
                this.moveToAdjustedOffset(editor, caret, cmd, (Motion.AdjustedOffset)offset);
                return true;
            }
            if (motion instanceof Motion.AbsoluteOffset) {
                this.moveToAbsoluteOffset(editor, caret, cmd, (Motion.AbsoluteOffset)offset);
                return true;
            }
            if (motion instanceof Motion.Error) {
                VimInjectorKt.getInjector().getMessages().indicateError();
                return true;
            }
            if (!(motion instanceof Motion.NoMotion)) return true;
        }
        if (!(motionActionHandler instanceof ForEachCaret)) return true;
        ForEachCaret $this$baseExecute_u24lambda_u241 = (ForEachCaret)this;
        boolean bl = false;
        if (blockSubmodeActive || editor.carets().size() == 1) {
            VimCaret primaryCaret = editor.primaryCaret();
            this.doExecuteForEach($this$baseExecute_u24lambda_u241, editor, primaryCaret, context, cmd, operatorArguments);
            return true;
        }
        try {
            editor.addCaretListener(CaretMergingWatcher.INSTANCE);
            editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)new Function1<VimCaret, Unit>(this, $this$baseExecute_u24lambda_u241, editor, context, cmd, operatorArguments){
                final /* synthetic */ MotionActionHandler this$0;
                final /* synthetic */ ForEachCaret $this_run;
                final /* synthetic */ VimEditor $editor;
                final /* synthetic */ ExecutionContext $context;
                final /* synthetic */ Command $cmd;
                final /* synthetic */ OperatorArguments $operatorArguments;
                {
                    this.this$0 = $receiver;
                    this.$this_run = $receiver2;
                    this.$editor = $editor;
                    this.$context = $context;
                    this.$cmd = $cmd;
                    this.$operatorArguments = $operatorArguments;
                    super(1);
                }

                public final void invoke(@NotNull VimCaret caret) {
                    Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                    MotionActionHandler.access$doExecuteForEach(this.this$0, this.$this_run, this.$editor, caret, this.$context, this.$cmd, this.$operatorArguments);
                }
            }));
            return true;
        }
        finally {
            editor.removeCaretListener(CaretMergingWatcher.INSTANCE);
        }
        return true;
    }

    private final void doExecuteForEach(ForEachCaret $this$doExecuteForEach, VimEditor editor, VimCaret caret, ExecutionContext context, Command cmd, OperatorArguments operatorArguments) {
        Motion offset = $this$doExecuteForEach.getOffset(editor, caret, context, cmd.getArgument(), operatorArguments);
        Motion motion = offset;
        if (motion instanceof Motion.AdjustedOffset) {
            this.moveToAdjustedOffset(editor, caret, cmd, (Motion.AdjustedOffset)offset);
        } else if (motion instanceof Motion.AbsoluteOffset) {
            this.moveToAbsoluteOffset(editor, caret, cmd, (Motion.AbsoluteOffset)offset);
        } else if (motion instanceof Motion.Error) {
            VimInjectorKt.getInjector().getMessages().indicateError();
        } else if (motion instanceof Motion.NoMotion) {
            // empty if block
        }
    }

    private final void moveToAdjustedOffset(VimEditor editor, VimCaret caret, Command cmd, Motion.AdjustedOffset offset) {
        int normalisedOffset;
        if (EditorExtensionsKt.getInBlockSelection(editor)) {
            StrictMode.INSTANCE.assertTrue(caret.isPrimary(), "Block selection mode must only operate on primary caret");
        }
        StrictMode.INSTANCE.assertTrue((normalisedOffset = this.prepareMoveToAbsoluteOffset(editor, cmd, offset)) == offset.getOffset(), "Adjusted offset should be normalised by action");
        caret.setVimLastColumn(offset.getIntendedColumn());
        VimCaret caretAfterMove = caret.moveToOffset(normalisedOffset);
        VimCaret validCaret = EditorExtensionsKt.getInBlockSelection(editor) ? editor.primaryCaret() : caretAfterMove;
        validCaret.setVimLastColumn(offset.getIntendedColumn());
    }

    private final void moveToAbsoluteOffset(VimEditor editor, VimCaret caret, Command cmd, Motion.AbsoluteOffset offset) {
        int normalisedOffset = this.prepareMoveToAbsoluteOffset(editor, cmd, offset);
        caret.moveToOffset(normalisedOffset);
    }

    private final int prepareMoveToAbsoluteOffset(VimEditor editor, Command cmd, Motion.AbsoluteOffset offset) {
        VimFoldRegion foldRegion;
        int resultOffset = offset.getOffset();
        if (resultOffset < 0) {
            logger.error("Offset is less than 0. " + resultOffset + ". " + this.getClass().getName());
        }
        if (cmd.getFlags().contains((Object)CommandFlags.FLAG_SAVE_JUMP)) {
            VimInjectorKt.getInjector().getJumpService().saveJumpLocation(editor);
        }
        if (!EngineHelperKt.isEndAllowed(editor)) {
            resultOffset = EngineEditorHelperKt.normalizeOffset(editor, resultOffset, false);
        }
        if ((foldRegion = editor.getFoldRegionAtOffset(resultOffset)) != null && !foldRegion.isExpanded()) {
            if (this.getKeepFold()) {
                resultOffset = foldRegion.getStartOffset().getPoint();
            } else {
                foldRegion.setExpanded(true);
            }
        }
        return resultOffset;
    }

    public /* synthetic */ MotionActionHandler(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ void access$doExecuteForEach(MotionActionHandler $this, ForEachCaret $receiver, VimEditor editor, VimCaret caret, ExecutionContext context, Command cmd, OperatorArguments operatorArguments) {
        $this.doExecuteForEach($receiver, editor, caret, context, cmd, operatorArguments);
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(MotionActionHandler.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/handler/MotionActionHandler$CaretMergingWatcher;", "Lcom/maddyhome/idea/vim/api/VimCaretListener;", "()V", "caretRemoved", "", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "vim-engine"})
    private static final class CaretMergingWatcher
    implements VimCaretListener {
        @NotNull
        public static final CaretMergingWatcher INSTANCE = new CaretMergingWatcher();

        private CaretMergingWatcher() {
        }

        @Override
        public void caretRemoved(@Nullable ImmutableVimCaret caret) {
            if (caret == null) {
                return;
            }
            VimEditor editor = caret.getEditor();
            ImmutableVimCaret caretToDelete = caret;
            if (EditorExtensionsKt.getInVisualMode(editor)) {
                for (VimCaret vimCaret : editor.carets()) {
                    boolean caretEndBetweenCur;
                    int curCaretStart = vimCaret.getSelectionStart();
                    int curCaretEnd = vimCaret.getSelectionEnd();
                    int n = caretToDelete.getSelectionStart();
                    boolean caretStartBetweenCur = curCaretStart <= n ? n < curCaretEnd : false;
                    int n2 = curCaretStart + 1;
                    int n3 = caretToDelete.getSelectionEnd();
                    boolean bl = n2 <= n3 ? n3 <= curCaretEnd : (caretEndBetweenCur = false);
                    if (!caretStartBetweenCur && !caretEndBetweenCur) continue;
                    int vimSelectionStart = caretToDelete.getVimSelectionStart();
                    vimCaret.setVimSelectionStart(vimSelectionStart);
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/handler/MotionActionHandler$Companion;", "", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLogger", "()Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH&\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/handler/MotionActionHandler$ForEachCaret;", "Lcom/maddyhome/idea/vim/handler/MotionActionHandler;", "()V", "getOffset", "Lcom/maddyhome/idea/vim/handler/Motion;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
    public static abstract class ForEachCaret
    extends MotionActionHandler {
        public ForEachCaret() {
            super(null);
        }

        @NotNull
        public abstract Motion getOffset(@NotNull VimEditor var1, @NotNull ImmutableVimCaret var2, @NotNull ExecutionContext var3, @Nullable Argument var4, @NotNull OperatorArguments var5);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r"}, d2={"Lcom/maddyhome/idea/vim/handler/MotionActionHandler$SingleExecution;", "Lcom/maddyhome/idea/vim/handler/MotionActionHandler;", "()V", "getOffset", "Lcom/maddyhome/idea/vim/handler/Motion;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
    public static abstract class SingleExecution
    extends MotionActionHandler {
        public SingleExecution() {
            super(null);
        }

        @NotNull
        public abstract Motion getOffset(@NotNull VimEditor var1, @NotNull ExecutionContext var2, @Nullable Argument var3, @NotNull OperatorArguments var4);
    }
}

