/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group.visual;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.visual.VimBlockSelection;
import com.maddyhome.idea.vim.group.visual.VimCharacterSelection;
import com.maddyhome.idea.vim.group.visual.VimLineSelection;
import com.maddyhome.idea.vim.group.visual.VimVisualGroupKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0012H&J\b\u0010\u0013\u001a\u00020\u0014H\u0017J\u0012\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u0082\u0001\u0002\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lcom/maddyhome/idea/vim/group/visual/VimSelection;", "", "()V", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getEditor", "()Lcom/maddyhome/idea/vim/api/VimEditor;", "type", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "getType", "()Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "vimEnd", "", "getVimEnd", "()I", "vimStart", "getVimStart", "getNativeStartAndEnd", "Lkotlin/Pair;", "toString", "", "toVimTextRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "skipNewLineForLineMode", "", "Companion", "Lcom/maddyhome/idea/vim/group/visual/VimBlockSelection;", "Lcom/maddyhome/idea/vim/group/visual/VimSimpleSelection;", "vim-engine"})
public abstract class VimSelection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private VimSelection() {
    }

    @NotNull
    public abstract SelectionType getType();

    public abstract int getVimStart();

    public abstract int getVimEnd();

    @NotNull
    protected abstract VimEditor getEditor();

    @NotNull
    public abstract TextRange toVimTextRange(boolean var1);

    public static /* synthetic */ TextRange toVimTextRange$default(VimSelection vimSelection, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toVimTextRange");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return vimSelection.toVimTextRange(bl);
    }

    @NotNull
    public abstract Pair<Integer, Integer> getNativeStartAndEnd();

    @NonNls
    @NotNull
    public String toString() {
        BufferPosition startLogPosition = this.getEditor().offsetToBufferPosition(this.getVimStart());
        BufferPosition endLogPosition = this.getEditor().offsetToBufferPosition(this.getVimEnd());
        return "Selection [" + this.getType() + "]: vim start[offset: " + this.getVimStart() + " : col " + startLogPosition.getColumn() + " line " + startLogPosition.getLine() + "] vim end[offset: " + this.getVimEnd() + " : col " + endLogPosition.getColumn() + " line " + endLogPosition.getLine() + "]";
    }

    public /* synthetic */ VimSelection(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/maddyhome/idea/vim/group/visual/VimSelection$Companion;", "", "()V", "create", "Lcom/maddyhome/idea/vim/group/visual/VimSelection;", "vimStart", "", "vimEnd", "type", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimSelection create(int vimStart, int vimEnd, @NotNull SelectionType type, @NotNull VimEditor editor) {
            VimSelection vimSelection;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    Pair<Integer, Integer> nativeSelection = VimVisualGroupKt.charToNativeSelection(editor, vimStart, vimEnd, new Mode.VISUAL(SelectionType.CHARACTER_WISE, null, 2, null));
                    vimSelection = new VimCharacterSelection(vimStart, vimEnd, ((Number)nativeSelection.getFirst()).intValue(), ((Number)nativeSelection.getSecond()).intValue(), editor);
                    break;
                }
                case 2: {
                    Pair<Integer, Integer> nativeSelection = VimVisualGroupKt.lineToNativeSelection(editor, vimStart, vimEnd);
                    vimSelection = new VimLineSelection(vimStart, vimEnd, ((Number)nativeSelection.getFirst()).intValue(), ((Number)nativeSelection.getSecond()).intValue(), editor);
                    break;
                }
                case 3: {
                    vimSelection = new VimBlockSelection(vimStart, vimEnd, editor, false);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return vimSelection;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SelectionType.values().length];
                try {
                    nArray[SelectionType.CHARACTER_WISE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SelectionType.LINE_WISE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SelectionType.BLOCK_WISE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

