/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group.visual;

import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.common.Pointer;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.visual.VimSimpleSelection;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/maddyhome/idea/vim/group/visual/VimLineSelection;", "Lcom/maddyhome/idea/vim/group/visual/VimSimpleSelection;", "vimStart", "", "vimEnd", "nativeStart", "nativeEnd", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "(IIIILcom/maddyhome/idea/vim/api/VimEditor;)V", "getEditor", "()Lcom/maddyhome/idea/vim/api/VimEditor;", "getNativeEnd", "()I", "getNativeStart", "normNativeEnd", "getNormNativeEnd", "normNativeStart", "getNormNativeStart", "type", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "getType", "()Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "getVimEnd", "getVimStart", "toVimTextRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "skipNewLineForLineMode", "", "vim-engine"})
public final class VimLineSelection
extends VimSimpleSelection {
    private final int vimStart;
    private final int vimEnd;
    private final int nativeStart;
    private final int nativeEnd;
    @NotNull
    private final VimEditor editor;
    private final int normNativeStart;
    private final int normNativeEnd;
    @NotNull
    private final SelectionType type;

    public VimLineSelection(int vimStart, int vimEnd, int nativeStart, int nativeEnd, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(null);
        this.vimStart = vimStart;
        this.vimEnd = vimEnd;
        this.nativeStart = nativeStart;
        this.nativeEnd = nativeEnd;
        this.editor = editor;
        this.normNativeStart = Math.min(this.getNativeStart(), this.getNativeEnd());
        this.normNativeEnd = Math.max(this.getNativeStart(), this.getNativeEnd());
        this.type = SelectionType.LINE_WISE;
    }

    @Override
    public int getVimStart() {
        return this.vimStart;
    }

    @Override
    public int getVimEnd() {
        return this.vimEnd;
    }

    @Override
    public int getNativeStart() {
        return this.nativeStart;
    }

    @Override
    public int getNativeEnd() {
        return this.nativeEnd;
    }

    @Override
    @NotNull
    protected VimEditor getEditor() {
        return this.editor;
    }

    @Override
    public int getNormNativeStart() {
        return this.normNativeStart;
    }

    @Override
    public int getNormNativeEnd() {
        return this.normNativeEnd;
    }

    @Override
    @NotNull
    public SelectionType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public TextRange toVimTextRange(boolean skipNewLineForLineMode) {
        return skipNewLineForLineMode && this.getEditor().fileSize() >= (long)this.getNormNativeEnd() && this.getNormNativeEnd() > 0 && this.getEditor().charAt(new Pointer(this.getNormNativeEnd() - 1)) == '\n' ? new TextRange(this.getNormNativeStart(), RangesKt.coerceAtLeast((int)(this.getNormNativeEnd() - 1), (int)0)) : new TextRange(this.getNormNativeStart(), this.getNormNativeEnd());
    }
}

