/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.ranges;

import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimSearchGroup;
import com.maddyhome.idea.vim.common.Direction;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ranges.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0014J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0007H\u0014J(\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/SearchRange;", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "pattern", "", "offset", "", "move", "", "(Ljava/lang/String;IZ)V", "directions", "", "Lcom/maddyhome/idea/vim/common/Direction;", "patterns", "equals", "other", "", "getRangeLine", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "lastZero", "getSearchOffset", "line", "direction", "hashCode", "setPattern", "", "toString", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nExRanges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExRanges.kt\ncom/maddyhome/idea/vim/ex/ranges/SearchRange\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,354:1\n33#2,4:355\n38#2:359\n*S KotlinDebug\n*F\n+ 1 ExRanges.kt\ncom/maddyhome/idea/vim/ex/ranges/SearchRange\n*L\n236#1:355,4\n347#1:359\n*E\n"})
public final class SearchRange
extends Range {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> patterns;
    @NotNull
    private final List<Direction> directions;
    @NotNull
    private static final VimLogger logger;

    public SearchRange(@NotNull String pattern, int offset, boolean move) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        super(offset, move, null);
        this.patterns = new ArrayList();
        this.directions = new ArrayList();
        this.setPattern(pattern);
    }

    private final void setPattern(String pattern) {
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("pattern=" + pattern);
        }
        StringTokenizer tok = new StringTokenizer(pattern, "\u0000");
        block10: while (tok.hasMoreTokens()) {
            String string;
            int n;
            String pat;
            block19: {
                pat = tok.nextToken();
                String string2 = pat;
                if (string2 == null) break block19;
                int n2 = -1;
                switch (string2.hashCode()) {
                    case 2899: {
                        if (string2.equals("\\/")) {
                            n2 = 1;
                        }
                        break;
                    }
                    case 2915: {
                        if (string2.equals("\\?")) {
                            n2 = 2;
                        }
                        break;
                    }
                    case 2890: {
                        if (string2.equals("\\&")) {
                            n2 = 3;
                        }
                        break;
                    }
                }
                switch (n2) {
                    case 1: {
                        this.patterns.add(VimInjectorKt.getInjector().getSearchGroup().getLastSearchPattern());
                        this.directions.add(Direction.FORWARDS);
                        continue block10;
                    }
                    case 2: {
                        this.patterns.add(VimInjectorKt.getInjector().getSearchGroup().getLastSearchPattern());
                        this.directions.add(Direction.BACKWARDS);
                        continue block10;
                    }
                    case 3: {
                        this.patterns.add(VimInjectorKt.getInjector().getSearchGroup().getLastSubstitutePattern());
                        this.directions.add(Direction.FORWARDS);
                        continue block10;
                    }
                }
            }
            if (pat.charAt(0) == '/') {
                this.directions.add(Direction.FORWARDS);
            } else {
                this.directions.add(Direction.BACKWARDS);
            }
            String string3 = pat;
            Intrinsics.checkNotNull((Object)string3);
            if (StringsKt.last((CharSequence)string3) == pat.charAt(0)) {
                string3 = pat;
                Intrinsics.checkNotNull((Object)string3);
                n = 1;
                int n3 = pat.length() - 1;
                String string4 = string3.substring(n, n3);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            } else {
                string3 = pat;
                Intrinsics.checkNotNull((Object)string3);
                n = 1;
                String string5 = string3.substring(n);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            }
            pat = string;
            this.patterns.add(pat);
        }
    }

    @Override
    protected int getRangeLine(@NotNull VimEditor editor, boolean lastZero) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getRangeLine(editor, editor.currentCaret(), lastZero);
    }

    @Override
    protected int getRangeLine(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, boolean lastZero) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int line = caret.getBufferPosition().getLine();
        int searchOffset = -1;
        int n = this.patterns.size();
        for (int i = 0; i < n; ++i) {
            String pattern = this.patterns.get(i);
            Direction direction = this.directions.get(i);
            int patternOffset = i == this.patterns.size() - 1 ? this.getOffset() : 0;
            searchOffset = this.getSearchOffset(editor, line, direction, lastZero);
            VimSearchGroup vimSearchGroup = VimInjectorKt.getInjector().getSearchGroup();
            String string = pattern;
            Intrinsics.checkNotNull((Object)string);
            searchOffset = vimSearchGroup.processSearchRange(editor, string, patternOffset, searchOffset, direction);
            if (searchOffset == -1) break;
            line = editor.offsetToBufferPosition(searchOffset).getLine();
        }
        return searchOffset != -1 ? line : -1;
    }

    private final int getSearchOffset(VimEditor editor, int line, Direction direction, boolean lastZero) {
        return direction == Direction.FORWARDS && !lastZero ? VimInjectorKt.getInjector().getMotion().moveCaretToLineEnd(editor, line, true) : VimInjectorKt.getInjector().getMotion().moveCaretToLineStart(editor, line);
    }

    @Override
    @NotNull
    public String toString() {
        return "SearchRange[patterns=" + this.patterns + ", " + super.toString() + "]";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.ex.ranges.SearchRange");
        SearchRange cfr_ignored_0 = (SearchRange)other;
        if (!Intrinsics.areEqual(this.patterns, ((SearchRange)other).patterns)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.directions, ((SearchRange)other).directions)) {
            return false;
        }
        if (this.getOffset() != ((SearchRange)other).getOffset()) {
            return false;
        }
        return this.isMove() == ((SearchRange)other).isMove();
    }

    @Override
    public int hashCode() {
        int result = ((Object)this.patterns).hashCode();
        result = 31 * result + ((Object)this.directions).hashCode();
        result = 31 * result + Integer.hashCode(this.getOffset());
        result = 31 * result + Boolean.hashCode(this.isMove());
        return result;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(SearchRange.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/SearchRange$Companion;", "", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

