/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.ranges;

import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0004J\u001e\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010#\u001a\u00020\u0004H\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0004J\u0006\u0010'\u001a\u00020\u0004J\b\u0010(\u001a\u00020)H\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "", "()V", "count", "", "defaultLine", "done", "", "endLine", "ranges", "", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getRanges", "()Ljava/util/List;", "setRanges", "(Ljava/util/List;)V", "startLine", "addRange", "", "range", "", "([Lcom/maddyhome/idea/vim/ex/ranges/Range;)V", "equals", "other", "getCount", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "getFirstLine", "getLine", "getLineRange", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "getTextRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "hashCode", "processRange", "setDefaultLine", "line", "size", "toString", "", "vim-engine"})
public final class Ranges {
    private int startLine;
    private int endLine;
    private int count;
    private int defaultLine = -1;
    private boolean done;
    @NotNull
    private List<Range> ranges = new ArrayList();

    public final void addRange(@NotNull Range[] range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        CollectionsKt.addAll((Collection)this.ranges, (Object[])range);
    }

    public final int size() {
        return this.ranges.size();
    }

    public final void setDefaultLine(int line) {
        this.defaultLine = line;
    }

    public final int getLine(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.processRange(editor);
        return this.endLine;
    }

    public final int getLine(@NotNull VimEditor editor, @NotNull VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        this.processRange(editor, caret);
        return this.endLine;
    }

    public final int getFirstLine(@NotNull VimEditor editor, @NotNull VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        this.processRange(editor, caret);
        return this.startLine;
    }

    public final int getCount(@NotNull VimEditor editor, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return count == -1 ? this.getLine(editor) : count;
    }

    public final int getCount(@NotNull VimEditor editor, @NotNull VimCaret caret, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return count == -1 ? this.getLine(editor, caret) : count;
    }

    @NotNull
    public final LineRange getLineRange(@NotNull VimEditor editor, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.processRange(editor);
        int end = 0;
        int start2 = 0;
        if (count == -1) {
            end = this.endLine;
            start2 = this.startLine;
        } else {
            start2 = this.endLine;
            end = start2 + count - 1;
        }
        return new LineRange(start2, end);
    }

    @NotNull
    public final LineRange getLineRange(@NotNull VimEditor editor, @NotNull VimCaret caret, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        this.processRange(editor, caret);
        return count == -1 ? new LineRange(this.startLine, this.endLine) : new LineRange(this.endLine, this.endLine + count - 1);
    }

    @NotNull
    public final TextRange getTextRange(@NotNull VimEditor editor, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        LineRange lr = this.getLineRange(editor, count);
        int start2 = editor.getLineStartOffset(lr.startLine);
        int end = EngineEditorHelperKt.getLineEndOffset(editor, lr.endLine, true) + 1;
        return new TextRange(start2, Math.min(end, (int)editor.fileSize()));
    }

    @NotNull
    public final TextRange getTextRange(@NotNull VimEditor editor, @NotNull VimCaret caret, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        LineRange lineRange = this.getLineRange(editor, caret, count);
        int start2 = editor.getLineStartOffset(lineRange.startLine);
        int end = EngineEditorHelperKt.getLineEndOffset(editor, lineRange.endLine, true) + 1;
        return new TextRange(start2, Math.min(end, (int)editor.fileSize()));
    }

    private final void processRange(VimEditor editor) {
        if (this.done) {
            return;
        }
        this.endLine = this.startLine = this.defaultLine == -1 ? editor.currentCaret().getBufferPosition().getLine() : this.defaultLine;
        boolean lastZero = false;
        for (Range range : this.ranges) {
            this.startLine = this.endLine;
            this.endLine = range.getLine(editor, lastZero);
            if (range.isMove()) {
                editor.primaryCaret().moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToLineWithSameColumn(editor, this.endLine, editor.primaryCaret()));
            }
            lastZero = this.endLine < 0;
            int n = this.count;
            this.count = n + 1;
        }
        if (this.count == 1) {
            this.startLine = this.endLine;
        }
        this.done = true;
    }

    private final void processRange(VimEditor editor, VimCaret caret) {
        this.endLine = this.startLine = this.defaultLine == -1 ? caret.getBufferPosition().getLine() : this.defaultLine;
        boolean lastZero = false;
        for (Range range : this.ranges) {
            this.startLine = this.endLine;
            this.endLine = range.getLine(editor, caret, lastZero);
            if (range.isMove()) {
                caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToLineWithSameColumn(editor, this.endLine, editor.primaryCaret()));
            }
            lastZero = this.endLine < 0;
            ++this.count;
        }
        if (this.count == 1) {
            this.startLine = this.endLine;
        }
        this.count = 0;
    }

    @NonNls
    @NotNull
    public String toString() {
        return "Ranges[ranges=" + this.ranges + "]";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Ranges)) {
            return false;
        }
        if (this.startLine != ((Ranges)other).startLine) {
            return false;
        }
        if (this.endLine != ((Ranges)other).endLine) {
            return false;
        }
        if (this.count != ((Ranges)other).count) {
            return false;
        }
        if (this.defaultLine != ((Ranges)other).defaultLine) {
            return false;
        }
        if (this.done != ((Ranges)other).done) {
            return false;
        }
        return Intrinsics.areEqual(this.ranges, ((Ranges)other).ranges);
    }

    public int hashCode() {
        int result = this.startLine;
        result = 31 * result + this.endLine;
        result = 31 * result + this.count;
        result = 31 * result + this.defaultLine;
        result = 31 * result + Boolean.hashCode(this.done);
        result = 31 * result + ((Object)this.ranges).hashCode();
        return result;
    }

    @NotNull
    public final List<Range> getRanges() {
        return this.ranges;
    }

    public final void setRanges(@NotNull List<Range> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.ranges = list;
    }
}

