/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.command;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ExecutionContextManager;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.MappingProcessor;
import com.maddyhome.idea.vim.command.MappingState;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.impl.state.VimStateMachineImplKt;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.key.KeyMappingLayer;
import com.maddyhome.idea.vim.key.MappingInfoLayer;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.VimStateMachine;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001cH\u0002J.\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J:\u0010!\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#H\u0002J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/maddyhome/idea/vim/command/MappingProcessor;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "()V", "log", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "consumeKey", "", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "mappingCompleted", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "shouldRecord", "Lcom/maddyhome/idea/vim/KeyHandler$MutableBoolean;", "handleAbandonedMappingSequence", "processBuilder", "handleCompleteMappingSequence", "mapping", "Lcom/maddyhome/idea/vim/key/KeyMappingLayer;", "handleUnfinishedMappingSequence", "isMappingDisabledForKey", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "isPluginMapping", "unhandledKeyStrokes", "", "processAbondonedMappingSequence", "", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "processCompleteMappingSequence", "mappingInfo", "Lcom/maddyhome/idea/vim/key/MappingInfoLayer;", "currentMappingInfo", "processUnfinishedMappingSequence", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nMappingProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappingProcessor.kt\ncom/maddyhome/idea/vim/command/MappingProcessor\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,300:1\n27#2,4:301\n33#2,4:305\n33#2,4:309\n38#2:315\n1855#3,2:313\n*S KotlinDebug\n*F\n+ 1 MappingProcessor.kt\ncom/maddyhome/idea/vim/command/MappingProcessor\n*L\n62#1:301,4\n70#1:305,4\n80#1:309,4\n30#1:315\n181#1:313,2\n*E\n"})
public final class MappingProcessor
implements KeyConsumer {
    @NotNull
    public static final MappingProcessor INSTANCE = new MappingProcessor();
    @NotNull
    private static final VimLogger log;

    private MappingProcessor() {
    }

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, boolean mappingCompleted, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder, @NotNull KeyHandler.MutableBoolean shouldRecord) {
        VimLogger vimLogger;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        Intrinsics.checkNotNullParameter((Object)shouldRecord, (String)"shouldRecord");
        if (!allowKeyMappings) {
            return false;
        }
        log.debug("Start processing key mappings.");
        KeyHandlerState keyState = keyProcessResultBuilder.getState();
        VimStateMachine commandState = EngineHelperKt.getVimStateMachine(editor);
        MappingState mappingState = keyState.getMappingState();
        CommandBuilder commandBuilder = keyState.getCommandBuilder();
        if (commandBuilder.isAwaitingCharOrDigraphArgument() || commandBuilder.isBuildingMultiKeyCommand() || this.isMappingDisabledForKey(key, keyState) || commandState.isRegisterPending()) {
            log.debug("Finish key processing, returning false");
            return false;
        }
        mappingState.stopMappingTimer();
        log.trace("Add key to mapping state");
        mappingState.addKey(key);
        MappingMode mappingMode = VimStateMachineImplKt.toMappingMode(editor.getMode());
        KeyMappingLayer mapping = VimInjectorKt.getInjector().getKeyGroup().getKeyMappingLayer(mappingMode);
        VimLogger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("Get keys for mapping mode. mode = " + mappingMode);
        }
        boolean mappingProcessed = this.handleUnfinishedMappingSequence(keyProcessResultBuilder, mapping, mappingCompleted) || this.handleCompleteMappingSequence(keyProcessResultBuilder, mapping, key) || this.handleAbandonedMappingSequence(keyProcessResultBuilder);
        VimLogger $this$debug$iv = log;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("Finish mapping processing. Return " + mappingProcessed);
        }
        return mappingProcessed;
    }

    private final boolean isMappingDisabledForKey(KeyStroke key, KeyHandlerState keyState) {
        boolean isMappingDisabled = key.getKeyChar() == '0' && keyState.getCommandBuilder().getCount() > 0;
        VimLogger $this$debug$iv = log;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("Mapping disabled for key: " + isMappingDisabled);
        }
        return isMappingDisabled;
    }

    private final boolean handleUnfinishedMappingSequence(KeyProcessResult.KeyProcessResultBuilder processBuilder, KeyMappingLayer mapping, boolean mappingCompleted) {
        log.trace("processing unfinished mappings...");
        if (mappingCompleted) {
            log.trace("mapping is already completed. Returning false.");
            return false;
        }
        if (!mapping.isPrefix(processBuilder.getState().getMappingState().getKeys())) {
            log.debug("There are no mappings that start with the current sequence. Returning false.");
            return false;
        }
        processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)handleUnfinishedMappingSequence.1.INSTANCE));
        return true;
    }

    private final void processUnfinishedMappingSequence(VimEditor editor, KeyHandlerState keyState) {
        if (VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getTimeout()) {
            log.trace("timeout is set. schedule a mapping timer");
            MappingState mappingState = keyState.getMappingState();
            mappingState.startMappingTimer(arg_0 -> MappingProcessor.processUnfinishedMappingSequence$lambda$3(editor, mappingState, keyState, arg_0));
        }
        log.trace("Unfinished mapping processing finished");
    }

    private final boolean handleCompleteMappingSequence(KeyProcessResult.KeyProcessResultBuilder processBuilder, KeyMappingLayer mapping, KeyStroke key) {
        log.trace("Processing complete mapping sequence...");
        MappingState mappingState = processBuilder.getState().getMappingState();
        MappingInfoLayer currentMappingInfo = mapping.getLayer(mappingState.getKeys());
        Ref.ObjectRef mappingInfo = new Ref.ObjectRef();
        mappingInfo.element = currentMappingInfo;
        if (mappingInfo.element == null) {
            log.trace("Haven't found any mapping info for the given sequence. Trying to apply mapping to a subsequence.");
            ArrayList<KeyStroke> previouslyUnhandledKeySequence = new ArrayList<KeyStroke>();
            Iterable<KeyStroke> $this$forEach$iv = mappingState.getKeys();
            boolean $i$f$forEach = false;
            Iterator<KeyStroke> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                KeyStroke element$iv;
                KeyStroke e = element$iv = iterator.next();
                boolean bl = false;
                previouslyUnhandledKeySequence.add(e);
            }
            if (previouslyUnhandledKeySequence.size() > 1) {
                previouslyUnhandledKeySequence.remove(previouslyUnhandledKeySequence.size() - 1);
                mappingInfo.element = mapping.getLayer((Iterable<? extends KeyStroke>)previouslyUnhandledKeySequence);
            }
        }
        if (mappingInfo.element == null) {
            log.trace("Cannot find any mapping info for the sequence. Return false.");
            return false;
        }
        processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)new Function3<KeyHandlerState, VimEditor, ExecutionContext, Unit>(key, (Ref.ObjectRef<MappingInfoLayer>)mappingInfo, currentMappingInfo){
            final /* synthetic */ KeyStroke $key;
            final /* synthetic */ Ref.ObjectRef<MappingInfoLayer> $mappingInfo;
            final /* synthetic */ MappingInfoLayer $currentMappingInfo;
            {
                this.$key = $key;
                this.$mappingInfo = $mappingInfo;
                this.$currentMappingInfo = $currentMappingInfo;
                super(3);
            }

            public final void invoke(@NotNull KeyHandlerState b, @NotNull VimEditor c, @NotNull ExecutionContext d) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                MappingProcessor.access$processCompleteMappingSequence(MappingProcessor.INSTANCE, this.$key, b, c, d, (MappingInfoLayer)this.$mappingInfo.element, this.$currentMappingInfo);
            }
        }));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processCompleteMappingSequence(KeyStroke key, KeyHandlerState keyState, VimEditor editor, ExecutionContext context, MappingInfoLayer mappingInfo, MappingInfoLayer currentMappingInfo) {
        MappingState mappingState = keyState.getMappingState();
        mappingState.resetMappingSequence();
        ExecutionContext currentContext = context.updateEditor(editor);
        log.trace("Executing mapping info");
        try {
            mappingState.startMapExecution();
            mappingInfo.execute(editor, context, keyState);
        }
        catch (Exception e) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, e.getMessage());
            VimInjectorKt.getInjector().getMessages().indicateError();
            log.error(StringsKt.trimIndent((String)("\n                Caught exception during " + mappingInfo.getPresentableString() + "\n                " + e.getMessage() + "\n        ")), e);
        }
        catch (NotImplementedError e) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, e.getMessage());
            VimInjectorKt.getInjector().getMessages().indicateError();
            log.error(StringsKt.trimIndent((String)("\n                 Caught exception during " + mappingInfo.getPresentableString() + "\n                 " + e.getMessage() + "\n        ")), e);
        }
        finally {
            mappingState.stopMapExecution();
        }
        if (mappingInfo != currentMappingInfo) {
            log.trace("Evaluating the current key");
            KeyHandler.Companion.getInstance().handleKey(editor, key, currentContext, true, false, keyState);
        }
        log.trace("Success processing of mapping");
    }

    private final boolean handleAbandonedMappingSequence(KeyProcessResult.KeyProcessResultBuilder processBuilder) {
        log.debug("Processing abandoned mapping sequence");
        List<KeyStroke> unhandledKeyStrokes = processBuilder.getState().getMappingState().detachKeys();
        if (unhandledKeyStrokes.size() == 1) {
            log.trace("There is only one key in mapping. Return false.");
            return false;
        }
        processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)new Function3<KeyHandlerState, VimEditor, ExecutionContext, Unit>(unhandledKeyStrokes){
            final /* synthetic */ List<KeyStroke> $unhandledKeyStrokes;
            {
                this.$unhandledKeyStrokes = $unhandledKeyStrokes;
                super(3);
            }

            public final void invoke(@NotNull KeyHandlerState lambdaKeyState, @NotNull VimEditor lambdaEditor, @NotNull ExecutionContext lambdaContext) {
                Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
                Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
                Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
                MappingProcessor.access$processAbondonedMappingSequence(MappingProcessor.INSTANCE, this.$unhandledKeyStrokes, lambdaEditor, lambdaContext, lambdaKeyState);
            }
        }));
        return true;
    }

    private final void processAbondonedMappingSequence(List<? extends KeyStroke> unhandledKeyStrokes, VimEditor editor, ExecutionContext context, KeyHandlerState keyState) {
        if (this.isPluginMapping(unhandledKeyStrokes)) {
            log.trace("This is a plugin mapping, process it");
            KeyHandler.Companion.getInstance().handleKey(editor, unhandledKeyStrokes.get(unhandledKeyStrokes.size() - 1), context, true, false, keyState);
        } else {
            log.trace("Process abandoned keys.");
            KeyHandler.Companion.getInstance().handleKey(editor, unhandledKeyStrokes.get(0), context, false, false, keyState);
            for (KeyStroke keyStroke : unhandledKeyStrokes.subList(1, unhandledKeyStrokes.size())) {
                KeyHandler.Companion.getInstance().handleKey(editor, keyStroke, context, true, false, keyState);
            }
        }
        log.trace("Return true from abandoned keys processing.");
    }

    private final boolean isPluginMapping(List<? extends KeyStroke> unhandledKeyStrokes) {
        return !((Collection)unhandledKeyStrokes).isEmpty() && Intrinsics.areEqual((Object)unhandledKeyStrokes.get(0), (Object)VimInjectorKt.getInjector().getParser().getPlugKeyStroke());
    }

    private static final void processUnfinishedMappingSequence$lambda$3(VimEditor $editor, MappingState $mappingState, KeyHandlerState $keyState, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$mappingState, (String)"$mappingState");
        Intrinsics.checkNotNullParameter((Object)$keyState, (String)"$keyState");
        VimInjectorKt.getInjector().getApplication().invokeLater((Function0<Unit>)((Function0)new Function0<Unit>($mappingState, $editor, $keyState){
            final /* synthetic */ MappingState $mappingState;
            final /* synthetic */ VimEditor $editor;
            final /* synthetic */ KeyHandlerState $keyState;
            {
                this.$mappingState = $mappingState;
                this.$editor = $editor;
                this.$keyState = $keyState;
                super(0);
            }

            public final void invoke() {
                MappingProcessor.access$getLog$p().debug("Delayed mapping timer call");
                List<KeyStroke> unhandledKeys = this.$mappingState.detachKeys();
                if (this.$editor.isDisposed() || MappingProcessor.access$isPluginMapping(MappingProcessor.INSTANCE, unhandledKeys)) {
                    MappingProcessor.access$getLog$p().debug("Abandon mapping timer");
                    return;
                }
                MappingProcessor.access$getLog$p().trace("processing unhandled keys...");
                Iterator<KeyStroke> iterator = unhandledKeys.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int index = n++;
                    KeyStroke keyStroke = iterator.next();
                    boolean lastKeyInSequence = index == CollectionsKt.getLastIndex(unhandledKeys);
                    KeyHandler keyHandler = KeyHandler.Companion.getInstance();
                    keyHandler.handleKey(this.$editor, keyStroke, ExecutionContextManager.onEditor$default(VimInjectorKt.getInjector().getExecutionContextManager(), this.$editor, null, 2, null), true, lastKeyInSequence, this.$keyState);
                }
            }
        }), $editor);
    }

    public static final /* synthetic */ void access$processUnfinishedMappingSequence(MappingProcessor $this, VimEditor editor, KeyHandlerState keyState) {
        $this.processUnfinishedMappingSequence(editor, keyState);
    }

    public static final /* synthetic */ void access$processCompleteMappingSequence(MappingProcessor $this, KeyStroke key, KeyHandlerState keyState, VimEditor editor, ExecutionContext context, MappingInfoLayer mappingInfo, MappingInfoLayer currentMappingInfo) {
        $this.processCompleteMappingSequence(key, keyState, editor, context, mappingInfo, currentMappingInfo);
    }

    public static final /* synthetic */ void access$processAbondonedMappingSequence(MappingProcessor $this, List unhandledKeyStrokes, VimEditor editor, ExecutionContext context, KeyHandlerState keyState) {
        $this.processAbondonedMappingSequence(unhandledKeyStrokes, editor, context, keyState);
    }

    public static final /* synthetic */ VimLogger access$getLog$p() {
        return log;
    }

    public static final /* synthetic */ boolean access$isPluginMapping(MappingProcessor $this, List unhandledKeyStrokes) {
        return $this.isPluginMapping(unhandledKeyStrokes);
    }

    static {
        boolean $i$f$vimLogger = false;
        log = VimInjectorKt.getInjector().getLogger(MappingProcessor.class);
    }
}

