/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.LineDeleteShift;
import com.maddyhome.idea.vim.api.MutableVimEditor;
import com.maddyhome.idea.vim.api.NativeAction;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimCaretKt;
import com.maddyhome.idea.vim.api.VimChangeGroup;
import com.maddyhome.idea.vim.api.VimDocument;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimKeyGroup;
import com.maddyhome.idea.vim.api.VimMarkService;
import com.maddyhome.idea.vim.api.VimMarkServiceKt;
import com.maddyhome.idea.vim.api.VimMotionGroup;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.ChangesListener;
import com.maddyhome.idea.vim.common.Offset;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.common.VimRangeKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.group.visual.VimSelection;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.handler.Motion;
import com.maddyhome.idea.vim.helper.CharacterHelper;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.helper.StrictMode;
import com.maddyhome.idea.vim.listener.SelectionVimListenerSuppressor;
import com.maddyhome.idea.vim.listener.VimListenerSuppressor;
import com.maddyhome.idea.vim.register.VimRegisterGroup;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.VimStateMachine;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014\b&\u0018\u0000 u2\u00020\u0001:\u0002uvB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J(\u0010$\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J0\u0010&\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010\"\u001a\u00020#H\u0016J8\u0010+\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J0\u00102\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0016J(\u00104\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J0\u00105\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0016J8\u00107\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u00108\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0002J0\u00109\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010,\u001a\u00020-2\u0006\u00106\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0016J(\u0010:\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016JB\u0010;\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00103\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010<\u001a\u00020\u0006H\u0016J<\u0010=\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010<\u001a\u00020\u0006H\u0004JF\u0010>\u001a\u0010\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020/\u0018\u00010?2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020@2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u00103\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0016J \u0010A\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010B\u001a\u00020CH\u0016J\u0018\u0010D\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010E\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010F\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010G\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010H\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016J \u0010I\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010J\u001a\u00020\u000bH\u0014J \u0010K\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010J\u001a\u00020\u000bH\u0002J(\u0010L\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010M\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0016J(\u0010N\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0016J(\u0010N\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010S\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020RH\u0016J \u0010N\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010T\u001a\u00020\u00062\u0006\u0010U\u001a\u00020VH\u0002J \u0010W\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020\u000bH\u0016J,\u0010X\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020[0ZH\u0016J\u0018\u0010\\\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010]\u001a\u00020\u0004H\u0016J\u0018\u0010^\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016J\"\u0010_\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010`\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010a\u001a\u00020\u001e2\u0006\u0010b\u001a\u00020cH\u0016J \u0010d\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010a\u001a\u00020\u001e2\u0006\u0010b\u001a\u00020cH\u0016J \u0010e\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010f\u001a\u00020CH\u0016J\u0010\u0010g\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010h\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J0\u0010i\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010j\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0016J(\u0010k\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0014J0\u0010l\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010O\u001a\u00020\u000b2\u0006\u0010m\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020RH\u0016J\u0018\u0010n\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010o\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016J \u0010p\u001a\u0002012\u0006\u0010q\u001a\u00020\u000b2\u0006\u0010r\u001a\u00020\u000b2\u0006\u0010s\u001a\u00020\u0006H\u0016J\b\u0010t\u001a\u000201H\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00178\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00198\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006w"}, d2={"Lcom/maddyhome/idea/vim/api/VimChangeGroupBase;", "Lcom/maddyhome/idea/vim/api/VimChangeGroup;", "()V", "lastInsert", "Lcom/maddyhome/idea/vim/command/Command;", "lastLower", "", "lastStrokes", "", "", "oldOffset", "", "repeatAppend", "repeatCharsCount", "repeatColumn", "repeatLines", "strokes", "tabAction", "getTabAction", "()Z", "setTabAction", "(Z)V", "vimDocument", "Lcom/maddyhome/idea/vim/api/VimDocument;", "vimDocumentListener", "Lcom/maddyhome/idea/vim/common/ChangesListener;", "activeTemplateWithLeftRightMotion", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "keyStroke", "Ljavax/swing/KeyStroke;", "changeCharacters", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "changeEndOfLine", "count", "changeMotion", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "changeRange", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "type", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "clearStrokes", "", "deleteCharacter", "isChange", "deleteEndOfLine", "deleteJoinLines", "spaces", "deleteJoinNLines", "startLine", "deleteJoinRange", "deleteLine", "deleteRange", "saveToRegister", "deleteText", "getDeleteRangeAndType", "Lkotlin/Pair;", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "initInsert", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "insertAfterCursor", "insertAfterLineEnd", "insertBeforeCursor", "insertBeforeFirstNonBlank", "insertLineStart", "insertNewLineAbove", "col", "insertNewLineBelow", "insertPreviousInsert", "exit", "insertText", "start", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "str", "", "offset", "isPrintableChar", "c", "", "joinViaIdeaByCount", "joinViaIdeaBySelections", "caretsAndSelections", "", "Lcom/maddyhome/idea/vim/group/visual/VimSelection;", "processCommand", "cmd", "processEnter", "processEscape", "processKey", "key", "processResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "processKeyInSelectMode", "processPostChangeModeSwitch", "toSwitch", "processSingleCommand", "removeLastNewLine", "repeatInsert", "started", "repeatInsertText", "replaceText", "end", "runEnterAboveAction", "runEnterAction", "setInsertRepeat", "lines", "column", "append", "updateLastInsertedTextRegister", "Companion", "VimChangesListener", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimChangeGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimChangeGroupBase.kt\ncom/maddyhome/idea/vim/api/VimChangeGroupBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1319:1\n766#2:1320\n857#2,2:1321\n1855#2,2:1323\n1747#2,3:1329\n1855#2,2:1334\n33#3,4:1325\n38#3:1336\n215#4,2:1332\n*S KotlinDebug\n*F\n+ 1 VimChangeGroupBase.kt\ncom/maddyhome/idea/vim/api/VimChangeGroupBase\n*L\n667#1:1320\n667#1:1321,2\n668#1:1323,2\n793#1:1329,3\n849#1:1334,2\n721#1:1325,4\n1281#1:1336\n837#1:1332,2\n*E\n"})
public abstract class VimChangeGroupBase
implements VimChangeGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int repeatLines;
    private int repeatColumn;
    private boolean repeatAppend;
    @JvmField
    @NotNull
    protected final List<Object> strokes = new ArrayList();
    @JvmField
    protected int repeatCharsCount;
    @JvmField
    @Nullable
    protected List<Object> lastStrokes;
    @JvmField
    protected int oldOffset = -1;
    private boolean tabAction;
    @JvmField
    @Nullable
    protected ChangesListener vimDocumentListener;
    @JvmField
    protected boolean lastLower = true;
    @JvmField
    @Nullable
    protected VimDocument vimDocument;
    @JvmField
    @Nullable
    protected Command lastInsert;
    private static final int MAX_REPEAT_CHARS_COUNT = 10000;
    @NotNull
    private static final VimLogger logger;
    @NotNull
    public static final String HEX_START = "0x";
    @NotNull
    public static final String VIM_MOTION_BIG_WORD_RIGHT = "VimMotionBigWordRightAction";
    @NotNull
    public static final String VIM_MOTION_WORD_RIGHT = "VimMotionWordRightAction";
    @NotNull
    public static final String VIM_MOTION_CAMEL_RIGHT = "VimMotionCamelRightAction";
    @NotNull
    public static final String VIM_MOTION_WORD_END_RIGHT = "VimMotionWordEndRightAction";
    @NotNull
    public static final String VIM_MOTION_BIG_WORD_END_RIGHT = "VimMotionBigWordEndRightAction";
    @NotNull
    public static final String VIM_MOTION_CAMEL_END_RIGHT = "VimMotionCamelEndRightAction";
    @NotNull
    public static final String MAX_HEX_INTEGER = "ffffffffffffffff";
    @NotNull
    private static final Set<String> wordMotions;

    public final boolean getTabAction() {
        return this.tabAction;
    }

    public final void setTabAction(boolean bl) {
        this.tabAction = bl;
    }

    @Override
    public void setInsertRepeat(int lines, int column, boolean append) {
        this.repeatLines = lines;
        this.repeatColumn = column;
        this.repeatAppend = append;
    }

    @Override
    public boolean deleteCharacter(@NotNull VimEditor editor, @NotNull VimCaret caret, int count, boolean isChange, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        Motion endOffset = VimMotionGroup.getHorizontalMotion$default(VimInjectorKt.getInjector().getMotion(), editor, caret, count, true, false, 16, null);
        if (endOffset instanceof Motion.AbsoluteOffset) {
            boolean res2 = VimChangeGroupBase.deleteText$default(this, editor, new TextRange(caret.getOffset().getPoint(), ((Motion.AbsoluteOffset)endOffset).getOffset()), SelectionType.CHARACTER_WISE, caret, operatorArguments, false, 32, null);
            int pos = caret.getOffset().getPoint();
            int norm = EngineEditorHelperKt.normalizeOffset(editor, caret.getBufferPosition().getLine(), pos, isChange);
            if (norm != pos || editor.offsetToVisualPosition(norm) != VimInjectorKt.getInjector().getEngineEditorHelper().inlayAwareOffsetToVisualPosition(editor, norm)) {
                caret.moveToOffset(norm);
            }
            int offset = EngineEditorHelperKt.normalizeOffset(editor, caret.getBufferPosition().getLine(), caret.getOffset().getPoint(), isChange);
            caret.moveToOffset(offset);
            return res2;
        }
        return false;
    }

    protected final boolean deleteText(@NotNull VimEditor editor, @NotNull TextRange range, @Nullable SelectionType type, @NotNull VimCaret caret, @NotNull OperatorArguments operatorArguments, boolean saveToRegister) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        TextRange updatedRange = range;
        if (!range.normalize((int)editor.fileSize())) {
            if (range.getStartOffset() != range.getEndOffset() || range.getStartOffset() != (int)editor.fileSize() || range.getStartOffset() == 0) {
                return false;
            }
            updatedRange = new TextRange(range.getStartOffset() - 1, range.getEndOffset());
        }
        Mode mode = operatorArguments.getMode();
        if (type == null || Intrinsics.areEqual((Object)mode, (Object)Mode.INSERT.INSTANCE) || Intrinsics.areEqual((Object)mode, (Object)Mode.REPLACE.INSTANCE) || !saveToRegister || caret.getRegisterStorage().storeText(editor, updatedRange, type, true)) {
            int[] startOffsets = updatedRange.getStartOffsets();
            int[] endOffsets = updatedRange.getEndOffsets();
            for (int i = updatedRange.size() - 1; -1 < i; --i) {
                Pair<Pair<Offset, Offset>, LineDeleteShift> pair = editor.search((Pair<Offset, Offset>)TuplesKt.to((Object)VimRangeKt.getOffset(startOffsets[i]), (Object)VimRangeKt.getOffset(endOffsets[i])), editor, LineDeleteShift.NL_ON_END);
                if (pair == null) continue;
                Pair newRange = (Pair)pair.component1();
                editor.deleteString(new TextRange(((Offset)newRange.getFirst()).getPoint(), ((Offset)newRange.getSecond()).getPoint()));
            }
            if (type != null) {
                int start2 = updatedRange.getStartOffset();
                VimInjectorKt.getInjector().getMarkService().setMark(caret, '.', start2);
                VimMarkServiceKt.setChangeMarks(VimInjectorKt.getInjector().getMarkService(), caret, new TextRange(start2, start2 + 1));
            }
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean deleteText$default(VimChangeGroupBase vimChangeGroupBase, VimEditor vimEditor, TextRange textRange, SelectionType selectionType, VimCaret vimCaret, OperatorArguments operatorArguments, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deleteText");
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return vimChangeGroupBase.deleteText(vimEditor, textRange, selectionType, vimCaret, operatorArguments, bl);
    }

    @Override
    @NotNull
    public VimCaret insertText(@NotNull VimEditor editor, @NotNull VimCaret caret, int offset, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ((MutableVimEditor)editor).insertText(new Offset(offset), str);
        VimCaret newCaret = caret.moveToInlayAwareOffset(offset + str.length());
        VimInjectorKt.getInjector().getMarkService().setMark(newCaret, '.', offset);
        return newCaret;
    }

    @Override
    @NotNull
    public VimCaret insertText(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.insertText(editor, caret, caret.getOffset().getPoint(), str);
    }

    public void insertText(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull BufferPosition start2, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.insertText(editor, caret, editor.bufferPositionToOffset(start2), str);
    }

    protected void repeatInsertText(@NotNull VimEditor editor, @NotNull ExecutionContext context, int count, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        List<Object> list = this.lastStrokes;
        if (list == null) {
            return;
        }
        List<Object> myLastStrokes = list;
        for (VimCaret caret : editor.nativeCarets()) {
            for (int i = 0; i < count; ++i) {
                for (Object lastStroke : myLastStrokes) {
                    Object object = lastStroke;
                    if (object instanceof NativeAction) {
                        VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, (NativeAction)lastStroke, context);
                        this.strokes.add(lastStroke);
                        continue;
                    }
                    if (object instanceof EditorActionHandlerBase) {
                        VimInjectorKt.getInjector().getActionExecutor().executeVimAction(editor, (EditorActionHandlerBase)lastStroke, context, operatorArguments);
                        this.strokes.add(lastStroke);
                        continue;
                    }
                    if (object instanceof char[]) {
                        this.insertText(editor, caret, new String((char[])lastStroke));
                        continue;
                    }
                    throw new RuntimeException("Unexpected stroke type: " + lastStroke.getClass() + " " + lastStroke);
                }
            }
        }
    }

    @Override
    public void repeatInsert(@NotNull VimEditor editor, @NotNull ExecutionContext context, int count, boolean started, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        for (VimCaret caret : editor.nativeCarets()) {
            if (this.repeatLines > 0) {
                int visualLine = caret.getVisualPosition().getLine();
                int bufferLine = caret.getBufferPosition().getLine();
                int position = editor.bufferPositionToOffset(new BufferPosition(bufferLine, this.repeatColumn, false));
                int n = this.repeatLines;
                for (int i = 0; i < n; ++i) {
                    int updatedCount;
                    String pad;
                    if (this.repeatAppend && this.repeatColumn < 9999 && EngineEditorHelperKt.getVisualLineLength(editor, visualLine + i) < this.repeatColumn && ((CharSequence)(pad = VimInjectorKt.getInjector().getEngineEditorHelper().pad(editor, context, bufferLine + i, this.repeatColumn))).length() > 0) {
                        int offset = editor.getLineEndOffset(bufferLine + i);
                        this.insertText(editor, caret, offset, pad);
                    }
                    int n2 = started ? (i == 0 ? count : count + 1) : (updatedCount = count);
                    if (this.repeatColumn >= 9999) {
                        caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToLineEnd(editor, bufferLine + i, true));
                        this.repeatInsertText(editor, context, updatedCount, operatorArguments);
                        continue;
                    }
                    if (EngineEditorHelperKt.getVisualLineLength(editor, visualLine + i) < this.repeatColumn) continue;
                    VimVisualPosition visualPosition = new VimVisualPosition(visualLine + i, this.repeatColumn, false);
                    int inlaysCount = VimInjectorKt.getInjector().getEngineEditorHelper().amountOfInlaysBeforeVisualPosition(editor, visualPosition);
                    caret.moveToVisualPosition(new VimVisualPosition(visualLine + i, this.repeatColumn + inlaysCount, false));
                    this.repeatInsertText(editor, context, updatedCount, operatorArguments);
                }
                caret.moveToOffset(position);
                continue;
            }
            this.repeatInsertText(editor, context, count, operatorArguments);
            Motion position = VimMotionGroup.getHorizontalMotion$default(VimInjectorKt.getInjector().getMotion(), editor, caret, -1, false, false, 16, null);
            VimCaretKt.moveToMotion(caret, position);
        }
        this.repeatLines = 0;
        this.repeatColumn = 0;
        this.repeatAppend = false;
    }

    @Override
    public void insertBeforeCursor(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.initInsert(editor, context, Mode.INSERT.INSTANCE);
    }

    @Override
    public void insertAfterLineEnd(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        for (VimCaret caret : editor.nativeCarets()) {
            caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineEnd(editor, caret));
        }
        this.initInsert(editor, context, Mode.INSERT.INSTANCE);
    }

    @Override
    public void insertAfterCursor(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        for (VimCaret caret : editor.nativeCarets()) {
            VimCaretKt.moveToMotion(caret, VimMotionGroup.getHorizontalMotion$default(VimInjectorKt.getInjector().getMotion(), editor, caret, 1, true, false, 16, null));
        }
        this.initInsert(editor, context, Mode.INSERT.INSTANCE);
    }

    @Override
    public void insertLineStart(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        for (VimCaret caret : editor.nativeCarets()) {
            caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStart(editor, caret));
        }
        this.initInsert(editor, context, Mode.INSERT.INSTANCE);
    }

    @Override
    public void insertBeforeFirstNonBlank(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        for (VimCaret caret : editor.nativeCarets()) {
            caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStartSkipLeading(editor, caret));
        }
        this.initInsert(editor, context, Mode.INSERT.INSTANCE);
    }

    @Override
    public void initInsert(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        VimStateMachine state = VimStateMachine.Companion.getInstance(editor);
        for (VimCaret caret : editor.nativeCarets()) {
            caret.setVimInsertStart(editor.createLiveMarker(caret.getOffset(), caret.getOffset()));
            VimInjectorKt.getInjector().getMarkService().setMark(caret, '[', caret.getOffset().getPoint());
        }
        Command cmd = state.getExecutingCommand();
        if (cmd != null && state.isDotRepeatInProgress()) {
            VimStateMachine commandState;
            editor.setMode(mode);
            if (Intrinsics.areEqual((Object)mode, (Object)Mode.REPLACE.INSTANCE)) {
                editor.setInsertMode(false);
            }
            if (cmd.getFlags().contains((Object)CommandFlags.FLAG_NO_REPEAT_INSERT)) {
                commandState = VimStateMachine.Companion.getInstance(editor);
                this.repeatInsert(editor, context, 1, false, new OperatorArguments(false, 1, commandState.getMode()));
            } else {
                commandState = VimStateMachine.Companion.getInstance(editor);
                this.repeatInsert(editor, context, cmd.getCount(), false, new OperatorArguments(false, cmd.getCount(), commandState.getMode()));
            }
            if (Intrinsics.areEqual((Object)mode, (Object)Mode.REPLACE.INSTANCE)) {
                editor.setInsertMode(true);
            }
            editor.setMode(new Mode.NORMAL(null, 1, null));
        } else {
            this.lastInsert = cmd;
            this.strokes.clear();
            this.repeatCharsCount = 0;
            VimDocument myVimDocument = this.vimDocument;
            if (myVimDocument != null && this.vimDocumentListener != null) {
                ChangesListener changesListener = this.vimDocumentListener;
                Intrinsics.checkNotNull((Object)changesListener);
                myVimDocument.removeChangeListener(changesListener);
            }
            this.vimDocument = editor.getDocument();
            VimChangesListener myChangeListener = new VimChangesListener();
            this.vimDocumentListener = myChangeListener;
            VimDocument vimDocument = this.vimDocument;
            Intrinsics.checkNotNull((Object)vimDocument);
            vimDocument.addChangeListener(myChangeListener);
            this.oldOffset = editor.currentCaret().getOffset().getPoint();
            editor.setInsertMode(Intrinsics.areEqual((Object)mode, (Object)Mode.INSERT.INSTANCE));
            editor.setMode(mode);
        }
        this.notifyListeners(editor);
    }

    @Override
    public void runEnterAction(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        NativeAction action2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VimStateMachine state = VimStateMachine.Companion.getInstance(editor);
        if (!state.isDotRepeatInProgress() && (action2 = VimInjectorKt.getInjector().getNativeActionManager().getEnterAction()) != null) {
            this.strokes.add(action2);
            VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, action2, context);
        }
    }

    @Override
    public void runEnterAboveAction(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        NativeAction action2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VimStateMachine state = VimStateMachine.Companion.getInstance(editor);
        if (!state.isDotRepeatInProgress() && (action2 = VimInjectorKt.getInjector().getNativeActionManager().getCreateLineAboveCaret()) != null) {
            this.strokes.add(action2);
            VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, action2, context);
        }
    }

    @Override
    public void insertPreviousInsert(@NotNull VimEditor editor, @NotNull ExecutionContext context, boolean exit, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        this.repeatInsertText(editor, context, 1, operatorArguments);
        if (exit) {
            editor.exitInsertMode(context, operatorArguments);
        }
    }

    @Override
    public void processEscape(@NotNull VimEditor editor, @Nullable ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        int cnt;
        int n;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        VimMarkService markGroup = VimInjectorKt.getInjector().getMarkService();
        markGroup.setMark(editor, '^');
        markGroup.setMark(editor, ']');
        if (VimStateMachine.Companion.getInstance(editor).getMode() instanceof Mode.REPLACE) {
            editor.setInsertMode(true);
        }
        if (this.lastInsert != null) {
            Command command2 = this.lastInsert;
            Intrinsics.checkNotNull((Object)command2);
            n = command2.getCount();
        } else {
            n = cnt = 0;
        }
        if (this.lastInsert != null) {
            Command command3 = this.lastInsert;
            Intrinsics.checkNotNull((Object)command3);
            if (command3.getFlags().contains((Object)CommandFlags.FLAG_NO_REPEAT_INSERT)) {
                cnt = 1;
            }
        }
        if (this.vimDocument != null && this.vimDocumentListener != null) {
            VimDocument vimDocument = this.vimDocument;
            Intrinsics.checkNotNull((Object)vimDocument);
            ChangesListener changesListener = this.vimDocumentListener;
            Intrinsics.checkNotNull((Object)changesListener);
            vimDocument.removeChangeListener(changesListener);
            this.vimDocumentListener = null;
        }
        this.lastStrokes = new ArrayList(this.strokes);
        if (context != null) {
            VimInjectorKt.getInjector().getChangeGroup().repeatInsert(editor, context, cnt == 0 ? 0 : cnt - 1, true, operatorArguments);
        }
        if (VimStateMachine.Companion.getInstance(editor).getMode() instanceof Mode.INSERT) {
            this.updateLastInsertedTextRegister();
        }
        markGroup.setMark(editor, '.');
        editor.setMode(new Mode.NORMAL(null, 1, null));
    }

    private final void updateLastInsertedTextRegister() {
        StringBuilder textToPutRegister = new StringBuilder();
        if (this.lastStrokes != null) {
            List<Object> list = this.lastStrokes;
            Intrinsics.checkNotNull(list);
            for (Object lastStroke : list) {
                if (!(lastStroke instanceof char[])) continue;
                textToPutRegister.append(new String((char[])lastStroke));
            }
        }
        VimRegisterGroup vimRegisterGroup = VimInjectorKt.getInjector().getRegisterGroup();
        String string = textToPutRegister.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        vimRegisterGroup.storeTextSpecial('.', string);
    }

    @Override
    public void processEnter(@NotNull VimEditor editor, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (EngineHelperKt.getVimStateMachine(editor).getMode() instanceof Mode.REPLACE) {
            editor.setInsertMode(true);
        }
        KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        VimKeyGroup vimKeyGroup = VimInjectorKt.getInjector().getKeyGroup();
        Intrinsics.checkNotNull((Object)enterKeyStroke);
        List<NativeAction> actions = vimKeyGroup.getActions(editor, enterKeyStroke);
        for (NativeAction action2 : actions) {
            if (!VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, action2, context)) continue;
        }
        if (EngineHelperKt.getVimStateMachine(editor).getMode() instanceof Mode.REPLACE) {
            editor.setInsertMode(false);
        }
    }

    @Override
    public void processPostChangeModeSwitch(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Mode toSwitch) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)toSwitch, (String)"toSwitch");
        if (Intrinsics.areEqual((Object)toSwitch, (Object)Mode.INSERT.INSTANCE)) {
            this.initInsert(editor, context, Mode.INSERT.INSTANCE);
        }
    }

    @Override
    public void processCommand(@NotNull VimEditor editor, @NotNull Command cmd) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        if (cmd.getFlags().contains((Object)CommandFlags.FLAG_SAVE_STROKE)) {
            this.strokes.add(cmd.getAction());
        } else if (cmd.getFlags().contains((Object)CommandFlags.FLAG_CLEAR_STROKES)) {
            this.clearStrokes(editor);
        }
    }

    @Override
    public void processSingleCommand(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        editor.setMode(new Mode.NORMAL(ModeExtensionsKt.getToReturnTo(editor.getMode())));
        this.clearStrokes(editor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean deleteEndOfLine(@NotNull VimEditor editor, @NotNull VimCaret caret, int count, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int initialOffset = caret.getOffset().getPoint();
        int offset = VimInjectorKt.getInjector().getMotion().moveCaretToRelativeLineEnd(editor, caret, count - 1, true);
        int lineStart = VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStart(editor, caret);
        int startOffset = initialOffset;
        if (offset == initialOffset && offset != lineStart) {
            --startOffset;
        }
        if (offset != -1) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            TextRange rangeToDelete = new TextRange(startOffset, offset);
            Iterable $this$filter$iv = editor.nativeCarets();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VimCaret it = (VimCaret)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)caret) && rangeToDelete.contains(it.getOffset().getPoint()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VimCaret it = (VimCaret)element$iv;
                boolean bl = false;
                editor.removeCaret(it);
            }
            boolean res2 = VimChangeGroupBase.deleteText$default(this, editor, rangeToDelete, SelectionType.CHARACTER_WISE, caret, operatorArguments, false, 32, null);
            if (EngineHelperKt.getUsesVirtualSpace(editor)) {
                caret.moveToOffset(startOffset);
            } else {
                Motion pos = VimMotionGroup.getHorizontalMotion$default(VimInjectorKt.getInjector().getMotion(), editor, caret, -1, false, false, 16, null);
                VimCaretKt.moveToMotion(caret, pos);
            }
            return res2;
        }
        return false;
    }

    @Override
    public boolean deleteJoinLines(@NotNull VimEditor editor, @NotNull VimCaret caret, int count, boolean spaces, @NotNull OperatorArguments operatorArguments) {
        int total;
        int lline;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int myCount = count;
        if (myCount < 2) {
            myCount = 2;
        }
        return (lline = caret.getBufferPosition().getLine()) + myCount > (total = editor.lineCount()) ? false : this.deleteJoinNLines(editor, caret, lline, myCount, spaces, operatorArguments);
    }

    @Override
    public boolean processKey(@NotNull VimEditor editor, @NotNull KeyStroke key, @NotNull KeyProcessResult.KeyProcessResultBuilder processResultBuilder) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)processResultBuilder, (String)"processResultBuilder");
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("processKey(" + key + ")");
        }
        if (key.getKeyChar() != '\uffff') {
            processResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)new Function3<KeyHandlerState, VimEditor, ExecutionContext, Unit>(this, key){
                final /* synthetic */ VimChangeGroupBase this$0;
                final /* synthetic */ KeyStroke $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(3);
                }

                public final void invoke(@NotNull KeyHandlerState keyHandlerState, @NotNull VimEditor lambdaEditor, @NotNull ExecutionContext lambdaContext) {
                    Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
                    Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
                    this.this$0.type(lambdaEditor, lambdaContext, this.$key.getKeyChar());
                }
            }));
            return true;
        }
        if (key.getKeyCode() == 32 && (key.getModifiers() & 0x40) != 0) {
            processResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)new Function3<KeyHandlerState, VimEditor, ExecutionContext, Unit>(this){
                final /* synthetic */ VimChangeGroupBase this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                }

                public final void invoke(@NotNull KeyHandlerState keyHandlerState, @NotNull VimEditor lambdaEditor, @NotNull ExecutionContext lambdaContext) {
                    Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
                    Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
                    this.this$0.type(lambdaEditor, lambdaContext, ' ');
                }
            }));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processKeyInSelectMode(@NotNull VimEditor editor, @NotNull KeyStroke key, @NotNull KeyProcessResult.KeyProcessResultBuilder processResultBuilder) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)processResultBuilder, (String)"processResultBuilder");
        boolean res2 = false;
        Closeable closeable = SelectionVimListenerSuppressor.INSTANCE.lock();
        Throwable throwable = null;
        try {
            VimListenerSuppressor.Locked it = (VimListenerSuppressor.Locked)closeable;
            boolean bl = false;
            res2 = this.processKey(editor, key, processResultBuilder);
            processResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)new Function3<KeyHandlerState, VimEditor, ExecutionContext, Unit>(this, key){
                final /* synthetic */ VimChangeGroupBase this$0;
                final /* synthetic */ KeyStroke $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(3);
                }

                public final void invoke(@NotNull KeyHandlerState keyHandlerState, @NotNull VimEditor lambdaEditor, @NotNull ExecutionContext lambdaContext) {
                    Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
                    Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
                    lambdaEditor.exitSelectModeNative(false);
                    KeyHandler.Companion.getInstance().reset(lambdaEditor);
                    if (VimChangeGroupBase.access$isPrintableChar(this.this$0, this.$key.getKeyChar()) || VimChangeGroupBase.access$activeTemplateWithLeftRightMotion(this.this$0, lambdaEditor, this.$key)) {
                        VimInjectorKt.getInjector().getChangeGroup().insertBeforeCursor(lambdaEditor, lambdaContext);
                    }
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return res2;
    }

    @Override
    public boolean deleteLine(@NotNull VimEditor editor, @NotNull VimCaret caret, int count, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int start2 = VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStart(editor, caret);
        int offset = Math.min(VimInjectorKt.getInjector().getMotion().moveCaretToRelativeLineEnd(editor, caret, count - 1, true) + 1, (int)editor.fileSize());
        if (logger.isDebug()) {
            logger.debug("start=" + start2);
            logger.debug("offset=" + offset);
        }
        if (offset != -1) {
            boolean res2 = VimChangeGroupBase.deleteText$default(this, editor, new TextRange(start2, offset), SelectionType.LINE_WISE, caret, operatorArguments, false, 32, null);
            if (res2 && (long)caret.getOffset().getPoint() >= editor.fileSize() && caret.getOffset().getPoint() != 0) {
                caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToRelativeLineStartSkipLeading(editor, caret, -1));
            }
            return res2;
        }
        return false;
    }

    @Override
    public boolean joinViaIdeaByCount(@NotNull VimEditor editor, @NotNull ExecutionContext context, int count) {
        boolean allowedExecution;
        int executions;
        block5: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            executions = count > 1 ? count - 1 : 1;
            Iterable $this$any$iv = editor.nativeCarets();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    int total;
                    ImmutableVimCaret caret = (ImmutableVimCaret)element$iv;
                    boolean bl2 = false;
                    int lline = caret.getBufferPosition().getLine();
                    if (!(lline + count <= (total = editor.lineCount()))) continue;
                    bl = true;
                    break block5;
                }
                bl = allowedExecution = false;
            }
        }
        if (!allowedExecution) {
            return false;
        }
        for (int i = 0; i < executions; ++i) {
            NativeAction joinLinesAction = VimInjectorKt.getInjector().getNativeActionManager().getJoinLines();
            if (joinLinesAction == null) continue;
            VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, joinLinesAction, context);
        }
        return true;
    }

    @Override
    public boolean deleteJoinRange(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull TextRange range, boolean spaces, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int startLine = editor.offsetToBufferPosition(range.getStartOffset()).getLine();
        int endLine = editor.offsetToBufferPosition(range.getEndOffset()).getLine();
        int count = endLine - startLine + 1;
        if (count < 2) {
            count = 2;
        }
        return this.deleteJoinNLines(editor, caret, startLine, count, spaces, operatorArguments);
    }

    @Override
    public void joinViaIdeaBySelections(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Map<VimCaret, ? extends VimSelection> caretsAndSelections) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(caretsAndSelections, (String)"caretsAndSelections");
        Map<VimCaret, ? extends VimSelection> $this$forEach$iv = caretsAndSelections;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<VimCaret, ? extends VimSelection>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<VimCaret, ? extends VimSelection> element$iv;
            Map.Entry<VimCaret, ? extends VimSelection> entry = element$iv = iterator.next();
            boolean bl = false;
            VimCaret caret = entry.getKey();
            VimSelection range = entry.getValue();
            if (!caret.isValid()) continue;
            Pair<Integer, Integer> pair = range.getNativeStartAndEnd();
            int first = ((Number)pair.component1()).intValue();
            int second = ((Number)pair.component2()).intValue();
            caret.setSelection(VimRangeKt.getOffset(first), VimRangeKt.getOffset(second));
        }
        NativeAction joinLinesAction = VimInjectorKt.getInjector().getNativeActionManager().getJoinLines();
        if (joinLinesAction != null) {
            VimInjectorKt.getInjector().getActionExecutor().executeAction(editor, joinLinesAction, context);
        }
        Iterable $this$forEach$iv2 = editor.nativeCarets();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            VimCaret caret = (VimCaret)element$iv;
            boolean bl = false;
            caret.removeSelection();
            VimVisualPosition vimVisualPosition = caret.getVisualPosition();
            int line = vimVisualPosition.component1();
            int column = vimVisualPosition.component2();
            if (line < 1) continue;
            VimVisualPosition newVisualPosition = new VimVisualPosition(line - 1, column, false);
            caret.moveToVisualPosition(newVisualPosition);
        }
    }

    @Override
    @Nullable
    public Pair<TextRange, SelectionType> getDeleteRangeAndType(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull ExecutionContext context, @NotNull Argument argument, boolean isChange, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        TextRange textRange = VimInjectorKt.getInjector().getMotion().getMotionRange(editor, caret, context, argument, operatorArguments);
        if (textRange == null) {
            return null;
        }
        TextRange range = textRange;
        SelectionType type = argument.getMotion().isLinewiseMotion() ? SelectionType.LINE_WISE : SelectionType.CHARACTER_WISE;
        Command motion = argument.getMotion();
        if (!isChange && !motion.isLinewiseMotion()) {
            BufferPosition start2 = editor.offsetToBufferPosition(range.getStartOffset());
            BufferPosition end = editor.offsetToBufferPosition(range.getEndOffset());
            if (start2.getLine() != end.getLine() && !EngineEditorHelperKt.anyNonWhitespace(editor, range.getStartOffset(), -1) && !EngineEditorHelperKt.anyNonWhitespace(editor, range.getEndOffset(), 1)) {
                type = SelectionType.LINE_WISE;
            }
        }
        return new Pair((Object)range, (Object)type);
    }

    @Override
    public boolean deleteRange(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull TextRange range, @Nullable SelectionType type, boolean isChange, @NotNull OperatorArguments operatorArguments, boolean saveToRegister) {
        VimCaret processedCaret;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int intendedColumn = caret.getVimLastColumn();
        boolean removeLastNewLine = this.removeLastNewLine(editor, range, type);
        boolean res2 = this.deleteText(editor, range, type, caret, operatorArguments, saveToRegister);
        VimCaret vimCaret = (VimCaret)editor.findLastVersionOfCaret((ImmutableVimCaret)caret);
        if (vimCaret == null) {
            vimCaret = processedCaret = caret;
        }
        if (removeLastNewLine) {
            int textLength = (int)editor.fileSize();
            editor.deleteString(new TextRange(textLength - 1, textLength));
            VimCaret vimCaret2 = (VimCaret)editor.findLastVersionOfCaret((ImmutableVimCaret)caret);
            if (vimCaret2 == null) {
                vimCaret2 = processedCaret = caret;
            }
        }
        if (res2) {
            VimCaret vimCaret3;
            int pos = EngineEditorHelperKt.normalizeOffset(editor, range.getStartOffset(), isChange);
            if (type == SelectionType.LINE_WISE) {
                VimCaret updated = processedCaret.setVimLastColumnAndGetCaret(intendedColumn);
                pos = VimInjectorKt.getInjector().getMotion().moveCaretToLineWithStartOfLineOption(editor, editor.offsetToBufferPosition(pos).getLine(), caret);
                vimCaret3 = updated;
            } else {
                vimCaret3 = caret;
            }
            processedCaret = vimCaret3;
            processedCaret = processedCaret.moveToOffset(pos);
            processedCaret.resetLastColumn();
        }
        return res2;
    }

    private final boolean removeLastNewLine(VimEditor editor, TextRange range, SelectionType type) {
        int fileSize;
        int endOffset = range.getEndOffset();
        if (endOffset > (fileSize = (int)editor.fileSize())) {
            StrictMode.INSTANCE.fail("Incorrect offset. File size: " + fileSize + ", offset: " + endOffset);
            endOffset = fileSize;
        }
        return type == SelectionType.LINE_WISE && range.getStartOffset() != 0 && editor.text().charAt(endOffset - 1) != '\n' && endOffset == fileSize;
    }

    @Override
    public boolean changeEndOfLine(@NotNull VimEditor editor, @NotNull VimCaret caret, int count, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        boolean res2 = this.deleteEndOfLine(editor, caret, count, operatorArguments);
        if (res2) {
            caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineEnd(editor, caret));
            editor.setVimChangeActionSwitchMode(Mode.INSERT.INSTANCE);
        }
        return res2;
    }

    @Override
    public boolean changeCharacters(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int count = operatorArguments.getCount1();
        int len = EngineEditorHelperKt.lineLength(editor, editor.primaryCaret().getBufferPosition().getLine());
        int col = caret.getBufferPosition().getColumn();
        if (col + count >= len) {
            return this.changeEndOfLine(editor, caret, 1, operatorArguments);
        }
        boolean res2 = this.deleteCharacter(editor, caret, count, true, operatorArguments);
        if (res2) {
            editor.setVimChangeActionSwitchMode(Mode.INSERT.INSTANCE);
        }
        return res2;
    }

    protected final void clearStrokes(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.strokes.clear();
        this.repeatCharsCount = 0;
        for (VimCaret caret : editor.nativeCarets()) {
            caret.setVimInsertStart(editor.createLiveMarker(caret.getOffset(), caret.getOffset()));
        }
    }

    private final boolean deleteJoinNLines(VimEditor editor, VimCaret caret, int startLine, int count, boolean spaces, OperatorArguments operatorArguments) {
        caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToLineEnd(editor, startLine, true));
        for (int i = 1; i < count; ++i) {
            int trailingWhitespaceStart;
            int start2 = VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineEnd(editor, caret);
            boolean hasTrailingWhitespace = start2 != (trailingWhitespaceStart = VimInjectorKt.getInjector().getMotion().moveCaretToRelativeLineEndSkipTrailing(editor, caret, 0)) + 1;
            caret.moveToOffset(start2);
            int offset = spaces ? VimInjectorKt.getInjector().getMotion().moveCaretToRelativeLineStartSkipLeading(editor, caret, 1) : VimInjectorKt.getInjector().getMotion().moveCaretToLineStart(editor, caret.getBufferPosition().getLine() + 1);
            VimChangeGroupBase.deleteText$default(this, editor, new TextRange(caret.getOffset().getPoint(), offset), null, caret, operatorArguments, false, 32, null);
            if (!spaces || hasTrailingWhitespace) continue;
            this.insertText(editor, caret, " ");
            VimCaretKt.moveToMotion(caret, VimMotionGroup.getHorizontalMotion$default(VimInjectorKt.getInjector().getMotion(), editor, caret, -1, true, false, 16, null));
        }
        return true;
    }

    private final boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    private final boolean activeTemplateWithLeftRightMotion(VimEditor editor, KeyStroke keyStroke) {
        return VimInjectorKt.getInjector().getTemplateManager().getTemplateState(editor) != null && (keyStroke.getKeyCode() == 37 || keyStroke.getKeyCode() == 39);
    }

    @Override
    public void replaceText(@NotNull VimEditor editor, @NotNull VimCaret caret, int start2, int end, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ((MutableVimEditor)editor).replaceString(start2, end, str);
        int newEnd = start2 + str.length();
        VimMarkServiceKt.setChangeMarks(VimInjectorKt.getInjector().getMarkService(), caret, new TextRange(start2, newEnd));
        VimInjectorKt.getInjector().getMarkService().setMark(caret, '.', newEnd);
    }

    protected void insertNewLineAbove(@NotNull VimEditor editor, @NotNull VimCaret caret, int col) {
        Motion motion;
        VimCaret vimCaret;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        if (editor.isOneLineMode()) {
            return;
        }
        boolean firstLiner = false;
        if (caret.getVisualPosition().getLine() == 0) {
            VimCaret newCaret = caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStart(editor, caret));
            firstLiner = true;
            vimCaret = newCaret;
        } else {
            motion = VimInjectorKt.getInjector().getMotion().getVerticalMotionOffset(editor, caret, -1);
            Intrinsics.checkNotNull((Object)motion, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.handler.Motion.AbsoluteOffset");
            VimCaret updated = caret.moveToOffset(((Motion.AbsoluteOffset)motion).getOffset());
            vimCaret = updated.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineEnd(editor, updated));
        }
        VimCaret newCaret = vimCaret;
        editor.setVimChangeActionSwitchMode(Mode.INSERT.INSTANCE);
        newCaret = this.insertText(editor, newCaret, "\n" + editor.createIndentBySize(col));
        if (firstLiner) {
            motion = VimInjectorKt.getInjector().getMotion().getVerticalMotionOffset(editor, newCaret, -1);
            Intrinsics.checkNotNull((Object)motion, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.handler.Motion.AbsoluteOffset");
            newCaret.moveToOffset(((Motion.AbsoluteOffset)motion).getOffset());
        }
    }

    @Override
    public boolean changeMotion(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Argument argument, @NotNull OperatorArguments operatorArguments) {
        int offset;
        boolean bigWord;
        boolean kludge;
        Command motion;
        int count0;
        block23: {
            boolean lastWordChar;
            CharacterHelper.CharacterType charType;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            count0 = operatorArguments.getCount0();
            motion = argument.getMotion();
            String id = motion.getAction().getId();
            kludge = false;
            bigWord = Intrinsics.areEqual((Object)id, (Object)VIM_MOTION_BIG_WORD_RIGHT);
            CharSequence chars = editor.text();
            offset = caret.getOffset().getPoint();
            int fileSize = (int)editor.fileSize();
            if (fileSize <= 0 || offset >= fileSize || (charType = CharacterHelper.charType(editor, chars.charAt(offset), bigWord)) == CharacterHelper.CharacterType.WHITESPACE) break block23;
            boolean bl = lastWordChar = offset >= fileSize - 1 || CharacterHelper.charType(editor, chars.charAt(offset + 1), bigWord) != charType;
            if (wordMotions.contains(id) && lastWordChar && motion.getCount() == 1) {
                boolean res2 = this.deleteCharacter(editor, caret, 1, true, operatorArguments);
                if (res2) {
                    editor.setVimChangeActionSwitchMode(Mode.INSERT.INSTANCE);
                }
                return res2;
            }
            switch (id) {
                case "VimMotionWordRightAction": {
                    kludge = true;
                    motion.setAction(VimInjectorKt.getInjector().getActionExecutor().findVimActionOrDie(VIM_MOTION_WORD_END_RIGHT));
                    break;
                }
                case "VimMotionBigWordRightAction": {
                    kludge = true;
                    motion.setAction(VimInjectorKt.getInjector().getActionExecutor().findVimActionOrDie(VIM_MOTION_BIG_WORD_END_RIGHT));
                    break;
                }
                case "VimMotionCamelRightAction": {
                    kludge = true;
                    motion.setAction(VimInjectorKt.getInjector().getActionExecutor().findVimActionOrDie(VIM_MOTION_CAMEL_END_RIGHT));
                }
            }
        }
        if (kludge) {
            int cnt = operatorArguments.getCount1() * motion.getCount();
            int pos1 = VimInjectorKt.getInjector().getSearchHelper().findNextWordEnd(editor, offset, cnt, bigWord, false);
            int pos2 = VimInjectorKt.getInjector().getSearchHelper().findNextWordEnd(editor, pos1, -cnt, bigWord, false);
            if (logger.isDebug()) {
                logger.debug("pos=" + offset);
                logger.debug("pos1=" + pos1);
                logger.debug("pos2=" + pos2);
                logger.debug("count=" + operatorArguments.getCount1());
                logger.debug("arg.count=" + motion.getCount());
            }
            if (pos2 == offset) {
                if (operatorArguments.getCount1() > 1) {
                    --count0;
                } else if (motion.getCount() > 1) {
                    motion.setCount(motion.getCount() - 1);
                } else {
                    EnumSet<CommandFlags> enumSet = EnumSet.noneOf(CommandFlags.class);
                    Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
                    motion.setFlags(enumSet);
                }
            }
        }
        Pair<TextRange, SelectionType> pair = this.getDeleteRangeAndType(editor, caret, context, argument, true, operatorArguments.withCount0(count0));
        if (pair == null) {
            return false;
        }
        Pair<TextRange, SelectionType> pair2 = pair;
        TextRange first = (TextRange)pair2.component1();
        SelectionType second = (SelectionType)((Object)pair2.component2());
        return this.changeRange(editor, caret, first, second, context, operatorArguments);
    }

    private final void insertNewLineBelow(VimEditor editor, VimCaret caret, int col) {
        if (editor.isOneLineMode()) {
            return;
        }
        VimCaret newCaret = caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineEnd(editor, caret));
        editor.setVimChangeActionSwitchMode(Mode.INSERT.INSTANCE);
        this.insertText(editor, newCaret, "\n" + editor.createIndentBySize(col));
    }

    @Override
    public boolean changeRange(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull TextRange range, @NotNull SelectionType type, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        VimCaret updatedCaret;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int col = 0;
        int lines = 0;
        if (type == SelectionType.BLOCK_WISE) {
            lines = Companion.getLinesCountInVisualBlock(editor, range);
            col = editor.offsetToBufferPosition(range.getStartOffset()).getColumn();
            if (caret.getVimLastColumn() == 9999) {
                col = 9999;
            }
        }
        boolean after = (long)range.getEndOffset() >= editor.fileSize();
        BufferPosition lp = editor.offsetToBufferPosition(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStartSkipLeading(editor, caret));
        boolean res2 = VimChangeGroup.deleteRange$default(this, editor, caret, range, type, true, operatorArguments, false, 64, null);
        VimCaret vimCaret = (VimCaret)editor.findLastVersionOfCaret((ImmutableVimCaret)caret);
        if (vimCaret == null) {
            vimCaret = updatedCaret = caret;
        }
        if (res2) {
            if (type == SelectionType.LINE_WISE) {
                if (editor.fileSize() == 0L) {
                    this.insertBeforeCursor(editor, context);
                } else if (after && !EngineEditorHelperKt.endsWithNewLine(editor)) {
                    this.insertNewLineBelow(editor, updatedCaret, lp.getColumn());
                } else {
                    this.insertNewLineAbove(editor, updatedCaret, lp.getColumn());
                }
            } else {
                if (type == SelectionType.BLOCK_WISE) {
                    this.setInsertRepeat(lines, col, false);
                }
                editor.setVimChangeActionSwitchMode(Mode.INSERT.INSTANCE);
            }
        } else {
            this.insertBeforeCursor(editor, context);
        }
        return true;
    }

    public static final /* synthetic */ boolean access$isPrintableChar(VimChangeGroupBase $this, char c) {
        return $this.isPrintableChar(c);
    }

    public static final /* synthetic */ boolean access$activeTemplateWithLeftRightMotion(VimChangeGroupBase $this, VimEditor editor, KeyStroke keyStroke) {
        return $this.activeTemplateWithLeftRightMotion(editor, keyStroke);
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(VimChangeGroupBase.class);
        Object[] objectArray = new String[]{VIM_MOTION_WORD_RIGHT, VIM_MOTION_BIG_WORD_RIGHT, VIM_MOTION_CAMEL_RIGHT};
        wordMotions = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/maddyhome/idea/vim/api/VimChangeGroupBase$Companion;", "", "()V", "HEX_START", "", "Lorg/jetbrains/annotations/NonNls;", "MAX_HEX_INTEGER", "MAX_REPEAT_CHARS_COUNT", "", "VIM_MOTION_BIG_WORD_END_RIGHT", "VIM_MOTION_BIG_WORD_RIGHT", "VIM_MOTION_CAMEL_END_RIGHT", "VIM_MOTION_CAMEL_RIGHT", "VIM_MOTION_WORD_END_RIGHT", "VIM_MOTION_WORD_RIGHT", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "wordMotions", "", "getWordMotions", "()Ljava/util/Set;", "getLinesCountInVisualBlock", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public final int getLinesCountInVisualBlock(@NotNull VimEditor editor, @NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            int[] startOffsets = range.getStartOffsets();
            if (startOffsets.length == 0) {
                return 0;
            }
            BufferPosition firstStart = editor.offsetToBufferPosition(startOffsets[0]);
            BufferPosition lastStart = editor.offsetToBufferPosition(startOffsets[range.size() - 1]);
            return lastStart.getLine() - firstStart.getLine() + 1;
        }

        @NotNull
        public final Set<String> getWordMotions() {
            return wordMotions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/api/VimChangeGroupBase$VimChangesListener;", "Lcom/maddyhome/idea/vim/common/ChangesListener;", "(Lcom/maddyhome/idea/vim/api/VimChangeGroupBase;)V", "documentChanged", "", "change", "Lcom/maddyhome/idea/vim/common/ChangesListener$Change;", "getAdjustCaretActions", "", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "vim-engine"})
    @SourceDebugExtension(value={"SMAP\nVimChangeGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimChangeGroupBase.kt\ncom/maddyhome/idea/vim/api/VimChangeGroupBase$VimChangesListener\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,1319:1\n107#2:1320\n79#2,22:1321\n107#2:1343\n79#2,22:1344\n*S KotlinDebug\n*F\n+ 1 VimChangeGroupBase.kt\ncom/maddyhome/idea/vim/api/VimChangeGroupBase$VimChangesListener\n*L\n333#1:1320\n333#1:1321,22\n340#1:1343\n340#1:1344,22\n*E\n"})
    protected final class VimChangesListener
    implements ChangesListener {
        @Override
        public void documentChanged(@NotNull ChangesListener.Change change) {
            NativeAction editorDelete;
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            boolean startFound$iv$iv;
            int endIndex$iv$iv;
            int startIndex$iv$iv;
            boolean $i$f$trim;
            CharSequence $this$trim$iv$iv;
            boolean $i$f$trim2;
            String $this$trim$iv;
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            String newFragment = change.getNewFragment();
            String oldFragment = change.getOldFragment();
            int newFragmentLength = newFragment.length();
            int oldFragmentLength = oldFragment.length();
            if (VimChangeGroupBase.this.repeatCharsCount > 10000) {
                return;
            }
            if (StringsKt.startsWith$default((String)newFragment, (String)"\n", (boolean)false, (int)2, null)) {
                $this$trim$iv = newFragment;
                $i$f$trim2 = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) {
                    VimChangeGroupBase.this.strokes.addAll((Collection<Object>)this.getAdjustCaretActions(change));
                    VimChangeGroupBase.this.oldOffset = -1;
                    return;
                }
            }
            if (!VimChangeGroupBase.this.getTabAction() && newFragmentLength > 1) {
                $this$trim$iv = newFragment;
                $i$f$trim2 = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) {
                    return;
                }
            }
            VimChangeGroupBase.this.setTabAction(false);
            VimChangeGroupBase.this.strokes.addAll((Collection<Object>)this.getAdjustCaretActions(change));
            if (oldFragmentLength > 0 && (editorDelete = VimInjectorKt.getInjector().getNativeActionManager().getDeleteAction()) != null) {
                for (int i = 0; i < oldFragmentLength; ++i) {
                    VimChangeGroupBase.this.strokes.add(editorDelete);
                }
            }
            if (newFragmentLength > 0) {
                List<Object> list = VimChangeGroupBase.this.strokes;
                char[] cArray = newFragment.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                list.add(cArray);
            }
            VimChangeGroupBase vimChangeGroupBase = VimChangeGroupBase.this;
            vimChangeGroupBase.repeatCharsCount += newFragmentLength;
            VimChangeGroupBase.this.oldOffset = change.getOffset() + newFragmentLength;
        }

        private final List<EditorActionHandlerBase> getAdjustCaretActions(ChangesListener.Change change) {
            int delta = change.getOffset() - VimChangeGroupBase.this.oldOffset;
            if (VimChangeGroupBase.this.oldOffset >= 0 && delta != 0) {
                List positionCaretActions = new ArrayList();
                String motionName = delta < 0 ? "VimMotionLeftAction" : "VimMotionRightAction";
                EditorActionHandlerBase editorActionHandlerBase = VimInjectorKt.getInjector().getActionExecutor().findVimAction(motionName);
                Intrinsics.checkNotNull((Object)editorActionHandlerBase);
                EditorActionHandlerBase action2 = editorActionHandlerBase;
                int count = Math.abs(delta);
                for (int i = 0; i < count; ++i) {
                    positionCaretActions.add(action2);
                }
                return positionCaretActions;
            }
            return CollectionsKt.emptyList();
        }
    }
}

