/*
 * Decompiled with CFR 0.152.
 */
package fleet.dock.desktop.os;

import fleet.dock.bootstrap.FleetDistributionLayout;
import fleet.dock.impl.WithDockPathsKt;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lfleet/dock/desktop/os/ToolboxInstallationMarker;", "", "<init>", "()V", "log", "Lfleet/util/logging/KLogger;", "mark", "", "layout", "Lfleet/dock/bootstrap/FleetDistributionLayout;", "fleet.dock.desktop"})
@SourceDebugExtension(value={"SMAP\nToolboxInstallationMarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxInstallationMarker.kt\nfleet/dock/desktop/os/ToolboxInstallationMarker\n+ 2 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,30:1\n25#2:31\n*S KotlinDebug\n*F\n+ 1 ToolboxInstallationMarker.kt\nfleet/dock/desktop/os/ToolboxInstallationMarker\n*L\n9#1:31\n*E\n"})
public final class ToolboxInstallationMarker {
    @NotNull
    public static final ToolboxInstallationMarker INSTANCE = new ToolboxInstallationMarker();
    @NotNull
    private static final KLogger log;

    private ToolboxInstallationMarker() {
    }

    public final void mark(@NotNull FleetDistributionLayout layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Path f = WithDockPathsKt.getInstalledViaToolboxPath((FleetDistributionLayout)layout);
        if (f == null) {
            throw new IllegalStateException("failed to resolve 'installed by Toolbox' marker file location, cannot successfully complete the installation of Fleet".toString());
        }
        try {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(f, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
            log.info((Object)(f + " added to the distribution directory, marking that installation of Fleet as installed via Toolbox"));
        }
        catch (FileAlreadyExistsException e) {
            log.info((Object)(f + " already present in the distribution"));
        }
    }

    static {
        boolean $i$f$logger = false;
        log = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ToolboxInstallationMarker.class));
    }
}

