/*
 * Decompiled with CFR 0.152.
 */
package fleet.dock.desktop.os;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinNT;
import fleet.dock.bootstrap.FleetDistributionLayout;
import fleet.dock.desktop.os.WinShellExt;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import fleet.util.os.Os;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lfleet/dock/desktop/os/ShellExtension;", "", "<init>", "()V", "logger", "Lfleet/util/logging/KLogger;", "install", "", "distributionLayout", "Lfleet/dock/bootstrap/FleetDistributionLayout;", "uninstall", "registerWindowsShellExtension", "unregisterWindowsShellExtension", "loadWinShellExtLibrary", "Lfleet/dock/desktop/os/WinShellExt;", "getAppImagePath", "", "getMsixPackagePath", "fleet.dock.desktop"})
@SourceDebugExtension(value={"SMAP\nShellExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellExtension.kt\nfleet/dock/desktop/os/ShellExtension\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n+ 3 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,79:1\n10#2,2:80\n22#2,2:82\n10#2,2:84\n18#2,2:86\n25#3:88\n*S KotlinDebug\n*F\n+ 1 ShellExtension.kt\nfleet/dock/desktop/os/ShellExtension\n*L\n34#1:80,2\n43#1:82,2\n48#1:84,2\n56#1:86,2\n17#1:88\n*E\n"})
public final class ShellExtension {
    @NotNull
    public static final ShellExtension INSTANCE = new ShellExtension();
    @NotNull
    private static final KLogger logger;

    private ShellExtension() {
    }

    public final void install(@NotNull FleetDistributionLayout distributionLayout) {
        Intrinsics.checkNotNullParameter((Object)distributionLayout, (String)"distributionLayout");
        Os.Type type = Os.INSTANCE.getType();
        if ((type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) == 1) {
            this.registerWindowsShellExtension(distributionLayout);
        }
    }

    public final void uninstall(@NotNull FleetDistributionLayout distributionLayout) {
        Intrinsics.checkNotNullParameter((Object)distributionLayout, (String)"distributionLayout");
        Os.Type type = Os.INSTANCE.getType();
        if ((type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) == 1) {
            this.unregisterWindowsShellExtension(distributionLayout);
        }
    }

    private final void registerWindowsShellExtension(FleetDistributionLayout distributionLayout) {
        KLogger kLogger;
        KLogger this_$iv = logger;
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug((Object)"Registering Fleet Windows Shell Extension...");
        }
        WinShellExt winShellExt = this.loadWinShellExtLibrary(distributionLayout);
        String installDir = this.getAppImagePath(distributionLayout);
        String msixPath = this.getMsixPackagePath(distributionLayout);
        WinNT.HRESULT result = winShellExt.registerFleetShellExtension(installDir, msixPath);
        if (COMUtils.FAILED((WinNT.HRESULT)result)) {
            KLogger this_$iv2 = logger;
            boolean $i$f$error = false;
            if (this_$iv2.isErrorEnabled()) {
                kLogger = this_$iv2;
                boolean bl = false;
                kLogger.error((Object)("Failed to register Fleet Windows Shell Extension: " + Kernel32Util.formatMessage((WinNT.HRESULT)result)));
            }
        }
    }

    private final void unregisterWindowsShellExtension(FleetDistributionLayout distributionLayout) {
        KLogger kLogger;
        KLogger this_$iv = logger;
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug((Object)"Un-registering Fleet Windows Shell Extension...");
        }
        WinShellExt winShellExt = this.loadWinShellExtLibrary(distributionLayout);
        String installDir = this.getAppImagePath(distributionLayout);
        WinNT.HRESULT result = winShellExt.unregisterFleetShellExtension(installDir, "FleetShellExt", "CN=JetBrains s.r.o., SERIALNUMBER=26502275, OID.2.5.4.15=Private Organization, O=JetBrains s.r.o., OID.1.3.6.1.4.1.311.60.2.1.3=CZ, L=Praha, C=CZ");
        if (COMUtils.FAILED((WinNT.HRESULT)result)) {
            KLogger this_$iv2 = logger;
            boolean $i$f$warn = false;
            if (this_$iv2.isWarnEnabled()) {
                kLogger = this_$iv2;
                boolean bl = false;
                kLogger.warn((Object)("Failed to un-register Fleet Windows Shell Extension: " + Kernel32Util.formatMessage((WinNT.HRESULT)result)));
            }
        }
    }

    private final WinShellExt loadWinShellExtLibrary(FleetDistributionLayout distributionLayout) {
        Library library = Native.load((String)(distributionLayout.librariesDirectory() + "\\winshellext.dll"), WinShellExt.class);
        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"load(...)");
        return (WinShellExt)library;
    }

    private final String getAppImagePath(FleetDistributionLayout distributionLayout) {
        Object object = distributionLayout.installationDirectory();
        if (object == null || (object = object.toString()) == null) {
            throw new IllegalStateException("Failed to locate installation directory. Are you trying to run Fleet from sources?".toString());
        }
        return object;
    }

    private final String getMsixPackagePath(FleetDistributionLayout distributionLayout) {
        Path path = distributionLayout.extensionsDirectory();
        if (path == null) {
            throw new IllegalStateException("Failed to locate the extensions directory. Are you trying to run Fleet from sources?".toString());
        }
        Path extensionsPath = path;
        Path path2 = extensionsPath.resolve("winshellext.msix");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return ((Object)path2).toString();
    }

    static {
        boolean $i$f$logger = false;
        logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ShellExtension.class));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Os.Type.values().length];
            try {
                nArray[Os.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

