/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.tbe.config.machine;

import com.jetbrains.tbe.config.machine.IdeAnalyticsConfig;
import com.jetbrains.tbe.config.machine.TbeMachineConfig;
import com.jetbrains.tbe.config.machine.TbeMachineConfigCertificates;
import com.jetbrains.tbe.config.machine.TbeMachineConfigFactory$IdeAnalyticsConfigData$;
import com.jetbrains.tbe.config.machine.TbeMachineConfigFactory$TbeMachineConfigData$;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.datetime.Instant;
import kotlinx.datetime.serializers.InstantIso8601Serializer;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory;", "", "<init>", "()V", "intelliJvmOpt", "", "getIntelliJvmOpt", "()Ljava/lang/String;", "fromConfigLocation", "Lcom/jetbrains/tbe/config/machine/TbeMachineConfig;", "configFile", "Ljava/nio/file/Path;", "parser", "Lkotlinx/serialization/json/Json;", "getParser", "()Lkotlinx/serialization/json/Json;", "parser$delegate", "Lkotlin/Lazy;", "fromConfigData", "data", "", "toConfigData", "config", "TbeMachineConfigData", "IdeAnalyticsConfigData", "TbeMachineConfigImpl", "tbe-config-machine"})
@SourceDebugExtension(value={"SMAP\nTbeMachineConfigFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TbeMachineConfigFactory.kt\ncom/jetbrains/tbe/config/machine/TbeMachineConfigFactory\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,113:1\n147#2:114\n1567#3:115\n1598#3,4:116\n1557#3:120\n1628#3,3:121\n1#4:124\n113#5:125\n*S KotlinDebug\n*F\n+ 1 TbeMachineConfigFactory.kt\ncom/jetbrains/tbe/config/machine/TbeMachineConfigFactory\n*L\n35#1:114\n36#1:115\n36#1:116,4\n58#1:120\n58#1:121,3\n65#1:125\n*E\n"})
public final class TbeMachineConfigFactory {
    @NotNull
    public static final TbeMachineConfigFactory INSTANCE = new TbeMachineConfigFactory();
    @NotNull
    private static final Lazy parser$delegate = LazyKt.lazy(TbeMachineConfigFactory::parser_delegate$lambda$1);

    private TbeMachineConfigFactory() {
    }

    @NotNull
    public final String getIntelliJvmOpt() {
        return "jetbrains.tbe.trust";
    }

    @NotNull
    public final TbeMachineConfig fromConfigLocation(@NotNull Path configFile) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        try {
            byArray = Files.readAllBytes(configFile);
        }
        catch (Exception t) {
            throw new IllegalArgumentException("Failed to read TBE Machine configuration from " + configFile + ". " + t.getMessage(), t);
        }
        byte[] data = byArray;
        Intrinsics.checkNotNull((Object)data);
        return this.fromConfigData(data);
    }

    private final Json getParser() {
        Lazy lazy = parser$delegate;
        return (Json)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TbeMachineConfig fromConfigData(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Iterable string$iv;
            void this_$iv;
            Json json = this.getParser();
            String string = new String(data, Charsets.UTF_8);
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            TbeMachineConfigData model = (TbeMachineConfigData)this_$iv.decodeFromString((DeserializationStrategy)TbeMachineConfigData.Companion.serializer(), (String)((Object)string$iv));
            string$iv = model.getHttpsTrustStorePem();
            TbeMachineConfigCertificates tbeMachineConfigCertificates = TbeMachineConfigCertificates.INSTANCE;
            boolean $i$f$mapIndexed = false;
            void var7_9 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void p1;
                void p0;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(tbeMachineConfigCertificates.loadCertificate((int)p0, (String)p1));
            }
            List certificates = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
            return new TbeMachineConfigImpl(model, certificates);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to parse TBE Machine configuration file. " + t.getMessage(), t);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] toConfigData(@NotNull TbeMachineConfig config) {
        IdeAnalyticsConfigData ideAnalyticsConfigData;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String string = config.getTbeServerUrl();
        String string2 = config.getCompanyName();
        String string3 = config.getCompanyLogoUrl();
        String string4 = config.getOverriddenAuthorization();
        Instant instant = config.getExpiresAt();
        Iterable $this$map$iv = config.getHttpsTrustStore();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            X509Certificate x509Certificate = (X509Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TbeMachineConfigCertificates.INSTANCE.saveCertificatePem((X509Certificate)it));
        }
        List list = (List)destination$iv$iv;
        String string5 = config.getBrowserUrl();
        Map<String, String> map = config.getAdditionalHeaders();
        IdeAnalyticsConfig ideAnalyticsConfig = config.getIdeAnalytics();
        if (ideAnalyticsConfig != null) {
            IdeAnalyticsConfig it = ideAnalyticsConfig;
            boolean bl = false;
            ideAnalyticsConfigData = new IdeAnalyticsConfigData(it);
        } else {
            ideAnalyticsConfigData = null;
        }
        iterable = ideAnalyticsConfigData;
        TbeMachineConfigData data = new TbeMachineConfigData(string, string2, string3, list, string4, instant, string5, map, null, (IdeAnalyticsConfigData)((Object)iterable), 256, null);
        StringFormat $this$encodeToString$iv = (StringFormat)this.getParser();
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        string = $this$encodeToString$iv.encodeToString((SerializationStrategy)TbeMachineConfigData.Companion.serializer(), (Object)data);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    private static final Unit parser_delegate$lambda$1$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setEncodeDefaults(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final Json parser_delegate$lambda$1() {
        return JsonKt.Json$default(null, TbeMachineConfigFactory::parser_delegate$lambda$1$lambda$0, (int)1, null);
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007B#\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0004\u0010\fJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\b\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$IdeAnalyticsConfigData;", "", "enabled", "", "<init>", "(Z)V", "Lcom/jetbrains/tbe/config/machine/IdeAnalyticsConfig;", "(Lcom/jetbrains/tbe/config/machine/IdeAnalyticsConfig;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getEnabled", "()Z", "component1", "copy", "equals", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$tbe_config_machine", "$serializer", "Companion", "tbe-config-machine"})
    public static final class IdeAnalyticsConfigData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean enabled;

        public IdeAnalyticsConfigData(boolean enabled) {
            this.enabled = enabled;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public IdeAnalyticsConfigData(@NotNull IdeAnalyticsConfig enabled) {
            Intrinsics.checkNotNullParameter((Object)enabled, (String)"enabled");
            this(enabled.getEnabled());
        }

        public final boolean component1() {
            return this.enabled;
        }

        @NotNull
        public final IdeAnalyticsConfigData copy(boolean enabled) {
            return new IdeAnalyticsConfigData(enabled);
        }

        public static /* synthetic */ IdeAnalyticsConfigData copy$default(IdeAnalyticsConfigData ideAnalyticsConfigData, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = ideAnalyticsConfigData.enabled;
            }
            return ideAnalyticsConfigData.copy(bl);
        }

        @NotNull
        public String toString() {
            return "IdeAnalyticsConfigData(enabled=" + this.enabled + ")";
        }

        public int hashCode() {
            return Boolean.hashCode(this.enabled);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IdeAnalyticsConfigData)) {
                return false;
            }
            IdeAnalyticsConfigData ideAnalyticsConfigData = (IdeAnalyticsConfigData)other;
            return this.enabled == ideAnalyticsConfigData.enabled;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$tbe_config_machine(IdeAnalyticsConfigData self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeBooleanElement(serialDesc, 0, self.enabled);
        }

        public /* synthetic */ IdeAnalyticsConfigData(int seen0, boolean enabled, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)IdeAnalyticsConfigData$$serializer.INSTANCE.getDescriptor());
            }
            this.enabled = enabled;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$IdeAnalyticsConfigData$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$IdeAnalyticsConfigData;", "tbe-config-machine"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<IdeAnalyticsConfigData> serializer() {
                return (KSerializer)IdeAnalyticsConfigData$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 @2\u00020\u0001:\u0002?@B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012B\u0091\u0001\b\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0017J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rH\u00c6\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00100\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u008b\u0001\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00c6\u0001J\u0013\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00105\u001a\u00020\u0014H\u00d6\u0001J\t\u00106\u001a\u00020\u0003H\u00d6\u0001J%\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0001\u00a2\u0006\u0002\b>R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0019R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006A"}, d2={"Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$TbeMachineConfigData;", "", "tbeServerUrl", "", "companyName", "companyLogoUrl", "httpsTrustStorePem", "", "overriddenAuthorization", "expiresAt", "Lkotlinx/datetime/Instant;", "browserUrl", "additionalHeaders", "", "clientKey", "ideAnalytics", "Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$IdeAnalyticsConfigData;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lkotlinx/datetime/Instant;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$IdeAnalyticsConfigData;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lkotlinx/datetime/Instant;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$IdeAnalyticsConfigData;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getTbeServerUrl", "()Ljava/lang/String;", "getCompanyName", "getCompanyLogoUrl", "getHttpsTrustStorePem", "()Ljava/util/List;", "getOverriddenAuthorization", "getExpiresAt", "()Lkotlinx/datetime/Instant;", "getBrowserUrl", "getAdditionalHeaders", "()Ljava/util/Map;", "getClientKey", "getIdeAnalytics", "()Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$IdeAnalyticsConfigData;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$tbe_config_machine", "$serializer", "Companion", "tbe-config-machine"})
    private static final class TbeMachineConfigData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String tbeServerUrl;
        @NotNull
        private final String companyName;
        @Nullable
        private final String companyLogoUrl;
        @NotNull
        private final List<String> httpsTrustStorePem;
        @Nullable
        private final String overriddenAuthorization;
        @Nullable
        private final Instant expiresAt;
        @Nullable
        private final String browserUrl;
        @NotNull
        private final Map<String, String> additionalHeaders;
        @Nullable
        private final String clientKey;
        @Nullable
        private final IdeAnalyticsConfigData ideAnalytics;
        @JvmField
        @NotNull
        private static final KSerializer<Object>[] $childSerializers;

        public TbeMachineConfigData(@NotNull String tbeServerUrl, @NotNull String companyName, @Nullable String companyLogoUrl, @NotNull List<String> httpsTrustStorePem, @Nullable String overriddenAuthorization, @Nullable Instant expiresAt, @Nullable String browserUrl, @NotNull Map<String, String> additionalHeaders, @Nullable String clientKey, @Nullable IdeAnalyticsConfigData ideAnalytics) {
            Intrinsics.checkNotNullParameter((Object)tbeServerUrl, (String)"tbeServerUrl");
            Intrinsics.checkNotNullParameter((Object)companyName, (String)"companyName");
            Intrinsics.checkNotNullParameter(httpsTrustStorePem, (String)"httpsTrustStorePem");
            Intrinsics.checkNotNullParameter(additionalHeaders, (String)"additionalHeaders");
            this.tbeServerUrl = tbeServerUrl;
            this.companyName = companyName;
            this.companyLogoUrl = companyLogoUrl;
            this.httpsTrustStorePem = httpsTrustStorePem;
            this.overriddenAuthorization = overriddenAuthorization;
            this.expiresAt = expiresAt;
            this.browserUrl = browserUrl;
            this.additionalHeaders = additionalHeaders;
            this.clientKey = clientKey;
            this.ideAnalytics = ideAnalytics;
        }

        public /* synthetic */ TbeMachineConfigData(String string, String string2, String string3, List list, String string4, Instant instant, String string5, Map map, String string6, IdeAnalyticsConfigData ideAnalyticsConfigData, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 0x10) != 0) {
                string4 = null;
            }
            if ((n & 0x20) != 0) {
                instant = null;
            }
            if ((n & 0x40) != 0) {
                string5 = null;
            }
            if ((n & 0x80) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 0x100) != 0) {
                string6 = null;
            }
            if ((n & 0x200) != 0) {
                ideAnalyticsConfigData = null;
            }
            this(string, string2, string3, list, string4, instant, string5, map, string6, ideAnalyticsConfigData);
        }

        @NotNull
        public final String getTbeServerUrl() {
            return this.tbeServerUrl;
        }

        @NotNull
        public final String getCompanyName() {
            return this.companyName;
        }

        @Nullable
        public final String getCompanyLogoUrl() {
            return this.companyLogoUrl;
        }

        @NotNull
        public final List<String> getHttpsTrustStorePem() {
            return this.httpsTrustStorePem;
        }

        @Nullable
        public final String getOverriddenAuthorization() {
            return this.overriddenAuthorization;
        }

        @Nullable
        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        @Nullable
        public final String getBrowserUrl() {
            return this.browserUrl;
        }

        @NotNull
        public final Map<String, String> getAdditionalHeaders() {
            return this.additionalHeaders;
        }

        @Nullable
        public final String getClientKey() {
            return this.clientKey;
        }

        @Nullable
        public final IdeAnalyticsConfigData getIdeAnalytics() {
            return this.ideAnalytics;
        }

        @NotNull
        public final String component1() {
            return this.tbeServerUrl;
        }

        @NotNull
        public final String component2() {
            return this.companyName;
        }

        @Nullable
        public final String component3() {
            return this.companyLogoUrl;
        }

        @NotNull
        public final List<String> component4() {
            return this.httpsTrustStorePem;
        }

        @Nullable
        public final String component5() {
            return this.overriddenAuthorization;
        }

        @Nullable
        public final Instant component6() {
            return this.expiresAt;
        }

        @Nullable
        public final String component7() {
            return this.browserUrl;
        }

        @NotNull
        public final Map<String, String> component8() {
            return this.additionalHeaders;
        }

        @Nullable
        public final String component9() {
            return this.clientKey;
        }

        @Nullable
        public final IdeAnalyticsConfigData component10() {
            return this.ideAnalytics;
        }

        @NotNull
        public final TbeMachineConfigData copy(@NotNull String tbeServerUrl, @NotNull String companyName, @Nullable String companyLogoUrl, @NotNull List<String> httpsTrustStorePem, @Nullable String overriddenAuthorization, @Nullable Instant expiresAt, @Nullable String browserUrl, @NotNull Map<String, String> additionalHeaders, @Nullable String clientKey, @Nullable IdeAnalyticsConfigData ideAnalytics) {
            Intrinsics.checkNotNullParameter((Object)tbeServerUrl, (String)"tbeServerUrl");
            Intrinsics.checkNotNullParameter((Object)companyName, (String)"companyName");
            Intrinsics.checkNotNullParameter(httpsTrustStorePem, (String)"httpsTrustStorePem");
            Intrinsics.checkNotNullParameter(additionalHeaders, (String)"additionalHeaders");
            return new TbeMachineConfigData(tbeServerUrl, companyName, companyLogoUrl, httpsTrustStorePem, overriddenAuthorization, expiresAt, browserUrl, additionalHeaders, clientKey, ideAnalytics);
        }

        public static /* synthetic */ TbeMachineConfigData copy$default(TbeMachineConfigData tbeMachineConfigData, String string, String string2, String string3, List list, String string4, Instant instant, String string5, Map map, String string6, IdeAnalyticsConfigData ideAnalyticsConfigData, int n, Object object) {
            if ((n & 1) != 0) {
                string = tbeMachineConfigData.tbeServerUrl;
            }
            if ((n & 2) != 0) {
                string2 = tbeMachineConfigData.companyName;
            }
            if ((n & 4) != 0) {
                string3 = tbeMachineConfigData.companyLogoUrl;
            }
            if ((n & 8) != 0) {
                list = tbeMachineConfigData.httpsTrustStorePem;
            }
            if ((n & 0x10) != 0) {
                string4 = tbeMachineConfigData.overriddenAuthorization;
            }
            if ((n & 0x20) != 0) {
                instant = tbeMachineConfigData.expiresAt;
            }
            if ((n & 0x40) != 0) {
                string5 = tbeMachineConfigData.browserUrl;
            }
            if ((n & 0x80) != 0) {
                map = tbeMachineConfigData.additionalHeaders;
            }
            if ((n & 0x100) != 0) {
                string6 = tbeMachineConfigData.clientKey;
            }
            if ((n & 0x200) != 0) {
                ideAnalyticsConfigData = tbeMachineConfigData.ideAnalytics;
            }
            return tbeMachineConfigData.copy(string, string2, string3, list, string4, instant, string5, map, string6, ideAnalyticsConfigData);
        }

        @NotNull
        public String toString() {
            return "TbeMachineConfigData(tbeServerUrl=" + this.tbeServerUrl + ", companyName=" + this.companyName + ", companyLogoUrl=" + this.companyLogoUrl + ", httpsTrustStorePem=" + this.httpsTrustStorePem + ", overriddenAuthorization=" + this.overriddenAuthorization + ", expiresAt=" + this.expiresAt + ", browserUrl=" + this.browserUrl + ", additionalHeaders=" + this.additionalHeaders + ", clientKey=" + this.clientKey + ", ideAnalytics=" + this.ideAnalytics + ")";
        }

        public int hashCode() {
            int result = this.tbeServerUrl.hashCode();
            result = result * 31 + this.companyName.hashCode();
            result = result * 31 + (this.companyLogoUrl == null ? 0 : this.companyLogoUrl.hashCode());
            result = result * 31 + ((Object)this.httpsTrustStorePem).hashCode();
            result = result * 31 + (this.overriddenAuthorization == null ? 0 : this.overriddenAuthorization.hashCode());
            result = result * 31 + (this.expiresAt == null ? 0 : this.expiresAt.hashCode());
            result = result * 31 + (this.browserUrl == null ? 0 : this.browserUrl.hashCode());
            result = result * 31 + ((Object)this.additionalHeaders).hashCode();
            result = result * 31 + (this.clientKey == null ? 0 : this.clientKey.hashCode());
            result = result * 31 + (this.ideAnalytics == null ? 0 : this.ideAnalytics.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TbeMachineConfigData)) {
                return false;
            }
            TbeMachineConfigData tbeMachineConfigData = (TbeMachineConfigData)other;
            if (!Intrinsics.areEqual((Object)this.tbeServerUrl, (Object)tbeMachineConfigData.tbeServerUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.companyName, (Object)tbeMachineConfigData.companyName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.companyLogoUrl, (Object)tbeMachineConfigData.companyLogoUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.httpsTrustStorePem, tbeMachineConfigData.httpsTrustStorePem)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.overriddenAuthorization, (Object)tbeMachineConfigData.overriddenAuthorization)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expiresAt, (Object)tbeMachineConfigData.expiresAt)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.browserUrl, (Object)tbeMachineConfigData.browserUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.additionalHeaders, tbeMachineConfigData.additionalHeaders)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.clientKey, (Object)tbeMachineConfigData.clientKey)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.ideAnalytics, (Object)tbeMachineConfigData.ideAnalytics);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$tbe_config_machine(TbeMachineConfigData self, CompositeEncoder output, SerialDescriptor serialDesc) {
            KSerializer<Object>[] kSerializerArray = $childSerializers;
            output.encodeStringElement(serialDesc, 0, self.tbeServerUrl);
            output.encodeStringElement(serialDesc, 1, self.companyName);
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.companyLogoUrl != null) {
                output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.companyLogoUrl);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : !Intrinsics.areEqual(self.httpsTrustStorePem, (Object)CollectionsKt.emptyList())) {
                output.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)kSerializerArray[3], self.httpsTrustStorePem);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.overriddenAuthorization != null) {
                output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.overriddenAuthorization);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.expiresAt != null) {
                output.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)InstantIso8601Serializer.INSTANCE, (Object)self.expiresAt);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 6) ? true : self.browserUrl != null) {
                output.encodeNullableSerializableElement(serialDesc, 6, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.browserUrl);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : !Intrinsics.areEqual(self.additionalHeaders, (Object)MapsKt.emptyMap())) {
                output.encodeSerializableElement(serialDesc, 7, (SerializationStrategy)kSerializerArray[7], self.additionalHeaders);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 8) ? true : self.clientKey != null) {
                output.encodeNullableSerializableElement(serialDesc, 8, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.clientKey);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 9) ? true : self.ideAnalytics != null) {
                output.encodeNullableSerializableElement(serialDesc, 9, (SerializationStrategy)IdeAnalyticsConfigData$$serializer.INSTANCE, (Object)self.ideAnalytics);
            }
        }

        public /* synthetic */ TbeMachineConfigData(int seen0, String tbeServerUrl, String companyName, String companyLogoUrl, List httpsTrustStorePem, String overriddenAuthorization, Instant expiresAt, String browserUrl, Map additionalHeaders, String clientKey, IdeAnalyticsConfigData ideAnalytics, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)TbeMachineConfigData$$serializer.INSTANCE.getDescriptor());
            }
            this.tbeServerUrl = tbeServerUrl;
            this.companyName = companyName;
            this.companyLogoUrl = (seen0 & 4) == 0 ? null : companyLogoUrl;
            this.httpsTrustStorePem = (seen0 & 8) == 0 ? CollectionsKt.emptyList() : httpsTrustStorePem;
            this.overriddenAuthorization = (seen0 & 0x10) == 0 ? null : overriddenAuthorization;
            this.expiresAt = (seen0 & 0x20) == 0 ? null : expiresAt;
            this.browserUrl = (seen0 & 0x40) == 0 ? null : browserUrl;
            this.additionalHeaders = (seen0 & 0x80) == 0 ? MapsKt.emptyMap() : additionalHeaders;
            this.clientKey = (seen0 & 0x100) == 0 ? null : clientKey;
            this.ideAnalytics = (seen0 & 0x200) == 0 ? null : ideAnalytics;
        }

        public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            KSerializer[] kSerializerArray = new KSerializer[]{null, null, null, new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), null, null, null, new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), null, null};
            $childSerializers = kSerializerArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$TbeMachineConfigData$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$TbeMachineConfigData;", "tbe-config-machine"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<TbeMachineConfigData> serializer() {
                return (KSerializer)TbeMachineConfigData$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010,\u001a\u00020\nH\u0016J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u0096\u0002J\b\u00101\u001a\u000202H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e*\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u000e*\u0004\b\u0010\u0010\fR\u001d\u0010\u0012\u001a\u0004\u0018\u00010\n8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u000e*\u0004\b\u0013\u0010\fR\u001d\u0010\u0015\u001a\u0004\u0018\u00010\n8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u000e*\u0004\b\u0016\u0010\fR\u001d\u0010\u0018\u001a\u0004\u0018\u00010\u00198VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c*\u0004\b\u001a\u0010\fR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001d\u0010 \u001a\u0004\u0018\u00010\n8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\"\u0010\u000e*\u0004\b!\u0010\fR'\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0$8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b&\u0010'*\u0004\b%\u0010\fR\u0016\u0010(\u001a\u0004\u0018\u00010)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u00063"}, d2={"Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$TbeMachineConfigImpl;", "Lcom/jetbrains/tbe/config/machine/TbeMachineConfig;", "data", "Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$TbeMachineConfigData;", "certificates", "", "Ljava/security/cert/X509Certificate;", "<init>", "(Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$TbeMachineConfigData;Ljava/util/List;)V", "tbeServerUrl", "", "getTbeServerUrl$delegate", "(Lcom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$TbeMachineConfigImpl;)Ljava/lang/Object;", "getTbeServerUrl", "()Ljava/lang/String;", "companyName", "getCompanyName$delegate", "getCompanyName", "companyLogoUrl", "getCompanyLogoUrl$delegate", "getCompanyLogoUrl", "overriddenAuthorization", "getOverriddenAuthorization$delegate", "getOverriddenAuthorization", "expiresAt", "Lkotlinx/datetime/Instant;", "getExpiresAt$delegate", "getExpiresAt", "()Lkotlinx/datetime/Instant;", "httpsTrustStore", "getHttpsTrustStore", "()Ljava/util/List;", "browserUrl", "getBrowserUrl$delegate", "getBrowserUrl", "additionalHeaders", "", "getAdditionalHeaders$delegate", "getAdditionalHeaders", "()Ljava/util/Map;", "ideAnalytics", "Lcom/jetbrains/tbe/config/machine/IdeAnalyticsConfig;", "getIdeAnalytics", "()Lcom/jetbrains/tbe/config/machine/IdeAnalyticsConfig;", "toString", "equals", "", "other", "", "hashCode", "", "tbe-config-machine"})
    @SourceDebugExtension(value={"SMAP\nTbeMachineConfigFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TbeMachineConfigFactory.kt\ncom/jetbrains/tbe/config/machine/TbeMachineConfigFactory$TbeMachineConfigImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
    private static final class TbeMachineConfigImpl
    implements TbeMachineConfig {
        @NotNull
        private final TbeMachineConfigData data;
        @NotNull
        private final List<X509Certificate> httpsTrustStore;
        @Nullable
        private final IdeAnalyticsConfig ideAnalytics;

        /*
         * WARNING - void declaration
         */
        public TbeMachineConfigImpl(@NotNull TbeMachineConfigData data, @NotNull List<? extends X509Certificate> certificates) {
            IdeAnalyticsConfig ideAnalyticsConfig;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
            this.data = data;
            this.httpsTrustStore = certificates;
            TbeMachineConfigImpl tbeMachineConfigImpl = this;
            IdeAnalyticsConfigData ideAnalyticsConfigData = this.data.getIdeAnalytics();
            if (ideAnalyticsConfigData != null) {
                void it;
                IdeAnalyticsConfigData ideAnalyticsConfigData2 = ideAnalyticsConfigData;
                TbeMachineConfigImpl tbeMachineConfigImpl2 = tbeMachineConfigImpl;
                boolean bl = false;
                ideAnalyticsConfig = new IdeAnalyticsConfig((IdeAnalyticsConfigData)it);
                tbeMachineConfigImpl = tbeMachineConfigImpl2;
            } else {
                ideAnalyticsConfig = null;
            }
            tbeMachineConfigImpl.ideAnalytics = ideAnalyticsConfig;
        }

        @Override
        @NotNull
        public String getTbeServerUrl() {
            return this.data.getTbeServerUrl();
        }

        private static Object getTbeServerUrl$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "tbeServerUrl", "getTbeServerUrl()Ljava/lang/String;", 0)));
        }

        @Override
        @NotNull
        public String getCompanyName() {
            return this.data.getCompanyName();
        }

        private static Object getCompanyName$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "companyName", "getCompanyName()Ljava/lang/String;", 0)));
        }

        @Override
        @Nullable
        public String getCompanyLogoUrl() {
            return this.data.getCompanyLogoUrl();
        }

        private static Object getCompanyLogoUrl$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "companyLogoUrl", "getCompanyLogoUrl()Ljava/lang/String;", 0)));
        }

        @Override
        @Nullable
        public String getOverriddenAuthorization() {
            return this.data.getOverriddenAuthorization();
        }

        private static Object getOverriddenAuthorization$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "overriddenAuthorization", "getOverriddenAuthorization()Ljava/lang/String;", 0)));
        }

        @Override
        @Nullable
        public Instant getExpiresAt() {
            return this.data.getExpiresAt();
        }

        private static Object getExpiresAt$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "expiresAt", "getExpiresAt()Lkotlinx/datetime/Instant;", 0)));
        }

        @Override
        @NotNull
        public List<X509Certificate> getHttpsTrustStore() {
            return this.httpsTrustStore;
        }

        @Override
        @Nullable
        public String getBrowserUrl() {
            return this.data.getBrowserUrl();
        }

        private static Object getBrowserUrl$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "browserUrl", "getBrowserUrl()Ljava/lang/String;", 0)));
        }

        @Override
        @NotNull
        public Map<String, String> getAdditionalHeaders() {
            return this.data.getAdditionalHeaders();
        }

        private static Object getAdditionalHeaders$delegate(TbeMachineConfigImpl tbeMachineConfigImpl) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)tbeMachineConfigImpl.data, TbeMachineConfigData.class, "additionalHeaders", "getAdditionalHeaders()Ljava/util/Map;", 0)));
        }

        @Override
        @Nullable
        public IdeAnalyticsConfig getIdeAnalytics() {
            return this.ideAnalytics;
        }

        @NotNull
        public String toString() {
            return "TbeMachineConfig(tbeServerUrl='" + this.getTbeServerUrl() + "', companyName='" + this.getCompanyName() + "')";
        }

        public boolean equals(@Nullable Object other) {
            TbeMachineConfigImpl tbeMachineConfigImpl = other instanceof TbeMachineConfigImpl ? (TbeMachineConfigImpl)other : null;
            return Intrinsics.areEqual((Object)this.data, (Object)(tbeMachineConfigImpl != null ? tbeMachineConfigImpl.data : null));
        }

        public int hashCode() {
            return this.data.hashCode();
        }
    }
}

