/*
 * Decompiled with CFR 0.152.
 */
package fleet.reporting.fus.impl;

import fleet.reporting.fus.impl.FusEventMerger;
import fleet.reporting.fus.impl.FusFileAccessor;
import fleet.reporting.shared.config.TracingConfigProperties;
import fleet.util.logging.KLogger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lfleet/reporting/fus/impl/FusFileAccessor;", "", "ownDir", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "currentFile", "maxFileAgeMs", "", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "writeEvent", "", "event", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepareFilesForSend", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cleanupOldFiles", "generateNewFile", "dir", "fleet.reporting.fus.impl"})
@SourceDebugExtension(value={"SMAP\nFusFileAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FusFileAccessor.kt\nfleet/reporting/fus/impl/FusFileAccessor\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,81:1\n18#2,2:82\n116#3,10:84\n116#3,10:94\n116#3,10:104\n*S KotlinDebug\n*F\n+ 1 FusFileAccessor.kt\nfleet/reporting/fus/impl/FusFileAccessor\n*L\n24#1:82,2\n29#1:84,10\n41#1:94,10\n51#1:104,10\n*E\n"})
public final class FusFileAccessor {
    @NotNull
    private final Path ownDir;
    @Nullable
    private Path currentFile;
    private final long maxFileAgeMs;
    @NotNull
    private final Mutex mutex;

    public FusFileAccessor(@NotNull Path ownDir) {
        Intrinsics.checkNotNullParameter((Object)ownDir, (String)"ownDir");
        this.ownDir = ownDir;
        this.maxFileAgeMs = 604800000L;
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        if (TracingConfigProperties.INSTANCE.getFusTestingMode()) {
            KLogger this_$iv = FusEventMerger.Companion.getLogger();
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.warn((Object)("Fus directory: " + this.ownDir));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object writeEvent(@NotNull String var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof writeEvent.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ FusFileAccessor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.writeEvent(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.mutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = event;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl33
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                event = (String)$continuation.L$1;
                this = (FusFileAccessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 3 sources

                $i$a$-withLock$default-FusFileAccessor$writeEvent$2 = false;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = InterruptibleKt.runInterruptible((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function0)((Function0)new Function0<Path>(this, event){
                    final /* synthetic */ FusFileAccessor this$0;
                    final /* synthetic */ String $event;
                    {
                        this.this$0 = $receiver;
                        this.$event = $event;
                        super(0);
                    }

                    public final Path invoke() {
                        if (FusFileAccessor.access$getCurrentFile$p(this.this$0) == null) {
                            FusFileAccessor.access$setCurrentFile$p(this.this$0, FusFileAccessor.access$generateNewFile(this.this$0, FusFileAccessor.access$getOwnDir$p(this.this$0)));
                        }
                        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND};
                        return Files.writeString(FusFileAccessor.access$getCurrentFile$p(this.this$0), (CharSequence)this.$event, openOptionArray);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var11_5) goto lbl42
lbl41:
                // 1 sources

                return var11_5;
lbl42:
                // 1 sources

                ** GOTO lbl53
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-FusFileAccessor$writeEvent$2 = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl53:
                    // 2 sources

                    var7_13 = (Path)v1;
                }
                catch (Throwable var8_14) {
                    throw var8_14;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object prepareFilesForSend(@NotNull Continuation<? super List<? extends Path>> $completion) {
        if (!($completion instanceof prepareFilesForSend.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FusFileAccessor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.prepareFilesForSend((Continuation<? super List<? extends Path>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.mutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl31
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (FusFileAccessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 3 sources

                $i$a$-withLock$default-FusFileAccessor$prepareFilesForSend$2 = false;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = InterruptibleKt.runInterruptible((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function0)((Function0)new Function0<List<? extends Path>>(this){
                    final /* synthetic */ FusFileAccessor this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final List<Path> invoke() {
                        void $this$filterTo$iv$iv;
                        FusFileAccessor.access$setCurrentFile$p(this.this$0, null);
                        Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)FusFileAccessor.access$getOwnDir$p(this.this$0), null, (int)1, null);
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            Path it = (Path)element$iv$iv;
                            boolean bl = false;
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (!Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var9_4) goto lbl39
lbl38:
                // 1 sources

                return var9_4;
lbl39:
                // 1 sources

                ** GOTO lbl50
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-FusFileAccessor$prepareFilesForSend$2 = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl50:
                    // 2 sources

                    var6_13 = (List)v1;
                }
                catch (Throwable var5_12) {
                    throw var5_12;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var6_13;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object cleanupOldFiles(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof cleanupOldFiles.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FusFileAccessor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.cleanupOldFiles((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.mutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl31
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (FusFileAccessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 3 sources

                $i$a$-withLock$default-FusFileAccessor$cleanupOldFiles$2 = false;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = InterruptibleKt.runInterruptible((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function0)((Function0)new Function0<Result<? extends Unit>>(this){
                    final /* synthetic */ FusFileAccessor this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final Object invoke-d1pmJ48() {
                        Object object;
                        long oldestAcceptable = System.currentTimeMillis() - FusFileAccessor.access$getMaxFileAgeMs$p(this.this$0);
                        FusFileAccessor fusFileAccessor = this.this$0;
                        try {
                            FusFileAccessor $this$invoke_d1pmJ48_u24lambda_u243 = fusFileAccessor;
                            boolean bl = false;
                            AutoCloseable autoCloseable = Files.list(FusFileAccessor.access$getOwnDir$p($this$invoke_d1pmJ48_u24lambda_u243));
                            Throwable throwable = null;
                            try {
                                Stream files = (Stream)autoCloseable;
                                boolean bl2 = false;
                                files.filter(arg_0 -> cleanupOldFiles.2.1.invoke_d1pmJ48$lambda$3$lambda$2$lambda$0((Function1)new Function1<Path, Boolean>($this$invoke_d1pmJ48_u24lambda_u243){
                                    final /* synthetic */ FusFileAccessor $this_runCatching;
                                    {
                                        this.$this_runCatching = $receiver;
                                        super(1);
                                    }

                                    public final Boolean invoke(Path it) {
                                        return !Intrinsics.areEqual((Object)it, (Object)FusFileAccessor.access$getCurrentFile$p(this.$this_runCatching));
                                    }
                                }, arg_0)).forEach(arg_0 -> cleanupOldFiles.2.1.invoke_d1pmJ48$lambda$3$lambda$2$lambda$1((Function1)new Function1<Path, Unit>(oldestAcceptable){
                                    final /* synthetic */ long $oldestAcceptable;
                                    {
                                        this.$oldestAcceptable = $oldestAcceptable;
                                        super(1);
                                    }

                                    public final void invoke(Path file) {
                                        Intrinsics.checkNotNull((Object)file);
                                        LinkOption[] linkOptionArray = new LinkOption[]{};
                                        FileTime fileTime = Files.getLastModifiedTime(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                                        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                                        if (fileTime.toMillis() < this.$oldestAcceptable) {
                                            LinkOption[] linkOptionArray2 = new LinkOption[]{};
                                            if (Files.isDirectory(file, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                                                PathsKt.deleteRecursively((Path)file);
                                            } else {
                                                Files.deleteIfExists(file);
                                            }
                                        }
                                    }
                                }, arg_0));
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                            }
                            object = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable throwable) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        return object;
                    }

                    private static final boolean invoke_d1pmJ48$lambda$3$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
                        return (Boolean)$tmp0.invoke(p0);
                    }

                    private static final void invoke_d1pmJ48$lambda$3$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
                        $tmp0.invoke(p0);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var9_4) goto lbl39
lbl38:
                // 1 sources

                return var9_4;
lbl39:
                // 1 sources

                ** GOTO lbl50
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-FusFileAccessor$cleanupOldFiles$2 = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl50:
                    // 2 sources

                    var6_13 = ((Result)v1).unbox-impl();
                }
                catch (Throwable var5_12) {
                    throw var5_12;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Path generateNewFile(Path dir) {
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createDirectories(dir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createDirectories(...)");
        Path path2 = Files.createTempFile(path, "stats" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("hhmmss")), ".json.log", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempFile(...)");
        return path2;
    }

    public static final /* synthetic */ Path access$getCurrentFile$p(FusFileAccessor $this) {
        return $this.currentFile;
    }

    public static final /* synthetic */ void access$setCurrentFile$p(FusFileAccessor $this, Path path) {
        $this.currentFile = path;
    }

    public static final /* synthetic */ Path access$generateNewFile(FusFileAccessor $this, Path dir) {
        return $this.generateNewFile(dir);
    }

    public static final /* synthetic */ Path access$getOwnDir$p(FusFileAccessor $this) {
        return $this.ownDir;
    }

    public static final /* synthetic */ long access$getMaxFileAgeMs$p(FusFileAccessor $this) {
        return $this.maxFileAgeMs;
    }
}

