/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.vfs;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.llvm.adt.StringRef;
import org.llvm.support.sys.TimeValue;
import org.llvm.support.sys.fs;

public class Status
implements Destructors.ClassWithDestructor,
Native.NativePOD<Status> {
    private std.string Name;
    private fs.UniqueID UID;
    private TimeValue MTime;
    private int User;
    private int Group;
    private long Size;
    private fs.file_type Type;
    private int Perms;
    public boolean IsVFSMapped;

    public Status() {
        this.Name = new std.string();
        this.UID = new fs.UniqueID();
        this.MTime = new TimeValue();
        this.Type = fs.file_type.status_error;
    }

    public Status(fs.file_status Status2) {
        this.Name = new std.string();
        this.UID = Status2.getUniqueID();
        this.MTime = Status2.getLastModificationTime();
        this.User = Status2.getUser();
        this.Group = Status2.getGroup();
        this.Size = Status2.getSize();
        this.Type = Status2.type();
        this.Perms = Status2.permissions();
        this.IsVFSMapped = false;
    }

    public Status(StringRef Name, fs.UniqueID UID, TimeValue MTime, int User, int Group, long Size, fs.file_type Type2, int Perms) {
        this.Name = Name.$string();
        this.UID = new fs.UniqueID(UID);
        this.MTime = new TimeValue(MTime);
        this.User = User;
        this.Group = Group;
        this.Size = Size;
        this.Type = Type2;
        this.Perms = Perms;
        this.IsVFSMapped = false;
    }

    public static Status copyWithNewName(Status In, StringRef NewName) {
        return new Status(NewName, In.getUniqueID(), In.getLastModificationTime(), In.getUser(), In.getGroup(), In.getSize(), In.getType(), In.getPermissions());
    }

    public static Status copyWithNewName(fs.file_status In, StringRef NewName) {
        return new Status(NewName, In.getUniqueID(), In.getLastModificationTime(), In.getUser(), In.getGroup(), In.getSize(), In.type(), In.permissions());
    }

    public StringRef getName() {
        return new StringRef(this.Name);
    }

    public fs.file_type getType() {
        return this.Type;
    }

    public int getPermissions() {
        return this.Perms;
    }

    public TimeValue getLastModificationTime() {
        return new TimeValue(this.MTime);
    }

    public fs.UniqueID getUniqueID() {
        return new fs.UniqueID(this.UID);
    }

    public int getUser() {
        return this.User;
    }

    public int getGroup() {
        return this.Group;
    }

    public long getSize() {
        return this.Size;
    }

    public boolean equivalent(Status Other) {
        return this.getUniqueID().$eq(Other.getUniqueID());
    }

    public boolean isDirectory() {
        return this.Type == fs.file_type.directory_file;
    }

    public boolean isRegularFile() {
        return this.Type == fs.file_type.regular_file;
    }

    public boolean isOther() {
        return this.exists() && !this.isRegularFile() && !this.isDirectory() && !this.isSymlink();
    }

    public boolean isSymlink() {
        return this.Type == fs.file_type.symlink_file;
    }

    public boolean isStatusKnown() {
        return this.Type != fs.file_type.status_error;
    }

    public boolean exists() {
        return this.isStatusKnown() && this.Type != fs.file_type.file_not_found;
    }

    public Status(Status $Prm0) {
        this.Name = new std.string($Prm0.Name);
        this.UID = new fs.UniqueID($Prm0.UID);
        this.MTime = new TimeValue($Prm0.MTime);
        this.User = $Prm0.User;
        this.Group = $Prm0.Group;
        this.Size = $Prm0.Size;
        this.Type = $Prm0.Type;
        this.Perms = $Prm0.Perms;
        this.IsVFSMapped = $Prm0.IsVFSMapped;
    }

    public Status(JavaDifferentiators.JD.Move _dparam, Status $Prm0) {
        this.Name = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Name);
        this.UID = new fs.UniqueID(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.UID);
        this.MTime = new TimeValue(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.MTime);
        this.User = $Prm0.User;
        this.Group = $Prm0.Group;
        this.Size = $Prm0.Size;
        this.Type = $Prm0.Type;
        this.Perms = $Prm0.Perms;
        this.IsVFSMapped = $Prm0.IsVFSMapped;
    }

    public Status $assign(Status $Prm0) {
        this.Name.$assign($Prm0.Name);
        this.UID.$assign($Prm0.UID);
        this.MTime.$assign($Prm0.MTime);
        this.User = $Prm0.User;
        this.Group = $Prm0.Group;
        this.Size = $Prm0.Size;
        this.Type = $Prm0.Type;
        this.Perms = $Prm0.Perms;
        this.IsVFSMapped = $Prm0.IsVFSMapped;
        return this;
    }

    public Status $assignMove(Status $Prm0) {
        this.Name.$assignMove($Prm0.Name);
        this.UID.$assignMove($Prm0.UID);
        this.MTime.$assignMove($Prm0.MTime);
        this.User = $Prm0.User;
        this.Group = $Prm0.Group;
        this.Size = $Prm0.Size;
        this.Type = $Prm0.Type;
        this.Perms = $Prm0.Perms;
        this.IsVFSMapped = $Prm0.IsVFSMapped;
        return this;
    }

    public void $destroy() {
        this.Name.$destroy();
    }

    public Status clone() {
        return new Status(this);
    }

    public String toString() {
        return "Name=[" + this.Name.toJavaString() + "], UID=" + this.UID + ", MTime=" + this.MTime + ", User=" + this.User + ", Group=" + this.Group + ", Size=" + this.Size + ", Type=" + this.Type + ", Perms=" + this.Perms + ", IsVFSMapped=" + this.IsVFSMapped;
    }
}

