/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.Builtin;
import org.clang.basic.CallingConv;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.TargetInfo;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.APFloat;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitchBool;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.StringMapBool;
import org.llvm.support.fltSemantics;
import org.llvm.support.llvm;

public class SystemZTargetInfo
extends TargetInfo
implements Destructors.ClassWithDestructor {
    private static Builtin.Info[] BuiltinInfo = new Builtin.Info[]{new Builtin.Info("__builtin_tbegin", "iv*", NativePointer.$j, null, 14, NativePointer.$((String)"transactional-execution")), new Builtin.Info("__builtin_tbegin_nofloat", "iv*", NativePointer.$j, null, 14, NativePointer.$((String)"transactional-execution")), new Builtin.Info("__builtin_tbeginc", NativePointer.$v, "nj", null, 14, NativePointer.$((String)"transactional-execution")), new Builtin.Info("__builtin_tabort", "vi", NativePointer.$r, null, 14, NativePointer.$((String)"transactional-execution")), new Builtin.Info("__builtin_tend", NativePointer.$i, NativePointer.$n, null, 14, NativePointer.$((String)"transactional-execution")), new Builtin.Info("__builtin_tx_nesting_depth", NativePointer.$i, NativePointer.$nc, null, 14, NativePointer.$((String)"transactional-execution")), new Builtin.Info("__builtin_tx_assist", "vi", NativePointer.$n, null, 14, NativePointer.$((String)"transactional-execution")), new Builtin.Info("__builtin_non_tx_store", "vULi*ULi", NativePointer.$EMPTY, null, 14, NativePointer.$((String)"transactional-execution")), new Builtin.Info("__builtin_s390_lcbb", "UivC*Ii", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vlbb", "V16ScvC*Ii", NativePointer.$EMPTY, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vll", "V16ScUivC*", NativePointer.$EMPTY, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vstl", "vV16ScUiv*", NativePointer.$EMPTY, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vperm", "V16UcV16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpdi", "V2ULLiV2ULLiV2ULLiIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpksh", "V16ScV8SsV8Ss", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpkshs", "V16ScV8SsV8Ssi*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpksf", "V8SsV4SiV4Si", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpksfs", "V8SsV4SiV4Sii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpksg", "V4SiV2SLLiV2SLLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpksgs", "V4SiV2SLLiV2SLLii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpklsh", "V16UcV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpklshs", "V16UcV8UsV8Usi*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpklsf", "V8UsV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpklsfs", "V8UsV4UiV4Uii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpklsg", "V4UiV2ULLiV2ULLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpklsgs", "V4UiV2ULLiV2ULLii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vuphb", "V8SsV16Sc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vuphh", "V4SiV8Ss", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vuphf", "V2SLLiV4Si", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vuplb", "V8SsV16Sc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vuplhw", "V4SiV8Ss", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vuplf", "V2SLLiV4Si", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vuplhb", "V8UsV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vuplhh", "V4UiV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vuplhf", "V2ULLiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vupllb", "V8UsV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vupllh", "V4UiV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vupllf", "V2ULLiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vaq", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vacq", "V16UcV16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vaccb", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vacch", "V8UsV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vaccf", "V4UiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vaccg", "V2ULLiV2ULLiV2ULLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vaccq", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vacccq", "V16UcV16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vavgb", "V16ScV16ScV16Sc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vavgh", "V8SsV8SsV8Ss", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vavgf", "V4SiV4SiV4Si", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vavgg", "V2SLLiV2SLLiV2SLLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vavglb", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vavglh", "V8UsV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vavglf", "V4UiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vavglg", "V2ULLiV2ULLiV2ULLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vceqbs", "V16ScV16ScV16Sci*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vceqhs", "V8SsV8SsV8Ssi*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vceqfs", "V4SiV4SiV4Sii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vceqgs", "V2SLLiV2SLLiV2SLLii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vchbs", "V16ScV16ScV16Sci*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vchhs", "V8SsV8SsV8Ssi*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vchfs", "V4SiV4SiV4Sii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vchgs", "V2SLLiV2SLLiV2SLLii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vchlbs", "V16ScV16UcV16Uci*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vchlhs", "V8SsV8UsV8Usi*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vchlfs", "V4SiV4UiV4Uii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vchlgs", "V2SLLiV2ULLiV2ULLii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vcksm", "V4UiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vclzb", "V16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vclzh", "V8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vclzf", "V4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vclzg", "V2ULLiV2ULLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vctzb", "V16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vctzh", "V8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vctzf", "V4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vctzg", "V2ULLiV2ULLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_verimb", "V16UcV16UcV16UcV16UcIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_verimh", "V8UsV8UsV8UsV8UsIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_verimf", "V4UiV4UiV4UiV4UiIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_verimg", "V2ULLiV2ULLiV2ULLiV2ULLiIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_verllb", "V16UcV16UcUi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_verllh", "V8UsV8UsUi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_verllf", "V4UiV4UiUi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_verllg", "V2ULLiV2ULLiUi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_verllvb", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_verllvh", "V8UsV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_verllvf", "V4UiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_verllvg", "V2ULLiV2ULLiV2ULLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vgfmb", "V8UsV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vgfmh", "V4UiV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vgfmf", "V2ULLiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vgfmg", "V16UcV2ULLiV2ULLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vgfmab", "V8UsV16UcV16UcV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vgfmah", "V4UiV8UsV8UsV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vgfmaf", "V2ULLiV4UiV4UiV2ULLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vgfmag", "V16UcV2ULLiV2ULLiV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmahb", "V16ScV16ScV16ScV16Sc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmahh", "V8SsV8SsV8SsV8Ss", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmahf", "V4SiV4SiV4SiV4Si", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmalhb", "V16UcV16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmalhh", "V8UsV8UsV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmalhf", "V4UiV4UiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmaeb", "V8SsV16ScV16ScV8Ss", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmaeh", "V4SiV8SsV8SsV4Si", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmaef", "V2SLLiV4SiV4SiV2SLLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmaleb", "V8UsV16UcV16UcV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmaleh", "V4UiV8UsV8UsV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmalef", "V2ULLiV4UiV4UiV2ULLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmaob", "V8SsV16ScV16ScV8Ss", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmaoh", "V4SiV8SsV8SsV4Si", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmaof", "V2SLLiV4SiV4SiV2SLLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmalob", "V8UsV16UcV16UcV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmaloh", "V4UiV8UsV8UsV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmalof", "V2ULLiV4UiV4UiV2ULLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmhb", "V16ScV16ScV16Sc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmhh", "V8SsV8SsV8Ss", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmhf", "V4SiV4SiV4Si", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmlhb", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmlhh", "V8UsV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmlhf", "V4UiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmeb", "V8SsV16ScV16Sc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmeh", "V4SiV8SsV8Ss", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmef", "V2SLLiV4SiV4Si", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmleb", "V8UsV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmleh", "V4UiV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmlef", "V2ULLiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmob", "V8SsV16ScV16Sc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmoh", "V4SiV8SsV8Ss", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmof", "V2SLLiV4SiV4Si", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmlob", "V8UsV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmloh", "V4UiV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vmlof", "V2ULLiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpopctb", "V16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpopcth", "V8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpopctf", "V4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vpopctg", "V2ULLiV2ULLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsq", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsbcbiq", "V16UcV16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsbiq", "V16UcV16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vscbib", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vscbih", "V8UsV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vscbif", "V4UiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vscbig", "V2ULLiV2ULLiV2ULLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vscbiq", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsl", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vslb", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsldb", "V16UcV16UcV16UcIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsra", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsrab", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsrl", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsrlb", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsumb", "V4UiV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsumh", "V4UiV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsumgh", "V2ULLiV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsumgf", "V2ULLiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsumqf", "V16UcV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vsumqg", "V16UcV2ULLiV2ULLi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vtm", "iV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfaeb", "V16UcV16UcV16UcIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfaebs", "V16UcV16UcV16UcIii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfaeh", "V8UsV8UsV8UsIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfaehs", "V8UsV8UsV8UsIii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfaef", "V4UiV4UiV4UiIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfaefs", "V4UiV4UiV4UiIii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfaezb", "V16UcV16UcV16UcIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfaezbs", "V16UcV16UcV16UcIii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfaezh", "V8UsV8UsV8UsIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfaezhs", "V8UsV8UsV8UsIii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfaezf", "V4UiV4UiV4UiIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfaezfs", "V4UiV4UiV4UiIii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeeb", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeebs", "V16UcV16UcV16Uci*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeeh", "V8UsV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeehs", "V8UsV8UsV8Usi*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeef", "V4UiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeefs", "V4UiV4UiV4Uii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeezb", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeezbs", "V16UcV16UcV16Uci*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeezh", "V8UsV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeezhs", "V8UsV8UsV8Usi*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeezf", "V4UiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeezfs", "V4UiV4UiV4Uii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeneb", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfenebs", "V16UcV16UcV16Uci*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfeneh", "V8UsV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfenehs", "V8UsV8UsV8Usi*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfenef", "V4UiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfenefs", "V4UiV4UiV4Uii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfenezb", "V16UcV16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfenezbs", "V16UcV16UcV16Uci*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfenezh", "V8UsV8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfenezhs", "V8UsV8UsV8Usi*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfenezf", "V4UiV4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfenezfs", "V4UiV4UiV4Uii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vistrb", "V16UcV16Uc", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vistrbs", "V16UcV16Uci*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vistrh", "V8UsV8Us", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vistrhs", "V8UsV8Usi*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vistrf", "V4UiV4Ui", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vistrfs", "V4UiV4Uii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vstrcb", "V16UcV16UcV16UcV16UcIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vstrcbs", "V16UcV16UcV16UcV16UcIii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vstrch", "V8UsV8UsV8UsV8UsIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vstrchs", "V8UsV8UsV8UsV8UsIii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vstrcf", "V4UiV4UiV4UiV4UiIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vstrcfs", "V4UiV4UiV4UiV4UiIii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vstrczb", "V16UcV16UcV16UcV16UcIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vstrczbs", "V16UcV16UcV16UcV16UcIii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vstrczh", "V8UsV8UsV8UsV8UsIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vstrczhs", "V8UsV8UsV8UsV8UsIii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vstrczf", "V4UiV4UiV4UiV4UiIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vstrczfs", "V4UiV4UiV4UiV4UiIii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfcedbs", "V2SLLiV2dV2di*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfchdbs", "V2SLLiV2dV2di*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfchedbs", "V2SLLiV2dV2di*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfidb", "V2dV2dIiIi", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vflndb", "V2dV2d", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vflpdb", "V2dV2d", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfmadb", "V2dV2dV2dV2d", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfmsdb", "V2dV2dV2dV2d", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vfsqdb", "V2dV2d", NativePointer.$nc, null, 14, NativePointer.$((String)"vector")), new Builtin.Info("__builtin_s390_vftcidb", "V2SLLiV2dIii*", NativePointer.$nc, null, 14, NativePointer.$((String)"vector"))};
    private static char.ptr[] GCCRegNames = new char.ptr[]{NativePointer.$((String)"r0"), NativePointer.$((String)"r1"), NativePointer.$((String)"r2"), NativePointer.$((String)"r3"), NativePointer.$((String)"r4"), NativePointer.$((String)"r5"), NativePointer.$((String)"r6"), NativePointer.$((String)"r7"), NativePointer.$((String)"r8"), NativePointer.$((String)"r9"), NativePointer.$((String)"r10"), NativePointer.$((String)"r11"), NativePointer.$((String)"r12"), NativePointer.$((String)"r13"), NativePointer.$((String)"r14"), NativePointer.$((String)"r15"), NativePointer.$((String)"f0"), NativePointer.$((String)"f2"), NativePointer.$((String)"f4"), NativePointer.$((String)"f6"), NativePointer.$((String)"f1"), NativePointer.$((String)"f3"), NativePointer.$((String)"f5"), NativePointer.$((String)"f7"), NativePointer.$((String)"f8"), NativePointer.$((String)"f10"), NativePointer.$((String)"f12"), NativePointer.$((String)"f14"), NativePointer.$((String)"f9"), NativePointer.$((String)"f11"), NativePointer.$((String)"f13"), NativePointer.$((String)"f15")};
    private std.string CPU = new std.string((CharSequence)"z10");
    private boolean HasTransactionalExecution = false;
    private boolean HasVector = false;

    public SystemZTargetInfo(Triple Triple2, TargetOptions $Prm1) {
        super(Triple2);
        this.IntMaxType = TargetInfo.IntType.SignedLong;
        this.Int64Type = TargetInfo.IntType.SignedLong;
        this.TLSSupported = true;
        this.IntAlign = (byte)32;
        this.IntWidth = (byte)32;
        this.LongLongAlign = (byte)64;
        this.LongAlign = (byte)64;
        this.LongLongWidth = (byte)64;
        this.LongWidth = (byte)64;
        this.PointerAlign = (byte)64;
        this.PointerWidth = (byte)64;
        this.LongDoubleWidth = Unsigned.$int2uchar((int)128);
        this.LongDoubleAlign = (byte)64;
        this.LongDoubleFormat = (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEquad);
        this.DefaultAlignForAttributeAligned = (byte)64;
        this.MinGlobalAlign = (byte)16;
        this.resetDataLayout(new StringRef("E-m:e-i1:8:16-i8:8:16-i64:64-f128:64-a:8:16-n32:64"));
        this.MaxAtomicInlineWidth = (byte)64;
        this.MaxAtomicPromoteWidth = (byte)64;
    }

    @Override
    public void getTargetDefines(LangOptions Opts, MacroBuilder Builder2) {
        Builder2.defineMacro(new Twine("__s390__"));
        Builder2.defineMacro(new Twine("__s390x__"));
        Builder2.defineMacro(new Twine("__zarch__"));
        Builder2.defineMacro(new Twine("__LONG_DOUBLE_128__"));
        Builder2.defineMacro(new Twine("__GCC_HAVE_SYNC_COMPARE_AND_SWAP_1"));
        Builder2.defineMacro(new Twine("__GCC_HAVE_SYNC_COMPARE_AND_SWAP_2"));
        Builder2.defineMacro(new Twine("__GCC_HAVE_SYNC_COMPARE_AND_SWAP_4"));
        Builder2.defineMacro(new Twine("__GCC_HAVE_SYNC_COMPARE_AND_SWAP_8"));
        if (this.HasTransactionalExecution) {
            Builder2.defineMacro(new Twine("__HTM__"));
        }
        if (Opts.ZVector) {
            Builder2.defineMacro(new Twine("__VEC__"), new Twine("10301"));
        }
    }

    @Override
    public ArrayRef<Builtin.Info> getTargetBuiltins() {
        return llvm.makeArrayRef((Object[])BuiltinInfo, (int)(1191 - Builtin.ID.FirstTSBuiltin.getValue()));
    }

    @Override
    public ArrayRef<char.ptr> getGCCRegNames() {
        return llvm.makeArrayRef((Object[])GCCRegNames);
    }

    @Override
    public ArrayRef<TargetInfo.GCCRegAlias> getGCCRegAliases() {
        return ArrayRef.None();
    }

    @Override
    public boolean validateAsmConstraint(char.ptr Name, TargetInfo.ConstraintInfo Info2) {
        switch (Name.$star()) {
            default: {
                return false;
            }
            case 97: 
            case 100: 
            case 102: {
                Info2.setAllowsRegister();
                return true;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                return true;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
        }
        Info2.setAllowsMemory();
        return true;
    }

    @Override
    public char.ptr getClobbers() {
        return NativePointer.$EMPTY;
    }

    @Override
    public TargetInfo.BuiltinVaListKind getBuiltinVaListKind() {
        return TargetInfo.BuiltinVaListKind.SystemZBuiltinVaList;
    }

    @Override
    public boolean setCPU(std.string Name) {
        this.CPU.$assign(Name);
        boolean CPUKnown = new StringSwitchBool(new StringRef(Name)).Case("z10", true).Case("z196", true).Case("zEC12", true).Case("z13", true).Default(false);
        return CPUKnown;
    }

    @Override
    public boolean initFeatureMap(StringMapBool Features, DiagnosticsEngine Diags, StringRef CPU, std.vectorString FeaturesVec) {
        if (llvm.$eq_StringRef((StringRef)CPU, (String)"zEC12")) {
            Features.$set("transactional-execution", true);
        }
        if (llvm.$eq_StringRef((StringRef)CPU, (String)"z13")) {
            Features.$set("transactional-execution", true);
            Features.$set("vector", true);
        }
        return super.initFeatureMap(Features, Diags, CPU, FeaturesVec);
    }

    @Override
    public boolean handleTargetFeatures(std.vectorString Features, DiagnosticsEngine Diags) {
        this.HasTransactionalExecution = false;
        for (std.string Feature2 : Features) {
            if (std.$eq_string$C_T((std.string)Feature2, (String)"+transactional-execution")) {
                this.HasTransactionalExecution = true;
                continue;
            }
            if (!std.$eq_string$C_T((std.string)Feature2, (String)"+vector")) continue;
            this.HasVector = true;
        }
        if (this.HasVector) {
            this.MaxVectorAlign = (char)64;
            this.resetDataLayout(new StringRef("E-m:e-i1:8:16-i8:8:16-i64:64-f128:64-v128:64-a:8:16-n32:64"));
        }
        return true;
    }

    @Override
    public boolean hasFeature(StringRef Feature2) {
        return new StringSwitchBool(Feature2).Case("systemz", true).Case("htm", this.HasTransactionalExecution).Case("vx", this.HasVector).Default(false);
    }

    @Override
    public TargetInfo.CallingConvCheckResult checkCallingConvention(CallingConv CC) {
        switch (CC) {
            case CC_C: 
            case CC_Swift: {
                return TargetInfo.CallingConvCheckResult.CCCR_OK;
            }
        }
        return TargetInfo.CallingConvCheckResult.CCCR_Warning;
    }

    @Override
    public StringRef getABI() {
        if (this.HasVector) {
            return new StringRef("vector");
        }
        return new StringRef(NativePointer.$EMPTY);
    }

    @Override
    public boolean useFloat128ManglingForLongDouble() {
        return true;
    }

    @Override
    public void $destroy() {
        this.CPU.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "CPU=" + this.CPU + ", HasTransactionalExecution=" + this.HasTransactionalExecution + ", HasVector=" + this.HasVector + super.toString();
    }
}

