/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.OSTargetInfo;
import org.clang.basic.target.impl.TargetInfo;
import org.clang.basic.target.impl.TargetsStatics;
import org.clank.support.JavaDifferentiators;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;

public class FreeBSDTargetInfo<Target extends TargetInfo>
extends OSTargetInfo<Target> {
    private static final int FREEBSD_CC_VERSION = 0;

    @Override
    protected void getOSDefines(LangOptions Opts, Triple Triple2, MacroBuilder Builder2) {
        int CCVersion;
        int Release = Triple2.getOSMajorVersion();
        if (Release == 0) {
            Release = 8;
        }
        if ((CCVersion = 0) == 0) {
            CCVersion = Release * 100000 + 1;
        }
        Builder2.defineMacro(new Twine("__FreeBSD__"), new Twine(JavaDifferentiators.JD$UInt.INSTANCE, Release));
        Builder2.defineMacro(new Twine("__FreeBSD_cc_version"), new Twine(JavaDifferentiators.JD$UInt.INSTANCE, CCVersion));
        Builder2.defineMacro(new Twine("__KPRINTF_ATTRIBUTE__"));
        TargetsStatics.DefineStd(Builder2, new StringRef("unix"), Opts);
        Builder2.defineMacro(new Twine("__ELF__"));
        Builder2.defineMacro(new Twine("__STDC_MB_MIGHT_NEQ_WC__"), new Twine(NativePointer.$1));
    }

    public FreeBSDTargetInfo(Target T2, Triple Triple2, TargetOptions Opts) {
        super(T2, Triple2, Opts);
        switch (Triple2.getArch()) {
            default: {
                this.tgt.MCountName = NativePointer.$((String)".mcount");
                break;
            }
            case mips: 
            case mipsel: 
            case ppc: 
            case ppc64: 
            case ppc64le: {
                this.tgt.MCountName = NativePointer.$((String)"_mcount");
                break;
            }
            case arm: {
                this.tgt.MCountName = NativePointer.$((String)"__mcount");
            }
        }
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

