/*
 * Decompiled with CFR 0.152.
 */
package fleet.language.json.parser;

import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.language.json.parser.DecoderState;
import fleet.language.json.parser.JsonDeserializationException;
import fleet.language.json.parser.JsonObjectProperty;
import fleet.language.json.parser.TreeWalkerDecoderKt;
import fleet.language.json.parser.TreeWalkerUtilsKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CB\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u001b\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\u000bJ#\u0010\u0016\u001a\u0006\b\u0002\u0018\u0001H\u0017\"\u0006\b\u0000\u0010\u0017\u0018\u0001*\u0004\u0018\u0001H\u0017H\u0082\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J=\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\u0006\b\u0000\u0010\u0017\u0018\u0001\"\u0006\b\u0001\u0010\u001a\u0018\u0001*\u0002H\u00172\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u001a0\u001c\u00a2\u0006\u0002\b\u001dH\u0082\b\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0006H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u0006H\u0016J\b\u00101\u001a\u000202H\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0016J\u0010\u00105\u001a\u00020)2\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u000207H\u0016J\u0010\u0010@\u001a\u00020)2\u0006\u0010?\u001a\u000207H\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010?\u001a\u000207H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020:098BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006D"}, d2={"Lfleet/language/json/parser/SyntaxNodeDecoder;", "Lkotlinx/serialization/json/JsonDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "state", "Lfleet/language/json/parser/DecoderState;", "graceful", "", "<init>", "(Lfleet/language/json/parser/DecoderState;Z)V", "node", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "(Lfleet/com/jetbrains/lang/syntax/SyntaxNode;Z)V", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "getNode", "()Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "ensure", "T", "(Ljava/lang/Object;)Ljava/lang/Object;", "convert", "R", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "decodeBoolean", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeFloat", "", "decodeInt", "", "decodeLong", "", "decodeShort", "", "decodeString", "", "decodeNotNullMark", "decodeJsonElement", "Lkotlinx/serialization/json/JsonElement;", "decodeNull", "", "decodeEnum", "enumDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "nodeObject", "Lkotlin/sequences/Sequence;", "Lfleet/language/json/parser/JsonObjectProperty;", "getNodeObject", "()Lkotlin/sequences/Sequence;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "decodeElementIndex", "endStructure", "", "Companion", "fleet.plugins.json.parsing.common"})
@SourceDebugExtension(value={"SMAP\nTreeWalkerDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeWalkerDecoder.kt\nfleet/language/json/parser/SyntaxNodeDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n38#1:185\n41#1,6:186\n38#1:192\n38#1:193\n38#1:194\n41#1,6:195\n38#1:201\n38#1:202\n41#1,6:203\n38#1:209\n41#1,6:210\n38#1:216\n38#1:217\n1#2:218\n*S KotlinDebug\n*F\n+ 1 TreeWalkerDecoder.kt\nfleet/language/json/parser/SyntaxNodeDecoder\n*L\n48#1:185\n49#1:186,6\n49#1:192\n50#1:193\n51#1:194\n52#1:195,6\n52#1:201\n53#1:202\n54#1:203,6\n54#1:209\n55#1:210,6\n55#1:216\n56#1:217\n*E\n"})
public final class SyntaxNodeDecoder
extends AbstractDecoder
implements JsonDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DecoderState state;
    private final boolean graceful;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private static final Json.Default someJson = Json.Default;

    private SyntaxNodeDecoder(DecoderState state, boolean graceful) {
        this.state = state;
        this.graceful = graceful;
        this.serializersModule = SerializersModuleKt.getEmptySerializersModule();
    }

    public SyntaxNodeDecoder(@NotNull SyntaxNode node, boolean graceful) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this(new DecoderState.Value(node), graceful);
    }

    public /* synthetic */ SyntaxNodeDecoder(SyntaxNode syntaxNode, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(syntaxNode, bl);
    }

    @NotNull
    public Json getJson() {
        return (Json)someJson;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    private final SyntaxNode getNode() {
        return this.state.getNode();
    }

    private final /* synthetic */ <T> T ensure(T $this$ensure) {
        boolean $i$f$ensure = false;
        T t = $this$ensure;
        if (t == null) {
            CharSequence charSequence = this.getNode().getText();
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            throw new JsonDeserializationException(charSequence + " is not a proper " + null, this.getNode());
        }
        return t;
    }

    private final /* synthetic */ <T, R> R convert(T $this$convert, Function1<? super T, ? extends R> f) {
        Object object;
        boolean $i$f$convert = false;
        try {
            object = f.invoke($this$convert);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = null;
        }
        return (R)object;
    }

    /*
     * WARNING - void declaration
     */
    public boolean decodeBoolean() {
        SyntaxNodeDecoder syntaxNodeDecoder = this;
        Boolean $this$ensure$iv = TreeWalkerUtilsKt.asJsonBoolean(this.getNode());
        boolean $i$f$ensure = false;
        Boolean bl = $this$ensure$iv;
        if (bl == null) {
            void this_$iv;
            throw new JsonDeserializationException(super.getNode().getText() + " is not a proper " + Reflection.typeOf(Boolean.TYPE), super.getNode());
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public byte decodeByte() {
        Byte by;
        SyntaxNodeDecoder syntaxNodeDecoder = this;
        Integer n = TreeWalkerUtilsKt.asJsonInt(this.getNode());
        if (n != null) {
            Byte by2;
            SyntaxNodeDecoder syntaxNodeDecoder2 = this;
            Integer $this$convert$iv = n;
            boolean $i$f$convert = false;
            try {
                int $this$decodeByte_u24lambda_u240 = ((Number)$this$convert$iv).intValue();
                boolean bl = false;
                by2 = (byte)$this$decodeByte_u24lambda_u240;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                by2 = null;
            }
            by = by2;
        } else {
            by = null;
        }
        Byte $this$ensure$iv = by;
        boolean $i$f$ensure = false;
        Byte by3 = $this$ensure$iv;
        if (by3 == null) {
            void this_$iv;
            throw new JsonDeserializationException(super.getNode().getText() + " is not a proper " + Reflection.typeOf(Byte.TYPE), super.getNode());
        }
        return ((Number)by3).byteValue();
    }

    /*
     * WARNING - void declaration
     */
    public char decodeChar() {
        SyntaxNodeDecoder syntaxNodeDecoder = this;
        Character $this$ensure$iv = StringsKt.singleOrNull((CharSequence)this.decodeString());
        boolean $i$f$ensure = false;
        Character c = $this$ensure$iv;
        if (c == null) {
            void this_$iv;
            throw new JsonDeserializationException(super.getNode().getText() + " is not a proper " + Reflection.typeOf(Character.TYPE), super.getNode());
        }
        return c.charValue();
    }

    /*
     * WARNING - void declaration
     */
    public double decodeDouble() {
        SyntaxNodeDecoder syntaxNodeDecoder = this;
        Double $this$ensure$iv = TreeWalkerUtilsKt.asJsonDouble(this.getNode());
        boolean $i$f$ensure = false;
        Double d = $this$ensure$iv;
        if (d == null) {
            void this_$iv;
            throw new JsonDeserializationException(super.getNode().getText() + " is not a proper " + Reflection.typeOf(Double.TYPE), super.getNode());
        }
        return ((Number)d).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public float decodeFloat() {
        Float f;
        SyntaxNodeDecoder syntaxNodeDecoder = this;
        Double d = TreeWalkerUtilsKt.asJsonDouble(this.getNode());
        if (d != null) {
            Float f2;
            SyntaxNodeDecoder syntaxNodeDecoder2 = this;
            Double $this$convert$iv = d;
            boolean $i$f$convert = false;
            try {
                double $this$decodeFloat_u24lambda_u241 = ((Number)$this$convert$iv).doubleValue();
                boolean bl = false;
                f2 = Float.valueOf((float)$this$decodeFloat_u24lambda_u241);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                f2 = null;
            }
            f = f2;
        } else {
            f = null;
        }
        Float $this$ensure$iv = f;
        boolean $i$f$ensure = false;
        Float f3 = $this$ensure$iv;
        if (f3 == null) {
            void this_$iv;
            throw new JsonDeserializationException(super.getNode().getText() + " is not a proper " + Reflection.typeOf(Float.TYPE), super.getNode());
        }
        return ((Number)f3).floatValue();
    }

    /*
     * WARNING - void declaration
     */
    public int decodeInt() {
        SyntaxNodeDecoder syntaxNodeDecoder = this;
        Integer $this$ensure$iv = TreeWalkerUtilsKt.asJsonInt(this.getNode());
        boolean $i$f$ensure = false;
        Integer n = $this$ensure$iv;
        if (n == null) {
            void this_$iv;
            throw new JsonDeserializationException(super.getNode().getText() + " is not a proper " + Reflection.typeOf(Integer.TYPE), super.getNode());
        }
        return ((Number)n).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public long decodeLong() {
        Long l;
        SyntaxNodeDecoder syntaxNodeDecoder = this;
        Long l2 = TreeWalkerUtilsKt.asJsonLong(this.getNode());
        if (l2 != null) {
            Long l3;
            SyntaxNodeDecoder syntaxNodeDecoder2 = this;
            Long $this$convert$iv = l2;
            boolean $i$f$convert = false;
            try {
                long $this$decodeLong_u24lambda_u242 = ((Number)$this$convert$iv).longValue();
                boolean bl = false;
                l3 = $this$decodeLong_u24lambda_u242;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = null;
            }
            l = l3;
        } else {
            l = null;
        }
        Long $this$ensure$iv = l;
        boolean $i$f$ensure = false;
        Long l4 = $this$ensure$iv;
        if (l4 == null) {
            void this_$iv;
            throw new JsonDeserializationException(super.getNode().getText() + " is not a proper " + Reflection.typeOf(Long.TYPE), super.getNode());
        }
        return ((Number)l4).longValue();
    }

    /*
     * WARNING - void declaration
     */
    public short decodeShort() {
        Short s;
        SyntaxNodeDecoder syntaxNodeDecoder = this;
        Integer n = TreeWalkerUtilsKt.asJsonInt(this.getNode());
        if (n != null) {
            Short s2;
            SyntaxNodeDecoder syntaxNodeDecoder2 = this;
            Integer $this$convert$iv = n;
            boolean $i$f$convert = false;
            try {
                int $this$decodeShort_u24lambda_u243 = ((Number)$this$convert$iv).intValue();
                boolean bl = false;
                s2 = (short)$this$decodeShort_u24lambda_u243;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                s2 = null;
            }
            s = s2;
        } else {
            s = null;
        }
        Short $this$ensure$iv = s;
        boolean $i$f$ensure = false;
        Short s3 = $this$ensure$iv;
        if (s3 == null) {
            void this_$iv;
            throw new JsonDeserializationException(super.getNode().getText() + " is not a proper " + Reflection.typeOf(Short.TYPE), super.getNode());
        }
        return ((Number)s3).shortValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String decodeString() {
        SyntaxNodeDecoder syntaxNodeDecoder = this;
        String $this$ensure$iv = TreeWalkerUtilsKt.asJsonString(this.getNode());
        boolean $i$f$ensure = false;
        String string = $this$ensure$iv;
        if (string == null) {
            void this_$iv;
            throw new JsonDeserializationException(super.getNode().getText() + " is not a proper " + Reflection.typeOf(String.class), super.getNode());
        }
        return string;
    }

    public boolean decodeNotNullMark() {
        return !TreeWalkerUtilsKt.isJsonNull(this.getNode());
    }

    @NotNull
    public JsonElement decodeJsonElement() {
        return TreeWalkerDecoderKt.toJsonElement(this.getNode(), this.graceful);
    }

    @Nullable
    public Void decodeNull() {
        if (!TreeWalkerUtilsKt.isJsonNull(this.getNode())) {
            throw new JsonDeserializationException(this.getNode() + " is not Null", this.getNode());
        }
        return null;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        String it = this.decodeString();
        boolean bl = false;
        return enumDescriptor.getElementIndex(it);
    }

    private final Sequence<JsonObjectProperty> getNodeObject() {
        Sequence<JsonObjectProperty> sequence = TreeWalkerUtilsKt.jsonObjectPropertiesCursorOrNull(this.getNode());
        if (sequence == null) {
            throw new JsonDeserializationException("Expected an object", this.getNode());
        }
        return sequence;
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            compositeDecoder = (CompositeDecoder)new SyntaxNodeDecoder(new DecoderState.Mapping(this.getNodeObject()), this.graceful);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) {
            compositeDecoder = (CompositeDecoder)new SyntaxNodeDecoder(new DecoderState.Object(this.getNodeObject()), this.graceful);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            compositeDecoder = (CompositeDecoder)new SyntaxNodeDecoder(new DecoderState.Object(this.getNodeObject()), this.graceful);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            Sequence<SyntaxNode> sequence = TreeWalkerUtilsKt.jsonArrayItemsCursor(this.getNode());
            if (sequence == null) {
                throw new JsonDeserializationException("Expected an array", this.getNode());
            }
            Sequence<SyntaxNode> it = sequence;
            boolean bl = false;
            compositeDecoder = (CompositeDecoder)new SyntaxNodeDecoder(new DecoderState.Array((Sequence<? extends SyntaxNode>)it), this.graceful);
        } else {
            throw new IllegalStateException(("Unsupported SerialKind: " + descriptor.getKind()).toString());
        }
        return compositeDecoder;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        DecoderState decoderState = this.state;
        if (decoderState instanceof DecoderState.Object) {
            if (!((DecoderState.Object)this.state).hasNext()) {
                return -1;
            }
            JsonObjectProperty property = (JsonObjectProperty)((DecoderState.Object)this.state).next();
            SyntaxNode it = property.getKeyNode();
            boolean bl = false;
            String key = new SyntaxNodeDecoder(new DecoderState.Value(it), this.graceful).decodeString();
            return descriptor.getElementIndex(key);
        }
        if (decoderState instanceof DecoderState.Mapping) {
            if (!((DecoderState.Mapping)this.state).hasNext()) {
                return -1;
            }
            int idx = ((Number)((Pair)((DecoderState.Mapping)this.state).next()).component1()).intValue();
            return idx;
        }
        if (decoderState instanceof DecoderState.Array) {
            if (!((DecoderState.Array)this.state).hasNext()) {
                return -1;
            }
            return ((IndexedValue)((DecoderState.Array)this.state).next()).getIndex();
        }
        throw new IllegalStateException("Impossible".toString());
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.state instanceof Iterator && ((Iterator)((Object)this.state)).hasNext()) {
            throw new JsonDeserializationException(this.getNode() + " has unhandled items", this.getNode());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lfleet/language/json/parser/SyntaxNodeDecoder$Companion;", "", "<init>", "()V", "someJson", "Lkotlinx/serialization/json/Json$Default;", "fleet.plugins.json.parsing.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

