/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.markdown.frontend.preview;

import fleet.plugins.markdown.frontend.language.BackendAstKt;
import fleet.plugins.markdown.frontend.language.HeadersKt;
import fleet.plugins.markdown.frontend.preview.HeaderGeneratingProvider;
import fleet.plugins.markdown.frontend.preview.HeaderGeneratingProviderKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.visitors.Visitor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bR\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lfleet/plugins/markdown/frontend/preview/HeaderGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "tag", "", "classes", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "node", "Lorg/intellij/markdown/ast/ASTNode;", "Companion", "fleet.plugins.markdown.frontend"})
@SourceDebugExtension(value={"SMAP\nHeaderGeneratingProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderGeneratingProvider.kt\nfleet/plugins/markdown/frontend/preview/HeaderGeneratingProvider\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,133:1\n37#2,2:134\n*S KotlinDebug\n*F\n+ 1 HeaderGeneratingProvider.kt\nfleet/plugins/markdown/frontend/preview/HeaderGeneratingProvider\n*L\n35#1:134,2\n*E\n"})
public abstract class HeaderGeneratingProvider
implements GeneratingProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;
    @NotNull
    private final List<String> classes;
    @NotNull
    private static final Set<IElementType> Whitespaces;
    @NotNull
    private static final Regex EntityRegex;

    public HeaderGeneratingProvider(@NotNull String tag, @NotNull List<String> classes) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        this.tag = tag;
        this.classes = classes;
    }

    public /* synthetic */ HeaderGeneratingProvider(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, list);
    }

    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text2, @NotNull ASTNode node) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String anchorText = HeaderGeneratingProvider.Companion.buildUniqueAnchorText(node, text2);
        String[] $this$processNode_u24lambda_u240 = stringArray = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$processNode_u24lambda_u240.add("id=\"" + anchorText + "\"");
        String classList = CollectionsKt.joinToString$default((Iterable)this.classes, (CharSequence)" ", (CharSequence)"class=\"", (CharSequence)"\"", (int)0, null, null, (int)56, null);
        $this$processNode_u24lambda_u240.add(classList);
        List attributes = CollectionsKt.build((List)stringArray);
        Collection $this$toTypedArray$iv = attributes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new String[0]);
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor, (ASTNode)node, (CharSequence)this.tag, (CharSequence[])Arrays.copyOf(stringArray, stringArray.length), (boolean)false, (int)8, null);
        ASTNodeKt.acceptChildren((ASTNode)node, (Visitor)((Visitor)visitor));
        visitor.consumeTagClose((CharSequence)this.tag);
    }

    public static final /* synthetic */ Set access$getWhitespaces$cp() {
        return Whitespaces;
    }

    static {
        Object[] objectArray = new IElementType[]{MarkdownTokenTypes.EOL, MarkdownTokenTypes.WHITE_SPACE};
        Whitespaces = SetsKt.setOf((Object[])objectArray);
        EntityRegex = new Regex("&(?:([a-zA-Z0-9]+)|#([0-9]{1,8})|#[xX]([a-fA-F0-9]{1,8}));");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\u0015\u001a\u00020\u0016*\u00060\u0017j\u0002`\u00182\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lfleet/plugins/markdown/frontend/preview/HeaderGeneratingProvider$Companion;", "", "<init>", "()V", "Whitespaces", "", "Lorg/intellij/markdown/IElementType;", "findContentHolder", "Lorg/intellij/markdown/ast/ASTNode;", "node", "buildAnchorText", "", "fileText", "buildUniqueAnchorText", "createUniqueAnchorText", "rawAnchorText", "occurenceNumber", "", "calculateUniqueNumber", "obtainLinkTextElements", "Lkotlin/sequences/Sequence;", "processInlineLink", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "EntityRegex", "Lkotlin/text/Regex;", "replaceEntities", "text", "", "fleet.plugins.markdown.frontend"})
    @SourceDebugExtension(value={"SMAP\nHeaderGeneratingProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderGeneratingProvider.kt\nfleet/plugins/markdown/frontend/preview/HeaderGeneratingProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ASTNode findContentHolder(ASTNode node) {
            Object v0;
            block1: {
                Sequence<ASTNode> sequence = BackendAstKt.children(node);
                for (Object e : sequence) {
                    ASTNode it = (ASTNode)e;
                    boolean bl = false;
                    if (!HeadersKt.getHeaderContentHolderTypes().contains(it.getType())) continue;
                    v0 = e;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final String buildAnchorText(@NotNull ASTNode node, @NotNull String fileText) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
            ASTNode aSTNode = this.findContentHolder(node);
            if (aSTNode == null) {
                return null;
            }
            ASTNode contentHolder = aSTNode;
            Sequence children2 = SequencesKt.dropWhile(BackendAstKt.children(contentHolder), (Function1)buildAnchorText.children.1.INSTANCE);
            StringBuilder $this$buildAnchorText_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            int count = 0;
            for (ASTNode child : children2) {
                if (Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.WHITE_SPACE)) {
                    $this$buildAnchorText_u24lambda_u241.append(" ");
                    continue;
                }
                IElementType iElementType = child.getType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.IMAGE)) {
                    v1 = $this$buildAnchorText_u24lambda_u241.append("");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_LINK)) {
                    Companion.processInlineLink($this$buildAnchorText_u24lambda_u241, child, fileText);
                    v1 = Unit.INSTANCE;
                } else {
                    v1 = $this$buildAnchorText_u24lambda_u241.append(ASTUtilKt.getTextInNode((ASTNode)child, (CharSequence)fileText));
                }
                ++count;
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String text2 = string;
            String string2 = this.replaceEntities(text2).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            CharSequence charSequence = string2;
            Regex regex = HeaderGeneratingProviderKt.access$getHeaderGarbageRegex$p();
            String string3 = "";
            String replaced = StringsKt.replace$default((String)regex.replace(charSequence, string3), (String)" ", (String)"-", (boolean)false, (int)4, null);
            return replaced;
        }

        private final String buildUniqueAnchorText(ASTNode node, String fileText) {
            String string = this.buildAnchorText(node, fileText);
            if (string == null) {
                return null;
            }
            String anchorText = string;
            int number = this.calculateUniqueNumber(node, fileText, anchorText);
            return this.createUniqueAnchorText(anchorText, number);
        }

        private final String createUniqueAnchorText(String rawAnchorText, int occurenceNumber) {
            return occurenceNumber == 0 ? rawAnchorText : rawAnchorText + "-" + occurenceNumber;
        }

        private final int calculateUniqueNumber(ASTNode node, String fileText, String rawAnchorText) {
            IElementType[] iElementTypeArray = new IElementType[]{MarkdownElementTypes.MARKDOWN_FILE};
            ASTNode aSTNode = ASTUtilKt.getParentOfType((ASTNode)node, (IElementType[])iElementTypeArray);
            if (aSTNode == null) {
                return 0;
            }
            ASTNode file = aSTNode;
            Sequence headers2 = SequencesKt.filter(BackendAstKt.traverse(file), (Function1)calculateUniqueNumber.headers.1.INSTANCE);
            Sequence sameHeaders2 = SequencesKt.filter((Sequence)headers2, (Function1)((Function1)new Function1<ASTNode, Boolean>(fileText, rawAnchorText){
                final /* synthetic */ String $fileText;
                final /* synthetic */ String $rawAnchorText;
                {
                    this.$fileText = $fileText;
                    this.$rawAnchorText = $rawAnchorText;
                    super(1);
                }

                public final Boolean invoke(ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)HeaderGeneratingProvider.Companion.buildAnchorText(it, this.$fileText), (Object)this.$rawAnchorText);
                }
            }));
            return SequencesKt.count((Sequence)SequencesKt.takeWhile((Sequence)sameHeaders2, (Function1)((Function1)new Function1<ASTNode, Boolean>(node){
                final /* synthetic */ ASTNode $node;
                {
                    this.$node = $node;
                    super(1);
                }

                public final Boolean invoke(ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it, (Object)this.$node);
                }
            })));
        }

        private final Sequence<ASTNode> obtainLinkTextElements(ASTNode node) {
            Iterator iterator;
            Object object;
            Object v0;
            Iterator iterator2;
            ASTNode aSTNode;
            block6: {
                aSTNode = BackendAstKt.children(node);
                iterator2 = aSTNode.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    ASTNode it = (ASTNode)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_TEXT)) continue;
                    v0 = e;
                    break block6;
                }
                v0 = null;
            }
            ASTNode aSTNode2 = v0;
            if (aSTNode2 == null) {
                return SequencesKt.emptySequence();
            }
            ASTNode textHolder = aSTNode2;
            ASTNode aSTNode3 = BackendAstKt.getFirstChild(textHolder);
            if (aSTNode3 != null) {
                ASTNode it = aSTNode = aSTNode3;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET) ? aSTNode : null;
            } else {
                object = null;
            }
            ASTNode openBracket = object;
            ASTNode aSTNode4 = BackendAstKt.getLastChild(textHolder);
            if (aSTNode4 != null) {
                Iterator it = iterator2 = aSTNode4;
                boolean bl = false;
                iterator = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET) ? iterator2 : null;
            } else {
                iterator = null;
            }
            Iterator closeBracket = iterator;
            return SequencesKt.filterNot(BackendAstKt.children(textHolder), (Function1)((Function1)new Function1<ASTNode, Boolean>(openBracket, closeBracket){
                final /* synthetic */ ASTNode $openBracket;
                final /* synthetic */ ASTNode $closeBracket;
                {
                    this.$openBracket = $openBracket;
                    this.$closeBracket = $closeBracket;
                    super(1);
                }

                public final Boolean invoke(ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$openBracket) || Intrinsics.areEqual((Object)it, (Object)this.$closeBracket);
                }
            }));
        }

        private final void processInlineLink(StringBuilder $this$processInlineLink, ASTNode node, String fileText) {
            Sequence<ASTNode> contentElements = this.obtainLinkTextElements(node);
            Sequence withoutWhitespaces2 = SequencesKt.filterNot(contentElements, (Function1)processInlineLink.withoutWhitespaces.1.INSTANCE);
            SequencesKt.joinTo$default((Sequence)withoutWhitespaces2, (Appendable)$this$processInlineLink, (CharSequence)" ", null, null, (int)0, null, (Function1)((Function1)new Function1<ASTNode, CharSequence>(fileText){
                final /* synthetic */ String $fileText;
                {
                    this.$fileText = $fileText;
                    super(1);
                }

                public final CharSequence invoke(ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.IMAGE) ? (CharSequence)"" : ASTUtilKt.getTextInNode((ASTNode)it, (CharSequence)this.$fileText);
                }
            }), (int)60, null);
        }

        private final String replaceEntities(CharSequence text2) {
            return EntityRegex.replace(text2, (Function1)replaceEntities.1.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

