/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.markdown.frontend.language;

import andel.text.TextRange;
import andel.text.TextRangeKt;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.frontend.lang.FoldableNodeAspect;
import fleet.plugins.markdown.frontend.language.HeadersKt;
import fleet.plugins.markdown.frontend.language.MarkdownHeaderFoldableAspect;
import fleet.plugins.markdown.frontend.language.MarkdownHeaderFoldableAspect$foldableRegions$;
import fleet.plugins.markdown.frontend.language.MarkdownSyntaxNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.markdown.MarkdownElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J2\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f*\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lfleet/plugins/markdown/frontend/language/MarkdownHeaderFoldableAspect;", "Lfleet/frontend/lang/FoldableNodeAspect;", "<init>", "()V", "foldableRegions", "", "Landel/text/TextRange;", "node", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "removeAll", "", "K", "V", "", "keys", "", "fleet.plugins.markdown.frontend"})
@SourceDebugExtension(value={"SMAP\nMarkdownFoldableBlockAspect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownFoldableBlockAspect.kt\nfleet/plugins/markdown/frontend/language/MarkdownHeaderFoldableAspect\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,90:1\n1#2:91\n477#3:92\n487#4,7:93\n*S KotlinDebug\n*F\n+ 1 MarkdownFoldableBlockAspect.kt\nfleet/plugins/markdown/frontend/language/MarkdownHeaderFoldableAspect\n*L\n59#1:92\n63#1:93,7\n*E\n"})
public final class MarkdownHeaderFoldableAspect
implements FoldableNodeAspect {
    @NotNull
    public static final MarkdownHeaderFoldableAspect INSTANCE = new MarkdownHeaderFoldableAspect();

    private MarkdownHeaderFoldableAspect() {
    }

    @NotNull
    public List<TextRange> foldableRegions(@NotNull SyntaxNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        MarkdownSyntaxNode markdownSyntaxNode = node instanceof MarkdownSyntaxNode ? (MarkdownSyntaxNode)node : null;
        if (markdownSyntaxNode == null) {
            return CollectionsKt.emptyList();
        }
        MarkdownSyntaxNode file = markdownSyntaxNode;
        if (!Intrinsics.areEqual((Object)file.getType(), (Object)MarkdownElementTypes.MARKDOWN_FILE)) {
            boolean $i$a$-check-MarkdownHeaderFoldableAspect$foldableRegions$22 = false;
            String $i$a$-check-MarkdownHeaderFoldableAspect$foldableRegions$22 = "Should be invoked only on files. Was invoked on " + file.getType() + ".";
            throw new IllegalStateException($i$a$-check-MarkdownHeaderFoldableAspect$foldableRegions$22.toString());
        }
        List ranges = new ArrayList();
        Sequence $this$filterIsInstance$iv = SyntaxNodeExtKt.children((SyntaxNode)file);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)foldableRegions$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence headers2 = SequencesKt.filter((Sequence)sequence, (Function1)foldableRegions.headers.1.INSTANCE);
        HashMap state = new HashMap();
        for (MarkdownSyntaxNode header : headers2) {
            Integer n = HeadersKt.headerLevel(header.getType());
            if (n == null) {
                continue;
            }
            int level = n;
            Map $this$filterKeys$iv = state;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                int it = ((Number)entry$iv.getKey()).intValue();
                boolean bl = false;
                if (!(it >= level)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map previousHeaders = result$iv;
            Iterator iterator = previousHeaders.values().iterator();
            while (iterator.hasNext()) {
                long endOffset;
                long startOffset = ((Number)iterator.next()).longValue();
                TextRange range = new TextRange(startOffset, endOffset = RangesKt.coerceAtLeast((long)(header.getStartOffset() - 1L), (long)0L));
                if (!TextRangeKt.isNotEmpty((TextRange)range)) continue;
                ranges.add(range);
            }
            this.removeAll(state, previousHeaders.keySet());
            Integer startOffset = level;
            ((Map)state).put(startOffset, header.getStartOffset());
        }
        long endOffset = file.getEndOffset();
        for (Object v : state.values()) {
            Intrinsics.checkNotNullExpressionValue(v, (String)"next(...)");
            long startOffset = ((Number)v).longValue();
            TextRange range = new TextRange(startOffset, endOffset);
            if (!TextRangeKt.isNotEmpty((TextRange)range)) continue;
            ranges.add(range);
        }
        return ranges;
    }

    private final <K, V> void removeAll(Map<K, V> $this$removeAll, Collection<? extends K> keys) {
        for (K key : keys) {
            $this$removeAll.remove(key);
        }
    }

    @Nullable
    public String placeholder(@NotNull SyntaxNode node) {
        return FoldableNodeAspect.DefaultImpls.placeholder((FoldableNodeAspect)this, (SyntaxNode)node);
    }

    public boolean defaultFolded(@NotNull SyntaxNode node, @NotNull TextRange textRange) {
        return FoldableNodeAspect.DefaultImpls.defaultFolded((FoldableNodeAspect)this, (SyntaxNode)node, (TextRange)textRange);
    }
}

