/*
 * Decompiled with CFR 0.152.
 */
package noria.ui.components.awt;

import androidx.compose.ui.text.FontRasterizationSettings;
import fleet.compose.theme.text.FontCacheKt;
import fleet.compose.theme.text.NoriaParagraphStyle;
import fleet.compose.theme.text.ParagraphKt;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.util.Locale;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.ui.components.awt.CompatibilityFontCollectionKt;
import noria.ui.components.awt.SkiaGraphics;
import noria.ui.components.awt.SkiaGraphicsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.FontStyle;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skia.paragraph.FontCollection;
import org.jetbrains.skia.paragraph.Paragraph;
import org.jetbrains.skia.paragraph.ParagraphBuilder;
import org.jetbrains.skia.paragraph.TextStyle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lnoria/ui/components/awt/SkikoContainer;", "Ljavax/swing/text/JTextComponent;", "document", "Ljavax/swing/text/html/HTMLDocument;", "fontRasterSettings", "Landroidx/compose/ui/text/FontRasterizationSettings;", "<init>", "(Ljavax/swing/text/html/HTMLDocument;Landroidx/compose/ui/text/FontRasterizationSettings;)V", "getFontRasterSettings", "()Landroidx/compose/ui/text/FontRasterizationSettings;", "getFontMetrics", "Ljava/awt/FontMetrics;", "font", "Ljava/awt/Font;", "getFont", "updateUI", "", "fleet.noria.awt"})
@SourceDebugExtension(value={"SMAP\nBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Browser.kt\nnoria/ui/components/awt/SkikoContainer\n+ 2 Managed.kt\norg/jetbrains/skia/impl/ManagedKt\n*L\n1#1,302:1\n22#2,5:303\n*S KotlinDebug\n*F\n+ 1 Browser.kt\nnoria/ui/components/awt/SkikoContainer\n*L\n252#1:303,5\n*E\n"})
final class SkikoContainer
extends JTextComponent {
    @NotNull
    private final FontRasterizationSettings fontRasterSettings;

    public SkikoContainer(@NotNull HTMLDocument document, @NotNull FontRasterizationSettings fontRasterSettings) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)fontRasterSettings, (String)"fontRasterSettings");
        this.fontRasterSettings = fontRasterSettings;
        this.setLocale(Locale.US);
        this.setDocument(document);
    }

    @NotNull
    public final FontRasterizationSettings getFontRasterSettings() {
        return this.fontRasterSettings;
    }

    @Override
    @NotNull
    public FontMetrics getFontMetrics(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        org.jetbrains.skia.Font skiaFont = CompatibilityFontCollectionKt.findEquivalentSkiaFont(font, this.fontRasterSettings);
        org.jetbrains.skia.FontMetrics metrics = FontCacheKt.getCachedMetrics((org.jetbrains.skia.Font)skiaFont).getMetrics();
        return new FontMetrics(font, metrics, this){
            final /* synthetic */ Font $font;
            final /* synthetic */ org.jetbrains.skia.FontMetrics $metrics;
            final /* synthetic */ SkikoContainer this$0;
            {
                this.$font = $font;
                this.$metrics = $metrics;
                this.this$0 = $receiver;
                super($font);
            }

            public int getLeading() {
                return (int)this.$metrics.getLeading();
            }

            public int getAscent() {
                return (int)Math.abs(this.$metrics.getAscent());
            }

            public int getDescent() {
                return (int)this.$metrics.getDescent();
            }

            public int getHeight() {
                return (int)this.$metrics.getHeight();
            }

            public int charWidth(char ch) {
                return SkikoContainer.access$getFontMetrics$measureTextWidth(this.$font, this.this$0, String.valueOf(ch));
            }

            public int stringWidth(String str) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                return SkikoContainer.access$getFontMetrics$measureTextWidth(this.$font, this.this$0, str);
            }

            public int charsWidth(char[] data, int off, int len) {
                Intrinsics.checkNotNull((Object)data);
                return SkikoContainer.access$getFontMetrics$measureTextWidth(this.$font, this.this$0, new String(data, off, len));
            }

            public FontRenderContext getFontRenderContext() {
                return SkiaGraphicsKt.toFontRenderContext(this.this$0.getFontRasterSettings());
            }
        };
    }

    @Override
    @NotNull
    public Font getFont() {
        return SkiaGraphics.Companion.getDefaultFont();
    }

    @Override
    public void updateUI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int getFontMetrics$measureTextWidth(Font $font, SkikoContainer this$0, String text) {
        int n;
        boolean $i$f$use = false;
        try (Managed $this$use$iv = (Managed)new TextStyle();){
            TextStyle textStyle = (TextStyle)$this$use$iv;
            boolean bl = false;
            String[] stringArray = new String[]{$font.getFamily()};
            textStyle.setFontFamilies(stringArray);
            textStyle.setFontStyle(switch ($font.getStyle()) {
                case 1 -> FontStyle.Companion.getBOLD();
                case 2 -> FontStyle.Companion.getITALIC();
                case 3 -> FontStyle.Companion.getBOLD_ITALIC();
                default -> FontStyle.Companion.getNORMAL();
            });
            textStyle.setFontSize((float)$font.getSize());
            Paragraph paragraph2 = ParagraphKt.buildParagraph$default((NoriaParagraphStyle)NoriaParagraphStyle.Companion.getOneLine(), null, (FontCollection)CompatibilityFontCollectionKt.getCompatibilityFontCollection(), (FontRasterizationSettings)this$0.fontRasterSettings, (Function1)((Function1)new Function1<ParagraphBuilder, Unit>(text, textStyle){
                final /* synthetic */ String $text;
                final /* synthetic */ TextStyle $textStyle;
                {
                    this.$text = $text;
                    this.$textStyle = $textStyle;
                    super(1);
                }

                public final void invoke(ParagraphBuilder $this$buildParagraph) {
                    Intrinsics.checkNotNullParameter((Object)$this$buildParagraph, (String)"$this$buildParagraph");
                    ParagraphKt.styledText((ParagraphBuilder)$this$buildParagraph, (String)this.$text, (TextStyle)this.$textStyle);
                }
            }), (int)2, null);
            paragraph2.layout(Float.POSITIVE_INFINITY);
            n = (int)Math.ceil(paragraph2.getMaxIntrinsicWidth());
        }
        return n;
    }

    public static final /* synthetic */ int access$getFontMetrics$measureTextWidth(Font $font, SkikoContainer this$0, String text) {
        return SkikoContainer.getFontMetrics$measureTextWidth($font, this$0, text);
    }
}

