/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell.lists.hunspell;

import ai.grazie.nlp.utils.CharUtils;
import ai.grazie.nlp.utils.Symbols;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.spell.lists.hunspell.HunspellWordList;
import ai.grazie.utils.TextKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.FragmentChecker;
import org.apache.lucene.analysis.hunspell.Hunspell;
import org.apache.lucene.analysis.hunspell.NGramFragmentChecker;
import org.apache.lucene.analysis.hunspell.SortingStrategy;
import org.apache.lucene.analysis.hunspell.Suggester;
import org.apache.lucene.analysis.hunspell.SuggestionTimeoutException;
import org.apache.lucene.analysis.hunspell.TimeoutPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 -2\u00020\u0001:\u0001-B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\u0017H\u0014J\u0017\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&H\u0002J \u0010(\u001a\u0012\u0012\u0004\u0012\u00020\u001f0)j\b\u0012\u0004\u0012\u00020\u001f`*2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001f0,2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006."}, d2={"Lai/grazie/spell/lists/hunspell/HunspellWordList;", "Lai/grazie/spell/lists/WordListWithFrequency;", "affix", "Ljava/io/InputStream;", "dict", "checkCanceled", "Ljava/lang/Runnable;", "defaultIterationLimit", "", "(Ljava/io/InputStream;Ljava/io/InputStream;Ljava/lang/Runnable;J)V", "defaultFrequency", "", "getDefaultFrequency", "()I", "dictionary", "Lorg/apache/lucene/analysis/hunspell/Dictionary;", "hunspell", "Lorg/apache/lucene/analysis/hunspell/Hunspell;", "getHunspell", "()Lorg/apache/lucene/analysis/hunspell/Hunspell;", "maxFrequency", "getMaxFrequency", "suggester", "Lorg/apache/lucene/analysis/hunspell/Suggester;", "getSuggester", "()Lorg/apache/lucene/analysis/hunspell/Suggester;", "suggester$delegate", "Lkotlin/Lazy;", "contains", "", "word", "", "caseSensitive", "createSuggester", "getFrequency", "(Ljava/lang/String;)Ljava/lang/Integer;", "language", "obtainSuggestionTimeoutExceptionConstructor", "Ljava/lang/reflect/Constructor;", "Lorg/apache/lucene/analysis/hunspell/SuggestionTimeoutException;", "suggest", "Ljava/util/LinkedHashSet;", "Lai/grazie/utils/LinkedSet;", "suggestNonEmpty", "Lkotlin/sequences/Sequence;", "Companion", "gec-spell-engine-local"})
@SourceDebugExtension(value={"SMAP\nHunspellWordList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HunspellWordList.kt\nai/grazie/spell/lists/hunspell/HunspellWordList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public class HunspellWordList
implements WordListWithFrequency {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Runnable checkCanceled;
    private final long defaultIterationLimit;
    @NotNull
    private final Dictionary dictionary;
    @NotNull
    private final Lazy suggester$delegate;
    private final int maxFrequency;
    private final int defaultFrequency;
    private static final long MAX_TIME_LIMIT = 30000L;
    @NotNull
    private static final Regex verbClasses = new Regex(".*[IYZ].*");
    @NotNull
    private static final Regex innerApostropheS = new Regex("(.+)[" + CollectionsKt.joinToString$default((Iterable)Symbols.INSTANCE.getApostrophes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + "]s");

    public HunspellWordList(@NotNull InputStream affix, @NotNull InputStream dict, @NotNull Runnable checkCanceled, long defaultIterationLimit) {
        Intrinsics.checkNotNullParameter((Object)affix, (String)"affix");
        Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
        Intrinsics.checkNotNullParameter((Object)checkCanceled, (String)"checkCanceled");
        this.checkCanceled = checkCanceled;
        this.defaultIterationLimit = defaultIterationLimit;
        this.dictionary = new Dictionary(affix, CollectionsKt.listOf((Object)dict), false, SortingStrategy.inMemory());
        this.suggester$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Suggester>(this){
            final /* synthetic */ HunspellWordList this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Suggester invoke() {
                return this.this$0.createSuggester();
            }
        }));
        this.maxFrequency = 127;
    }

    public /* synthetic */ HunspellWordList(InputStream inputStream, InputStream inputStream2, Runnable runnable, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            runnable = HunspellWordList::_init_$lambda$0;
        }
        if ((n & 8) != 0) {
            l = 250000L;
        }
        this(inputStream, inputStream2, runnable, l);
    }

    private final Suggester getSuggester() {
        Lazy lazy = this.suggester$delegate;
        return (Suggester)lazy.getValue();
    }

    @NotNull
    protected Suggester createSuggester() {
        Suggester suggester2 = new Suggester(this.dictionary).withSuggestibleEntryCache().proceedPastRep();
        Intrinsics.checkNotNullExpressionValue((Object)suggester2, (String)"Suggester(dictionary).wi\u2026yCache().proceedPastRep()");
        return suggester2;
    }

    private final Hunspell getHunspell() {
        Ref.LongRef iterations = new Ref.LongRef();
        iterations.element = this.defaultIterationLimit;
        Ref.BooleanRef thrown = new Ref.BooleanRef();
        Constructor<SuggestionTimeoutException> suggestionExceptionConstructor = this.obtainSuggestionTimeoutExceptionConstructor();
        return new Hunspell(this.dictionary, TimeoutPolicy.RETURN_PARTIAL_RESULT, () -> HunspellWordList._get_hunspell_$lambda$1(iterations, thrown, suggestionExceptionConstructor, this));
    }

    private final Constructor<SuggestionTimeoutException> obtainSuggestionTimeoutExceptionConstructor() {
        Class<SuggestionTimeoutException> cls = SuggestionTimeoutException.class;
        Class[] classArray = new Class[]{String.class, List.class};
        Constructor<SuggestionTimeoutException> constructor = cls.getDeclaredConstructor(classArray);
        if (constructor.trySetAccessible()) {
            return constructor;
        }
        return null;
    }

    @Nullable
    public final String language() {
        Field field = Dictionary.class.getDeclaredField("language");
        if (field.trySetAccessible()) {
            return (String)field.get(this.dictionary);
        }
        return null;
    }

    @Override
    public boolean contains(@NotNull String word, boolean caseSensitive) {
        String toCheck;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        String clean = StringsKt.replace$default((String)word, (String)String.valueOf(CharUtils.INSTANCE.getSOFT_HYPHEN()), (String)"", (boolean)false, (int)4, null);
        if (caseSensitive) {
            v0 = clean;
        } else {
            String string = StringsKt.replace$default((String)clean, (String)"\u00df", (String)"+", (boolean)false, (int)4, null).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            v0 = toCheck = StringsKt.replace$default((String)string, (String)"+", (String)"\u00df", (boolean)false, (int)4, null);
        }
        if (this.getHunspell().spell(toCheck)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)this.language(), (Object)"de") && caseSensitive) {
            CharSequence charSequence = clean;
            Regex regex = innerApostropheS;
            String string = "$1";
            clean = regex.replace(charSequence, string);
            if (this.getHunspell().analyzeSimpleWord(clean + "e").stream().anyMatch(arg_0 -> HunspellWordList.contains$lambda$2(contains.1.INSTANCE, arg_0))) {
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public LinkedHashSet<String> suggest(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        String clean = StringsKt.replace$default((String)word, (String)String.valueOf(CharUtils.INSTANCE.getSOFT_HYPHEN()), (String)"", (boolean)false, (int)4, null);
        LinkedHashSet<String> overall = new LinkedHashSet<String>();
        if (TextKt.isCapitalized((String)clean)) {
            Collection collection = overall;
            String string = clean.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            CollectionsKt.addAll((Collection)collection, (Sequence)SequencesKt.map(this.suggestNonEmpty(string), (Function1)((Function1)new Function1<String, String>(clean){
                final /* synthetic */ String $clean;
                {
                    this.$clean = $clean;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return TextKt.alignCasingTo((String)it, (String)this.$clean);
                }
            })));
        }
        CollectionsKt.addAll((Collection)overall, this.suggestNonEmpty(clean));
        return overall;
    }

    private final Sequence<String> suggestNonEmpty(String word) {
        List list;
        try {
            list = this.getSuggester().suggestWithTimeout(word, 30000L, this.checkCanceled);
        }
        catch (SuggestionTimeoutException e) {
            list = e.getPartialResult();
        }
        List list2 = list;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"try {\n            sugges\u2026e.partialResult\n        }");
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)suggestNonEmpty.1.INSTANCE);
    }

    @Override
    public int getMaxFrequency() {
        return this.maxFrequency;
    }

    @Override
    public int getDefaultFrequency() {
        return this.defaultFrequency;
    }

    @Override
    @Nullable
    public Integer getFrequency(@NotNull String word) {
        Integer result;
        Integer n;
        Comparable comparable;
        List list;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        List it = list = this.getHunspell().getRoots(word);
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        List list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 == null) {
            return null;
        }
        List roots = list2;
        Iterator iterator = ((Iterable)roots).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            String it2 = (String)iterator.next();
            boolean bl2 = false;
            List list3 = this.dictionary.lookupEntries(it2).getMorphologicalValues(0, "fr:");
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"dictionary.lookupEntries\u2026hologicalValues(0, \"fr:\")");
            String string = (String)CollectionsKt.getOrNull((List)list3, (int)0);
            Comparable comparable2 = Integer.valueOf(string != null ? Integer.parseInt(string) : this.getDefaultFrequency());
            while (iterator.hasNext()) {
                String it3 = (String)iterator.next();
                $i$a$-maxOfOrNull-HunspellWordList$getFrequency$result$1 = false;
                List list4 = this.dictionary.lookupEntries(it3).getMorphologicalValues(0, "fr:");
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"dictionary.lookupEntries\u2026hologicalValues(0, \"fr:\")");
                String string2 = (String)CollectionsKt.getOrNull((List)list4, (int)0);
                Comparable comparable3 = Integer.valueOf(string2 != null ? Integer.parseInt(string2) : this.getDefaultFrequency());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        if ((n = (result = (Integer)comparable)) == null) {
            n = this.getDefaultFrequency();
        }
        return n;
    }

    private static final void _init_$lambda$0() {
    }

    private static final void _get_hunspell_$lambda$1(Ref.LongRef $iterations, Ref.BooleanRef $thrown, Constructor $suggestionExceptionConstructor, HunspellWordList this$0) {
        Intrinsics.checkNotNullParameter((Object)$iterations, (String)"$iterations");
        Intrinsics.checkNotNullParameter((Object)$thrown, (String)"$thrown");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($iterations.element == 0L && !$thrown.element && $suggestionExceptionConstructor != null) {
            $thrown.element = true;
            Object[] objectArray = new Object[]{"Out of iterations", CollectionsKt.emptyList()};
            SuggestionTimeoutException exception = (SuggestionTimeoutException)((Object)$suggestionExceptionConstructor.newInstance(objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)exception), (String)"exception");
            throw exception;
        }
        --$iterations.element;
        this$0.checkCanceled.run();
    }

    private static final boolean contains$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Regex access$getVerbClasses$cp() {
        return verbClasses;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0010J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/grazie/spell/lists/hunspell/HunspellWordList$Companion;", "", "()V", "MAX_TIME_LIMIT", "", "innerApostropheS", "Lkotlin/text/Regex;", "verbClasses", "create", "Lai/grazie/spell/lists/hunspell/HunspellWordList;", "affDict", "", "dicDict", "checkCanceled", "Ljava/lang/Runnable;", "trigrams", "", "gec-spell-engine-local"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HunspellWordList create(@NotNull String affDict, @NotNull String dicDict, @Nullable List<String> trigrams2) {
            Intrinsics.checkNotNullParameter((Object)affDict, (String)"affDict");
            Intrinsics.checkNotNullParameter((Object)dicDict, (String)"dicDict");
            return this.create(affDict, dicDict, trigrams2, Companion::create$lambda$0);
        }

        @Deprecated(message="Specify trigrams if possible", replaceWith=@ReplaceWith(expression="create(affDict, dicDict, null, checkCanceled)", imports={}))
        @NotNull
        public final HunspellWordList create(@NotNull String affDict, @NotNull String dicDict, @NotNull Runnable checkCanceled) {
            Intrinsics.checkNotNullParameter((Object)affDict, (String)"affDict");
            Intrinsics.checkNotNullParameter((Object)dicDict, (String)"dicDict");
            Intrinsics.checkNotNullParameter((Object)checkCanceled, (String)"checkCanceled");
            return this.create(affDict, dicDict, null, checkCanceled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final HunspellWordList create(@NotNull String affDict, @NotNull String dicDict, @Nullable List<String> trigrams2, @NotNull Runnable checkCanceled) {
            HunspellWordList hunspellWordList;
            Intrinsics.checkNotNullParameter((Object)affDict, (String)"affDict");
            Intrinsics.checkNotNullParameter((Object)dicDict, (String)"dicDict");
            Intrinsics.checkNotNullParameter((Object)checkCanceled, (String)"checkCanceled");
            Object object = affDict;
            Object object2 = Charsets.UTF_8;
            byte[] byArray = ((String)object).getBytes((Charset)object2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            object = new ByteArrayInputStream(byArray);
            object2 = null;
            try {
                HunspellWordList hunspellWordList2;
                ByteArrayInputStream affix = (ByteArrayInputStream)object;
                boolean bl = false;
                Object object3 = dicDict;
                Object object4 = Charsets.UTF_8;
                byte[] byArray2 = ((String)object3).getBytes((Charset)object4);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                object3 = new ByteArrayInputStream(byArray2);
                object4 = null;
                try {
                    ByteArrayInputStream dictionary = (ByteArrayInputStream)object3;
                    boolean bl2 = false;
                    hunspellWordList2 = new HunspellWordList(affix, dictionary, checkCanceled, trigrams2){
                        final /* synthetic */ List<String> $trigrams;
                        {
                            this.$trigrams = $trigrams;
                            super($affix, $dictionary, $checkCanceled, 0L, 8, null);
                        }

                        @NotNull
                        protected Suggester createSuggester() {
                            Suggester suggester2;
                            Suggester caching = super.createSuggester();
                            if (this.$trigrams == null) {
                                suggester2 = caching;
                            } else {
                                Suggester suggester3 = caching.withFragmentChecker((FragmentChecker)NGramFragmentChecker.fromWords((int)3, (Collection)this.$trigrams));
                                suggester2 = suggester3;
                                Intrinsics.checkNotNullExpressionValue((Object)suggester3, (String)"caching.withFragmentChec\u2026r.fromWords(3, trigrams))");
                            }
                            return suggester2;
                        }
                    };
                }
                catch (Throwable throwable) {
                    object4 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
                }
                hunspellWordList = hunspellWordList2;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            return hunspellWordList;
        }

        public static /* synthetic */ HunspellWordList create$default(Companion companion, String string, String string2, List list, Runnable runnable, int n, Object object) {
            if ((n & 4) != 0) {
                list = null;
            }
            return companion.create(string, string2, list, runnable);
        }

        private static final void create$lambda$0() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

