/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell;

import ai.grazie.utils.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0004J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0004H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lai/grazie/spell/GermanCompoundChecker;", "", "isInDictionary", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "()Lkotlin/jvm/functions/Function1;", "isNonDictCompound", "word", "looksLikeAdjective", "looksLikeNoun", "looksLikeVerb", "Companion", "gec-spell-engine-local"})
@SourceDebugExtension(value={"SMAP\nGermanCompoundChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GermanCompoundChecker.kt\nai/grazie/spell/GermanCompoundChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n766#2:54\n857#2,2:55\n1549#2:57\n1620#2,3:58\n1726#2,3:61\n*S KotlinDebug\n*F\n+ 1 GermanCompoundChecker.kt\nai/grazie/spell/GermanCompoundChecker\n*L\n42#1:54\n42#1:55,2\n45#1:57\n45#1:58,3\n46#1:61,3\n*E\n"})
public final class GermanCompoundChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, Boolean> isInDictionary;
    @NotNull
    private static final String S_ENDINGS = "([hk]eit|schaft|t\u00e4t|ung|um|ion|fahrt|ff|mm|ll|nn|rr|pp|tt)";
    @NotNull
    private static final String S_SUFFIX_COMPOUNDS = "(?<=([hk]eit|schaft|t\u00e4t|ung|um|ion|fahrt|ff|mm|ll|nn|rr|pp|tt))s(?!ch)(?=.{5,})";
    @NotNull
    private static final String NO_S_SUFFIX_COMPOUNDS = "(?<=(en|a)ten|ing)(?=.{4,})|(?<=.{3,}[^a]us)(?=[jwrdfgklzxvbnm].{3,})";
    @NotNull
    private static final String INNER_PREFIX = "(?<=.{5,})(?<![hrtpsdfgkljzxcvbnm]e)(?=(auf|aus|ein|gegen|nach|unter|\u00fcber|vor).{2,})";
    @NotNull
    private static final String THREE_SAME_LETTERS = "(?<=.{3,}ff)(?=f.{3,})|(?<=.{3,}pp)(?=p.{3,})|(?<=.{3,}tt)(?=t.{3,})|(?<=.{3,}nn)(?=n.{3,})|(?<=.{3,}ll)(?=l.{3,})|(?<=.{3,}mm)(?=m.{3,})|(?<=.{3,}rr)(?=r.{3,})|(?<=.{3,}ss)(?=s.{3,})|(?<=.{4,}\u00df)(?=s.{3,})";
    @NotNull
    private static final String NO_S_AFTER_EXCEPTIONS = "[Mm]ilit\u00e4rs|[Hh]eimatlande?s";
    @NotNull
    private static final String NO_S_BEFORE_EXCEPTIONS = "reich|laden";
    @NotNull
    private static final String UNLIKELY_COMBINATIONS = "(?<=.{3,}s)(?=sch.{2,})|(?<=.{4,}l)(?=h.{4,})|(?<=.{3,}[pjwrdfgklzxvbnmt]s)(?<![Mm]ilit\u00e4rs|[Hh]eimatlande?s)(?!reich|laden)(?=[jwrdfgklzxvbnm].{4,})";
    @NotNull
    private static final Regex compoundSplitRegex = new Regex("(?<=(en|a)ten|ing)(?=.{4,})|(?<=.{3,}[^a]us)(?=[jwrdfgklzxvbnm].{3,})|(?<=.{5,})(?<![hrtpsdfgkljzxcvbnm]e)(?=(auf|aus|ein|gegen|nach|unter|\u00fcber|vor).{2,})|(?<=([hk]eit|schaft|t\u00e4t|ung|um|ion|fahrt|ff|mm|ll|nn|rr|pp|tt))s(?!ch)(?=.{5,})|(?<=.{3,}s)(?=sch.{2,})|(?<=.{4,}l)(?=h.{4,})|(?<=.{3,}[pjwrdfgklzxvbnmt]s)(?<![Mm]ilit\u00e4rs|[Hh]eimatlande?s)(?!reich|laden)(?=[jwrdfgklzxvbnm].{4,})|(?<=.{3,}ff)(?=f.{3,})|(?<=.{3,}pp)(?=p.{3,})|(?<=.{3,}tt)(?=t.{3,})|(?<=.{3,}nn)(?=n.{3,})|(?<=.{3,}ll)(?=l.{3,})|(?<=.{3,}mm)(?=m.{3,})|(?<=.{3,}rr)(?=r.{3,})|(?<=.{3,}ss)(?=s.{3,})|(?<=.{4,}\u00df)(?=s.{3,})");
    @NotNull
    private static final Regex adjRegex = new Regex(".+e[nsr]");
    @NotNull
    private static final List<String> blackList;

    public GermanCompoundChecker(@NotNull Function1<? super String, Boolean> isInDictionary) {
        Intrinsics.checkNotNullParameter(isInDictionary, (String)"isInDictionary");
        this.isInDictionary = isInDictionary;
    }

    @NotNull
    public final Function1<String, Boolean> isInDictionary() {
        return this.isInDictionary;
    }

    private final boolean looksLikeNoun(String word) {
        return (Boolean)this.isInDictionary.invoke((Object)(word + "s")) != false || (Boolean)this.isInDictionary.invoke((Object)(word + "es")) != false;
    }

    private final boolean looksLikeVerb(String word) {
        return StringsKt.endsWith$default((String)word, (String)"te", (boolean)false, (int)2, null) && (Boolean)this.isInDictionary.invoke((Object)(word + "st")) != false && (Boolean)this.isInDictionary.invoke((Object)(StringsKt.dropLast((String)word, (int)2) + "en")) != false || StringsKt.endsWith$default((String)word, (String)"t", (boolean)false, (int)2, null) && (Boolean)this.isInDictionary.invoke((Object)(StringsKt.dropLast((String)word, (int)1) + "st")) != false && (Boolean)this.isInDictionary.invoke((Object)(StringsKt.dropLast((String)word, (int)1) + "en")) != false || !this.looksLikeNoun(word) && (Boolean)this.isInDictionary.invoke((Object)(word + "en")) != false && (Boolean)this.isInDictionary.invoke((Object)(word + "et")) != false;
    }

    private final boolean looksLikeAdjective(String word) {
        CharSequence charSequence;
        return StringsKt.endsWith$default((String)word, (String)"e", (boolean)false, (int)2, null) && (Boolean)this.isInDictionary.invoke((Object)(word + "m")) != false || adjRegex.matches(charSequence = (CharSequence)word) && (Boolean)this.isInDictionary.invoke((Object)(StringsKt.dropLast((String)word, (int)1) + "m")) != false || StringsKt.endsWith$default((String)word, (String)"em", (boolean)false, (int)2, null) && (Boolean)this.isInDictionary.invoke((Object)(StringsKt.dropLast((String)word, (int)1) + "n")) != false || (Boolean)this.isInDictionary.invoke((Object)(word + "em")) != false && (Boolean)this.isInDictionary.invoke((Object)(word + "e")) != false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isNonDictCompound(@NotNull String word) {
        boolean bl;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        String string = word.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        if (!TextKt.isLowercase((String)string)) {
            return false;
        }
        List parts = null;
        CharSequence charSequence = word;
        Regex regex = compoundSplitRegex;
        int n = 0;
        Iterable $this$filter$iv = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p = (String)element$iv$iv;
            boolean bl2 = false;
            if (!(!Intrinsics.areEqual((Object)p, (Object)""))) continue;
            collection.add(element$iv$iv);
        }
        parts = (List)collection;
        boolean shouldBeLowercase = this.looksLikeAdjective((String)CollectionsKt.last((List)parts));
        if (!shouldBeLowercase && TextKt.isLowercase((String)word)) {
            return false;
        }
        Iterable $this$map$iv = parts;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : iterable2) {
            String string2;
            void p;
            String bl2 = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)p, (Object)CollectionsKt.last((List)parts)) || !shouldBeLowercase) {
                String string3 = p.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                string2 = TextKt.capitalize((String)string3);
            } else {
                String string4 = p.toLowerCase(Locale.ROOT);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            }
            collection2.add(string2);
        }
        parts = (List)destination$iv$iv;
        if (parts.size() <= 1) return false;
        Iterable $this$all$iv = parts;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            String p = (String)element$iv;
            boolean bl4 = false;
            if (p.length() <= 3) return false;
            if ((Boolean)this.isInDictionary.invoke((Object)p) == false) return false;
            String string5 = p.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (blackList.contains(string5)) return false;
            if (!Intrinsics.areEqual((Object)p, (Object)CollectionsKt.last((List)parts))) {
                if (StringsKt.endsWith$default((String)p, (String)"enden", (boolean)false, (int)2, null)) return false;
            }
            if (!Intrinsics.areEqual((Object)p, (Object)CollectionsKt.first((List)parts))) {
                if (this.looksLikeVerb(p)) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    static {
        Object[] objectArray = new String[]{"rabat", "telle", "nivo", "selbs", "pairs", "wessen"};
        blackList = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/grazie/spell/GermanCompoundChecker$Companion;", "", "()V", "INNER_PREFIX", "", "NO_S_AFTER_EXCEPTIONS", "NO_S_BEFORE_EXCEPTIONS", "NO_S_SUFFIX_COMPOUNDS", "S_ENDINGS", "S_SUFFIX_COMPOUNDS", "THREE_SAME_LETTERS", "UNLIKELY_COMBINATIONS", "adjRegex", "Lkotlin/text/Regex;", "blackList", "", "compoundSplitRegex", "gec-spell-engine-local"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

