/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff.frontend;

import andel.intervals.Intervals;
import andel.intervals.IntervalsKt;
import andel.intervals.IntervalsQuery;
import fleet.diff.SideBySideDiff;
import fleet.diff.frontend.DiffFragmentsReaderKt;
import fleet.diff.frontend.DiffModelKt;
import fleet.diff.frontend.DiffSideEditor;
import fleet.diff.frontend.DiffSideEditorWithReader;
import fleet.diff.frontend.PatchEntry;
import fleet.frontend.VcsStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import noria.model.components.editor.MarkupData;
import noria.ui.components.editor.EditorData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014\u00a8\u0006\u0011"}, d2={"Lfleet/diff/frontend/PatchEntryBuilder;", "", "()V", "build", "Lfleet/diff/frontend/PatchEntry;", "left", "Lfleet/diff/frontend/DiffSideEditor;", "right", "diff", "Lfleet/diff/SideBySideDiff;", "renderable", "", "leftDiffEditor", "our", "Lfleet/diff/frontend/DiffSideEditorWithReader;", "their", "rightDiffEditor", "fleet.diff.frontend"})
public class PatchEntryBuilder {
    @Nullable
    public final PatchEntry build(@Nullable DiffSideEditor left2, @Nullable DiffSideEditor right2, @Nullable SideBySideDiff diff, boolean renderable) {
        PatchEntry patchEntry2;
        if (!renderable) {
            patchEntry2 = PatchEntry.NotRenderable.INSTANCE;
        } else if (left2 == null && right2 == null) {
            patchEntry2 = null;
        } else if (left2 == null) {
            DiffSideEditor diffSideEditor = right2;
            Intrinsics.checkNotNull((Object)diffSideEditor);
            patchEntry2 = new PatchEntry.OneSide(diffSideEditor, VcsStatus.Added);
        } else if (right2 == null) {
            patchEntry2 = new PatchEntry.OneSide(left2, VcsStatus.Removed);
        } else if (diff == null) {
            patchEntry2 = null;
        } else if (diff.getFragments().isEmpty()) {
            patchEntry2 = new PatchEntry.Identical(left2.getLineEnding(), right2.getLineEnding());
        } else {
            DiffSideEditorWithReader leftPwr = new DiffSideEditorWithReader(left2, DiffFragmentsReaderKt.leftDiffReader(diff));
            DiffSideEditorWithReader rightPwr = new DiffSideEditorWithReader(right2, DiffFragmentsReaderKt.rightDiffReader(diff));
            DiffSideEditor leftEditor2 = this.leftDiffEditor(leftPwr, rightPwr);
            DiffSideEditor rightEditor2 = this.rightDiffEditor(rightPwr, leftPwr);
            leftEditor2 = DiffModelKt.assoc(leftEditor2, rightEditor2);
            rightEditor2 = DiffModelKt.assoc(rightEditor2, leftEditor2);
            patchEntry2 = new PatchEntry.Diff(leftEditor2, rightEditor2);
        }
        return patchEntry2;
    }

    @NotNull
    protected DiffSideEditor leftDiffEditor(@NotNull DiffSideEditorWithReader our, @NotNull DiffSideEditorWithReader their) {
        Intrinsics.checkNotNullParameter((Object)our, (String)"our");
        Intrinsics.checkNotNullParameter((Object)their, (String)"their");
        Intervals addedInterlines2 = DiffModelKt.addedInterlines$default(our.getReader(), their.getReader(), our.getEditor().getData().getText(), null, 8, null);
        Intervals<Long, MarkupData> markup = DiffModelKt.leftDiffMarkup(our.getReader(), their.getReader(), our.getEditor().getData().getText());
        DiffSideEditor patched = DiffSideEditor.copy$default(our.getEditor(), EditorData.copy$default((EditorData)our.getEditor().getData(), null, null, null, null, (IntervalsQuery)IntervalsKt.plus((IntervalsQuery)our.getEditor().getData().getMarkup(), (IntervalsQuery)((IntervalsQuery)markup)), null, null, null, (IntervalsQuery)IntervalsKt.plus((IntervalsQuery)our.getEditor().getData().getInterlines(), (IntervalsQuery)((IntervalsQuery)addedInterlines2)), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (boolean)false, (int)0, (boolean)false, null, null, null, null, null, (int)-273, (int)31, null), null, null, null, null, 30, null);
        return DiffModelKt.diffEditor$default(DiffSideEditorWithReader.copy$default(our, patched, null, 2, null), their, false, false, 4, null);
    }

    @NotNull
    protected DiffSideEditor rightDiffEditor(@NotNull DiffSideEditorWithReader our, @NotNull DiffSideEditorWithReader their) {
        Intrinsics.checkNotNullParameter((Object)our, (String)"our");
        Intrinsics.checkNotNullParameter((Object)their, (String)"their");
        Intervals deletedInterlines2 = DiffModelKt.deletedInterlines$default(our.getReader(), their.getReader(), our.getEditor().getData().getText(), null, 8, null);
        Intervals<Long, MarkupData> markup = DiffModelKt.rightDiffMarkup(our.getReader(), their.getReader(), our.getEditor().getData().getText());
        DiffSideEditor patched = DiffSideEditor.copy$default(our.getEditor(), EditorData.copy$default((EditorData)our.getEditor().getData(), null, null, null, null, (IntervalsQuery)IntervalsKt.plus((IntervalsQuery)our.getEditor().getData().getMarkup(), (IntervalsQuery)((IntervalsQuery)markup)), null, null, null, (IntervalsQuery)IntervalsKt.plus((IntervalsQuery)our.getEditor().getData().getInterlines(), (IntervalsQuery)((IntervalsQuery)deletedInterlines2)), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (boolean)false, (int)0, (boolean)false, null, null, null, null, null, (int)-273, (int)31, null), null, null, null, null, 30, null);
        return DiffModelKt.diffEditor$default(DiffSideEditorWithReader.copy$default(our, patched, null, 2, null), their, false, true, 4, null);
    }
}

