/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff.frontend;

import andel.text.Text;
import andel.text.TextLine;
import andel.text.TextLines;
import andel.text.TextRange;
import fleet.diff.InlineDiff;
import fleet.diff.InlineDiffLine;
import fleet.diff.SideBySideDiff;
import fleet.diff.SideBySideDiffFragment;
import fleet.diff.SideBySideDiffFragmentType;
import fleet.diff.SideBySideDiffKt;
import fleet.diff.ThreeSideDiff;
import fleet.diff.ThreeSideDiffFragment;
import fleet.diff.ThreeSideDiffSide;
import fleet.diff.frontend.DiffFragmentReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u001a,\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a<\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a.\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001b\u001a\u00020\nH\u0002\u001a \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00012\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u00a8\u0006\u001f"}, d2={"buildDiffSlices", "", "Lkotlin/ranges/LongRange;", "inlineDiff", "Lfleet/diff/InlineDiff;", "text", "Landel/text/Text;", "lines", "Landel/text/TextLines;", "context", "", "reader", "Lfleet/diff/frontend/DiffFragmentReader;", "expanded", "fromChar", "lineNumber", "", "leftDiffReader", "diff", "Lfleet/diff/SideBySideDiff;", "rightDiffReader", "threeSideDiffReader", "Lfleet/diff/ThreeSideDiff;", "side", "Lfleet/diff/ThreeSideDiffSide;", "toChar", "joinExpanded", "length", "joinIntersection", "mergeNeighbours", "", "fleet.diff.frontend"})
@SourceDebugExtension(value={"SMAP\nDiffFragmentsReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffFragmentsReader.kt\nfleet/diff/frontend/DiffFragmentsReaderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1549#2:146\n1620#2,3:147\n1549#2:150\n1620#2,3:151\n766#2:154\n857#2,2:155\n1549#2:157\n1620#2,3:158\n1549#2:161\n1620#2,3:162\n1747#2,3:165\n*S KotlinDebug\n*F\n+ 1 DiffFragmentsReader.kt\nfleet/diff/frontend/DiffFragmentsReaderKt\n*L\n77#1:146\n77#1:147,3\n82#1:150\n82#1:151,3\n89#1:154\n89#1:155,2\n90#1:157\n90#1:158,3\n94#1:161\n94#1:162,3\n113#1:165,3\n*E\n"})
public final class DiffFragmentsReaderKt {
    @NotNull
    public static final DiffFragmentReader leftDiffReader(@NotNull SideBySideDiff diff) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        return new DiffFragmentReader(diff){
            final /* synthetic */ SideBySideDiff $diff;
            {
                this.$diff = $diff;
            }

            public int startLine(int i) {
                return ((SideBySideDiffFragment)this.$diff.getFragments().get(i)).getLeftStartLine();
            }

            public int lineCount(int i) {
                return ((SideBySideDiffFragment)this.$diff.getFragments().get(i)).getLeftLineCount();
            }

            @NotNull
            public SideBySideDiffFragmentType fragmentType(int i) {
                return ((SideBySideDiffFragment)this.$diff.getFragments().get(i)).getType();
            }

            @NotNull
            public List<TextRange> wordRanges(int i) {
                List list = ((SideBySideDiffFragment)this.$diff.getFragments().get(i)).getDeletedRanges();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }

            public int fragmentCounts() {
                return this.$diff.getFragments().size();
            }

            @Nullable
            public List<Boolean> wordIsMovedAst(int i) {
                return ((SideBySideDiffFragment)this.$diff.getFragments().get(i)).isMovedLeftAst();
            }

            @NotNull
            public TextRange editRange(int i, @NotNull Text text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return SideBySideDiffKt.leftEditRange((SideBySideDiffFragment)((SideBySideDiffFragment)this.$diff.getFragments().get(i)), (Text)text);
            }

            @NotNull
            public TextRange paintRange(int i, @NotNull Text text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return SideBySideDiffKt.leftPaintRange((SideBySideDiffFragment)((SideBySideDiffFragment)this.$diff.getFragments().get(i)), (Text)text);
            }
        };
    }

    @NotNull
    public static final DiffFragmentReader rightDiffReader(@NotNull SideBySideDiff diff) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        return new DiffFragmentReader(diff){
            final /* synthetic */ SideBySideDiff $diff;
            {
                this.$diff = $diff;
            }

            public int startLine(int i) {
                return ((SideBySideDiffFragment)this.$diff.getFragments().get(i)).getRightStartLine();
            }

            public int lineCount(int i) {
                return ((SideBySideDiffFragment)this.$diff.getFragments().get(i)).getRightLineCount();
            }

            @NotNull
            public SideBySideDiffFragmentType fragmentType(int i) {
                return ((SideBySideDiffFragment)this.$diff.getFragments().get(i)).getType();
            }

            @NotNull
            public List<TextRange> wordRanges(int i) {
                List list = ((SideBySideDiffFragment)this.$diff.getFragments().get(i)).getAddedRanges();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }

            public int fragmentCounts() {
                return this.$diff.getFragments().size();
            }

            @Nullable
            public List<Boolean> wordIsMovedAst(int i) {
                return ((SideBySideDiffFragment)this.$diff.getFragments().get(i)).isMovedRightAst();
            }

            @NotNull
            public TextRange editRange(int i, @NotNull Text text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return SideBySideDiffKt.rightEditRange((SideBySideDiffFragment)((SideBySideDiffFragment)this.$diff.getFragments().get(i)), (Text)text);
            }

            @NotNull
            public TextRange paintRange(int i, @NotNull Text text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return SideBySideDiffKt.rightPaintRange((SideBySideDiffFragment)((SideBySideDiffFragment)this.$diff.getFragments().get(i)), (Text)text);
            }
        };
    }

    @NotNull
    public static final DiffFragmentReader threeSideDiffReader(@NotNull ThreeSideDiff diff, @NotNull ThreeSideDiffSide side) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return new DiffFragmentReader(diff, side){
            final /* synthetic */ ThreeSideDiff $diff;
            final /* synthetic */ ThreeSideDiffSide $side;
            {
                this.$diff = $diff;
                this.$side = $side;
            }

            public int startLine(int i) {
                return ((ThreeSideDiffFragment)this.$diff.getFragments().get(i)).startLine(this.$side);
            }

            public int lineCount(int i) {
                return ((ThreeSideDiffFragment)this.$diff.getFragments().get(i)).linesCount(this.$side);
            }

            @NotNull
            public SideBySideDiffFragmentType fragmentType(int i) {
                ThreeSideDiffFragment fragment = (ThreeSideDiffFragment)this.$diff.getFragments().get(i);
                return ((Number)fragment.getLinesCount().getFirst()).intValue() > 0 && ((Number)fragment.getLinesCount().getSecond()).intValue() > 0 && ((Number)fragment.getLinesCount().getThird()).intValue() > 0 ? SideBySideDiffFragmentType.MODIFIED : (((Number)fragment.getLinesCount().getSecond()).intValue() == 0 ? SideBySideDiffFragmentType.DELETED : SideBySideDiffFragmentType.ADDED);
            }

            @NotNull
            public List<TextRange> wordRanges(int i) {
                return CollectionsKt.emptyList();
            }

            public int fragmentCounts() {
                return this.$diff.getFragments().size();
            }

            @Nullable
            public List<Boolean> wordIsMovedAst(int i) {
                return null;
            }

            @NotNull
            public TextRange editRange(int i, @NotNull Text text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return ThreeSideDiffFragment.editRange$default((ThreeSideDiffFragment)((ThreeSideDiffFragment)this.$diff.getFragments().get(i)), (ThreeSideDiffSide)this.$side, (Text)text, (int)0, (int)4, null);
            }

            @NotNull
            public TextRange paintRange(int i, @NotNull Text text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return SideBySideDiffKt.paintRange((int)this.startLine(i), (int)this.lineCount(i), (Text)text);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LongRange> buildDiffSlices(@NotNull DiffFragmentReader reader, @NotNull Text text, @NotNull TextLines lines2, long context, @NotNull List<LongRange> expanded2) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)lines2, (String)"lines");
        Intrinsics.checkNotNullParameter(expanded2, (String)"expanded");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)reader.fragmentCounts());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LongRange(Math.max((long)reader.startLine((int)i) - context, 0L), Math.min((long)reader.startLine((int)i) + (long)reader.lineCount((int)i) + context, text.linesCount() - 1L)));
        }
        $this$map$iv = DiffFragmentsReaderKt.joinIntersection((List)destination$iv$iv, true);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LongRange i = (LongRange)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LongRange(DiffFragmentsReaderKt.fromChar(it.getFirst(), lines2, text), DiffFragmentsReaderKt.toChar(it.getLast(), lines2, text)));
        }
        return DiffFragmentsReaderKt.joinExpanded((List)destination$iv$iv, expanded2, text.charsCount());
    }

    public static /* synthetic */ List buildDiffSlices$default(DiffFragmentReader diffFragmentReader, Text text, TextLines textLines, long l, List list, int n, Object object) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        return DiffFragmentsReaderKt.buildDiffSlices(diffFragmentReader, text, textLines, l, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LongRange> buildDiffSlices(@NotNull InlineDiff inlineDiff, @NotNull Text text, @NotNull TextLines lines2, long context) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        int it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)inlineDiff, (String)"inlineDiff");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)lines2, (String)"lines");
        if (!(inlineDiff.getLines().size() == (int)text.linesCount())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)inlineDiff.getLines());
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(((InlineDiffLine)inlineDiff.getLines().get(it)).getType() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void i;
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LongRange(Math.max((long)i - context, 0L), Math.min((long)i + context, text.linesCount() - 1L)));
        }
        $this$map$iv = DiffFragmentsReaderKt.joinIntersection$default((List)destination$iv$iv, false, 1, null);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            LongRange i = (LongRange)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LongRange(DiffFragmentsReaderKt.fromChar(it2.getFirst(), lines2, text), DiffFragmentsReaderKt.toChar(it2.getLast(), lines2, text)));
        }
        return (List)destination$iv$iv;
    }

    private static final List<LongRange> joinExpanded(List<LongRange> $this$joinExpanded, List<LongRange> expanded2, long length) {
        List result;
        List list;
        if ($this$joinExpanded.isEmpty()) {
            return $this$joinExpanded;
        }
        ArrayList<LongRange> list2 = new ArrayList<LongRange>($this$joinExpanded.size() + 2);
        LongRange longRange = (LongRange)CollectionsKt.firstOrNull($this$joinExpanded);
        if (!(longRange != null ? longRange.getFirst() == 0L : false)) {
            list2.add(new LongRange(0L, 0L));
        }
        list2.addAll((Collection)$this$joinExpanded);
        LongRange longRange2 = (LongRange)CollectionsKt.lastOrNull($this$joinExpanded);
        if (!(longRange2 != null ? longRange2.getLast() == length : false)) {
            list2.add(new LongRange(length, length));
        }
        List it = list = (result = (List)new ArrayList());
        boolean bl = false;
        int i = 0;
        while (i < list2.size()) {
            int j = 0;
            for (j = i + 1; j < list2.size(); ++j) {
                boolean bl2;
                block8: {
                    Iterable $this$any$iv = expanded2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            LongRange e = (LongRange)element$iv;
                            boolean bl3 = false;
                            if (!(((LongRange)list2.get(j - 1)).getLast() <= e.getLast() && ((LongRange)list2.get(j)).getFirst() >= e.getFirst())) continue;
                            bl2 = true;
                            break block8;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) break;
            }
            it.add(new LongRange(((LongRange)list2.get(i)).getFirst(), ((LongRange)list2.get(j - 1)).getLast()));
            i = j;
        }
        return result;
    }

    @NotNull
    public static final List<LongRange> joinIntersection(@NotNull List<LongRange> $this$joinIntersection, boolean mergeNeighbours) {
        List list;
        Intrinsics.checkNotNullParameter($this$joinIntersection, (String)"<this>");
        List it = list = (List)new ArrayList();
        boolean bl = false;
        int i = 0;
        while (i < $this$joinIntersection.size()) {
            int j;
            for (j = i + 1; j < $this$joinIntersection.size() && $this$joinIntersection.get(j - 1).getLast() + (mergeNeighbours ? 1L : 0L) >= $this$joinIntersection.get(j).getFirst(); ++j) {
            }
            it.add(new LongRange($this$joinIntersection.get(i).getFirst(), $this$joinIntersection.get(j - 1).getLast()));
            i = j;
        }
        return list;
    }

    public static /* synthetic */ List joinIntersection$default(List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return DiffFragmentsReaderKt.joinIntersection(list, bl);
    }

    public static final long fromChar(long lineNumber, @NotNull TextLines lines2, @NotNull Text text) {
        Intrinsics.checkNotNullParameter((Object)lines2, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return lineNumber < (long)lines2.size() ? lines2.get(lineNumber).getFromChar() : text.charsCount();
    }

    public static final long fromChar(int lineNumber, @NotNull TextLines lines2, @NotNull Text text) {
        Intrinsics.checkNotNullParameter((Object)lines2, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return lineNumber < lines2.size() ? ((TextLine)lines2.get(lineNumber)).getFromChar() : text.charsCount();
    }

    public static final long toChar(long lineNumber, @NotNull TextLines lines2, @NotNull Text text) {
        Intrinsics.checkNotNullParameter((Object)lines2, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return lineNumber < (long)lines2.size() ? lines2.get(lineNumber).getToChar() : text.charsCount();
    }

    public static final long toChar(int lineNumber, @NotNull TextLines lines2, @NotNull Text text) {
        Intrinsics.checkNotNullParameter((Object)lines2, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return lineNumber < lines2.size() ? ((TextLine)lines2.get(lineNumber)).getToChar() : text.charsCount();
    }
}

