/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.themeDesigner.frontend;

import andel.text.TextRange;
import androidx.compose.ui.graphics.Color;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.api.ProtocolPath;
import fleet.api.workspace.document.MediaType;
import fleet.ast.SyntexNodeExtKt;
import fleet.com.intellij.json.JsonElementTypes;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentFileEntity;
import fleet.compose.theme.graphics.NoriaColorKt;
import fleet.frontend.code.daemon.inlayHint.ColorInlay;
import fleet.frontend.fsd.LocalFsdExtKt;
import fleet.plugins.themeDesigner.frontend.DetectedThemeDocument;
import fleet.plugins.themeDesigner.frontend.ThemeDesignerKt;
import fleet.schema.common.Schema;
import fleet.schema.common.SchemaKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a:\u0010\f\u001a\u00020\r*\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\b2\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u0010H\u0002\u001a\u0014\u0010\u0014\u001a\u0004\u0018\u00010\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\b\u0010\u0016\u001a\u00020\u0017H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"EDITABLE_THEMES_RELATIVE_PATH", "", "isThemeFile", "", "fileAddress", "Lfleet/api/FileAddress;", "wasMarkedAsTheme", "parsePalette", "", "Landroidx/compose/ui/graphics/Color;", "root", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "findAllColors", "", "palette", "result", "", "Lkotlin/Pair;", "Landel/text/TextRange;", "Lfleet/frontend/code/daemon/inlayHint/ColorInlay;", "stringToColor", "colorString", "buildThemeSchema", "Lfleet/schema/common/Schema;", "JsonMediaType", "Lfleet/api/workspace/document/MediaType;", "fleet.plugins.themeDesigner.frontend"})
@SourceDebugExtension(value={"SMAP\nThemeDesigner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeDesigner.kt\nfleet/plugins/themeDesigner/frontend/ThemeDesignerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,400:1\n1611#2,9:401\n1863#2:410\n1864#2:412\n1620#2:413\n1755#2,3:414\n1#3:411\n1#3:418\n1317#4:417\n1318#4:419\n1317#4,2:420\n*S KotlinDebug\n*F\n+ 1 ThemeDesigner.kt\nfleet/plugins/themeDesigner/frontend/ThemeDesignerKt\n*L\n62#1:401,9\n62#1:410\n62#1:412\n62#1:413\n63#1:414,3\n62#1:411\n225#1:417\n225#1:419\n243#1:420,2\n*E\n"})
public final class ThemeDesignerKt {
    @NotNull
    private static final String EDITABLE_THEMES_RELATIVE_PATH = ".fleet/themes";
    @NotNull
    private static final MediaType JsonMediaType = new MediaType("text", "json", null, null, 12, null);

    public static final boolean isThemeFile(@NotNull FileAddress fileAddress) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
        ProtocolPath protocolPath = LocalFsdExtKt.getLocalFs().getUserHome();
        if (protocolPath != null && (protocolPath = protocolPath.resolveChild(EDITABLE_THEMES_RELATIVE_PATH)) != null) {
            ProtocolPath themesDir = protocolPath;
            boolean bl2 = false;
            bl = fileAddress.getPath().startsWith(themesDir) && Intrinsics.areEqual((Object)FileAddressKt.getExtension((FileAddress)fileAddress), (Object)"json") || ThemeDesignerKt.wasMarkedAsTheme(fileAddress);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean wasMarkedAsTheme(FileAddress fileAddress) {
        boolean bl;
        block4: {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)DocumentFileEntity.Companion.getFileAddressAttr()), (Object)fileAddress);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                DocumentEntity it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                DocumentFileEntity documentFileEntity = (DocumentFileEntity)element$iv$iv;
                boolean bl3 = false;
                if (documentFileEntity.getDocument() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DocumentEntity documentEntity = (DocumentEntity)element$iv;
                    boolean bl5 = false;
                    if (!(EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)DetectedThemeDocument.Companion.getDocumentEntityAttr()), (Object)documentEntity) != null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Color> parsePalette(SyntaxNode root) {
        SyntaxNode syntaxNode;
        Object v1;
        Object object;
        Iterator iterator;
        Sequence sequence;
        Map palette;
        block4: {
            palette = new LinkedHashMap();
            sequence = SequencesKt.filter((Sequence)SyntaxNodeExtKt.children((SyntaxNode)root), (Function1)parsePalette.paletteProperty.1.INSTANCE);
            iterator = sequence.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                SyntaxNode property = (SyntaxNode)object;
                boolean bl = false;
                SyntaxNode propertyKey = property.firstChild();
                SyntaxNode propertyValue = property.lastChild();
                SyntaxNode syntaxNode2 = propertyKey;
                if (!(Intrinsics.areEqual((Object)String.valueOf(syntaxNode2 != null ? syntaxNode2.getText() : null), (Object)"\"palette\"") && propertyValue != null)) continue;
                v1 = object;
                break block4;
            }
            v1 = null;
        }
        SyntaxNode paletteProperty2 = v1;
        if (paletteProperty2 != null && (syntaxNode = paletteProperty2.lastChild()) != null && (sequence = SyntaxNodeExtKt.children((SyntaxNode)syntaxNode)) != null && (iterator = SequencesKt.filter((Sequence)sequence, (Function1)parsePalette.1.INSTANCE)) != null) {
            void $this$forEach$iv;
            object = iterator;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SyntaxNode property = (SyntaxNode)element$iv;
                boolean bl = false;
                SyntaxNode propertyKey = property.firstChild();
                SyntaxNode propertyValue = property.lastChild();
                if (propertyKey == null || propertyValue == null || !Intrinsics.areEqual((Object)propertyValue.getType(), (Object)JsonElementTypes.STRING_LITERAL)) continue;
                CharSequence $this$parsePalette_u24lambda_u247_u24lambda_u244 = propertyKey.getText();
                boolean bl2 = false;
                String propertyKeyString = ((Object)$this$parsePalette_u24lambda_u247_u24lambda_u244.subSequence(1, $this$parsePalette_u24lambda_u247_u24lambda_u244.length() - 1)).toString();
                CharSequence $this$parsePalette_u24lambda_u247_u24lambda_u245 = propertyValue.getText();
                boolean bl3 = false;
                String propertyValueString = ((Object)$this$parsePalette_u24lambda_u247_u24lambda_u245.subSequence(1, $this$parsePalette_u24lambda_u247_u24lambda_u245.length() - 1)).toString();
                Color color = ThemeDesignerKt.stringToColor(propertyValueString);
                if (color != null) {
                    long color2 = color.unbox-impl();
                    boolean bl4 = false;
                    Color color3 = Color.box-impl((long)color2);
                    palette.put(propertyKeyString, color3);
                }
            }
        }
        return palette;
    }

    private static final void findAllColors(SyntaxNode $this$findAllColors, Map<String, Color> palette, List<Pair<TextRange, ColorInlay>> result) {
        Color color;
        Sequence $this$forEach$iv = SyntaxNodeExtKt.children((SyntaxNode)$this$findAllColors);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SyntaxNode it = (SyntaxNode)element$iv;
            boolean bl = false;
            ThemeDesignerKt.findAllColors(it, palette, result);
        }
        SyntaxNode propertyValue = $this$findAllColors.lastChild();
        if (!Intrinsics.areEqual((Object)$this$findAllColors.getType(), (Object)JsonElementTypes.PROPERTY) || propertyValue == null || !Intrinsics.areEqual((Object)propertyValue.getType(), (Object)JsonElementTypes.STRING_LITERAL)) {
            return;
        }
        CharSequence $this$findAllColors_u24lambda_u249 = propertyValue.getText();
        boolean bl = false;
        String valueString = ((Object)$this$findAllColors_u24lambda_u249.subSequence(1, $this$findAllColors_u24lambda_u249.length() - 1)).toString();
        Color color2 = palette.get(valueString);
        if (color2 == null) {
            color2 = ThemeDesignerKt.stringToColor(valueString);
        }
        if ((color = color2) != null) {
            result.add((Pair<TextRange, ColorInlay>)TuplesKt.to((Object)SyntexNodeExtKt.getTextRange((SyntaxNode)propertyValue), (Object)new ColorInlay(color.unbox-impl(), null)));
        }
    }

    private static final Color stringToColor(String colorString) {
        Color color;
        if (colorString == null) {
            return null;
        }
        try {
            long l;
            String string;
            if (StringsKt.startsWith$default((String)colorString, (String)"#", (boolean)false, (int)2, null)) {
                String string2 = colorString.substring(1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = colorString;
            }
            String color2 = string;
            if (StringsKt.endsWith$default((String)color2, (String)"%", (boolean)false, (int)2, null)) {
                String string3 = color2.substring(0, 6);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String mainPart = string3;
                String string4 = color2.substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                char[] cArray = new char[]{'%'};
                String alpha = StringsKt.trimEnd((String)string4, (char[])cArray);
                l = Color.copy-wmQWz5c$default((long)NoriaColorKt.css((Color.Companion)Color.Companion, (String)mainPart), (float)(Float.parseFloat(alpha) / (float)100), (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null);
            } else {
                l = NoriaColorKt.css((Color.Companion)Color.Companion, (String)color2);
            }
            color = Color.box-impl((long)l);
        }
        catch (Throwable throwable) {
            color = null;
        }
        return color;
    }

    private static final Schema buildThemeSchema() {
        return SchemaKt.schema((Function1)buildThemeSchema.1.INSTANCE);
    }

    public static final /* synthetic */ Schema access$buildThemeSchema() {
        return ThemeDesignerKt.buildThemeSchema();
    }

    public static final /* synthetic */ MediaType access$getJsonMediaType$p() {
        return JsonMediaType;
    }

    public static final /* synthetic */ Map access$parsePalette(SyntaxNode root) {
        return ThemeDesignerKt.parsePalette(root);
    }

    public static final /* synthetic */ void access$findAllColors(SyntaxNode $receiver, Map palette, List result) {
        ThemeDesignerKt.findAllColors($receiver, palette, result);
    }
}

