/*
 * Decompiled with CFR 0.152.
 */
package fleet.rpc.relay.end2end;

import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\u0012\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lfleet/rpc/relay/end2end/DeflaterByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "byteChannel", "compressionLevel", "", "nowrap", "", "bufferSize", "<init>", "(Ljava/nio/channels/WritableByteChannel;IZI)V", "deflater", "Ljava/util/zip/Deflater;", "deflatedOutputStream", "Ljava/util/zip/DeflaterOutputStream;", "buffer", "", "close", "", "isOpen", "write", "src", "Ljava/nio/ByteBuffer;", "fleet.rpc.relay"})
final class DeflaterByteChannel
implements WritableByteChannel {
    @NotNull
    private final WritableByteChannel byteChannel;
    @NotNull
    private final Deflater deflater;
    @NotNull
    private final DeflaterOutputStream deflatedOutputStream;
    @NotNull
    private final byte[] buffer;

    public DeflaterByteChannel(@NotNull WritableByteChannel byteChannel, int compressionLevel, boolean nowrap, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)byteChannel, (String)"byteChannel");
        this.byteChannel = byteChannel;
        this.deflater = new Deflater(compressionLevel, nowrap);
        this.deflatedOutputStream = new DeflaterOutputStream(Channels.newOutputStream(this.byteChannel), this.deflater, bufferSize, true);
        this.buffer = new byte[bufferSize];
    }

    @Override
    public void close() {
        this.byteChannel.close();
    }

    @Override
    public boolean isOpen() {
        return this.byteChannel.isOpen();
    }

    @Override
    public int write(@Nullable ByteBuffer src) {
        if (src == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        int bytes = Math.min(src.remaining(), this.buffer.length);
        src.get(this.buffer, 0, bytes);
        this.deflatedOutputStream.write(this.buffer, 0, bytes);
        this.deflatedOutputStream.flush();
        return bytes;
    }
}

