/*
 * Decompiled with CFR 0.152.
 */
package fleet.rpc.relay;

import fleet.rpc.client.ClientId;
import fleet.rpc.relay.RelaySessionSerializer;
import fleet.util.UID;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=RelaySessionSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lfleet/rpc/relay/RelaySession;", "", "clientId", "Lfleet/rpc/client/ClientId;", "session", "Lfleet/util/UID;", "<init>", "(Lfleet/rpc/client/ClientId;Lfleet/util/UID;)V", "getClientId", "()Lfleet/rpc/client/ClientId;", "getSession", "()Lfleet/util/UID;", "encode", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "fleet.rpc.relay"})
public final class RelaySession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientId clientId;
    @NotNull
    private final UID session;
    @NotNull
    public static final String SEPARATOR = "_";

    public RelaySession(@NotNull ClientId clientId, @NotNull UID session) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.clientId = clientId;
        this.session = session;
    }

    @NotNull
    public final ClientId getClientId() {
        return this.clientId;
    }

    @NotNull
    public final UID getSession() {
        return this.session;
    }

    @NotNull
    public final String encode() {
        return this.clientId.getUid().getId() + SEPARATOR + this.session.getId();
    }

    @NotNull
    public final ClientId component1() {
        return this.clientId;
    }

    @NotNull
    public final UID component2() {
        return this.session;
    }

    @NotNull
    public final RelaySession copy(@NotNull ClientId clientId, @NotNull UID session) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new RelaySession(clientId, session);
    }

    public static /* synthetic */ RelaySession copy$default(RelaySession relaySession, ClientId clientId, UID uID, int n, Object object) {
        if ((n & 1) != 0) {
            clientId = relaySession.clientId;
        }
        if ((n & 2) != 0) {
            uID = relaySession.session;
        }
        return relaySession.copy(clientId, uID);
    }

    @NotNull
    public String toString() {
        return "RelaySession(clientId=" + this.clientId + ", session=" + this.session + ")";
    }

    public int hashCode() {
        int result2 = this.clientId.hashCode();
        result2 = result2 * 31 + this.session.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RelaySession)) {
            return false;
        }
        RelaySession relaySession = (RelaySession)other;
        if (!Intrinsics.areEqual((Object)this.clientId, (Object)relaySession.clientId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.session, (Object)relaySession.session);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lfleet/rpc/relay/RelaySession$Companion;", "", "<init>", "()V", "SEPARATOR", "", "decode", "Lfleet/rpc/relay/RelaySession;", "string", "serializer", "Lkotlinx/serialization/KSerializer;", "fleet.rpc.relay"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RelaySession decode(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            String[] stringArray = new String[]{RelaySession.SEPARATOR};
            List components = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (!(components.size() == 2)) {
                boolean bl = false;
                String string2 = "Wrong components count in network address string [" + string + "]";
                throw new IllegalStateException(string2.toString());
            }
            return new RelaySession(new ClientId(UID.Companion.fromString((String)components.get(0))), UID.Companion.fromString((String)components.get(1)));
        }

        @NotNull
        public final KSerializer<RelaySession> serializer() {
            return (KSerializer)new RelaySessionSerializer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

