/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.files.jvm;

import ai.grazie.code.files.model.Language;
import ai.grazie.code.files.model.LanguageProvider;
import java.io.File;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\b"}, d2={"Lai/grazie/code/files/jvm/JVMLanguageProvider;", "Lai/grazie/code/files/model/LanguageProvider;", "Ljava/io/File;", "()V", "language", "Lai/grazie/code/files/model/Language;", "path", "(Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "code-files-jvm"})
public final class JVMLanguageProvider
implements LanguageProvider<File> {
    @NotNull
    public static final JVMLanguageProvider INSTANCE = new JVMLanguageProvider();

    private JVMLanguageProvider() {
    }

    @Nullable
    public Object language(@NotNull File path, @NotNull Continuation<? super Language> $completion) {
        return switch (FilesKt.getExtension((File)path)) {
            case "c", "h" -> Language.Companion.getC();
            case "cpp", "hpp" -> Language.Companion.getCPP();
            case "css" -> Language.Companion.getCSS();
            case "cs" -> Language.Companion.getCSharp();
            case "go" -> Language.Companion.getGo();
            case "groovy" -> Language.Companion.getGroovy();
            case "hcl", "tf" -> Language.Companion.getHCL();
            case "html" -> Language.Companion.getHTML();
            case "json" -> Language.Companion.getJSON();
            case "java" -> Language.Companion.getJava();
            case "js", "jsx" -> Language.Companion.getJavaScript();
            case "ipynb" -> Language.Companion.getJupyter();
            case "kt" -> Language.Companion.getKotlin();
            case "kts" -> Language.Companion.getKotlinScript();
            case "md" -> Language.Companion.getMarkdown();
            case "php" -> Language.Companion.getPHP();
            case "py" -> Language.Companion.getPython();
            case "rb" -> Language.Companion.getRuby();
            case "rs" -> Language.Companion.getRust();
            case "scala" -> Language.Companion.getScala();
            case "sh" -> Language.Companion.getShell();
            case "swift" -> Language.Companion.getSwift();
            case "toml" -> Language.Companion.getTOML();
            case "tsx", "ts" -> Language.Companion.getTypeScript();
            case "xml" -> Language.Companion.getXML();
            case "yaml" -> Language.Companion.getYAML();
            default -> Language.Companion.getUnknown();
        };
    }
}

