/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.files.jvm;

import ai.grazie.code.files.jvm.JVMFileSystemProvider;
import ai.grazie.code.files.model.FileMetadata;
import ai.grazie.code.files.model.FileSystemProvider;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lai/grazie/code/files/jvm/JVMFileSystemProvider;", "", "()V", "Read", "Select", "Serialization", "Write", "code-files-jvm"})
public final class JVMFileSystemProvider {
    @NotNull
    public static final JVMFileSystemProvider INSTANCE = new JVMFileSystemProvider();

    private JVMFileSystemProvider() {
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\t\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0001J\u0019\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0001J\u0019\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0001\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lai/grazie/code/files/jvm/JVMFileSystemProvider$Read;", "Lai/grazie/code/files/model/FileSystemProvider$Read;", "Ljava/io/File;", "Lai/grazie/code/files/model/FileSystemProvider$Serialization;", "()V", "extension", "", "path", "(Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fromAbsoluteString", "fromRelativeString", "base", "name", "read", "", "size", "", "toPathString", "code-files-jvm"})
    public static final class Read
    implements FileSystemProvider.Read<File>,
    FileSystemProvider.Serialization<File> {
        @NotNull
        public static final Read INSTANCE = new Read();
        private final /* synthetic */ Serialization $$delegate_0;

        private Read() {
            this.$$delegate_0 = Serialization.INSTANCE;
        }

        @NotNull
        public File fromAbsoluteString(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.$$delegate_0.fromAbsoluteString(path);
        }

        @NotNull
        public File fromRelativeString(@NotNull File base, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.$$delegate_0.fromRelativeString(base, path);
        }

        @NotNull
        public String toPathString(@NotNull File path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.$$delegate_0.toPathString(path);
        }

        @Nullable
        public Object read(@NotNull File path, @NotNull Continuation<? super byte[]> $completion) {
            return FilesKt.readBytes((File)path);
        }

        @Nullable
        public Object name(@NotNull File path, @NotNull Continuation<? super String> $completion) {
            String string = path.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.name");
            return string;
        }

        @Nullable
        public Object extension(@NotNull File path, @NotNull Continuation<? super String> $completion) {
            return FilesKt.getExtension((File)path);
        }

        @Nullable
        public Object size(@NotNull File path, @NotNull Continuation<? super Long> $completion) {
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(path, null){
                int label;
                final /* synthetic */ File $path;
                {
                    this.$path = $path;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            return Boxing.boxLong((long)Files.size(this.$path.toPath()));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0001J\u001f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ#\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0011\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002H\u0096\u0001\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lai/grazie/code/files/jvm/JVMFileSystemProvider$Select;", "Lai/grazie/code/files/model/FileSystemProvider$Select;", "Ljava/io/File;", "Lai/grazie/code/files/model/FileSystemProvider$Serialization;", "()V", "fromAbsoluteString", "path", "", "fromRelativeString", "base", "list", "", "(Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "metadata", "Lai/grazie/code/files/model/FileMetadata;", "parent", "relative", "root", "(Ljava/io/File;Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toPathString", "code-files-jvm"})
    @SourceDebugExtension(value={"SMAP\nJVMFileSystemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JVMFileSystemProvider.kt\nai/grazie/code/files/jvm/JVMFileSystemProvider$Select\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,73:1\n18#2:74\n26#3:75\n6442#4:76\n*S KotlinDebug\n*F\n+ 1 JVMFileSystemProvider.kt\nai/grazie/code/files/jvm/JVMFileSystemProvider$Select\n*L\n35#1:74\n35#1:75\n35#1:76\n*E\n"})
    public static final class Select
    implements FileSystemProvider.Select<File>,
    FileSystemProvider.Serialization<File> {
        @NotNull
        public static final Select INSTANCE = new Select();
        private final /* synthetic */ Serialization $$delegate_0;

        private Select() {
            this.$$delegate_0 = Serialization.INSTANCE;
        }

        @NotNull
        public File fromAbsoluteString(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.$$delegate_0.fromAbsoluteString(path);
        }

        @NotNull
        public File fromRelativeString(@NotNull File base, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.$$delegate_0.fromRelativeString(base, path);
        }

        @NotNull
        public String toPathString(@NotNull File path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.$$delegate_0.toPathString(path);
        }

        @Nullable
        public Object metadata(@NotNull File path, @NotNull Continuation<? super FileMetadata> $completion) {
            return path.isFile() ? new FileMetadata(FileMetadata.FileType.File) : (path.isDirectory() ? new FileMetadata(FileMetadata.FileType.Directory) : null);
        }

        @Nullable
        public Object list(@NotNull File path, @NotNull Continuation<? super List<? extends File>> $completion) {
            Object[] $this$orEmpty$iv = path.listFiles();
            boolean $i$f$orEmpty = false;
            Object[] objectArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                boolean $i$f$emptyArray = false;
                objectArray = new File[]{};
            }
            Object[] $this$sortedBy$iv = objectArray;
            boolean $i$f$sortedBy = false;
            return ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    File it = (File)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (File)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
        }

        @Nullable
        public Object parent(@NotNull File path, @NotNull Continuation<? super File> $completion) {
            return path.getParentFile();
        }

        @Nullable
        public Object relative(@NotNull File root, @NotNull File path, @NotNull Continuation<? super File> $completion) {
            File file = FilesKt.relativeToOrNull((File)path, (File)root);
            return file != null ? FilesKt.normalize((File)file) : null;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lai/grazie/code/files/jvm/JVMFileSystemProvider$Serialization;", "Lai/grazie/code/files/model/FileSystemProvider$Serialization;", "Ljava/io/File;", "()V", "fromAbsoluteString", "path", "", "fromRelativeString", "base", "toPathString", "toSystemDependentName", "code-files-jvm"})
    public static final class Serialization
    implements FileSystemProvider.Serialization<File> {
        @NotNull
        public static final Serialization INSTANCE = new Serialization();

        private Serialization() {
        }

        @NotNull
        public String toPathString(@NotNull File path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = FilesKt.normalize((File)path).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.normalize().path");
            return string;
        }

        @NotNull
        public File fromAbsoluteString(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return FilesKt.normalize((File)new File(this.toSystemDependentName(path)));
        }

        @NotNull
        public File fromRelativeString(@NotNull File base, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return FilesKt.normalize((File)FilesKt.resolve((File)base, (String)path));
        }

        private final String toSystemDependentName(String path) {
            return StringsKt.replace$default((String)StringsKt.replace$default((String)path, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null), (char)'\\', (char)File.separatorChar, (boolean)false, (int)4, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ!\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0011\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\tH\u0096\u0001J\u0019\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\tH\u0096\u0001J\u0011\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0002H\u0096\u0001\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lai/grazie/code/files/jvm/JVMFileSystemProvider$Write;", "Lai/grazie/code/files/model/FileSystemProvider$Write;", "Ljava/io/File;", "Lai/grazie/code/files/model/FileSystemProvider$Serialization;", "()V", "create", "", "parent", "name", "", "type", "Lai/grazie/code/files/model/FileMetadata$FileType;", "(Ljava/io/File;Ljava/lang/String;Lai/grazie/code/files/model/FileMetadata$FileType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "delete", "(Ljava/io/File;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fromAbsoluteString", "path", "fromRelativeString", "base", "toPathString", "code-files-jvm"})
    public static final class Write
    implements FileSystemProvider.Write<File>,
    FileSystemProvider.Serialization<File> {
        @NotNull
        public static final Write INSTANCE = new Write();
        private final /* synthetic */ Serialization $$delegate_0;

        private Write() {
            this.$$delegate_0 = Serialization.INSTANCE;
        }

        @NotNull
        public File fromAbsoluteString(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.$$delegate_0.fromAbsoluteString(path);
        }

        @NotNull
        public File fromRelativeString(@NotNull File base, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.$$delegate_0.fromRelativeString(base, path);
        }

        @NotNull
        public String toPathString(@NotNull File path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.$$delegate_0.toPathString(path);
        }

        @Nullable
        public Object create(@NotNull File parent, @NotNull String name, @NotNull FileMetadata.FileType type, @NotNull Continuation<? super Unit> $completion) {
            Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)new Function2<CoroutineScope, Continuation<? super Comparable<?>>, Object>(parent, name, type, null){
                int label;
                final /* synthetic */ File $parent;
                final /* synthetic */ String $name;
                final /* synthetic */ FileMetadata.FileType $type;
                {
                    this.$parent = $parent;
                    this.$name = $name;
                    this.$type = $type;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            File file = new File(this.$parent, this.$name);
                            return switch (create.WhenMappings.$EnumSwitchMapping$0[this.$type.ordinal()]) {
                                case 1 -> Boxing.boxBoolean((boolean)file.createNewFile());
                                case 2 -> {
                                    Path var3_3 = file.toPath();
                                    Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"file.toPath()");
                                    FileAttribute[] var4_4 = new FileAttribute[]{};
                                    Path v1 = Files.createDirectory(var3_3, Arrays.copyOf(var4_4, var4_4.length));
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"createDirectory(this, *attributes)");
                                    yield v1;
                                }
                                default -> throw new NoWhenBranchMatchedException();
                            };
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Comparable<?>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Nullable
        public Object delete(@NotNull File parent, @NotNull String name, @NotNull Continuation<? super Unit> $completion) {
            Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(parent, name, null){
                int label;
                final /* synthetic */ File $parent;
                final /* synthetic */ String $name;
                {
                    this.$parent = $parent;
                    this.$name = $name;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Boolean bl;
                            ResultKt.throwOnFailure((Object)object);
                            File file = new File(this.$parent, this.$name);
                            if (file.isDirectory()) {
                                bl = Boxing.boxBoolean((boolean)FilesKt.deleteRecursively((File)file));
                            } else {
                                Path path = file.toPath();
                                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toPath()");
                                Files.delete(path);
                                bl = Unit.INSTANCE;
                            }
                            return bl;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<Object> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }
}

