/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.xml.util;

import fleet.com.intellij.openapi.diagnostic.Logger;
import fleet.com.intellij.openapi.util.NlsSafe;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.util.ThreeState;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlUtil {
    private static final Logger LOG = Logger.getInstance(HtmlUtil.class);
    @NonNls
    private static final String JSFC = "jsfc";
    @NonNls
    private static final String CHARSET = "charset";
    @NonNls
    private static final String CHARSET_PREFIX = "charset=";
    @NonNls
    public static final String HTML5_DATA_ATTR_PREFIX = "data-";
    @NlsSafe
    public static final String SCRIPT_TAG_NAME = "script";
    @NlsSafe
    public static final String STYLE_TAG_NAME = "style";
    @NlsSafe
    public static final String TEMPLATE_TAG_NAME = "template";
    @NlsSafe
    public static final String TEXTAREA_TAG_NAME = "textarea";
    @NlsSafe
    public static final String TITLE_TAG_NAME = "title";
    @NlsSafe
    public static final String SLOT_TAG_NAME = "slot";
    @NlsSafe
    public static final String STYLE_ATTRIBUTE_NAME = "style";
    @NlsSafe
    public static final String SRC_ATTRIBUTE_NAME = "src";
    @NlsSafe
    public static final String ID_ATTRIBUTE_NAME = "id";
    @NlsSafe
    public static final String CLASS_ATTRIBUTE_NAME = "class";
    @NlsSafe
    public static final String TYPE_ATTRIBUTE_NAME = "type";
    @NlsSafe
    public static final String LANGUAGE_ATTRIBUTE_NAME = "language";
    @NlsSafe
    public static final String LANG_ATTRIBUTE_NAME = "lang";
    @NonNls
    public static final String MATH_ML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    @NonNls
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    public static final String[] RFC2616_HEADERS = new String[]{"Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Ranges", "Age", "Allow", "Authorization", "Cache-Control", "Connection", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Date", "ETag", "Expect", "Expires", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Last-Modified", "Location", "Max-Forwards", "Pragma", "Proxy-Authenticate", "Proxy-Authorization", "Range", "Referer", "Refresh", "Retry-After", "Server", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "User-Agent", "Vary", "Via", "Warning", "WWW-Authenticate"};
    private static final String HTML_TAG_REGEXP = "\\s*</?\\w+\\s*(\\w+\\s*=.*)?>.*";
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("\\s*</?\\w+\\s*(\\w+\\s*=.*)?>.*");
    private static final Set<String> EMPTY_TAGS_MAP = Set.of("area", "base", "basefont", "br", "col", "embed", "frame", "hr", "meta", "img", "input", "isindex", "link", "param", "source", "track", "wbr");
    private static final Set<String> OPTIONAL_END_TAGS_MAP = Set.of("head", "caption", "colgroup", "dd", "dt", "embed", "li", "noembed", "optgroup", "option", "p", "rt", "rp", "tbody", "td", "tfoot", "th", "thead", "tr");
    private static final Set<String> BLOCK_TAGS_MAP = Set.of("p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "dir", "menu", "pre", "dl", "div", "center", "noscript", "noframes", "blockquote", "form", "isindex", "hr", "table", "fieldset", "address", "map", "body", "object", "applet", "ins", "del", "dd", "li", "button", "th", "td", "iframe", "comment");
    private static final Set<String> POSSIBLY_INLINE_TAGS_MAP = Set.of("a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var");
    private static final Set<String> INLINE_ELEMENTS_CONTAINER_MAP = Set.of("p", "h1", "h2", "h3", "h4", "h5", "h6", "pre");
    private static final Set<String> HTML5_TAGS_SET = Set.of("article", "aside", "audio", "canvas", "command", "datalist", "details", "embed", "figcaption", "figure", "footer", "header", "keygen", "mark", "meter", "nav", "output", "progress", "rp", "rt", "ruby", "section", "source", "summary", "time", "video", "wbr", "main");
    private static final Set<String> P_AUTO_CLOSE_CLOSING_TAGS = Set.of("abbr", "acronym", "address", "applet", "area", "article", "aside", "b", "base", "basefont", "bdi", "bdo", "big", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "data", "datalist", "dd", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "em", "embed", "fieldset", "figcaption", "figure", "font", "footer", "form", "frame", "frameset", "head", "header", "hgroup", "h1", "hr", "html", "i", "iframe", "img", "input", "kbd", "keygen", "label", "legend", "li", "link", "main", "mark", "menu", "menuitem", "meta", "meter", "nav", "noframes", "object", "ol", "optgroup", "option", "output", "p", "param", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "script", "section", "select", "small", "source", "span", "strike", "strong", "style", "sub", "summary", "sup", "svg", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "title", "tr", "track", "tt", "u", "ul", "var", "wbr");
    private static final Map<String, Set<String>> AUTO_CLOSE_BY_OPENING_TAG = new HashMap<String, Set<String>>();

    private HtmlUtil() {
    }

    public static boolean isSingleHtmlTag(String tagName, boolean caseSensitive) {
        return EMPTY_TAGS_MAP.contains(caseSensitive ? tagName : StringUtil.toLowerCase((String)tagName));
    }

    @Deprecated(forRemoval=true)
    public static boolean isSingleHtmlTag(String tagName) {
        return HtmlUtil.isSingleHtmlTag(tagName, false);
    }

    public static boolean isTagWithOptionalEnd(@NotNull String tagName, boolean caseSensitive) {
        return OPTIONAL_END_TAGS_MAP.contains(caseSensitive ? tagName : StringUtil.toLowerCase((String)tagName));
    }

    @NotNull
    public static ThreeState canOpeningTagAutoClose(@NotNull String tagToClose, @NotNull String openingTag, boolean caseSensitive) {
        String normalizedOpeningTag;
        String normalizedTagToClose = caseSensitive ? tagToClose : StringUtil.toLowerCase((String)tagToClose);
        String string = normalizedOpeningTag = caseSensitive ? openingTag : StringUtil.toLowerCase((String)openingTag);
        if (!HtmlUtil.isTagWithOptionalEnd(normalizedTagToClose, true)) {
            return ThreeState.NO;
        }
        Set<String> closingTags = AUTO_CLOSE_BY_OPENING_TAG.get(normalizedTagToClose);
        if (closingTags != null && closingTags.contains(normalizedOpeningTag)) {
            return ThreeState.YES;
        }
        return ThreeState.UNSURE;
    }

    public static boolean canClosingTagAutoClose(@NotNull String tagToClose, @NotNull String closingTag, boolean caseSensitive) {
        String normalizedClosingTag;
        String normalizedTagToClose = caseSensitive ? tagToClose : StringUtil.toLowerCase((String)tagToClose);
        String string = normalizedClosingTag = caseSensitive ? closingTag : StringUtil.toLowerCase((String)closingTag);
        if (!HtmlUtil.isTagWithOptionalEnd(normalizedTagToClose, true)) {
            return false;
        }
        if (normalizedTagToClose.equals("p")) {
            return P_AUTO_CLOSE_CLOSING_TAGS.contains(normalizedClosingTag);
        }
        return true;
    }

    public static boolean isHtmlBlockTag(String tagName, boolean caseSensitive) {
        return BLOCK_TAGS_MAP.contains(caseSensitive ? tagName : StringUtil.toLowerCase((String)tagName));
    }

    @Deprecated(forRemoval=true)
    public static boolean isHtmlBlockTag(String tagName) {
        return HtmlUtil.isHtmlBlockTag(tagName, false);
    }

    public static boolean isPossiblyInlineTag(@NotNull String tagName) {
        return POSSIBLY_INLINE_TAGS_MAP.contains(tagName);
    }

    public static boolean isInlineTagContainer(String tagName, boolean caseSensitive) {
        return INLINE_ELEMENTS_CONTAINER_MAP.contains(caseSensitive ? tagName : StringUtil.toLowerCase((String)tagName));
    }

    static {
        AUTO_CLOSE_BY_OPENING_TAG.put("colgroup", Set.of("colgroup", "tbody", "tfoot", "thead"));
        AUTO_CLOSE_BY_OPENING_TAG.put("dd", Set.of("dd", "dt"));
        AUTO_CLOSE_BY_OPENING_TAG.put("dt", Set.of("dd", "dt"));
        AUTO_CLOSE_BY_OPENING_TAG.put("head", Set.of("body"));
        AUTO_CLOSE_BY_OPENING_TAG.put("li", Set.of("li"));
        AUTO_CLOSE_BY_OPENING_TAG.put("optgroup", Set.of("optgroup"));
        AUTO_CLOSE_BY_OPENING_TAG.put("option", Set.of("optgroup", "option"));
        AUTO_CLOSE_BY_OPENING_TAG.put("p", Set.of("address", "article", "aside", "blockquote", "center", "details", "div", "dl", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "header", "hgroup", "hr", "main", "menu", "nav", "ol", "p", "pre", "section", "table", "ul"));
        AUTO_CLOSE_BY_OPENING_TAG.put("rp", Set.of("rp", "rt"));
        AUTO_CLOSE_BY_OPENING_TAG.put("rt", Set.of("rp", "rt"));
        AUTO_CLOSE_BY_OPENING_TAG.put("tbody", Set.of("tbody", "tfoot"));
        AUTO_CLOSE_BY_OPENING_TAG.put("td", Set.of("td", "th"));
        AUTO_CLOSE_BY_OPENING_TAG.put("th", Set.of("td", "th"));
        AUTO_CLOSE_BY_OPENING_TAG.put("thead", Set.of("tbody", "tfoot"));
        AUTO_CLOSE_BY_OPENING_TAG.put("tr", Set.of("tr"));
    }
}

