/*
 * Decompiled with CFR 0.152.
 */
package boringFormatter.indenter;

import boringFormatter.TextContentLine;
import boringFormatter.indenter.IndentingEditorSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001c\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0010"}, d2={"absoluteIndentSize", "", "LboringFormatter/indenter/IndentingEditorSettings;", "getAbsoluteIndentSize", "(LboringFormatter/indenter/IndentingEditorSettings;)I", "string", "", "getAbsoluteIndentSizeForLine", "line", "LboringFormatter/TextContentLine;", "getColumnNumber", "", "offset", "getIndentString", "", "size", "fleet.boringFormatter"})
public final class IndentingEditorSettingsKt {
    public static final int getAbsoluteIndentSize(@NotNull IndentingEditorSettings $this$absoluteIndentSize) {
        Intrinsics.checkNotNullParameter((Object)$this$absoluteIndentSize, (String)"<this>");
        return $this$absoluteIndentSize.isTab() ? $this$absoluteIndentSize.getTabWidth() : $this$absoluteIndentSize.getIndentSize();
    }

    public static final int getAbsoluteIndentSizeForLine(@NotNull IndentingEditorSettings $this$getAbsoluteIndentSizeForLine, @NotNull TextContentLine line) {
        Intrinsics.checkNotNullParameter((Object)$this$getAbsoluteIndentSizeForLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return IndentingEditorSettingsKt.getAbsoluteIndentSize($this$getAbsoluteIndentSizeForLine, line.getContent());
    }

    public static final long getColumnNumber(@NotNull IndentingEditorSettings $this$getColumnNumber, @NotNull CharSequence string, long offset) {
        Intrinsics.checkNotNullParameter((Object)$this$getColumnNumber, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        long counter = 0L;
        int index = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((long)index >= offset) break;
            if (c == '\t') {
                counter += (long)$this$getColumnNumber.getTabWidth();
            } else {
                long l = counter;
                counter = l + 1L;
            }
            ++index;
        }
        return counter;
    }

    @NotNull
    public static final String getIndentString(@NotNull IndentingEditorSettings $this$getIndentString, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$getIndentString, (String)"<this>");
        return IndentingEditorSettingsKt.getIndentString($this$getIndentString, (int)size);
    }

    public static final int getAbsoluteIndentSize(@NotNull IndentingEditorSettings $this$getAbsoluteIndentSize, @NotNull CharSequence string) {
        Intrinsics.checkNotNullParameter((Object)$this$getAbsoluteIndentSize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int counter = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                ++counter;
                continue;
            }
            if (c != '\t') break;
            counter += $this$getAbsoluteIndentSize.getTabWidth();
        }
        return counter;
    }

    @NotNull
    public static final String getIndentString(@NotNull IndentingEditorSettings $this$getIndentString, int size) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getIndentString, (String)"<this>");
        if (!$this$getIndentString.isTab()) {
            object = StringsKt.repeat((CharSequence)" ", (int)size);
        } else {
            int spaceCount = size % $this$getIndentString.getTabWidth();
            int tabCount = (size - spaceCount) / $this$getIndentString.getTabWidth();
            object = StringsKt.repeat((CharSequence)"\t", (int)tabCount) + StringsKt.repeat((CharSequence)" ", (int)spaceCount);
        }
        return object;
    }
}

