/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.lang.parsing.builder;

import fleet.com.intellij.lang.WhitespacesAndCommentsBinder;
import fleet.com.intellij.lang.WhitespacesBinders;
import fleet.com.jetbrains.lang.parsing.builder.MarkerPsiBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MarkerOptionalData
extends BitSet {
    private final Int2ObjectOpenHashMap<Throwable> myDebugAllocationPositions = new Int2ObjectOpenHashMap();
    private final Int2ObjectOpenHashMap<String> myDoneErrors = new Int2ObjectOpenHashMap();
    private final Int2ObjectOpenHashMap<WhitespacesAndCommentsBinder> myLeftBinders = new Int2ObjectOpenHashMap();
    private final Int2ObjectOpenHashMap<WhitespacesAndCommentsBinder> myRightBinders = new Int2ObjectOpenHashMap();
    private final IntOpenHashSet myCollapsed = new IntOpenHashSet();

    MarkerOptionalData() {
    }

    void clean(int markerId) {
        if (this.get(markerId)) {
            this.set(markerId, false);
            this.myLeftBinders.remove(markerId);
            this.myRightBinders.remove(markerId);
            this.myDoneErrors.remove(markerId);
            this.myCollapsed.remove(markerId);
            this.myDebugAllocationPositions.remove(markerId);
        }
    }

    void compact() {
        this.myLeftBinders.trim();
        this.myRightBinders.trim();
        this.myDebugAllocationPositions.trim();
        this.myCollapsed.trim();
        this.myDoneErrors.trim();
    }

    @Nullable
    String getDoneError(int markerId) {
        if (!this.get(markerId)) {
            return null;
        }
        return (String)this.myDoneErrors.get(markerId);
    }

    boolean isCollapsed(int markerId) {
        return this.get(markerId) && this.myCollapsed.contains(markerId);
    }

    void setErrorMessage(int markerId, @NotNull String message) {
        this.markAsHavingOptionalData(markerId);
        this.myDoneErrors.put(markerId, (Object)message);
    }

    void markCollapsed(int markerId) {
        this.markAsHavingOptionalData(markerId);
        this.myCollapsed.add(markerId);
    }

    private void markAsHavingOptionalData(int markerId) {
        this.set(markerId);
    }

    void notifyAllocated(int markerId) {
        this.markAsHavingOptionalData(markerId);
        this.myDebugAllocationPositions.put(markerId, (Object)new Throwable("Created at the following trace."));
    }

    Throwable getAllocationTrace(MarkerPsiBuilder.StartMarker marker) {
        return (Throwable)this.myDebugAllocationPositions.get(marker.markerId);
    }

    WhitespacesAndCommentsBinder getBinder(int markerId, boolean right) {
        if (!this.get(markerId)) {
            return MarkerOptionalData.getDefaultBinder(right);
        }
        WhitespacesAndCommentsBinder binder = (WhitespacesAndCommentsBinder)this.getBinderMap(right).get(markerId);
        return binder != null ? binder : MarkerOptionalData.getDefaultBinder(right);
    }

    void assignBinder(int markerId, @NotNull WhitespacesAndCommentsBinder binder, boolean right) {
        Int2ObjectOpenHashMap<WhitespacesAndCommentsBinder> map = this.getBinderMap(right);
        if (binder != MarkerOptionalData.getDefaultBinder(right)) {
            this.markAsHavingOptionalData(markerId);
            map.put(markerId, (Object)binder);
        } else {
            map.remove(markerId);
        }
    }

    private static WhitespacesAndCommentsBinder getDefaultBinder(boolean right) {
        return right ? WhitespacesBinders.DEFAULT_RIGHT_BINDER : WhitespacesBinders.DEFAULT_LEFT_BINDER;
    }

    private Int2ObjectOpenHashMap<WhitespacesAndCommentsBinder> getBinderMap(boolean right) {
        return right ? this.myRightBinders : this.myLeftBinders;
    }
}

