/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.psi.tree;

import fleet.com.intellij.lang.Language;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IElementType {
    public static final IElementType[] EMPTY_ARRAY = new IElementType[0];
    public static final Predicate TRUE = type -> true;
    public static final short FIRST_TOKEN_INDEX = 1;
    private static final short MAX_INDEXED_TYPES = 15000;
    private static short size;
    private static volatile IElementType @NotNull [] ourRegistry;
    @NonNls
    private static final Object lock;
    private final short myIndex;
    @NonNls
    @NotNull
    private final String myDebugName;
    @NotNull
    private final Language myLanguage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IElementType @NotNull [] push(IElementType @NotNull [] types) {
        Object object = lock;
        synchronized (object) {
            IElementType[] oldRegistry = ourRegistry;
            ourRegistry = types;
            size = (short)Arrays.stream(ourRegistry).filter(Objects::nonNull).count();
            return oldRegistry;
        }
    }

    public static void unregisterElementTypes(@NotNull ClassLoader loader) {
        for (int i = 0; i < ourRegistry.length; ++i) {
            IElementType type = ourRegistry[i];
            if (type == null || type.getClass().getClassLoader() != loader) continue;
            IElementType.ourRegistry[i] = null;
        }
    }

    public static void unregisterElementTypes(@NotNull Language language2) {
        for (int i = 0; i < ourRegistry.length; ++i) {
            IElementType type = ourRegistry[i];
            if (type == null || !type.getLanguage().equals(language2)) continue;
            IElementType.ourRegistry[i] = null;
        }
    }

    public IElementType(@NonNls @NotNull String debugName, @Nullable Language language2) {
        this(debugName, language2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IElementType(@NonNls @NotNull String debugName, @Nullable Language language2, boolean register) {
        this.myDebugName = debugName;
        Language language3 = this.myLanguage = language2 == null ? Language.ANY : language2;
        if (register) {
            Object object = lock;
            synchronized (object) {
                short s = size;
                size = (short)(s + 1);
                this.myIndex = s;
                if (this.myIndex >= 15000) {
                    throw new IllegalStateException("Too many elements registered");
                }
                IElementType[] newRegistry = this.myIndex >= ourRegistry.length ? Arrays.copyOf(ourRegistry, ourRegistry.length * 3 / 2 + 1) : ourRegistry;
                newRegistry[this.myIndex] = this;
                ourRegistry = newRegistry;
            }
        } else {
            this.myIndex = (short)-1;
        }
    }

    @NotNull
    public Language getLanguage() {
        return this.myLanguage;
    }

    public final short getIndex() {
        return this.myIndex;
    }

    public int hashCode() {
        return this.myIndex >= 0 ? this.myIndex : super.hashCode();
    }

    public String toString() {
        return this.myDebugName;
    }

    public boolean isLeftBound() {
        return false;
    }

    public static IElementType find(short idx) {
        return ourRegistry[idx];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    static short getAllocatedTypesCount() {
        Object object = lock;
        synchronized (object) {
            return size;
        }
    }

    public static IElementType @NotNull [] enumerate(@NotNull Predicate p) {
        ArrayList<IElementType> matches = new ArrayList<IElementType>();
        for (IElementType value : ourRegistry) {
            if (value == null || !p.matches(value)) continue;
            matches.add(value);
        }
        return matches.toArray(new IElementType[0]);
    }

    static {
        ourRegistry = EMPTY_ARRAY;
        lock = new String("registry lock");
        IElementType[] init = new IElementType[137];
        init[0] = new IElementType("NULL", Language.ANY, false);
        IElementType.push(init);
    }

    @FunctionalInterface
    public static interface Predicate {
        public boolean matches(@NotNull IElementType var1);
    }
}

