/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.openapi.util;

import fleet.com.intellij.openapi.util.Pair;
import fleet.com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class URLUtil {
    public static final String SCHEME_SEPARATOR = "://";
    public static final String FILE_PROTOCOL = "file";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_SEPARATOR = "!/";

    private URLUtil() {
    }

    @NotNull
    public static InputStream openStream(@NotNull URL url) throws IOException {
        String protocol = url.getProtocol();
        return protocol.equals(JAR_PROTOCOL) ? URLUtil.openJarStream(url) : url.openStream();
    }

    @NotNull
    private static InputStream openJarStream(@NotNull URL url) throws IOException {
        Pair<String, String> paths = URLUtil.splitJarUrl(url.getFile());
        if (paths == null) {
            throw new MalformedURLException(url.getFile());
        }
        final ZipFile zipFile = new ZipFile((String)paths.first);
        ZipEntry zipEntry = zipFile.getEntry((String)paths.second);
        if (zipEntry == null) {
            zipFile.close();
            throw new FileNotFoundException("Entry " + (String)paths.second + " not found in " + (String)paths.first);
        }
        return new FilterInputStream(zipFile.getInputStream(zipEntry)){

            @Override
            public void close() throws IOException {
                super.close();
                zipFile.close();
            }
        };
    }

    @Nullable
    public static Pair<String, String> splitJarUrl(@NotNull String url) {
        String jarPath;
        String resourcePath;
        block6: {
            int pivot = url.indexOf(JAR_SEPARATOR);
            if (pivot < 0) {
                return null;
            }
            resourcePath = url.substring(pivot + 2);
            jarPath = url.substring(0, pivot);
            if (StringUtil.startsWithConcatenation(jarPath, JAR_PROTOCOL, ":")) {
                jarPath = jarPath.substring(JAR_PROTOCOL.length() + 1);
            }
            if (jarPath.startsWith(FILE_PROTOCOL)) {
                try {
                    jarPath = URLUtil.urlToFile(new URL(jarPath)).getPath().replace('\\', '/');
                }
                catch (Exception e) {
                    jarPath = jarPath.substring(FILE_PROTOCOL.length());
                    if (jarPath.startsWith(SCHEME_SEPARATOR)) {
                        jarPath = jarPath.substring(SCHEME_SEPARATOR.length());
                    }
                    if (!StringUtil.startsWithChar(jarPath, ':')) break block6;
                    jarPath = jarPath.substring(1);
                }
            }
        }
        return new Pair<String, String>(jarPath, resourcePath);
    }

    @NotNull
    public static File urlToFile(@NotNull URL url) {
        try {
            return new File(url.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL='" + url.toString() + "'", e);
        }
    }
}

