/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.openapi.util;

import fleet.com.intellij.openapi.util.SafeStAXStreamBuilder;
import fleet.com.intellij.openapi.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class JDOMUtil {
    private static final String XML_INPUT_FACTORY_KEY = "javax.xml.stream.XMLInputFactory";
    private static final String XML_INPUT_FACTORY_IMPL = "com.sun.xml.internal.stream.XMLInputFactoryImpl";
    private static volatile XMLInputFactory XML_INPUT_FACTORY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XMLInputFactory getXmlInputFactory() {
        XMLInputFactory factory = XML_INPUT_FACTORY;
        if (factory != null) {
            return factory;
        }
        Class<JDOMUtil> clazz = JDOMUtil.class;
        synchronized (JDOMUtil.class) {
            factory = XML_INPUT_FACTORY;
            if (factory != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return factory;
            }
            String property = System.setProperty(XML_INPUT_FACTORY_KEY, XML_INPUT_FACTORY_IMPL);
            try {
                factory = XMLInputFactory.newFactory();
            }
            finally {
                if (property != null) {
                    System.setProperty(XML_INPUT_FACTORY_KEY, property);
                } else {
                    System.clearProperty(XML_INPUT_FACTORY_KEY);
                }
            }
            factory.setProperty("javax.xml.stream.isCoalescing", true);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            XML_INPUT_FACTORY = factory;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return factory;
        }
    }

    @NotNull
    public static Element load(@NotNull URL url) throws JDOMException, IOException {
        return JDOMUtil.load(URLUtil.openStream(url));
    }

    @NotNull
    public static Element load(@NotNull InputStream stream) throws JDOMException, IOException {
        return JDOMUtil.loadUsingStaX(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    @NotNull
    private static Element loadUsingStaX(@NotNull Reader reader) throws JDOMException, IOException {
        try {
            Element element;
            XMLStreamReader xmlStreamReader = JDOMUtil.getXmlInputFactory().createXMLStreamReader(reader);
            try {
                element = SafeStAXStreamBuilder.build(xmlStreamReader, true, SafeStAXStreamBuilder.FACTORY);
            }
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), (Throwable)e);
                }
            }
            xmlStreamReader.close();
            return element;
        }
        finally {
            reader.close();
        }
    }
}

