/*
 * Decompiled with CFR 0.152.
 */
package fleet.profiling.core.idea;

import fleet.util.logging.BaseLogger;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H&J\u0006\u0010\u0013\u001a\u00020\u0004J\u0015\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u000eH\u0014R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lfleet/profiling/core/idea/AbstractLazyCachingExtractor;", "", "postProcessor", "Lkotlin/Function1;", "Ljava/io/File;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "log", "Lfleet/util/logging/KLogger;", "extractedFile", "lastModified", "", "tmpFileName", "", "getTmpFileName", "()Ljava/lang/String;", "sourceStream", "Ljava/io/InputStream;", "getFile", "extract", "destination", "extract$fleet_profiling_core", "createTempFile", "name", "fleet.profiling.core"})
@SourceDebugExtension(value={"SMAP\nLazyCachingExtractorFromJar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyCachingExtractorFromJar.kt\nfleet/profiling/core/idea/AbstractLazyCachingExtractor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public abstract class AbstractLazyCachingExtractor {
    @Nullable
    private final Function1<File, Unit> postProcessor;
    @NotNull
    private final KLogger log;
    private File extractedFile;
    private long lastModified;

    public AbstractLazyCachingExtractor(@Nullable Function1<? super File, Unit> postProcessor) {
        this.postProcessor = postProcessor;
        this.log = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(AbstractLazyCachingExtractor.class));
        this.lastModified = -1L;
    }

    public /* synthetic */ AbstractLazyCachingExtractor(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        this((Function1<? super File, Unit>)function1);
    }

    @NotNull
    public abstract String getTmpFileName();

    @NotNull
    public abstract InputStream sourceStream();

    @NotNull
    public final synchronized File getFile() {
        File file;
        block10: {
            block9: {
                if (this.extractedFile == null) break block9;
                File file2 = this.extractedFile;
                if (file2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extractedFile");
                    file2 = null;
                }
                if (!file2.exists()) break block9;
                File file3 = this.extractedFile;
                if (file3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extractedFile");
                    file3 = null;
                }
                if (file3.lastModified() == this.lastModified) break block10;
            }
            File extracted = this.createTempFile(this.getTmpFileName());
            try {
                this.extract$fleet_profiling_core(extracted);
                Function1<File, Unit> function1 = this.postProcessor;
                if (function1 != null) {
                    function1.invoke((Object)extracted);
                }
                this.extractedFile = extracted;
                this.lastModified = extracted.lastModified();
            }
            catch (Exception e) {
                BaseLogger.error$default((BaseLogger)((BaseLogger)this.log), (Throwable)e, null, (int)2, null);
                throw new Exception("Internal error: can't extract file '" + extracted.getAbsolutePath() + "'", e);
            }
        }
        if ((file = this.extractedFile) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extractedFile");
            file = null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract$fleet_profiling_core(@NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Closeable closeable = this.sourceStream();
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            long l = Files.copy(input, destination.toPath(), copyOptionArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    protected File createTempFile(@NotNull String name) {
        File file;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        File it = file = Files.createTempFile(StringsKt.substringAfterLast$default((String)name, (String)"/", null, (int)2, null), null, new FileAttribute[0]).toFile();
        boolean bl = false;
        it.deleteOnExit();
        File file2 = file;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"also(...)");
        return file2;
    }

    public AbstractLazyCachingExtractor() {
        this(null, 1, null);
    }
}

