/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.model.cloud.ip;

import ai.grazie.model.cloud.ip.IPAddress;
import ai.grazie.model.cloud.ip.IPv6Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\bH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lai/grazie/model/cloud/ip/IPv6Address;", "Lai/grazie/model/cloud/ip/IPAddress;", "bytes", "", "([B)V", "getBytes", "()[B", "display", "", "getDisplay", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "model-cloud"})
@SourceDebugExtension(value={"SMAP\nIPv6Address.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IPv6Address.kt\nai/grazie/model/cloud/ip/IPv6Address\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class IPv6Address
implements IPAddress {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] bytes;
    @NotNull
    private final String display;

    public IPv6Address(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        if (!(this.getBytes().length == 16)) {
            boolean bl = false;
            String string = "Invalid IPv6 address: " + this.getDisplay();
            throw new IllegalArgumentException(string.toString());
        }
        this.display = CollectionsKt.joinToString$default((Iterable)CollectionsKt.chunked((Iterable)ArraysKt.toList((byte[])this.getBytes()), (int)2), (CharSequence)":", null, null, (int)0, null, (Function1)display.1.INSTANCE, (int)30, null);
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    @NotNull
    public String getDisplay() {
        return this.display;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IPv6Address cfr_ignored_0 = (IPv6Address)other;
        if (!Arrays.equals(this.getBytes(), ((IPv6Address)other).getBytes())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getDisplay(), (Object)((IPv6Address)other).getDisplay());
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.getBytes());
        result = 31 * result + this.getDisplay().hashCode();
        return result;
    }

    @NotNull
    public final byte[] component1() {
        return this.bytes;
    }

    @NotNull
    public final IPv6Address copy(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return new IPv6Address(bytes);
    }

    public static /* synthetic */ IPv6Address copy$default(IPv6Address iPv6Address, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = iPv6Address.bytes;
        }
        return iPv6Address.copy(byArray);
    }

    @NotNull
    public String toString() {
        return "IPv6Address(bytes=" + Arrays.toString(this.bytes) + ")";
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lai/grazie/model/cloud/ip/IPv6Address$Companion;", "", "()V", "check", "", "ip", "", "chunks", "", "parse", "Lai/grazie/model/cloud/ip/IPv6Address;", "parseOrNull", "ipAddress", "model-cloud"})
    @SourceDebugExtension(value={"SMAP\nIPv6Address.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IPv6Address.kt\nai/grazie/model/cloud/ip/IPv6Address$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1#2:82\n1726#3,3:83\n1360#3:86\n1446#3,5:87\n1549#3:92\n1620#3,3:93\n*S KotlinDebug\n*F\n+ 1 IPv6Address.kt\nai/grazie/model/cloud/ip/IPv6Address$Companion\n*L\n33#1:83,3\n44#1:86\n44#1:87,5\n46#1:92\n46#1:93,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> chunks(String ip) {
            String[] stringArray = new String[]{":"};
            List split = StringsKt.split$default((CharSequence)ip, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            int zerosIndex = split.indexOf("");
            int zerosCount = 8 - split.size() + 1;
            ArrayList<String> result = new ArrayList<String>();
            int n = split.size();
            for (int i = 0; i < n; ++i) {
                if (i == zerosIndex) {
                    ArrayList<String> arrayList = result;
                    ArrayList<String> arrayList2 = new ArrayList<String>(zerosCount);
                    int n2 = 0;
                    while (n2 < zerosCount) {
                        int n3;
                        int n4 = n3 = n2++;
                        ArrayList<String> arrayList3 = arrayList2;
                        boolean bl = false;
                        arrayList3.add("0000");
                    }
                    arrayList.addAll((Collection)arrayList2);
                    continue;
                }
                result.add(StringsKt.padStart((String)((String)split.get(i)), (int)4, (char)'0'));
            }
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean check(@NotNull String ip) {
            boolean bl;
            String it;
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            if (StringsKt.contains$default((CharSequence)ip, (CharSequence)":::", (boolean)false, (int)2, null)) {
                return false;
            }
            String[] stringArray = new String[]{"::"};
            if (StringsKt.split$default((CharSequence)ip, (String[])stringArray, (boolean)false, (int)0, (int)6, null).size() - 1 > 1) {
                return false;
            }
            List<String> parts = this.chunks(ip);
            if (parts.size() != 8) return false;
            Iterable $this$all$iv = parts;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (String)element$iv;
                    boolean bl3 = false;
                    if (it.length() > 4) return false;
                    boolean bl4 = true;
                    if (bl4) continue;
                    return false;
                }
                bl2 = true;
            }
            if (!bl2) return false;
            $this$all$iv = parts;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                Object element$iv;
                if (!iterator.hasNext()) return true;
                element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl5 = false;
                IntRange intRange = new IntRange(0, 65535);
                Integer n = StringsKt.toIntOrNull((String)it, (int)16);
                if (n == null) return false;
                if (!intRange.contains(n.intValue())) return false;
                bl = true;
            } while (bl);
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final IPv6Address parseOrNull(@NotNull String ipAddress) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable list$iv$iv;
            String it;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
            String ip = ipAddress;
            if (StringsKt.startsWith$default((String)ip, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)ip, (String)"]", (boolean)false, (int)2, null)) {
                String string = ip.substring(1, ip.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                ip = string;
            }
            if (Intrinsics.areEqual((Object)ip, (Object)"::1") || Intrinsics.areEqual((Object)ip, (Object)"localhost")) {
                return this.parse("0:0:0:0:0:0:0:1");
            }
            if (!this.check(ip)) {
                return null;
            }
            List<String> parts = this.chunks(ip);
            Iterable $this$flatMap$iv = parts;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                list$iv$iv = StringsKt.toList((CharSequence)it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)2);
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(UStringsKt.toUByte((String)CollectionsKt.joinToString$default((Iterable)((Iterable)((Object)it)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (int)16));
            }
            byte[] bytes = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
            return new IPv6Address(bytes);
        }

        @NotNull
        public final IPv6Address parse(@NotNull String ip) {
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            IPv6Address iPv6Address = this.parseOrNull(ip);
            if (iPv6Address == null) {
                throw new IllegalStateException(("Invalid IPv6 address: " + ip).toString());
            }
            return iPv6Address;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

