/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.model.cloud.exceptions;

import ai.grazie.model.cloud.HeaderCollection;
import ai.grazie.model.cloud.HeaderCollectionKt;
import ai.grazie.model.cloud.exceptions.HTTPStatusExceptionKt;
import ai.grazie.utils.mpp.time.Duration;
import ai.grazie.utils.mpp.time.Timestamp;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0016\b\u0017\u0018\u0000 \u001b2\u00060\u0001j\u0002`\u0002:\u0014\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+B3\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\nB+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006,"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "status", "", "description", "", "e", "", "traceId", "(ILjava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(ILjava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "getDescription", "()Ljava/lang/String;", "getHeaders", "()Lai/grazie/model/cloud/HeaderCollection;", "getStatus", "()I", "getTraceId", "isClientError", "", "isServerError", "AccessProhibited", "BadRequest", "ClosedRequest", "Companion", "Conflict", "ContentTooLarge", "DetachedQuotaUsage", "Forbidden", "InternalServerError", "LengthRequired", "NotFound", "OutOfApplicationQuota", "OutOfQuota", "OutOfStorage", "PreconditionFailed", "RequestTimeout", "TooManyRequests", "Unauthorized", "UnavailableForLegalReasons", "UnprocessableContent", "model-cloud"})
public class HTTPStatusException
extends RuntimeException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int status;
    @Nullable
    private final String description;
    @NotNull
    private final HeaderCollection headers;
    @Nullable
    private final String traceId;

    public HTTPStatusException(int status, @Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        super(description, e);
        this.status = status;
        this.description = description;
        this.headers = headers;
        Object[] objectArray = this.headers.get("Grazie-Trace-Id");
        this.traceId = objectArray != null ? (String)ArraysKt.singleOrNull((Object[])objectArray) : null;
    }

    public /* synthetic */ HTTPStatusException(int n, String string, Throwable throwable, HeaderCollection headerCollection, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        this(n, string, throwable, headerCollection);
    }

    public final int getStatus() {
        return this.status;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final HeaderCollection getHeaders() {
        return this.headers;
    }

    @Deprecated(message="Do not add traceId manually")
    public HTTPStatusException(int status, @Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
        this(status, description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
    }

    public /* synthetic */ HTTPStatusException(int n, String string, Throwable throwable, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        this(n, string, throwable, string2);
    }

    public final boolean isServerError() {
        return this.status >= 500;
    }

    public final boolean isClientError() {
        int n = this.status;
        return 400 <= n ? n < 500 : false;
    }

    @Nullable
    public final String getTraceId() {
        return this.traceId;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$AccessProhibited;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "status", "", "description", "", "e", "", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(ILjava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "Companion", "model-cloud"})
    public static abstract class AccessProhibited
    extends HTTPStatusException {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public AccessProhibited(int status, @Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            super(status, description, e, headers);
        }

        public /* synthetic */ AccessProhibited(int n, String string, Throwable throwable, HeaderCollection headerCollection, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string = null;
            }
            if ((n2 & 4) != 0) {
                throwable = null;
            }
            this(n, string, throwable, headerCollection);
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$AccessProhibited$Companion;", "", "()V", "model-cloud"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$BadRequest;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class BadRequest
    extends HTTPStatusException {
        public BadRequest(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Bad Request";
            }
            super(400, string, e, headers);
        }

        public /* synthetic */ BadRequest(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public BadRequest(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ BadRequest(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$ClosedRequest;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class ClosedRequest
    extends HTTPStatusException {
        public ClosedRequest(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Closed request";
            }
            super(499, string, e, headers);
        }

        public /* synthetic */ ClosedRequest(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public ClosedRequest(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ ClosedRequest(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\nH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J4\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\nH\u0007JN\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00120\u00112\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\nH\u0007\u00a8\u0006\u0013"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$Companion;", "", "()V", "from", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "code", "", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "description", "", "e", "", "traceId", "getRetryAfter", "Lai/grazie/utils/mpp/time/Duration;", "of", "", "", "model-cloud"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="in favor of from method", replaceWith=@ReplaceWith(expression="from(code, headers, description, e)", imports={}))
        @NotNull
        public final HTTPStatusException of(int code, @Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            return this.of(code, MapsKt.emptyMap(), description, e, traceId);
        }

        public static /* synthetic */ HTTPStatusException of$default(Companion companion, int n, String string, Throwable throwable, String string2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                string = null;
            }
            if ((n2 & 4) != 0) {
                throwable = null;
            }
            if ((n2 & 8) != 0) {
                string2 = null;
            }
            return companion.of(n, string, throwable, string2);
        }

        @Deprecated(message="broken contract method, will be removed", replaceWith=@ReplaceWith(expression="from(code, headers, description, e)", imports={}))
        @NotNull
        public final HTTPStatusException of(int code, @NotNull Map<String, ? extends List<String>> headers, @Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            HeaderCollection headersCollection = HeaderCollectionKt.of(HeaderCollection.Companion, headers);
            return switch (code) {
                case 400 -> new BadRequest(description, e, headersCollection);
                case 401 -> new Unauthorized(description, e, headersCollection);
                case 403 -> new Forbidden(description, e, headersCollection);
                case 404 -> new NotFound(description, e, headersCollection);
                case 409 -> new Conflict(description, e, headersCollection);
                case 411 -> new LengthRequired(description, e, headersCollection);
                case 412 -> new PreconditionFailed(description, e, headersCollection);
                case 413 -> new ContentTooLarge(description, e, headersCollection);
                case 422 -> new UnprocessableContent(description, e, headersCollection);
                case 429 -> new TooManyRequests(description, e, headersCollection);
                case 451 -> new UnavailableForLegalReasons(description, e, headersCollection);
                case 477 -> new OutOfQuota(description, e, headersCollection);
                case 478 -> new OutOfApplicationQuota(description, e, headersCollection);
                case 480 -> new OutOfStorage(description, e, headersCollection);
                case 493 -> new DetachedQuotaUsage(description, e, headersCollection);
                case 499 -> new ClosedRequest(description, e, headersCollection);
                case 500 -> new InternalServerError(description, e, headersCollection);
                default -> new HTTPStatusException(code, description, e, headersCollection);
            };
        }

        public static /* synthetic */ HTTPStatusException of$default(Companion companion, int n, Map map, String string, Throwable throwable, String string2, int n2, Object object) {
            if ((n2 & 4) != 0) {
                string = null;
            }
            if ((n2 & 8) != 0) {
                throwable = null;
            }
            if ((n2 & 0x10) != 0) {
                string2 = null;
            }
            return companion.of(n, map, string, throwable, string2);
        }

        @Deprecated(message="Remove traceId parameter", replaceWith=@ReplaceWith(expression="from(code, headers, description, e)", imports={}))
        @NotNull
        public final HTTPStatusException from(int code, @NotNull HeaderCollection headers, @Nullable String description, @Nullable Throwable e, @NotNull String traceId) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)traceId, (String)"traceId");
            return this.from(code, headers, description, e);
        }

        public static /* synthetic */ HTTPStatusException from$default(Companion companion, int n, HeaderCollection headerCollection, String string, Throwable throwable, String string2, int n2, Object object) {
            if ((n2 & 4) != 0) {
                string = null;
            }
            if ((n2 & 8) != 0) {
                throwable = null;
            }
            return companion.from(n, headerCollection, string, throwable, string2);
        }

        @NotNull
        public final HTTPStatusException from(int code, @NotNull HeaderCollection headers, @Nullable String description, @Nullable Throwable e) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            return switch (code) {
                case 400 -> new BadRequest(description, e, headers);
                case 401 -> new Unauthorized(description, e, headers);
                case 403 -> new Forbidden(description, e, headers);
                case 404 -> new NotFound(description, e, headers);
                case 409 -> new Conflict(description, e, headers);
                case 411 -> new LengthRequired(description, e, headers);
                case 412 -> new PreconditionFailed(description, e, headers);
                case 413 -> new ContentTooLarge(description, e, headers);
                case 422 -> new UnprocessableContent(description, e, headers);
                case 429 -> new TooManyRequests(description, e, headers);
                case 451 -> new UnavailableForLegalReasons(description, e, headers);
                case 477 -> new OutOfQuota(description, e, headers);
                case 478 -> new OutOfApplicationQuota(description, e, headers);
                case 480 -> new OutOfStorage(description, e, headers);
                case 493 -> new DetachedQuotaUsage(description, e, headers);
                case 499 -> new ClosedRequest(description, e, headers);
                case 500 -> new InternalServerError(description, e, headers);
                default -> new HTTPStatusException(code, description, e, headers);
            };
        }

        public static /* synthetic */ HTTPStatusException from$default(Companion companion, int n, HeaderCollection headerCollection, String string, Throwable throwable, int n2, Object object) {
            if ((n2 & 4) != 0) {
                string = null;
            }
            if ((n2 & 8) != 0) {
                throwable = null;
            }
            return companion.from(n, headerCollection, string, throwable);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final Duration getRetryAfter(HeaderCollection headers) {
            block3: {
                Object object = headers.get("Retry-After");
                if (object != null && (object = (String)ArraysKt.singleOrNull((Object[])object)) != null) {
                    Object object2 = object;
                    boolean bl = false;
                    try {
                        Timestamp date = Timestamp.Companion.ofHttpDate((String)object2);
                        return date.between(Timestamp.Companion.now());
                    }
                    catch (Exception ignored) {
                        Integer n = StringsKt.toIntOrNull((String)object2);
                        if (n == null) break block3;
                        int retryAfterSeconds = ((Number)n).intValue();
                        return Duration.Companion.seconds(retryAfterSeconds);
                    }
                }
            }
            Object[] objectArray = headers.get("Retry-After-Ms");
            Object object = objectArray;
            if (objectArray == null) return null;
            String string = (String)ArraysKt.singleOrNull((Object[])object);
            object = string;
            if (string == null) return null;
            Object object3 = object;
            boolean bl = false;
            Integer n = StringsKt.toIntOrNull((String)object3);
            if (n == null) return null;
            int retryAfterMs = ((Number)n).intValue();
            return Duration.Companion.millis(retryAfterMs);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$Conflict;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class Conflict
    extends HTTPStatusException {
        public Conflict(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Conflict";
            }
            super(409, string, e, headers);
        }

        public /* synthetic */ Conflict(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public Conflict(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ Conflict(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$ContentTooLarge;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class ContentTooLarge
    extends HTTPStatusException {
        public ContentTooLarge(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Content Too Large";
            }
            super(413, string, e, headers);
        }

        public /* synthetic */ ContentTooLarge(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public ContentTooLarge(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ ContentTooLarge(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$DetachedQuotaUsage;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class DetachedQuotaUsage
    extends HTTPStatusException {
        public DetachedQuotaUsage(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Forbidden Quota Usage";
            }
            super(493, string, e, headers);
        }

        public /* synthetic */ DetachedQuotaUsage(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public DetachedQuotaUsage(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ DetachedQuotaUsage(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$Forbidden;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException$AccessProhibited;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class Forbidden
    extends AccessProhibited {
        public Forbidden(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Forbidden";
            }
            super(403, string, e, headers);
        }

        public /* synthetic */ Forbidden(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public Forbidden(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ Forbidden(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$InternalServerError;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class InternalServerError
    extends HTTPStatusException {
        public InternalServerError(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Internal Server Error";
            }
            super(500, string, e, headers);
        }

        public /* synthetic */ InternalServerError(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public InternalServerError(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ InternalServerError(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$LengthRequired;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class LengthRequired
    extends HTTPStatusException {
        public LengthRequired(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Length Required";
            }
            super(411, string, e, headers);
        }

        public /* synthetic */ LengthRequired(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public LengthRequired(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ LengthRequired(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$NotFound;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class NotFound
    extends HTTPStatusException {
        public NotFound(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Not Found";
            }
            super(404, string, e, headers);
        }

        public /* synthetic */ NotFound(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public NotFound(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ NotFound(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$OutOfApplicationQuota;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class OutOfApplicationQuota
    extends HTTPStatusException {
        public OutOfApplicationQuota(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Out of Application Quota";
            }
            super(478, string, e, headers);
        }

        public /* synthetic */ OutOfApplicationQuota(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public OutOfApplicationQuota(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ OutOfApplicationQuota(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$OutOfQuota;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class OutOfQuota
    extends HTTPStatusException {
        public OutOfQuota(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Out of quota";
            }
            super(477, string, e, headers);
        }

        public /* synthetic */ OutOfQuota(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public OutOfQuota(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ OutOfQuota(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$OutOfStorage;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class OutOfStorage
    extends HTTPStatusException {
        public OutOfStorage(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Out of storage";
            }
            super(480, string, e, headers);
        }

        public /* synthetic */ OutOfStorage(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public OutOfStorage(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ OutOfStorage(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$PreconditionFailed;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class PreconditionFailed
    extends HTTPStatusException {
        public PreconditionFailed(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Precondition Failed";
            }
            super(412, string, e, headers);
        }

        public /* synthetic */ PreconditionFailed(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public PreconditionFailed(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ PreconditionFailed(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$RequestTimeout;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class RequestTimeout
    extends HTTPStatusException {
        public RequestTimeout(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Request Timeout";
            }
            super(408, string, e, headers);
        }

        public /* synthetic */ RequestTimeout(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public RequestTimeout(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ RequestTimeout(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B7\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tB%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$TooManyRequests;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "retryAfter", "Lai/grazie/utils/mpp/time/Duration;", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/utils/mpp/time/Duration;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "getRetryAfter", "()Lai/grazie/utils/mpp/time/Duration;", "model-cloud"})
    @SourceDebugExtension(value={"SMAP\nHTTPStatusException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTTPStatusException.kt\nai/grazie/model/cloud/exceptions/HTTPStatusException$TooManyRequests\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,282:1\n1#2:283\n*E\n"})
    public static final class TooManyRequests
    extends HTTPStatusException {
        @Nullable
        private final Duration retryAfter;

        /*
         * WARNING - void declaration
         */
        public TooManyRequests(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            void it;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Too Many Requests";
            }
            super(429, string, e, headers);
            HeaderCollection headerCollection = headers;
            TooManyRequests tooManyRequests = this;
            boolean bl = false;
            tooManyRequests.retryAfter = Companion.getRetryAfter((HeaderCollection)it);
        }

        public /* synthetic */ TooManyRequests(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public TooManyRequests(@Nullable String description, @Nullable Throwable e, @Nullable Duration retryAfter, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceIdAndRetryAfter(HeaderCollection.Companion, retryAfter, traceId));
        }

        public /* synthetic */ TooManyRequests(String string, Throwable throwable, Duration duration, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                duration = null;
            }
            if ((n & 8) != 0) {
                string2 = null;
            }
            this(string, throwable, duration, string2);
        }

        @Nullable
        public final Duration getRetryAfter() {
            return this.retryAfter;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$Unauthorized;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException$AccessProhibited;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class Unauthorized
    extends AccessProhibited {
        public Unauthorized(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Unauthorized";
            }
            super(401, string, e, headers);
        }

        public /* synthetic */ Unauthorized(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public Unauthorized(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ Unauthorized(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$UnavailableForLegalReasons;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class UnavailableForLegalReasons
    extends HTTPStatusException {
        public UnavailableForLegalReasons(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Unavailable For Legal Reasons";
            }
            super(451, string, e, headers);
        }

        public /* synthetic */ UnavailableForLegalReasons(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public UnavailableForLegalReasons(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ UnavailableForLegalReasons(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/grazie/model/cloud/exceptions/HTTPStatusException$UnprocessableContent;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "description", "", "e", "", "traceId", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/lang/String;)V", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "(Ljava/lang/String;Ljava/lang/Throwable;Lai/grazie/model/cloud/HeaderCollection;)V", "model-cloud"})
    public static final class UnprocessableContent
    extends HTTPStatusException {
        public UnprocessableContent(@Nullable String description, @Nullable Throwable e, @NotNull HeaderCollection headers) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            String string = description;
            if (string == null) {
                string = "Unprocessable Content";
            }
            super(422, string, e, headers);
        }

        public /* synthetic */ UnprocessableContent(String string, Throwable throwable, HeaderCollection headerCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable, headerCollection);
        }

        @Deprecated(message="Do not add traceId manually")
        public UnprocessableContent(@Nullable String description, @Nullable Throwable e, @Nullable String traceId) {
            this(description, e, HTTPStatusExceptionKt.access$fromTraceId(HeaderCollection.Companion, traceId));
        }

        public /* synthetic */ UnprocessableContent(String string, Throwable throwable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, throwable, string2);
        }
    }
}

