/*
 * Decompiled with CFR 0.152.
 */
package fleet.common;

import fleet.api.FileAddress;
import fleet.api.IOError;
import fleet.api.OpenMode;
import fleet.api.RpcResult;
import fleet.api.document.DocumentFileId;
import fleet.common.DocumentService;
import fleet.util.UID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=3, xi=48)
public final class DocumentServiceClientStub
implements DocumentService {
    @NotNull
    private Function3<String, Object[], Continuation<Object>, Object> invocationHandler;

    public DocumentServiceClientStub(@NotNull Function3<? super String, ? super Object[], ? super Continuation<Object>, ? extends Object> invocationHandler) {
        Intrinsics.checkNotNullParameter(invocationHandler, (String)"invocationHandler");
        this.invocationHandler = invocationHandler;
    }

    @NotNull
    public final Function3<String, Object[], Continuation<Object>, Object> getInvocationHandler() {
        return this.invocationHandler;
    }

    @Nullable
    public final Object openTextFile(@NotNull FileAddress fileAddress, @NotNull Continuation<? super RpcResult<UID, ? extends IOError>> $completion) {
        Object[] objectArray = new Object[]{fileAddress};
        return this.invocationHandler.invoke((Object)"openTextFile", (Object)objectArray, $completion);
    }

    @Nullable
    public final Object openBinaryFile(@NotNull FileAddress fileAddress, @NotNull Continuation<? super RpcResult<UID, ? extends IOError>> $completion) {
        Object[] objectArray = new Object[]{fileAddress};
        return this.invocationHandler.invoke((Object)"openBinaryFile", (Object)objectArray, $completion);
    }

    @Nullable
    public final Object reload(@NotNull DocumentFileId documentId, @NotNull Continuation<? super IOError> $completion) {
        Object[] objectArray = new Object[]{documentId};
        return this.invocationHandler.invoke((Object)"reload", (Object)objectArray, $completion);
    }

    @Nullable
    public final Object move(@NotNull DocumentFileId documentId, @NotNull FileAddress newAddress, boolean force, @NotNull Continuation<? super IOError> $completion) {
        Object[] objectArray = new Object[]{documentId, newAddress, Boxing.boxBoolean((boolean)force)};
        return this.invocationHandler.invoke((Object)"move", (Object)objectArray, $completion);
    }

    @Nullable
    public final Object save(@NotNull DocumentFileId documentId, @NotNull OpenMode mode, boolean ignoreConflicts, @NotNull Continuation<? super IOError> $completion) {
        Object[] objectArray = new Object[]{documentId, mode, Boxing.boxBoolean((boolean)ignoreConflicts)};
        return this.invocationHandler.invoke((Object)"save", (Object)objectArray, $completion);
    }

    @Nullable
    public final Object autoSaveAll(@NotNull Continuation<? super Unit> $completion) {
        return this.invocationHandler.invoke((Object)"autoSaveAll", (Object)new Object[0], $completion);
    }
}

