/*
 * Decompiled with CFR 0.152.
 */
package fleet.rpc.relay.end2end;

import fleet.rpc.relay.jwt.PrivateKey;
import fleet.util.UID;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lfleet/rpc/relay/end2end/Certificate;", "", "certificate", "Ljava/security/cert/X509Certificate;", "keyPassword", "", "keyStore", "Ljava/security/KeyStore;", "<init>", "(Ljava/security/cert/X509Certificate;[CLjava/security/KeyStore;)V", "getCertificate", "()Ljava/security/cert/X509Certificate;", "getKeyPassword", "()[C", "getKeyStore", "()Ljava/security/KeyStore;", "Companion", "fleet.rpc.relay"})
public final class Certificate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final X509Certificate certificate;
    @NotNull
    private final char[] keyPassword;
    @NotNull
    private final KeyStore keyStore;

    public Certificate(@NotNull X509Certificate certificate, @NotNull char[] keyPassword, @NotNull KeyStore keyStore) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        this.certificate = certificate;
        this.keyPassword = keyPassword;
        this.keyStore = keyStore;
    }

    @NotNull
    public final X509Certificate getCertificate() {
        return this.certificate;
    }

    @NotNull
    public final char[] getKeyPassword() {
        return this.keyPassword;
    }

    @NotNull
    public final KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lfleet/rpc/relay/end2end/Certificate$Companion;", "", "<init>", "()V", "create", "Lfleet/rpc/relay/end2end/Certificate;", "certificate", "Ljava/security/cert/X509Certificate;", "private", "Lfleet/rpc/relay/jwt/PrivateKey;", "fleet.rpc.relay"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Certificate create(@NotNull X509Certificate certificate, @NotNull PrivateKey privateKey) {
            KeyStore keyStore;
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"private");
            X509Certificate[] x509CertificateArray = new X509Certificate[]{certificate};
            X509Certificate[] chain = x509CertificateArray;
            char[] cArray = UID.Companion.random().toString().toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] keyPassword = cArray;
            KeyStore $this$create_u24lambda_u240 = keyStore = KeyStore.getInstance("jks");
            boolean bl = false;
            $this$create_u24lambda_u240.load(null, null);
            $this$create_u24lambda_u240.setKeyEntry("KEY_ALIAS", privateKey.key$fleet_rpc_relay(), keyPassword, chain);
            KeyStore keystore = keyStore;
            Intrinsics.checkNotNull((Object)keystore);
            return new Certificate(certificate, keyPassword, keystore);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

