/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.python;

import fleet.com.intellij.lang.ASTNode;
import fleet.com.intellij.lang.ParserDefinition;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiParser;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.openapi.project.Project;
import fleet.com.intellij.openapi.util.Key;
import fleet.com.intellij.psi.FileViewProvider;
import fleet.com.intellij.psi.PsiElement;
import fleet.com.intellij.psi.PsiFile;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.IFileElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.python.PyTokenTypes;
import fleet.com.jetbrains.python.lexer.PythonIndentingLexer;
import fleet.com.jetbrains.python.parsing.PyParser;
import fleet.com.jetbrains.python.psi.LanguageLevel;
import fleet.com.jetbrains.python.psi.PyFileElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonParserDefinition
implements ParserDefinition {
    private static final Key<LanguageLevel> ourLanguageLevelKey = Key.create((String)"python.language.level.key");
    @NotNull
    private LanguageLevel myLanguageLevel = LanguageLevel.getDefault();

    @NotNull
    public Lexer createLexer(Project project) {
        return new PythonIndentingLexer();
    }

    public IFileElementType getFileNodeType() {
        return PyFileElementType.INSTANCE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LINE_BREAK, PyTokenTypes.SPACE, PyTokenTypes.TAB, PyTokenTypes.FORMFEED});
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.END_OF_LINE_COMMENT});
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.orSet((TokenSet[])new TokenSet[]{PyTokenTypes.STRING_NODES, PyTokenTypes.FSTRING_TOKENS});
    }

    @NotNull
    public PsiParser createParser(Project project) {
        PyParser pyParser = new PyParser();
        pyParser.setLanguageLevel(this.myLanguageLevel);
        return pyParser;
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        throw new IllegalStateException();
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        throw new IllegalStateException();
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    public void setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        this.myLanguageLevel = languageLevel;
    }

    @Nullable
    public static LanguageLevel getLanguageLevel(@NotNull PsiBuilder psiBuilder) {
        return (LanguageLevel)((Object)psiBuilder.getUserData(ourLanguageLevelKey));
    }

    public static void setLanguageLevel(@NotNull LanguageLevel languageLevel, @NotNull PsiBuilder psiBuilder) {
        psiBuilder.putUserData(ourLanguageLevelKey, (Object)languageLevel);
    }
}

