/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.intellij.workspace;

import fleet.api.ProtocolPath;
import fleet.plugins.intellij.protocol.IntellijExitReason;
import fleet.plugins.intellij.workspace.BackendParametersKt;
import fleet.plugins.smartMode.protocol.BackendPluginReference;
import fleet.plugins.smartMode.protocol.BackendRequirements;
import fleet.preferences.FleetFromSourcesPaths;
import fleet.preferences.FleetPropertiesKt;
import fleet.reporting.shared.config.TracingConfigProperties;
import fleet.util.os.Os;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0007H\u0002\u001a'\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a0\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00072\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0015H\u0002\u001a0\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00072\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0001*\u00020\u0018H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u001a*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0015H\u0002\u001a\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010\u001c\u001a\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001b2\u0006\u0010\u001e\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001f\u001a#\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001b2\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010!\u001a\u0016\u0010\"\u001a\u00020\n2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010$H\u0002\u001a\u0010\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0001H\u0002\u001a\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00010$2\u0006\u0010*\u001a\u00020\nH\u0002\u001a\u0014\u0010+\u001a\u00020,*\u00020,2\u0006\u0010-\u001a\u00020\nH\u0002\u001a\u0018\u0010.\u001a\u00020/2\u0006\u0010-\u001a\u00020\n2\u0006\u00100\u001a\u00020\u0001H\u0002\u001a\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00010$H\u0002\u001a\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u00010$H\u0002\"\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"writePropertiesFile", "", "ideaSystemPath", "Lfleet/api/ProtocolPath;", "ideaConfigPath", "ideaLogPath", "additionalOptions", "", "writeVmoptionsFile", "binary", "Ljava/nio/file/Path;", "xmxMb", "", "debugPort", "(Ljava/nio/file/Path;ILjava/lang/Integer;)Ljava/lang/String;", "calcVmOptionsFileName", "launcherName", "getUpdatedAdditionalOptions", "backendRequirements", "Lfleet/plugins/smartMode/protocol/BackendRequirements;", "deriveBackendTelemetryOptions", "", "backendPluginsOption", "toStringId", "Lfleet/plugins/smartMode/protocol/BackendPluginReference$Marketplace;", "withRestartWithExitCode", "", "", "()[Ljava/lang/String;", "mountVolume", "path", "(Ljava/lang/String;)[Ljava/lang/String;", "targetPath", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "writeClassPathToFile", "classPath", "", "locateJDK", "javaExe", "docker", "", "findToolsJar", "jdkHome", "redirectStdErrOut", "Ljava/lang/ProcessBuilder;", "logsPath", "createLogFile", "Ljava/io/File;", "name", "getAddOpensOptions", "getModulesExclusions", "fleet.plugins.intellij.workspace"})
@SourceDebugExtension(value={"SMAP\nBackendParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendParameters.kt\nfleet/plugins/intellij/workspace/BackendParametersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,536:1\n808#2,11:537\n808#2,11:548\n774#2:559\n865#2:560\n2632#2,3:561\n866#2:564\n*S KotlinDebug\n*F\n+ 1 BackendParameters.kt\nfleet/plugins/intellij/workspace/BackendParametersKt\n*L\n449#1:537,11\n456#1:548,11\n516#1:559\n516#1:560\n517#1:561,3\n516#1:564\n*E\n"})
public final class BackendParametersKt {
    private static final boolean docker = Intrinsics.areEqual((Object)System.getProperty("fleet.docker.backend"), (Object)"true");

    private static final String writePropertiesFile(ProtocolPath ideaSystemPath, ProtocolPath ideaConfigPath, ProtocolPath ideaLogPath, Map<String, String> additionalOptions) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"idea.system.path", (Object)ideaSystemPath.joinToString()), TuplesKt.to((Object)"idea.config.path", (Object)ideaConfigPath.joinToString()), TuplesKt.to((Object)"idea.log.path", (Object)ideaLogPath.joinToString())};
        Map props = MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), additionalOptions);
        Path tempFile = Files.createTempFile("backend_properties", "", new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)tempFile);
        PathsKt.writeText((Path)tempFile, (CharSequence)CollectionsKt.joinToString$default((Iterable)props.entrySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)writePropertiesFile.1.INSTANCE, (int)30, null), (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
        tempFile.toFile().deleteOnExit();
        return ((Object)tempFile.toAbsolutePath()).toString();
    }

    private static final String writeVmoptionsFile(Path binary, int xmxMb, Integer debugPort) {
        Path distDir = binary.getParent().getParent();
        Path vmoptionsFile = distDir.resolve("bin").resolve(BackendParametersKt.calcVmOptionsFileName(PathsKt.getName((Path)binary)));
        Intrinsics.checkNotNull((Object)vmoptionsFile);
        Path path = vmoptionsFile;
        List<String> list = Files.readAllLines(path, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
        List vmOptions = CollectionsKt.toMutableList((Collection)list);
        vmOptions.removeIf(arg_0 -> BackendParametersKt.writeVmoptionsFile$lambda$0(writeVmoptionsFile.1.INSTANCE, arg_0));
        vmOptions.add("-Xmx" + xmxMb + "m");
        if (xmxMb < 1000) {
            vmOptions.add("-XX:MaxDirectMemorySize=850m");
        }
        if (Boolean.parseBoolean(System.getProperty("fleet.backend.debug", "false"))) {
            String suspend = Intrinsics.areEqual((Object)System.getProperty("fleet.backend.debug.suspend"), (Object)"y") ? "y" : "n";
            String address = debugPort != null && debugPort > 0 ? ",address=*:" + debugPort : "";
            vmOptions.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspend + address);
        }
        Path tempFile = Files.createTempFile("backend_vmoptions", "", new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)tempFile);
        Path path2 = tempFile;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)Files.write(path2, (Iterable<? extends CharSequence>)vmOptions, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
        tempFile.toFile().deleteOnExit();
        return ((Object)tempFile.toAbsolutePath()).toString();
    }

    private static final String calcVmOptionsFileName(String launcherName) {
        Object fileName = StringsKt.substringBeforeLast$default((String)StringsKt.substringBefore$default((String)launcherName, (String)".", null, (int)2, null), (String)"64", null, (int)2, null);
        if (!Os.INSTANCE.isMac()) {
            fileName = (String)fileName + "64";
        }
        if (Os.INSTANCE.isWindows()) {
            fileName = (String)fileName + ".exe";
        }
        fileName = (String)fileName + ".vmoptions";
        return fileName;
    }

    private static final Map<String, String> getUpdatedAdditionalOptions(Map<String, String> additionalOptions, BackendRequirements backendRequirements) {
        return MapsKt.plus((Map)MapsKt.plus(additionalOptions, BackendParametersKt.deriveBackendTelemetryOptions()), BackendParametersKt.backendPluginsOption(additionalOptions, backendRequirements));
    }

    private static final Map<String, String> deriveBackendTelemetryOptions() {
        Map telemetryOptions;
        block1: {
            telemetryOptions = new LinkedHashMap();
            String string = TracingConfigProperties.INSTANCE.getOtelHttpEndpoint();
            if (string != null) {
                String it = string;
                boolean bl = false;
                telemetryOptions.put("idea.diagnostic.opentelemetry.otlp", it);
            }
            String string2 = TracingConfigProperties.INSTANCE.getOtelTracesDir();
            if (string2 == null) break block1;
            String filePath = string2;
            boolean bl = false;
            Files.createDirectories(Path.of(filePath, new String[0]), new FileAttribute[0]);
            Map map2 = telemetryOptions;
            String string3 = "idea.diagnostic.opentelemetry.file";
            Path path = Path.of(filePath, new String[0]).resolve("fleet_backend.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            String string4 = ((Object)path.toAbsolutePath()).toString();
            map2.put(string3, string4);
        }
        return telemetryOptions;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, String> backendPluginsOption(Map<String, String> additionalOptions, BackendRequirements backendRequirements) {
        Iterable $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Map map2;
        Set pluginReferences = backendRequirements.getPluginReferences();
        if (pluginReferences.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map $this$backendPluginsOption_u24lambda_u243 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        Iterable iterable = pluginReferences;
        boolean $i$f$filterIsInstance = false;
        void var8_10 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BackendPluginReference.Marketplace)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String plugins2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, (Function1)backendPluginsOption.1.plugins.1.INSTANCE, (int)30, null);
        $this$backendPluginsOption_u24lambda_u243.put("fleet.backend.plugins", plugins2);
        boolean ignoreDisabledPlugins = Boolean.parseBoolean(additionalOptions.get("idea.ignore.disabled.plugins"));
        if (!ignoreDisabledPlugins) {
            void $this$filterIsInstanceTo$iv$iv2;
            void $this$filterIsInstance$iv2;
            $this$filterIsInstanceTo$iv$iv = pluginReferences;
            boolean $i$f$filterIsInstance2 = false;
            void $i$f$filterIsInstanceTo2 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo3 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof BackendPluginReference.Marketplace)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            String pluginsToLoadOnStartup2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)",", null, null, (int)0, null, (Function1)backendPluginsOption.1.pluginsToLoadOnStartup.1.INSTANCE, (int)30, null);
            $this$backendPluginsOption_u24lambda_u243.put("idea.load.plugins.id", pluginsToLoadOnStartup2);
        }
        return MapsKt.build((Map)map2);
    }

    private static final String toStringId(BackendPluginReference.Marketplace $this$toStringId) {
        String pluginId = $this$toStringId.getId().getId();
        CharSequence charSequence = $this$toStringId.getVersion();
        return charSequence == null || charSequence.length() == 0 ? pluginId : ((charSequence = (CharSequence)$this$toStringId.getChannel()) == null || charSequence.length() == 0 ? pluginId + ":" + $this$toStringId.getVersion() : pluginId + ":" + $this$toStringId.getVersion() + "@" + $this$toStringId.getChannel());
    }

    private static final void withRestartWithExitCode(Map<String, String> $this$withRestartWithExitCode) {
        $this$withRestartWithExitCode.put("IDEA_RESTART_VIA_EXIT_CODE", String.valueOf(IntellijExitReason.RestartRequested.getExitCode()));
    }

    private static final String[] withRestartWithExitCode() {
        String[] stringArray = new String[]{"-e", "IDEA_RESTART_VIA_EXIT_CODE=" + IntellijExitReason.RestartRequested.getExitCode()};
        return stringArray;
    }

    private static final String[] mountVolume(String path) {
        return BackendParametersKt.mountVolume(path, path);
    }

    private static final String[] mountVolume(String path, String targetPath) {
        String[] stringArray = new String[]{"-v", path + ":" + targetPath};
        return stringArray;
    }

    private static final Path writeClassPathToFile(List<String> classPath) {
        Path tmpFile = Files.createTempFile("backend_classpath", "", new FileAttribute[0]).toRealPath(new LinkOption[0]);
        Iterable iterable = classPath;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        String classPathString2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)writeClassPathToFile.classPathString.1.INSTANCE, (int)30, null);
        Files.write(tmpFile, (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)("-classpath " + classPathString2)), Charset.forName("UTF-8"), new OpenOption[0]);
        tmpFile.toFile().deleteOnExit();
        Intrinsics.checkNotNull((Object)tmpFile);
        return tmpFile;
    }

    private static final Path locateJDK(String javaExe) {
        Path javaHome;
        String string = FleetPropertiesKt.fleetProperty$default((String)"fleet.backend.jdk", null, (int)2, null);
        if (string == null) {
            string = System.getProperty("java.home");
        }
        if (StringsKt.equals((String)((Object)(javaHome = Paths.get(string, new String[0])).getFileName()).toString(), (String)"jre", (boolean)true)) {
            Path jdkHome = javaHome.getParent();
            if (!jdkHome.resolve("bin").resolve(javaExe).toFile().exists()) {
                throw new Exception("JDK needed, but JRE was found at " + javaHome);
            }
            javaHome = jdkHome;
        }
        Path path = javaHome;
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    private static final List<String> findToolsJar(Path jdkHome) {
        return CollectionsKt.listOf((Object)((Object)jdkHome.resolve("lib").resolve("tools.jar").toAbsolutePath()).toString());
    }

    private static final ProcessBuilder redirectStdErrOut(ProcessBuilder $this$redirectStdErrOut, Path logsPath) {
        ProcessBuilder processBuilder = $this$redirectStdErrOut.redirectError(ProcessBuilder.Redirect.to(BackendParametersKt.createLogFile(logsPath, "stderr.txt"))).redirectOutput(ProcessBuilder.Redirect.to(BackendParametersKt.createLogFile(logsPath, "stdout.txt")));
        Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"redirectOutput(...)");
        return processBuilder;
    }

    private static final File createLogFile(Path logsPath, String name) {
        Path path = logsPath.resolve(name);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        File file = PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> getAddOpensOptions() {
        void $this$filterTo$iv$iv;
        List<String> exclusions = BackendParametersKt.getModulesExclusions();
        Path path = FleetFromSourcesPaths.INSTANCE.getIntellijProjectRoot().resolve("community/platform/platform-impl/resources/META-INF/OpenedPackages.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        List<String> list = Files.readAllLines(path2, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                String line = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = exclusions;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.contains$default((CharSequence)line, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<String> getModulesExclusions() {
        List list;
        List $this$getModulesExclusions_u24lambda_u246 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (!Os.INSTANCE.isWindows()) {
            $this$getModulesExclusions_u24lambda_u246.add("/sun.awt.windows");
        }
        if (!Os.INSTANCE.isMac()) {
            $this$getModulesExclusions_u24lambda_u246.add("/sun.lwawt");
            $this$getModulesExclusions_u24lambda_u246.add("/com.apple");
        }
        if (!Os.INSTANCE.isLinux()) {
            $this$getModulesExclusions_u24lambda_u246.add("/sun.awt.X11");
            $this$getModulesExclusions_u24lambda_u246.add("/com.sun.java.swing.plaf.gtk");
        }
        return CollectionsKt.build((List)list);
    }

    private static final boolean writeVmoptionsFile$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ProcessBuilder access$redirectStdErrOut(ProcessBuilder $receiver, Path logsPath) {
        return BackendParametersKt.redirectStdErrOut($receiver, logsPath);
    }

    public static final /* synthetic */ Map access$getUpdatedAdditionalOptions(Map additionalOptions, BackendRequirements backendRequirements) {
        return BackendParametersKt.getUpdatedAdditionalOptions(additionalOptions, backendRequirements);
    }

    public static final /* synthetic */ boolean access$getDocker$p() {
        return docker;
    }

    public static final /* synthetic */ Path access$locateJDK(String javaExe) {
        return BackendParametersKt.locateJDK(javaExe);
    }

    public static final /* synthetic */ List access$getAddOpensOptions() {
        return BackendParametersKt.getAddOpensOptions();
    }

    public static final /* synthetic */ List access$findToolsJar(Path jdkHome) {
        return BackendParametersKt.findToolsJar(jdkHome);
    }

    public static final /* synthetic */ Path access$writeClassPathToFile(List classPath) {
        return BackendParametersKt.writeClassPathToFile(classPath);
    }

    public static final /* synthetic */ String[] access$mountVolume(String path) {
        return BackendParametersKt.mountVolume(path);
    }

    public static final /* synthetic */ String[] access$mountVolume(String path, String targetPath) {
        return BackendParametersKt.mountVolume(path, targetPath);
    }

    public static final /* synthetic */ String[] access$withRestartWithExitCode() {
        return BackendParametersKt.withRestartWithExitCode();
    }

    public static final /* synthetic */ void access$withRestartWithExitCode(Map $receiver) {
        BackendParametersKt.withRestartWithExitCode($receiver);
    }

    public static final /* synthetic */ String access$writePropertiesFile(ProtocolPath ideaSystemPath, ProtocolPath ideaConfigPath, ProtocolPath ideaLogPath, Map additionalOptions) {
        return BackendParametersKt.writePropertiesFile(ideaSystemPath, ideaConfigPath, ideaLogPath, additionalOptions);
    }

    public static final /* synthetic */ String access$writeVmoptionsFile(Path binary, int xmxMb, Integer debugPort) {
        return BackendParametersKt.writeVmoptionsFile(binary, xmxMb, debugPort);
    }

    public static final /* synthetic */ String access$toStringId(BackendPluginReference.Marketplace $receiver) {
        return BackendParametersKt.toStringId($receiver);
    }
}

