/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.intellij.workspace;

import fleet.api.EnvironmentOpts;
import fleet.api.HostId;
import fleet.api.ProtocolPath;
import fleet.api.lrp.LrpTaskArguments;
import fleet.api.lrp.Output;
import fleet.api.lrp.OutputStrategy;
import fleet.plugins.intellij.workspace.BackendParametersKt;
import fleet.plugins.intellij.workspace.IntellijBackendFlavour;
import fleet.util.UID;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u001e\u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020)J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0007H\u00c6\u0003J\t\u0010-\u001a\u00020\u0007H\u00c6\u0003J\t\u0010.\u001a\u00020\nH\u00c6\u0003J\t\u0010/\u001a\u00020\fH\u00c6\u0003J\t\u00100\u001a\u00020\fH\u00c6\u0003J!\u00101\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u00c6\u0003Jw\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2 \b\u0002\u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u00c6\u0001J\u0013\u00103\u001a\u00020%2\b\u00104\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00105\u001a\u000206H\u00d6\u0001J\t\u00107\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR)\u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00068"}, d2={"Lfleet/plugins/intellij/workspace/BackendParameters;", "", "program", "", "args", "", "workingDir", "Lfleet/api/ProtocolPath;", "ideaLogPath", "intellijBackendFlavour", "Lfleet/plugins/intellij/workspace/IntellijBackendFlavour;", "workspaceHostId", "Lfleet/api/HostId;", "backendHostId", "environmentAugmenter", "Lkotlin/Function1;", "", "", "<init>", "(Ljava/lang/String;Ljava/util/List;Lfleet/api/ProtocolPath;Lfleet/api/ProtocolPath;Lfleet/plugins/intellij/workspace/IntellijBackendFlavour;Lfleet/api/HostId;Lfleet/api/HostId;Lkotlin/jvm/functions/Function1;)V", "getProgram", "()Ljava/lang/String;", "getArgs", "()Ljava/util/List;", "getWorkingDir", "()Lfleet/api/ProtocolPath;", "getIdeaLogPath", "getIntellijBackendFlavour", "()Lfleet/plugins/intellij/workspace/IntellijBackendFlavour;", "getWorkspaceHostId", "()Lfleet/api/HostId;", "getBackendHostId", "getEnvironmentAugmenter", "()Lkotlin/jvm/functions/Function1;", "prepareForJavaProcess", "Ljava/lang/ProcessBuilder;", "redirectOutput", "", "prepareForLrpTask", "Lfleet/api/lrp/LrpTaskArguments;", "processId", "Lfleet/util/UID;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "fleet.plugins.intellij.workspace"})
@SourceDebugExtension(value={"SMAP\nBackendParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendParameters.kt\nfleet/plugins/intellij/workspace/BackendParameters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Helpers.kt\nfleet/util/HelpersKt\n*L\n1#1,536:1\n1#2:537\n13#3:538\n*S KotlinDebug\n*F\n+ 1 BackendParameters.kt\nfleet/plugins/intellij/workspace/BackendParameters\n*L\n65#1:538\n*E\n"})
public final class BackendParameters {
    @NotNull
    private final String program;
    @NotNull
    private final List<String> args;
    @NotNull
    private final ProtocolPath workingDir;
    @NotNull
    private final ProtocolPath ideaLogPath;
    @NotNull
    private final IntellijBackendFlavour intellijBackendFlavour;
    @NotNull
    private final HostId workspaceHostId;
    @NotNull
    private final HostId backendHostId;
    @NotNull
    private final Function1<Map<String, String>, Unit> environmentAugmenter;

    public BackendParameters(@NotNull String program, @NotNull List<String> args, @NotNull ProtocolPath workingDir, @NotNull ProtocolPath ideaLogPath, @NotNull IntellijBackendFlavour intellijBackendFlavour, @NotNull HostId workspaceHostId, @NotNull HostId backendHostId, @NotNull Function1<? super Map<String, String>, Unit> environmentAugmenter2) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)ideaLogPath, (String)"ideaLogPath");
        Intrinsics.checkNotNullParameter((Object)intellijBackendFlavour, (String)"intellijBackendFlavour");
        Intrinsics.checkNotNullParameter((Object)workspaceHostId, (String)"workspaceHostId");
        Intrinsics.checkNotNullParameter((Object)backendHostId, (String)"backendHostId");
        Intrinsics.checkNotNullParameter(environmentAugmenter2, (String)"environmentAugmenter");
        this.program = program;
        this.args = args;
        this.workingDir = workingDir;
        this.ideaLogPath = ideaLogPath;
        this.intellijBackendFlavour = intellijBackendFlavour;
        this.workspaceHostId = workspaceHostId;
        this.backendHostId = backendHostId;
        this.environmentAugmenter = environmentAugmenter2;
    }

    @NotNull
    public final String getProgram() {
        return this.program;
    }

    @NotNull
    public final List<String> getArgs() {
        return this.args;
    }

    @NotNull
    public final ProtocolPath getWorkingDir() {
        return this.workingDir;
    }

    @NotNull
    public final ProtocolPath getIdeaLogPath() {
        return this.ideaLogPath;
    }

    @NotNull
    public final IntellijBackendFlavour getIntellijBackendFlavour() {
        return this.intellijBackendFlavour;
    }

    @NotNull
    public final HostId getWorkspaceHostId() {
        return this.workspaceHostId;
    }

    @NotNull
    public final HostId getBackendHostId() {
        return this.backendHostId;
    }

    @NotNull
    public final Function1<Map<String, String>, Unit> getEnvironmentAugmenter() {
        return this.environmentAugmenter;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProcessBuilder prepareForJavaProcess(boolean redirectOutput) {
        ProcessBuilder processBuilder;
        ProcessBuilder $this$prepareForJavaProcess_u24lambda_u240 = processBuilder = new ProcessBuilder(new String[0]).command(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.program), (Iterable)this.args)).directory(new File(this.workingDir.joinToString()));
        boolean bl = false;
        Object object = $this$prepareForJavaProcess_u24lambda_u240.environment();
        this.environmentAugmenter.invoke(object);
        ProcessBuilder processBuilder2 = processBuilder;
        boolean bl2 = false;
        object = this.intellijBackendFlavour;
        if (object instanceof IntellijBackendFlavour.FromSources) {
            ProcessBuilder processBuilder3 = processBuilder2.redirectInput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
            boolean $i$f$letIf = false;
            if (redirectOutput) {
                void $this$letIf$iv;
                void it = $this$letIf$iv;
                boolean bl3 = false;
                it.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            }
        } else if (object instanceof IntellijBackendFlavour.FromExecutable) {
            if (Intrinsics.areEqual((Object)this.workspaceHostId, (Object)this.backendHostId)) {
                Intrinsics.checkNotNull((Object)processBuilder2);
                BackendParametersKt.access$redirectStdErrOut(processBuilder2, this.ideaLogPath.toNio());
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ProcessBuilder processBuilder4 = processBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)processBuilder4, (String)"also(...)");
        return processBuilder4;
    }

    @NotNull
    public final LrpTaskArguments prepareForLrpTask(boolean redirectOutput, @NotNull UID processId) {
        Output output;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        if (redirectOutput) {
            stringArray = new String[]{"stdout_" + processId + ".txt"};
            OutputStrategy.RedirectToFile redirectToFile = new OutputStrategy.RedirectToFile(this.ideaLogPath.child(stringArray), false);
            stringArray = new String[]{"stderr_" + processId + ".txt"};
            Output output2 = new Output((OutputStrategy)redirectToFile, (OutputStrategy)new OutputStrategy.RedirectToFile(this.ideaLogPath.child(stringArray), false));
            output = output2;
        } else {
            output = new Output((OutputStrategy)OutputStrategy.Discard.INSTANCE, (OutputStrategy)OutputStrategy.Discard.INSTANCE);
        }
        Output output3 = output;
        stringArray = this.program;
        List<String> list = this.args;
        ProtocolPath protocolPath = this.workingDir;
        Map map2 = new LinkedHashMap();
        this.environmentAugmenter.invoke((Object)map2);
        EnvironmentOpts.Merge merge = new EnvironmentOpts.Merge(map2);
        return new LrpTaskArguments((String)stringArray, list, protocolPath, (EnvironmentOpts)merge, null, null, output3, 48, null);
    }

    @NotNull
    public final String component1() {
        return this.program;
    }

    @NotNull
    public final List<String> component2() {
        return this.args;
    }

    @NotNull
    public final ProtocolPath component3() {
        return this.workingDir;
    }

    @NotNull
    public final ProtocolPath component4() {
        return this.ideaLogPath;
    }

    @NotNull
    public final IntellijBackendFlavour component5() {
        return this.intellijBackendFlavour;
    }

    @NotNull
    public final HostId component6() {
        return this.workspaceHostId;
    }

    @NotNull
    public final HostId component7() {
        return this.backendHostId;
    }

    @NotNull
    public final Function1<Map<String, String>, Unit> component8() {
        return this.environmentAugmenter;
    }

    @NotNull
    public final BackendParameters copy(@NotNull String program, @NotNull List<String> args, @NotNull ProtocolPath workingDir, @NotNull ProtocolPath ideaLogPath, @NotNull IntellijBackendFlavour intellijBackendFlavour, @NotNull HostId workspaceHostId, @NotNull HostId backendHostId, @NotNull Function1<? super Map<String, String>, Unit> environmentAugmenter2) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)ideaLogPath, (String)"ideaLogPath");
        Intrinsics.checkNotNullParameter((Object)intellijBackendFlavour, (String)"intellijBackendFlavour");
        Intrinsics.checkNotNullParameter((Object)workspaceHostId, (String)"workspaceHostId");
        Intrinsics.checkNotNullParameter((Object)backendHostId, (String)"backendHostId");
        Intrinsics.checkNotNullParameter(environmentAugmenter2, (String)"environmentAugmenter");
        return new BackendParameters(program, args, workingDir, ideaLogPath, intellijBackendFlavour, workspaceHostId, backendHostId, environmentAugmenter2);
    }

    public static /* synthetic */ BackendParameters copy$default(BackendParameters backendParameters, String string, List list, ProtocolPath protocolPath, ProtocolPath protocolPath2, IntellijBackendFlavour intellijBackendFlavour, HostId hostId, HostId hostId2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = backendParameters.program;
        }
        if ((n & 2) != 0) {
            list = backendParameters.args;
        }
        if ((n & 4) != 0) {
            protocolPath = backendParameters.workingDir;
        }
        if ((n & 8) != 0) {
            protocolPath2 = backendParameters.ideaLogPath;
        }
        if ((n & 0x10) != 0) {
            intellijBackendFlavour = backendParameters.intellijBackendFlavour;
        }
        if ((n & 0x20) != 0) {
            hostId = backendParameters.workspaceHostId;
        }
        if ((n & 0x40) != 0) {
            hostId2 = backendParameters.backendHostId;
        }
        if ((n & 0x80) != 0) {
            function1 = backendParameters.environmentAugmenter;
        }
        return backendParameters.copy(string, list, protocolPath, protocolPath2, intellijBackendFlavour, hostId, hostId2, function1);
    }

    @NotNull
    public String toString() {
        return "BackendParameters(program=" + this.program + ", args=" + this.args + ", workingDir=" + this.workingDir + ", ideaLogPath=" + this.ideaLogPath + ", intellijBackendFlavour=" + this.intellijBackendFlavour + ", workspaceHostId=" + this.workspaceHostId + ", backendHostId=" + this.backendHostId + ", environmentAugmenter=" + this.environmentAugmenter + ")";
    }

    public int hashCode() {
        int result2 = this.program.hashCode();
        result2 = result2 * 31 + ((Object)this.args).hashCode();
        result2 = result2 * 31 + this.workingDir.hashCode();
        result2 = result2 * 31 + this.ideaLogPath.hashCode();
        result2 = result2 * 31 + this.intellijBackendFlavour.hashCode();
        result2 = result2 * 31 + this.workspaceHostId.hashCode();
        result2 = result2 * 31 + this.backendHostId.hashCode();
        result2 = result2 * 31 + this.environmentAugmenter.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BackendParameters)) {
            return false;
        }
        BackendParameters backendParameters = (BackendParameters)other;
        if (!Intrinsics.areEqual((Object)this.program, (Object)backendParameters.program)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.args, backendParameters.args)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.workingDir, (Object)backendParameters.workingDir)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ideaLogPath, (Object)backendParameters.ideaLogPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.intellijBackendFlavour, (Object)backendParameters.intellijBackendFlavour)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.workspaceHostId, (Object)backendParameters.workspaceHostId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.backendHostId, (Object)backendParameters.backendHostId)) {
            return false;
        }
        return Intrinsics.areEqual(this.environmentAugmenter, backendParameters.environmentAugmenter);
    }
}

