/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.code.snippets;

import andel.editor.Caret;
import andel.editor.TextExtKt;
import andel.text.NavigationKt;
import andel.text.Text;
import andel.text.TextLine;
import andel.text.TextRange;
import andel.text.TextView;
import andel.text.TextViewExtKt;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.api.ProtocolPath;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentEntityKt;
import fleet.common.document.EditorEntity;
import fleet.common.fs.FsdKt;
import fleet.common.fs.SharedWorkspaceRootEntity;
import fleet.common.fs.SharedWorkspaceRootEntityKt;
import fleet.frontend.code.snippets.Base;
import fleet.frontend.code.snippets.Comment;
import fleet.frontend.code.snippets.TextMateVariable;
import fleet.frontend.code.snippets.TmVariableResolveKt;
import fleet.frontend.code.snippets.Variable;
import fleet.frontend.code.snippets.VariableResolver;
import fleet.frontend.lang.commenter.Commenter;
import fleet.util.Random;
import fleet.util.UID;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.windowManagement.api.Clipboard;
import noria.windowManagement.api.WindowManager;
import noria.windowManagement.extensions.ClipboardKt;
import noria.windowManagement.extensions.WindowManagerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a \u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\u0019\u001a\u0004\u0018\u00010\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\u001b\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u001a\u001a\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002\u001a\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\rH\u0002\u001a\u0010\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0007H\u0002\u001a\u0010\u0010$\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0007H\u0002\u001a\b\u0010%\u001a\u00020\rH\u0002\u001a\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0002\u001a \u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010*\u001a\u00020+2\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0002\u00a8\u0006,"}, d2={"createTMVariableResolver", "Lfleet/frontend/code/snippets/VariableResolver;", "editor", "Lfleet/common/document/EditorEntity;", "caret", "Landel/editor/Caret;", "honorCamelHumps", "", "commenter", "Lfleet/frontend/lang/commenter/Commenter;", "windowManager", "Lnoria/windowManagement/api/WindowManager;", "currentlySelectedText", "", "text", "Landel/text/Text;", "currentLine", "currentWord", "currentLineIndex", "", "currentLineNumber", "filename", "fileAddress", "Lfleet/api/FileAddress;", "withExtensions", "directory", "includingFile", "relativeFilePath", "workspaceFolder", "documentEntity", "Lfleet/common/document/DocumentEntity;", "onlyName", "dateTime", "patter", "currentMonthName", "short", "currentDayName", "secondsSinceEpoch", "randomSixDigits", "base", "Lfleet/frontend/code/snippets/Base;", "getComment", "comment", "Lfleet/frontend/code/snippets/Comment;", "fleet.code.frontend"})
@SourceDebugExtension(value={"SMAP\nTmVariableResolve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TmVariableResolve.kt\nfleet/frontend/code/snippets/TmVariableResolveKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n648#2,5:253\n1#3:258\n*S KotlinDebug\n*F\n+ 1 TmVariableResolve.kt\nfleet/frontend/code/snippets/TmVariableResolveKt\n*L\n175#1:253,5\n*E\n"})
public final class TmVariableResolveKt {
    @NotNull
    public static final VariableResolver createTMVariableResolver(@NotNull EditorEntity editor2, @NotNull Caret caret, boolean honorCamelHumps, @Nullable Commenter<?> commenter, @NotNull WindowManager windowManager) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
        return new VariableResolver(editor2, caret, honorCamelHumps, windowManager, commenter){
            final /* synthetic */ EditorEntity $editor;
            final /* synthetic */ Caret $caret;
            final /* synthetic */ boolean $honorCamelHumps;
            final /* synthetic */ WindowManager $windowManager;
            final /* synthetic */ Commenter<?> $commenter;
            {
                this.$editor = $editor;
                this.$caret = $caret;
                this.$honorCamelHumps = $honorCamelHumps;
                this.$windowManager = $windowManager;
                this.$commenter = $commenter;
            }

            public String resolve(Variable variable) {
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                TextMateVariable varType = TextMateVariable.Companion.nullableValueOf(variable.getName());
                if (EntitiesKt.exists((Entity)((Entity)this.$editor))) {
                    String string;
                    TextMateVariable textMateVariable = varType;
                    if (textMateVariable != null) {
                        TextMateVariable it = textMateVariable;
                        boolean bl = false;
                        string = this.resolve(it);
                    } else {
                        string = null;
                    }
                    return string;
                }
                return null;
            }

            public final String resolve(TextMateVariable tmVariable) {
                Intrinsics.checkNotNullParameter((Object)((Object)tmVariable), (String)"tmVariable");
                return switch (createTMVariableResolver.WhenMappings.$EnumSwitchMapping$0[tmVariable.ordinal()]) {
                    case 1 -> TmVariableResolveKt.access$currentlySelectedText(this.$editor.getDocument().getText(), this.$caret);
                    case 2 -> TmVariableResolveKt.access$currentLine(this.$editor.getDocument().getText(), this.$caret);
                    case 3 -> TmVariableResolveKt.access$currentWord(this.$editor.getDocument().getText(), this.$caret, this.$honorCamelHumps);
                    case 4 -> String.valueOf(TmVariableResolveKt.access$currentLineIndex(this.$editor.getDocument().getText(), this.$caret));
                    case 5 -> String.valueOf(TmVariableResolveKt.access$currentLineNumber(this.$editor.getDocument().getText(), this.$caret));
                    case 6 -> TmVariableResolveKt.access$filename(DocumentEntityKt.getLocationFileAddress((DocumentEntity)this.$editor.getDocument()), true);
                    case 7 -> TmVariableResolveKt.access$filename(DocumentEntityKt.getLocationFileAddress((DocumentEntity)this.$editor.getDocument()), false);
                    case 8 -> TmVariableResolveKt.access$directory(DocumentEntityKt.getLocationFileAddress((DocumentEntity)this.$editor.getDocument()), false);
                    case 9 -> TmVariableResolveKt.access$directory(DocumentEntityKt.getLocationFileAddress((DocumentEntity)this.$editor.getDocument()), true);
                    case 10 -> ClipboardKt.getText((Clipboard)WindowManagerKt.getClipboard((WindowManager)this.$windowManager));
                    case 11 -> TmVariableResolveKt.access$relativeFilePath(DocumentEntityKt.getLocationFileAddress((DocumentEntity)this.$editor.getDocument()));
                    case 12 -> TmVariableResolveKt.access$workspaceFolder(this.$editor.getDocument(), true);
                    case 13 -> TmVariableResolveKt.access$workspaceFolder(this.$editor.getDocument(), false);
                    case 14 -> TmVariableResolveKt.access$dateTime("YYYY");
                    case 15 -> TmVariableResolveKt.access$dateTime("YY");
                    case 16 -> TmVariableResolveKt.access$dateTime("MM");
                    case 17 -> TmVariableResolveKt.access$currentMonthName(false);
                    case 18 -> TmVariableResolveKt.access$currentMonthName(true);
                    case 19 -> TmVariableResolveKt.access$dateTime("dd");
                    case 20 -> TmVariableResolveKt.access$currentDayName(false);
                    case 21 -> TmVariableResolveKt.access$currentDayName(true);
                    case 22 -> TmVariableResolveKt.access$dateTime("HH");
                    case 23 -> TmVariableResolveKt.access$dateTime("mm");
                    case 24 -> TmVariableResolveKt.access$dateTime("ss");
                    case 25 -> TmVariableResolveKt.access$secondsSinceEpoch();
                    case 26 -> TmVariableResolveKt.access$randomSixDigits(Base.Decimal);
                    case 27 -> TmVariableResolveKt.access$randomSixDigits(Base.HEX);
                    case 28 -> UID.Companion.random().toString();
                    case 29 -> TmVariableResolveKt.access$getComment(Comment.BLOCK_START, this.$commenter);
                    case 30 -> TmVariableResolveKt.access$getComment(Comment.BLOCK_END, this.$commenter);
                    case 31 -> TmVariableResolveKt.access$getComment(Comment.LINE, this.$commenter);
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
        };
    }

    private static final String currentlySelectedText(Text text, Caret caret) {
        return caret.hasSelection() ? TextExtKt.substring((Text)text, (TextRange)caret.getSelection()) : "";
    }

    private static final String currentLine(Text text, Caret caret) {
        TextLine currentLine = TextViewExtKt.textLines$default((TextView)text.view(), (boolean)false, (int)1, null).atCharOffset(caret.getOffset());
        return currentLine.toString();
    }

    private static final String currentWord(Text text, Caret caret, boolean honorCamelHumps) {
        TextRange range = NavigationKt.textAroundOrNull((Caret)caret, (Text)text, (boolean)honorCamelHumps);
        TextRange textRange = range;
        return textRange != null ? TextExtKt.substring((Text)text, (TextRange)textRange) : "";
    }

    private static final long currentLineIndex(Text text, Caret caret) {
        TextLine currentLine = TextViewExtKt.textLines$default((TextView)text.view(), (boolean)false, (int)1, null).atCharOffset(caret.getOffset());
        return currentLine.getLineNumber();
    }

    private static final long currentLineNumber(Text text, Caret caret) {
        return TmVariableResolveKt.currentLineIndex(text, caret) + 1L;
    }

    /*
     * WARNING - void declaration
     */
    private static final String filename(FileAddress fileAddress, boolean withExtensions) {
        Object object;
        block4: {
            Object filename;
            Object object2 = fileAddress;
            if (object2 == null || (object2 = FileAddressKt.getName((FileAddress)object2)) == null) {
                object2 = filename = "";
            }
            if (withExtensions) {
                object = filename;
            } else {
                void var3_3;
                Object $this$takeWhile$iv = filename;
                boolean $i$f$takeWhile = false;
                int n = ((String)$this$takeWhile$iv).length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = ((String)$this$takeWhile$iv).charAt(index$iv);
                    boolean bl = false;
                    if (it != '.') continue;
                    Object object3 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string = ((String)object3).substring(n2, index$iv);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    break block4;
                }
                object = var3_3;
            }
        }
        return object;
    }

    private static final String directory(FileAddress fileAddress, boolean includingFile) {
        ProtocolPath refinedPath;
        Object object;
        ProtocolPath fullPath;
        FileAddress fileAddress2 = fileAddress;
        Object object2 = fullPath = fileAddress2 != null ? fileAddress2.getPath() : null;
        if (includingFile) {
            object = fullPath;
        } else {
            ProtocolPath protocolPath = fullPath;
            object = protocolPath != null ? protocolPath.parent() : null;
        }
        ProtocolPath protocolPath = refinedPath = object;
        return protocolPath != null ? protocolPath.joinToString() : null;
    }

    private static final String relativeFilePath(FileAddress fileAddress) {
        Object object;
        block3: {
            block2: {
                object = fileAddress;
                if (object == null) break block2;
                FileAddress it = object;
                boolean bl = false;
                String string = FsdKt.trimFileAddress$default((FileAddress)it, (boolean)false, (int)2, null);
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private static final String workspaceFolder(DocumentEntity documentEntity, boolean onlyName) {
        SharedWorkspaceRootEntity sharedWorkspaceRootEntity;
        SharedWorkspaceRootEntity sharedWorkspaceRootEntity2;
        SharedWorkspaceRootEntity workspace = SharedWorkspaceRootEntityKt.findWorkspaceRootEntity((DocumentEntity)documentEntity);
        return onlyName ? ((sharedWorkspaceRootEntity2 = workspace) != null && (sharedWorkspaceRootEntity2 = sharedWorkspaceRootEntity2.getDirAddress()) != null ? FileAddressKt.getName((FileAddress)sharedWorkspaceRootEntity2) : null) : ((sharedWorkspaceRootEntity = workspace) != null && (sharedWorkspaceRootEntity = sharedWorkspaceRootEntity.getDirAddress()) != null && (sharedWorkspaceRootEntity = sharedWorkspaceRootEntity.getPath()) != null ? sharedWorkspaceRootEntity.joinToString() : null);
    }

    private static final String dateTime(String patter) {
        String string = LocalDateTime.now().format(DateTimeFormatter.ofPattern(patter));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private static final String currentMonthName(boolean bl) {
        TextStyle textStyle = bl ? TextStyle.SHORT_STANDALONE : TextStyle.FULL_STANDALONE;
        String string = LocalDateTime.now().getMonth().getDisplayName(textStyle, Locale.getDefault());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    private static final String currentDayName(boolean bl) {
        TextStyle textStyle = bl ? TextStyle.SHORT_STANDALONE : TextStyle.FULL_STANDALONE;
        String string = LocalDateTime.now().getDayOfWeek().getDisplayName(textStyle, Locale.getDefault());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    private static final String secondsSinceEpoch() {
        return String.valueOf(System.currentTimeMillis() / (long)1000);
    }

    private static final String randomSixDigits(Base base) {
        return switch (WhenMappings.$EnumSwitchMapping$0[base.ordinal()]) {
            case 1 -> String.valueOf(Random.INSTANCE.nextInt(1000000));
            case 2 -> ArraysKt.joinToString$default((byte[])Random.INSTANCE.nextBytes(3), (CharSequence)"", null, null, (int)0, null, (Function1)randomSixDigits.1.INSTANCE, (int)30, null);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final String getComment(Comment comment, Commenter<?> commenter) {
        return switch (WhenMappings.$EnumSwitchMapping$1[comment.ordinal()]) {
            case 1 -> {
                Commenter<?> v0 = commenter;
                if (v0 != null) {
                    yield v0.getBlockCommentPrefix();
                }
                yield null;
            }
            case 2 -> {
                Commenter<?> v2 = commenter;
                if (v2 != null) {
                    yield v2.getBlockCommentSuffix();
                }
                yield null;
            }
            case 3 -> {
                Commenter<?> v3 = commenter;
                if (v3 != null) {
                    yield v3.getLineCommentPrefix();
                }
                yield null;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final /* synthetic */ String access$currentlySelectedText(Text text, Caret caret) {
        return TmVariableResolveKt.currentlySelectedText(text, caret);
    }

    public static final /* synthetic */ String access$currentLine(Text text, Caret caret) {
        return TmVariableResolveKt.currentLine(text, caret);
    }

    public static final /* synthetic */ String access$currentWord(Text text, Caret caret, boolean honorCamelHumps) {
        return TmVariableResolveKt.currentWord(text, caret, honorCamelHumps);
    }

    public static final /* synthetic */ long access$currentLineIndex(Text text, Caret caret) {
        return TmVariableResolveKt.currentLineIndex(text, caret);
    }

    public static final /* synthetic */ long access$currentLineNumber(Text text, Caret caret) {
        return TmVariableResolveKt.currentLineNumber(text, caret);
    }

    public static final /* synthetic */ String access$filename(FileAddress fileAddress, boolean withExtensions) {
        return TmVariableResolveKt.filename(fileAddress, withExtensions);
    }

    public static final /* synthetic */ String access$directory(FileAddress fileAddress, boolean includingFile) {
        return TmVariableResolveKt.directory(fileAddress, includingFile);
    }

    public static final /* synthetic */ String access$relativeFilePath(FileAddress fileAddress) {
        return TmVariableResolveKt.relativeFilePath(fileAddress);
    }

    public static final /* synthetic */ String access$workspaceFolder(DocumentEntity documentEntity, boolean onlyName) {
        return TmVariableResolveKt.workspaceFolder(documentEntity, onlyName);
    }

    public static final /* synthetic */ String access$dateTime(String patter) {
        return TmVariableResolveKt.dateTime(patter);
    }

    public static final /* synthetic */ String access$currentMonthName(boolean bl) {
        return TmVariableResolveKt.currentMonthName(bl);
    }

    public static final /* synthetic */ String access$currentDayName(boolean bl) {
        return TmVariableResolveKt.currentDayName(bl);
    }

    public static final /* synthetic */ String access$secondsSinceEpoch() {
        return TmVariableResolveKt.secondsSinceEpoch();
    }

    public static final /* synthetic */ String access$randomSixDigits(Base base) {
        return TmVariableResolveKt.randomSixDigits(base);
    }

    public static final /* synthetic */ String access$getComment(Comment comment, Commenter commenter) {
        return TmVariableResolveKt.getComment(comment, commenter);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Base.values().length];
            try {
                nArray[Base.Decimal.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Base.HEX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Comment.values().length];
            try {
                nArray[Comment.BLOCK_START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Comment.BLOCK_END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Comment.LINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

