/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.code.completion;

import andel.editor.DocumentComponent;
import andel.editor.DocumentComponentKey;
import andel.editor.EditorComponentKey;
import andel.text.Text;
import andel.text.TextRange;
import com.jetbrains.rhizomedb.CascadeDelete;
import com.jetbrains.rhizomedb.CascadeDeleteBy;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import fleet.api.SourcePosition;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentEntityKt;
import fleet.common.document.EditorEntity;
import fleet.frontend.code.completion.AdjustedCompletionItem;
import fleet.frontend.code.completion.CompletionItemsState;
import fleet.frontend.code.completion.CompletionSessionEntityKt;
import fleet.frontend.code.completion.CompletionSubSession;
import fleet.frontend.code.completion.CompletionSubSessionKt;
import fleet.frontend.code.completion.FilteredItems;
import fleet.frontend.code.completion.SoftRestartRequest;
import fleet.frontend.editor.CancellableEditorSagaEntity;
import fleet.frontend.editor.EditorEntityExtKt;
import fleet.frontend.editor.components.EditorPopupEntity;
import fleet.util.SortedSet;
import fleet.util.UID;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.coroutines.channels.Channel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 +2\u00020\u0001:\u0001+J\b\u0010%\u001a\u00020\u000eH\u0016J\b\u0010&\u001a\u00020\u001dH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016R\u001e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\u0006\"\u0004\b\f\u0010\bR$\u0010\r\u001a\u0004\u0018\u00010\u000e8&@&X\u00a7\u000e\u00a2\u0006\u0012\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u0004\u0018\u00010\u00168&@&X\u00a7\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u001dX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0018\u0010\"\u001a\u00020\u001dX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!\u00a8\u0006,"}, d2={"Lfleet/frontend/code/completion/CompletionSessionEntity;", "Lfleet/frontend/editor/components/EditorPopupEntity;", "cleanupTrigger", "Lkotlinx/coroutines/channels/Channel;", "", "getCleanupTrigger", "()Lkotlinx/coroutines/channels/Channel;", "setCleanupTrigger", "(Lkotlinx/coroutines/channels/Channel;)V", "restartCommands", "Lfleet/frontend/code/completion/SoftRestartRequest;", "getRestartCommands", "setRestartCommands", "subSession", "Lfleet/frontend/code/completion/CompletionSubSession;", "getSubSession$annotations", "()V", "getSubSession", "()Lfleet/frontend/code/completion/CompletionSubSession;", "setSubSession", "(Lfleet/frontend/code/completion/CompletionSubSession;)V", "cancellableEditorSagaEntity", "Lfleet/frontend/editor/CancellableEditorSagaEntity;", "getCancellableEditorSagaEntity$annotations", "getCancellableEditorSagaEntity", "()Lfleet/frontend/editor/CancellableEditorSagaEntity;", "setCancellableEditorSagaEntity", "(Lfleet/frontend/editor/CancellableEditorSagaEntity;)V", "showDocumentation", "", "getShowDocumentation", "()Z", "setShowDocumentation", "(Z)V", "showAbove", "getShowAbove", "setShowAbove", "assertiveSubSession", "isInitialized", "asComponent", "Landel/editor/DocumentComponent;", "changeScope", "Lcom/jetbrains/rhizomedb/ChangeScope;", "Companion", "fleet.code.frontend"})
public interface CompletionSessionEntity
extends EditorPopupEntity {
    @NotNull
    public static final Companion Companion = fleet.frontend.code.completion.CompletionSessionEntity$Companion.$$INSTANCE;

    @NotNull
    public Channel<Unit> getCleanupTrigger();

    public void setCleanupTrigger(@NotNull Channel<Unit> var1);

    @NotNull
    public Channel<SoftRestartRequest> getRestartCommands();

    public void setRestartCommands(@NotNull Channel<SoftRestartRequest> var1);

    @Nullable
    public CompletionSubSession getSubSession();

    public void setSubSession(@Nullable CompletionSubSession var1);

    @Nullable
    public CancellableEditorSagaEntity getCancellableEditorSagaEntity();

    public void setCancellableEditorSagaEntity(@Nullable CancellableEditorSagaEntity var1);

    public boolean getShowDocumentation();

    public void setShowDocumentation(boolean var1);

    public boolean getShowAbove();

    public void setShowAbove(boolean var1);

    @NotNull
    public CompletionSubSession assertiveSubSession();

    public boolean isInitialized();

    @NotNull
    public DocumentComponent asComponent(@NotNull ChangeScope var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lfleet/frontend/code/completion/CompletionSessionEntity$Companion;", "", "<init>", "()V", "logger", "Lfleet/util/logging/KLogger;", "getLogger$fleet_code_frontend", "()Lfleet/util/logging/KLogger;", "fleet.code.frontend"})
    @SourceDebugExtension(value={"SMAP\nCompletionSessionEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionSessionEntity.kt\nfleet/frontend/code/completion/CompletionSessionEntity$Companion\n+ 2 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,532:1\n25#2:533\n*S KotlinDebug\n*F\n+ 1 CompletionSessionEntity.kt\nfleet/frontend/code/completion/CompletionSessionEntity$Companion\n*L\n130#1:533\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final KLogger logger;

        private Companion() {
        }

        @NotNull
        public final KLogger getLogger$fleet_code_frontend() {
            return logger;
        }

        static {
            $$INSTANCE = new Companion();
            boolean $i$f$logger = false;
            logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(CompletionSessionEntity.class));
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nCompletionSessionEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionSessionEntity.kt\nfleet/frontend/code/completion/CompletionSessionEntity$DefaultImpls\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,532:1\n1#2:533\n*E\n"})
    public static final class DefaultImpls {
        @CascadeDelete
        public static /* synthetic */ void getSubSession$annotations() {
        }

        @CascadeDelete
        @CascadeDeleteBy
        public static /* synthetic */ void getCancellableEditorSagaEntity$annotations() {
        }

        @NotNull
        public static CompletionSubSession assertiveSubSession(@NotNull CompletionSessionEntity $this) {
            if (!($this.getSubSession() != null)) {
                boolean $i$a$-require-CompletionSessionEntity$assertiveSubSession$32 = false;
                String $i$a$-require-CompletionSessionEntity$assertiveSubSession$32 = "Subsession must be set at this CompletionSessionEntity";
                throw new IllegalArgumentException($i$a$-require-CompletionSessionEntity$assertiveSubSession$32.toString());
            }
            CompletionSubSession completionSubSession = $this.getSubSession();
            Intrinsics.checkNotNull((Object)completionSubSession);
            if (!EntitiesKt.exists((Entity)completionSubSession)) {
                boolean bl = false;
                String string = "SubSession must exist";
                throw new IllegalArgumentException(string.toString());
            }
            CompletionSubSession completionSubSession2 = $this.getSubSession();
            Intrinsics.checkNotNull((Object)completionSubSession2);
            return completionSubSession2;
        }

        public static boolean isInitialized(@NotNull CompletionSessionEntity $this) {
            return $this.getSubSession() != null;
        }

        @NotNull
        public static DocumentComponent asComponent(@NotNull CompletionSessionEntity $this, @NotNull ChangeScope changeScope) {
            Intrinsics.checkNotNullParameter((Object)changeScope, (String)"changeScope");
            CompletionSessionEntity completionState = $this;
            return new DocumentComponent(changeScope, completionState, $this){
                final /* synthetic */ ChangeScope $changeScope;
                final /* synthetic */ CompletionSessionEntity $completionState;
                final /* synthetic */ CompletionSessionEntity this$0;
                {
                    this.$changeScope = $changeScope;
                    this.$completionState = $completionState;
                    this.this$0 = $receiver;
                }

                public void onCommit() {
                    ChangeScope changeScope = this.$changeScope;
                    CompletionSessionEntity completionSessionEntity = this.$completionState;
                    CompletionSessionEntity completionSessionEntity2 = this.this$0;
                    ChangeScope changeScope2 = this.$changeScope;
                    ChangeScope $this$onCommit_u24lambda_u246 = changeScope;
                    boolean bl = false;
                    if (!EntitiesKt.exists((Entity)((Entity)completionSessionEntity)) || completionSessionEntity.getSubSession() == null || completionSessionEntity.assertiveSubSession().getInserting$fleet_code_frontend()) {
                        return;
                    }
                    CompletionSubSession subSession2 = completionSessionEntity.assertiveSubSession();
                    long currentOffset = EditorEntityExtKt.getMultiCaret((EditorEntity)completionSessionEntity2.getEditor()).getPrimaryCaret().getPosition().getOffset();
                    SourcePosition newPosition = DocumentEntityKt.SourcePosition((DocumentEntity)completionSessionEntity2.getDocument(), (long)currentOffset);
                    TextRange completionRange = subSession2.getCompletionRangeMarker$fleet_code_frontend().getRange();
                    TextRange replacementRange = subSession2.getReplacementRangeMarker$fleet_code_frontend().getRange();
                    if (completionRange.getStart() < currentOffset && currentOffset <= completionRange.getEnd()) {
                        boolean onTheEdge;
                        Text text = completionSessionEntity2.getEditor().getDocument().getText();
                        boolean bl2 = onTheEdge = CompletionSessionEntityKt.identifierEdge(currentOffset, text, false) == currentOffset && currentOffset == CompletionSessionEntityKt.identifierEdge(currentOffset, text, true) && !CompletionSessionEntityKt.access$atCompletionSequencePoint(currentOffset, completionSessionEntity2.getEditor().getDocument());
                        if (onTheEdge) {
                            KLogger this_$iv = CompletionSessionEntity.Companion.getLogger$fleet_code_frontend();
                            boolean $i$f$debug = false;
                            if (this_$iv.isDebugEnabled()) {
                                KLogger kLogger = this_$iv;
                                boolean bl3 = false;
                                kLogger.debug((Object)"We have no identifier on the right and on the left, closing the completion");
                            }
                            completionSessionEntity2.close(changeScope2);
                        } else {
                            boolean offsetWentBeforeCompletionRange = currentOffset <= replacementRange.getStart();
                            boolean restartBasedOnPrefix = CompletionSessionEntityKt.access$shouldRestartBasedOnPrefix(completionSessionEntity2, text.view().string((int)replacementRange.getStart(), (int)currentOffset));
                            if (restartBasedOnPrefix || offsetWentBeforeCompletionRange) {
                                KLogger this_$iv = CompletionSessionEntity.Companion.getLogger$fleet_code_frontend();
                                boolean $i$f$debug = false;
                                if (this_$iv.isDebugEnabled()) {
                                    KLogger kLogger = this_$iv;
                                    boolean bl4 = false;
                                    kLogger.debug((Object)(offsetWentBeforeCompletionRange ? "Offset went before completionRange.start, scheduling completion restart" : "New prefix satisfies the restart condition, scheduling completion restart"));
                                }
                                CompletionSessionEntityKt.createAnchorAndScheduleRestart($this$onCommit_u24lambda_u246, subSession2);
                            } else {
                                String newPrefix = text.view().string((int)replacementRange.getStart(), (int)currentOffset);
                                $this$onCommit_u24lambda_u246.set((Entity)subSession2, CompletionSubSession.Companion.getCompletionPrefixAttr$fleet_code_frontend(), (Object)newPrefix);
                                $this$onCommit_u24lambda_u246.set((Entity)subSession2, CompletionSubSession.Companion.getPrimaryCaretPositionAttr$fleet_code_frontend(), (Object)newPosition);
                                Pair pair = CompletionSessionEntityKt.access$adjustItems(subSession2, subSession2.getRawItems().values(), CompletionSubSessionKt.initialOffset(subSession2), currentOffset);
                                SortedSet items = (SortedSet)pair.component1();
                                int maxPrefix = ((Number)pair.component2()).intValue();
                                if (subSession2.getCompletionItemsState() == CompletionItemsState.Finished && items.size() == 0L) {
                                    if (CompletionSessionEntityKt.access$atCompletionSequencePoint(currentOffset, completionSessionEntity2.getEditor().getDocument())) {
                                        KLogger this_$iv = CompletionSessionEntity.Companion.getLogger$fleet_code_frontend();
                                        boolean $i$f$debug = false;
                                        if (this_$iv.isDebugEnabled()) {
                                            KLogger kLogger = this_$iv;
                                            boolean bl5 = false;
                                            kLogger.debug((Object)"There are no items left to adjust, but completion sequence point has been typed. Do nothing, wait for a soft-restart");
                                        }
                                    } else {
                                        KLogger this_$iv = CompletionSessionEntity.Companion.getLogger$fleet_code_frontend();
                                        boolean $i$f$debug = false;
                                        if (this_$iv.isDebugEnabled()) {
                                            KLogger kLogger = this_$iv;
                                            boolean bl6 = false;
                                            kLogger.debug((Object)"No items left after adjustment + no more items coming. Closing session");
                                        }
                                        completionSessionEntity2.close(changeScope2);
                                    }
                                } else {
                                    PersistentMap.Builder builder;
                                    CompletionSessionEntityKt.access$updateCompletionRange($this$onCommit_u24lambda_u246, subSession2, currentOffset - (long)maxPrefix);
                                    PersistentMap.Builder $this$onCommit_u24lambda_u246_u24lambda_u244 = builder = ExtensionsKt.persistentHashMapOf().builder();
                                    boolean bl7 = false;
                                    Iterator iterator = items.iterator();
                                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                                    Iterator iterator2 = iterator;
                                    while (iterator2.hasNext()) {
                                        AdjustedCompletionItem item = (AdjustedCompletionItem)iterator2.next();
                                        UID uID = item.getItem().getUid();
                                        Intrinsics.checkNotNull((Object)item);
                                        $this$onCommit_u24lambda_u246_u24lambda_u244.put((Object)uID, (Object)item);
                                    }
                                    PersistentMap index = builder.build();
                                    subSession2.getFilteredItems().setValue((Object)new FilteredItems((SortedSet<AdjustedCompletionItem>)items, (PersistentMap<UID, AdjustedCompletionItem>)index));
                                }
                            }
                        }
                    } else {
                        KLogger this_$iv = CompletionSessionEntity.Companion.getLogger$fleet_code_frontend();
                        boolean $i$f$debug = false;
                        if (this_$iv.isDebugEnabled()) {
                            KLogger kLogger = this_$iv;
                            boolean bl8 = false;
                            kLogger.debug((Object)"Offset went out of completionRange, closing the completion");
                        }
                        completionSessionEntity2.close(changeScope2);
                    }
                }
            };
        }

        @NotNull
        public static String getPopupKey(@NotNull CompletionSessionEntity $this) {
            return EditorPopupEntity.DefaultImpls.getPopupKey((EditorPopupEntity)$this);
        }

        public static void close(@NotNull CompletionSessionEntity $this, @NotNull ChangeScope changeScope) {
            Intrinsics.checkNotNullParameter((Object)changeScope, (String)"changeScope");
            EditorPopupEntity.DefaultImpls.close((EditorPopupEntity)$this, (ChangeScope)changeScope);
        }

        @NotNull
        public static DocumentComponentKey<DocumentComponent> getKey(@NotNull CompletionSessionEntity $this) {
            return EditorPopupEntity.DefaultImpls.getKey((EditorPopupEntity)$this);
        }

        @NotNull
        public static EditorComponentKey<DocumentComponent> getEditorKey(@NotNull CompletionSessionEntity $this) {
            return EditorPopupEntity.DefaultImpls.getEditorKey((EditorPopupEntity)$this);
        }

        @NotNull
        public static KClass<? extends Entity> getEntityClass(@NotNull CompletionSessionEntity $this) {
            return EditorPopupEntity.DefaultImpls.getEntityClass((EditorPopupEntity)$this);
        }
    }
}

