/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.FileHashStrategy;
import com.intellij.util.containers.PathHashStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0007H\u0007J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0007H\u0007J\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0007H\u0007J\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0007H\u0007J\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007J0\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u00072\u0014\u0010\u000f\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00070\u0010H\u0007J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0007J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014H\u0007J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0007J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0007J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0007J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/containers/FileCollectionFactory;", "", "<init>", "()V", "createCanonicalPathLinkedMap", "", "Ljava/nio/file/Path;", "V", "createCanonicalFilePathLinkedMap", "", "createCanonicalFileMap", "Ljava/io/File;", "createCanonicalPathMap", "expected", "", "map", "", "createCanonicalFileSet", "", "files", "", "createCanonicalPathSet", "createCanonicalFilePathSet", "createCanonicalFileLinkedSet", "intellij.platform.util.base"})
public final class FileCollectionFactory {
    @NotNull
    public static final FileCollectionFactory INSTANCE = new FileCollectionFactory();

    private FileCollectionFactory() {
    }

    @JvmStatic
    @NotNull
    public static final <V> Map<Path, V> createCanonicalPathLinkedMap() {
        return (Map)new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)PathHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final <V> Map<String, V> createCanonicalFilePathLinkedMap() {
        return (Map)new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<String>(){

            public int hashCode(String value) {
                return FileUtilRt.pathHashCode(value);
            }

            public boolean equals(String val1, String val2) {
                return FileUtilRt.pathsEqual(val1, val2);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final <V> Map<File, V> createCanonicalFileMap() {
        return (Map)new Object2ObjectOpenCustomHashMap((Hash.Strategy)FileHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final <V> Map<Path, V> createCanonicalPathMap() {
        return (Map)new Object2ObjectOpenCustomHashMap((Hash.Strategy)PathHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final <V> Map<File, V> createCanonicalFileMap(int expected) {
        return (Map)new Object2ObjectOpenCustomHashMap(expected, (Hash.Strategy)FileHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final <V> Map<File, V> createCanonicalFileMap(@NotNull Map<? extends File, ? extends V> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        return (Map)new Object2ObjectOpenCustomHashMap(map, (Hash.Strategy)FileHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Set<File> createCanonicalFileSet() {
        return (Set)new ObjectOpenCustomHashSet((Hash.Strategy)FileHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Set<File> createCanonicalFileSet(@NotNull Collection<? extends File> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return (Set)new ObjectOpenCustomHashSet(files, (Hash.Strategy)FileHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Set<Path> createCanonicalPathSet() {
        return (Set)new ObjectOpenCustomHashSet((Hash.Strategy)PathHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Set<Path> createCanonicalPathSet(@NotNull Collection<? extends Path> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return (Set)new ObjectOpenCustomHashSet(files, (Hash.Strategy)PathHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Set<String> createCanonicalFilePathSet() {
        return (Set)new ObjectOpenCustomHashSet(FastUtilHashingStrategies.FILE_PATH_HASH_STRATEGY);
    }

    @JvmStatic
    @NotNull
    public static final Set<File> createCanonicalFileLinkedSet() {
        return (Set)new ObjectLinkedOpenCustomHashSet((Hash.Strategy)FileHashStrategy.INSTANCE);
    }
}

