/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.terminal.model.LinesStorage;
import com.jediterm.terminal.model.TerminalLine;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0011\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0003H\u0096\u0002J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/jediterm/terminal/model/CyclicBufferLinesStorage;", "Lcom/jediterm/terminal/model/LinesStorage;", "maxCapacity", "", "(I)V", "isCapacityLimited", "", "lines", "Lkotlin/collections/ArrayDeque;", "Lcom/jediterm/terminal/model/TerminalLine;", "size", "getSize", "()I", "addToBottom", "", "line", "addToTop", "clear", "get", "index", "indexOf", "iterator", "", "removeFromBottom", "removeFromTop", "core"})
public final class CyclicBufferLinesStorage
implements LinesStorage {
    private final int maxCapacity;
    @NotNull
    private final ArrayDeque<TerminalLine> lines;
    private final boolean isCapacityLimited;

    public CyclicBufferLinesStorage(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.lines = new ArrayDeque();
        this.isCapacityLimited = this.maxCapacity >= 0;
    }

    @Override
    public int getSize() {
        return this.lines.size();
    }

    @Override
    @NotNull
    public TerminalLine get(int index) {
        return (TerminalLine)this.lines.get(index);
    }

    @Override
    public int indexOf(@NotNull TerminalLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.lines.indexOf((Object)line);
    }

    @Override
    public void addToTop(@NotNull TerminalLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (this.isCapacityLimited && this.lines.size() == this.maxCapacity) {
            return;
        }
        this.lines.addFirst((Object)line);
    }

    @Override
    public void addToBottom(@NotNull TerminalLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.lines.addLast((Object)line);
        if (this.isCapacityLimited && this.lines.size() > this.maxCapacity) {
            this.lines.removeFirst();
        }
    }

    @Override
    @NotNull
    public TerminalLine removeFromTop() {
        return (TerminalLine)this.lines.removeFirst();
    }

    @Override
    @NotNull
    public TerminalLine removeFromBottom() {
        return (TerminalLine)this.lines.removeLast();
    }

    @Override
    public void clear() {
        this.lines.clear();
    }

    @Override
    @NotNull
    public Iterator<TerminalLine> iterator() {
        return this.lines.iterator();
    }
}

